/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.verifier;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import org.jboss.metadata.XmlFileLoader;
import org.jboss.verifier.BeanVerifier;
import org.jboss.verifier.Listener;

public class Main {
    public static final int OK = 0;
    public static final int WARNING = 1;
    static int returnCode = 0;

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                throw new IllegalArgumentException("Usage: beanverifier mybeans.jar");
            }
            URL url = new File(args[0]).toURL();
            URLClassLoader cl = new URLClassLoader(new URL[]{url}, Thread.currentThread().getContextClassLoader());
            XmlFileLoader xfl = new XmlFileLoader();
            BeanVerifier verifier = new BeanVerifier();
            xfl.setClassLoader(cl);
            verifier.addVerificationListener(new Listener());
            verifier.verify(url, xfl.load(null));
        }
        catch (Exception e) {
            System.err.println("Problem starting the application:");
            System.err.println("Exception: " + e);
            System.err.println("Message:   " + e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
        System.exit(returnCode);
    }
}

