/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.virtual.plugins.context.jar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.virtual.plugins.context.jar.AbstractJarHandler;
import org.jboss.virtual.spi.VFSContext;
import org.jboss.virtual.spi.VirtualFileHandler;

public class NestedJarHandler
extends AbstractJarHandler {
    private static final long serialVersionUID = 1L;
    private transient JarEntry entry;
    private transient File temp;
    private transient URL original;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JarFile createTempJar(File temp, JarFile parentJar, JarEntry entry) throws IOException {
        InputStream inputStream = parentJar.getInputStream(entry);
        try {
            FileOutputStream outputStream = new FileOutputStream(temp);
            try {
                byte[] buffer = new byte[8096];
                int read = inputStream.read(buffer);
                while (read != -1) {
                    outputStream.write(buffer, 0, read);
                    read = inputStream.read(buffer);
                }
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ignored) {}
        }
        return new JarFile(temp);
    }

    public static NestedJarHandler create(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL url, String entryName) throws IOException {
        File temp = null;
        try {
            temp = File.createTempFile("nestedjar", null);
            temp.deleteOnExit();
        }
        catch (IOException original) {
            IOException e = new IOException("Error opening jar file: " + url + " reason=" + original.getMessage());
            e.setStackTrace(original.getStackTrace());
            throw e;
        }
        return new NestedJarHandler(context, parent, parentJar, entry, url, temp, entryName);
    }

    protected NestedJarHandler(VFSContext context, VirtualFileHandler parent, JarFile parentJar, JarEntry entry, URL original, File temp, String entryName) throws IOException {
        super(context, parent, temp.toURL(), entryName);
        try {
            String vfsParentUrl = parent.toVfsUrl().toString();
            this.vfsUrl = vfsParentUrl.endsWith("/") ? new URL(vfsParentUrl + entryName) : new URL(vfsParentUrl + "/" + entryName);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
        this.temp = temp;
        this.original = original;
        try {
            this.initJarFile(NestedJarHandler.createTempJar(temp, parentJar, entry));
        }
        catch (IOException old) {
            IOException e = new IOException("Error opening jar file: " + original + " reason=" + old.getMessage());
            e.setStackTrace(old.getStackTrace());
            throw e;
        }
        this.entry = entry;
    }

    protected JarEntry getEntry() {
        this.checkClosed();
        return this.entry;
    }

    public long getLastModified() throws IOException {
        return this.getEntry().getTime();
    }

    public long getSize() throws IOException {
        return this.getEntry().getSize();
    }

    public InputStream openStream() throws IOException {
        FileInputStream fis = new FileInputStream(this.temp);
        return fis;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        JarFile parentJar = super.getJar();
        super.initJarFile(parentJar);
    }
}

