/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.wsdl;

import java.net.URL;
import javax.wsdl.Definition;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLLocator;
import javax.wsdl.xml.WSDLReader;
import org.jboss.logging.Logger;
import org.jboss.ws.core.utils.JBossWSEntityResolver;
import org.jboss.ws.tools.wsdl.WSDLLocatorImpl;

public class WSDL11DefinitionFactory {
    private static Logger log = Logger.getLogger(WSDL11DefinitionFactory.class);
    public static final String FEATURE_IMPORT_DOCUMENTS = "javax.wsdl.importDocuments";
    public static final String FEATURE_VERBOSE = "javax.wsdl.verbose";
    private WSDLReader wsdlReader;

    private WSDL11DefinitionFactory() throws WSDLException {
        WSDLFactory wsdlFactory = WSDLFactory.newInstance();
        this.wsdlReader = wsdlFactory.newWSDLReader();
        this.wsdlReader.setExtensionRegistry(new ExtensionRegistry());
        this.wsdlReader.setFeature(FEATURE_VERBOSE, false);
    }

    public static WSDL11DefinitionFactory newInstance() throws WSDLException {
        return new WSDL11DefinitionFactory();
    }

    public void setFeature(String name, boolean value) throws IllegalArgumentException {
        this.wsdlReader.setFeature(name, value);
    }

    public Definition parse(URL wsdlLocation) throws WSDLException {
        if (wsdlLocation == null) {
            throw new IllegalArgumentException("URL cannot be null");
        }
        log.trace("parse: " + wsdlLocation.toExternalForm());
        JBossWSEntityResolver entityResolver = new JBossWSEntityResolver();
        Definition wsdlDefinition = this.wsdlReader.readWSDL((WSDLLocator)new WSDLLocatorImpl(entityResolver, wsdlLocation));
        return wsdlDefinition;
    }
}

