/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.util.HashMap;
import java.util.Map;

final class AliasManager {
    private static final String RELATION_TABLE_SUFFIX = "_RELATION_TABLE";
    private final String prefix;
    private final String suffix;
    private final int maxLength;
    private final Map aliases = new HashMap();
    private final Map relationTableAliases = new HashMap();
    private int count = 0;

    public AliasManager(String prefix, String suffix, int maxLength) {
        this.prefix = prefix;
        this.suffix = suffix;
        this.maxLength = maxLength;
    }

    public String getAlias(String path) {
        String alias = (String)this.aliases.get(path);
        if (alias == null) {
            alias = this.createAlias(path);
            this.aliases.put(path, alias);
        }
        return alias;
    }

    private String createAlias(String path) {
        StringBuffer alias = new StringBuffer();
        alias.append(this.prefix).append(this.count++).append(this.suffix);
        alias.append(path.replace('.', '_'));
        return alias.substring(0, Math.min(this.maxLength, alias.length()));
    }

    public void addAlias(String path, String alias) {
        this.aliases.put(path, alias);
    }

    public String getRelationTableAlias(String path) {
        String relationTableAlias = (String)this.relationTableAliases.get(path);
        if (relationTableAlias == null) {
            relationTableAlias = this.createRelationTableAlias(path);
            this.relationTableAliases.put(path, relationTableAlias);
        }
        return relationTableAlias;
    }

    private String createRelationTableAlias(String path) {
        StringBuffer relationTableAlias = new StringBuffer();
        relationTableAlias.append(this.prefix).append(this.count++).append(this.suffix);
        relationTableAlias.append(path.replace('.', '_'));
        relationTableAlias.append(RELATION_TABLE_SUFFIX);
        return relationTableAlias.substring(0, Math.min(this.maxLength, relationTableAlias.length()));
    }
}

