/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import javax.ejb.CreateException;
import javax.ejb.EJBException;
import javax.management.MalformedObjectNameException;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCCreateCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCUtil;
import org.jboss.ejb.plugins.cmp.jdbc.SQLExceptionProcessorMBean;
import org.jboss.ejb.plugins.cmp.jdbc.SQLUtil;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMPFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCCMRFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCEntityBridge;
import org.jboss.ejb.plugins.cmp.jdbc.bridge.JDBCFieldBridge;
import org.jboss.ejb.plugins.cmp.jdbc.metadata.JDBCEntityCommandMetaData;
import org.jboss.logging.Logger;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.security.AuthenticationManager;

public abstract class JDBCAbstractCreateCommand
implements JDBCCreateCommand {
    protected Logger log;
    protected boolean debug;
    protected boolean trace;
    protected JDBCEntityBridge entity;
    protected AuthenticationManager securityManager;
    protected boolean createAllowed;
    protected SQLExceptionProcessorMBean exceptionProcessor;
    protected String insertSQL;
    protected JDBCFieldBridge[] insertFields;
    protected boolean insertAfterEjbPostCreate;
    private JDBCCMPFieldBridge createdPrincipal;
    private JDBCCMPFieldBridge createdTime;
    private JDBCCMPFieldBridge updatedPrincipal;
    private JDBCCMPFieldBridge updatedTime;

    public void init(JDBCStoreManager manager) throws DeploymentException {
        this.log = Logger.getLogger(this.getClass().getName() + '.' + manager.getMetaData().getName());
        this.debug = this.log.isDebugEnabled();
        this.trace = this.log.isTraceEnabled();
        this.entity = (JDBCEntityBridge)manager.getEntityBridge();
        this.securityManager = manager.getContainer().getSecurityManager();
        this.insertAfterEjbPostCreate = manager.getContainer().getBeanMetaData().getContainerConfiguration().isInsertAfterEjbPostCreate();
        this.createAllowed = true;
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (!pkFields[i].isReadOnly()) continue;
            this.createAllowed = false;
            this.log.debug("Create will not be allowed because pk field " + pkFields[i].getFieldName() + "is read only.");
            break;
        }
        this.initGeneratedFields();
        JDBCEntityCommandMetaData entityCommand = manager.getMetaData().getEntityCommand();
        if (entityCommand == null) {
            throw new DeploymentException("entity-command is null");
        }
        this.initEntityCommand(entityCommand);
        this.initInsertFields();
        this.initInsertSQL();
    }

    protected void initEntityCommand(JDBCEntityCommandMetaData entityCommand) throws DeploymentException {
        String objectName = entityCommand.getAttribute("SQLExceptionProcessor");
        if (objectName != null) {
            try {
                this.exceptionProcessor = (SQLExceptionProcessorMBean)MBeanProxyExt.create(SQLExceptionProcessorMBean.class, objectName);
            }
            catch (MalformedObjectNameException e) {
                throw new DeploymentException("Invalid object name for SQLExceptionProcessor: ", e);
            }
        }
    }

    public Object execute(Method m, Object[] args, EntityEnterpriseContext ctx) throws CreateException {
        if (this.insertAfterEjbPostCreate) {
            if (!JDBCEntityBridge.isEjbCreateDone(ctx)) {
                this.checkCreateAllowed();
                this.generateFields(ctx);
                JDBCEntityBridge.setEjbCreateDone(ctx);
            } else {
                this.beforeInsert(ctx);
                this.performInsert(ctx);
                this.afterInsert(ctx);
                JDBCEntityBridge.setCreated(ctx);
            }
        } else {
            this.checkCreateAllowed();
            this.generateFields(ctx);
            this.beforeInsert(ctx);
            this.performInsert(ctx);
            this.afterInsert(ctx);
            JDBCEntityBridge.setCreated(ctx);
        }
        return this.getPrimaryKey(ctx);
    }

    protected void checkCreateAllowed() throws CreateException {
        if (!this.createAllowed) {
            throw new CreateException("Creation is not allowed because a primary key field is read only.");
        }
    }

    protected JDBCCMPFieldBridge getGeneratedPKField() throws DeploymentException {
        JDBCCMPFieldBridge pkField = null;
        JDBCFieldBridge[] pkFields = this.entity.getPrimaryKeyFields();
        for (int i = 0; i < pkFields.length; ++i) {
            if (pkField != null) {
                throw new DeploymentException("Generation only supported with single PK field");
            }
            pkField = (JDBCCMPFieldBridge)pkFields[i];
        }
        return pkField;
    }

    protected void initGeneratedFields() throws DeploymentException {
        this.createdPrincipal = this.entity.getCreatedPrincipalField();
        if (this.securityManager == null && this.createdPrincipal != null) {
            throw new DeploymentException("No security-domain configured but created-by specified");
        }
        this.updatedPrincipal = this.entity.getUpdatedPrincipalField();
        if (this.securityManager == null && this.updatedPrincipal != null) {
            throw new DeploymentException("No security-domain configured but updated-by specified");
        }
        this.createdTime = this.entity.getCreatedTimeField();
        this.updatedTime = this.entity.getUpdatedTimeField();
    }

    protected void generateFields(EntityEnterpriseContext ctx) throws CreateException {
        if (this.securityManager != null) {
            String principalName = ctx.getEJBContext().getCallerPrincipal().getName();
            if (this.createdPrincipal != null && this.createdPrincipal.getInstanceValue(ctx) == null) {
                this.createdPrincipal.setInstanceValue(ctx, principalName);
            }
        }
        Date date = null;
        if (this.createdTime != null && this.createdTime.getInstanceValue(ctx) == null) {
            date = new Date();
            this.createdTime.setInstanceValue(ctx, date);
        }
    }

    protected void initInsertFields() {
        JDBCFieldBridge[] fields = this.entity.getTableFields();
        ArrayList<JDBCFieldBridge> insertFieldsList = new ArrayList<JDBCFieldBridge>(fields.length);
        for (int i = 0; i < fields.length; ++i) {
            JDBCFieldBridge field = fields[i];
            if (!this.isInsertField(field)) continue;
            insertFieldsList.add(field);
        }
        this.insertFields = insertFieldsList.toArray(new JDBCFieldBridge[insertFieldsList.size()]);
    }

    protected boolean isInsertField(JDBCFieldBridge field) {
        boolean result;
        boolean bl = result = !(field instanceof JDBCCMRFieldBridge) && field.getJDBCType() != null && !field.isReadOnly();
        if (field instanceof JDBCCMPFieldBridge) {
            result = result && !((JDBCCMPFieldBridge)field).isRelationTableField();
        }
        return result;
    }

    protected void initInsertSQL() {
        StringBuffer sql = new StringBuffer(250);
        sql.append("INSERT INTO ").append(this.entity.getQualifiedTableName()).append(" (");
        SQLUtil.getColumnNamesClause(this.insertFields, sql);
        sql.append(')').append(" VALUES ").append('(');
        SQLUtil.getValuesClause(this.insertFields, sql).append(')');
        this.insertSQL = sql.toString();
        if (this.debug) {
            this.log.debug("Insert Entity SQL: " + this.insertSQL);
        }
    }

    protected void beforeInsert(EntityEnterpriseContext ctx) throws CreateException {
    }

    protected void performInsert(EntityEnterpriseContext ctx) throws CreateException {
        Connection c = null;
        PreparedStatement ps = null;
        boolean throwRuntimeExceptions = this.entity.getMetaData().getThrowRuntimeExceptions();
        if (throwRuntimeExceptions) {
            try {
                c = this.entity.getDataSource().getConnection();
            }
            catch (SQLException sqle) {
                EJBException ejbe = new EJBException("Could not get a connection; " + sqle);
                ejbe.initCause(sqle);
                throw ejbe;
            }
        }
        try {
            try {
                if (this.debug) {
                    this.log.debug("Executing SQL: " + this.insertSQL);
                }
                if (!throwRuntimeExceptions) {
                    c = this.entity.getDataSource().getConnection();
                }
                ps = this.prepareStatement(c, this.insertSQL, ctx);
                int index = 1;
                for (int fieldInd = 0; fieldInd < this.insertFields.length; ++fieldInd) {
                    index = this.insertFields[fieldInd].setInstanceParameters(ps, index, ctx);
                }
                int rowsAffected = this.executeInsert(index, ps, ctx);
                if (rowsAffected != 1) {
                    throw new CreateException("Expected one affected row but update returned" + rowsAffected + " for id=" + ctx.getId());
                }
                Object var8_11 = null;
            }
            catch (SQLException e) {
                if (this.exceptionProcessor != null && this.exceptionProcessor.isDuplicateKey(e)) {
                    this.log.error("Failed to create instance.", e);
                    throw new CreateException("Integrity constraint violation. Possibly unique key violation or invalid foreign key value.");
                }
                this.log.error("Could not create entity", e);
                CreateException ce = new CreateException("Could not create entity: " + e);
                ce.initCause(e);
                throw ce;
            }
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            JDBCUtil.safeClose(ps);
            JDBCUtil.safeClose(c);
            throw throwable;
        }
        JDBCUtil.safeClose(ps);
        JDBCUtil.safeClose(c);
        for (int fieldInd = 0; fieldInd < this.insertFields.length; ++fieldInd) {
            this.insertFields[fieldInd].setClean(ctx);
        }
    }

    protected PreparedStatement prepareStatement(Connection c, String sql, EntityEnterpriseContext ctx) throws SQLException {
        return c.prepareStatement(sql);
    }

    protected int executeInsert(int paramIndex, PreparedStatement ps, EntityEnterpriseContext ctx) throws SQLException {
        return ps.executeUpdate();
    }

    protected void afterInsert(EntityEnterpriseContext ctx) throws CreateException {
    }

    protected Object getPrimaryKey(EntityEnterpriseContext ctx) {
        return this.entity.extractPrimaryKeyFromInstance(ctx);
    }
}

