/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.handle;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.Hashtable;
import javax.ejb.EJBHome;
import javax.ejb.HomeHandle;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.naming.NamingContextFactory;

public class HomeHandleImpl
implements HomeHandle {
    static final long serialVersionUID = 208629381571948124L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("jndiName", String.class), new ObjectStreamField("jndiEnv", Hashtable.class)};
    private String jndiName;
    private Hashtable jndiEnv;

    public HomeHandleImpl(String jndiName) {
        this.jndiName = jndiName;
        this.jndiEnv = (Hashtable)NamingContextFactory.lastInitialContextEnv.get();
    }

    public EJBHome getEJBHome() throws RemoteException {
        try {
            InitialContext ic = InitialContextFactory.getInitialContext(this.jndiEnv);
            EJBHome home = (EJBHome)ic.lookup(this.jndiName);
            return home;
        }
        catch (NamingException e) {
            throw new ServerException("Could not get EJBHome", e);
        }
    }

    public String getJNDIName() {
        return this.jndiName;
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = ois.readFields();
        this.jndiName = (String)getField.get("jndiName", null);
        this.jndiEnv = (Hashtable)getField.get("jndiEnv", null);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        ObjectOutputStream.PutField putField = oos.putFields();
        putField.put("jndiName", this.jndiName);
        putField.put("jndiEnv", this.jndiEnv);
        oos.writeFields();
    }
}

