/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.messaging.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.jms.destination.JBossDestination;
import org.jboss.messaging.util.ObjectInputStreamWithClassLoader;
import org.jboss.messaging.util.SafeUTF;
import org.jboss.messaging.util.Streamable;

public class StreamUtils {
    private static final int BUFFER_SIZE = 4096;
    public static final byte NULL = 0;
    public static final byte STRING = 1;
    public static final byte MAP = 2;
    public static final byte BYTE = 3;
    public static final byte SHORT = 4;
    public static final byte INT = 5;
    public static final byte LONG = 6;
    public static final byte FLOAT = 7;
    public static final byte DOUBLE = 8;
    public static final byte BOOLEAN = 9;
    public static final byte BYTES = 10;
    public static final byte LIST = 11;
    public static final byte SERIALIZABLE = 12;
    public static final byte DESTINATION = 13;

    public static Object readObject(DataInputStream in, boolean longStrings) throws IOException, ClassNotFoundException {
        byte type = in.readByte();
        Object value = null;
        switch (type) {
            case 0: {
                value = null;
                break;
            }
            case 1: {
                if (longStrings) {
                    value = SafeUTF.instance.safeReadUTF(in);
                    break;
                }
                value = in.readUTF();
                break;
            }
            case 13: {
                value = JBossDestination.readDestination(in);
                break;
            }
            case 2: {
                value = StreamUtils.readMap(in, false);
                break;
            }
            case 3: {
                value = new Byte(in.readByte());
                break;
            }
            case 4: {
                value = new Short(in.readShort());
                break;
            }
            case 5: {
                value = new Integer(in.readInt());
                break;
            }
            case 6: {
                value = new Long(in.readLong());
                break;
            }
            case 7: {
                value = new Float(in.readFloat());
                break;
            }
            case 8: {
                value = new Double(in.readDouble());
                break;
            }
            case 9: {
                value = in.readBoolean() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 10: {
                int size = in.readInt();
                byte[] bytes = new byte[size];
                in.readFully(bytes);
                value = bytes;
                break;
            }
            case 11: {
                value = StreamUtils.readList(in);
                break;
            }
            case 12: {
                ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(in);
                value = ois.readObject();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown type: " + type);
            }
        }
        return value;
    }

    public static void writeObject(DataOutputStream out, Object object, boolean containerTypes, boolean longStrings) throws IOException {
        if (object == null) {
            out.writeByte(0);
        } else if (object instanceof String) {
            out.writeByte(1);
            if (longStrings) {
                SafeUTF.instance.safeWriteUTF(out, (String)object);
            } else {
                out.writeUTF((String)object);
            }
        } else if (object instanceof JBossDestination) {
            out.writeByte(13);
            JBossDestination.writeDestination(out, (JBossDestination)object);
        } else if (containerTypes && object instanceof Map) {
            out.writeByte(2);
            StreamUtils.writeMap(out, (Map)object, false);
        } else if (object instanceof Integer) {
            out.writeByte(5);
            out.writeInt((Integer)object);
        } else if (object instanceof Boolean) {
            out.writeByte(9);
            out.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            out.writeByte(3);
            out.writeByte(((Byte)object).byteValue());
        } else if (object instanceof Short) {
            out.writeByte(4);
            out.writeShort(((Short)object).shortValue());
        } else if (object instanceof Long) {
            out.writeByte(6);
            out.writeLong((Long)object);
        } else if (object instanceof Float) {
            out.writeByte(7);
            out.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Double) {
            out.writeByte(8);
            out.writeDouble((Double)object);
        } else if (object instanceof byte[]) {
            out.writeByte(10);
            byte[] bytes = (byte[])object;
            out.writeInt(bytes.length);
            out.write(bytes);
        } else if (containerTypes && object instanceof List) {
            out.write(11);
            StreamUtils.writeList(out, (List)object);
        } else if (object instanceof Serializable) {
            out.writeByte(12);
            ObjectOutputStream oos = new ObjectOutputStream(out);
            oos.writeObject(object);
            oos.flush();
        } else {
            throw new IllegalArgumentException("Don't know how to deal with object " + object);
        }
    }

    public static void writeList(DataOutputStream out, List list2) throws IOException {
        out.writeInt(list2.size());
        for (Object value : list2) {
            StreamUtils.writeObject(out, value, false, false);
        }
    }

    public static ArrayList readList(DataInputStream in) throws ClassNotFoundException, IOException {
        int size = in.readInt();
        ArrayList<Object> list2 = new ArrayList<Object>(size);
        for (int i = 0; i < size; ++i) {
            Object obj = StreamUtils.readObject(in, false);
            list2.add(obj);
        }
        return list2;
    }

    public static void writeMap(DataOutputStream out, Map map, boolean stringKeys) throws IOException {
        Set entrySet = map.entrySet();
        out.writeInt(entrySet.size());
        for (Map.Entry me : entrySet) {
            if (stringKeys) {
                out.writeUTF((String)me.getKey());
            } else {
                StreamUtils.writeObject(out, me.getKey(), false, false);
            }
            StreamUtils.writeObject(out, me.getValue(), false, false);
        }
    }

    public static HashMap readMap(DataInputStream in, boolean stringKeys) throws IOException, ClassNotFoundException {
        int size = in.readInt();
        HashMap<Object, Object> m = new HashMap<Object, Object>(size);
        for (int i = 0; i < size; ++i) {
            Object key = stringKeys ? in.readUTF() : StreamUtils.readObject(in, false);
            Object value = StreamUtils.readObject(in, false);
            m.put(key, value);
        }
        return m;
    }

    public static byte[] toBytes(Streamable streamable) throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        DataOutputStream daos = new DataOutputStream(baos);
        streamable.write(daos);
        daos.close();
        return baos.toByteArray();
    }

    public static void fromBytes(Streamable streamable, byte[] bytes) throws Exception {
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        DataInputStream dais = new DataInputStream(bais);
        streamable.read(dais);
        dais.close();
    }
}

