/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.iiop;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.iiop.CorbaORB;
import org.jboss.logging.Logger;
import org.jboss.tm.TxUtils;
import org.jboss.util.NestedRuntimeException;
import org.omg.CORBA.Any;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA_2_3.ORB;
import org.omg.CosTransactions.PropagationContext;
import org.omg.CosTransactions.PropagationContextHelper;
import org.omg.CosTransactions.TransIdentity;
import org.omg.CosTransactions.otid_t;
import org.omg.IOP.Codec;
import org.omg.IOP.CodecPackage.InvalidTypeForEncoding;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ClientRequestInterceptor;

public class TxServerClientInterceptor
extends LocalObject
implements ClientRequestInterceptor {
    static final long serialVersionUID = 4716203472714459196L;
    private static final Logger log = Logger.getLogger(TxServerClientInterceptor.class);
    private static final boolean traceEnabled = log.isTraceEnabled();
    private static final int txContextId = 0;
    private static Codec codec;
    private static TransactionManager tm;
    private static PropagationContext emptyPC;

    static void init(Codec codec) {
        TxServerClientInterceptor.codec = codec;
    }

    static TransactionManager getTransactionManager() {
        if (tm == null) {
            try {
                InitialContext ctx = new InitialContext();
                tm = (TransactionManager)ctx.lookup("java:/TransactionManager");
            }
            catch (NamingException e) {
                throw new NestedRuntimeException("java:/TransactionManager lookup failed", e);
            }
        }
        return tm;
    }

    static PropagationContext getEmptyPropagationContext() {
        if (emptyPC == null) {
            emptyPC = new PropagationContext();
            TxServerClientInterceptor.emptyPC.parents = new TransIdentity[0];
            TxServerClientInterceptor.emptyPC.current = new TransIdentity();
            TxServerClientInterceptor.emptyPC.current.otid = new otid_t();
            TxServerClientInterceptor.emptyPC.current.otid.formatID = 666;
            TxServerClientInterceptor.emptyPC.current.otid.bqual_length = 1;
            TxServerClientInterceptor.emptyPC.current.otid.tid = new byte[]{1};
            TxServerClientInterceptor.emptyPC.implementation_specific_data = ORB.init().create_any();
            TxServerClientInterceptor.emptyPC.implementation_specific_data.insert_boolean(false);
        }
        return emptyPC;
    }

    public String name() {
        return "TxServerClientInterceptor";
    }

    public void destroy() {
    }

    public void send_request(ClientRequestInfo ri) {
        if (traceEnabled) {
            log.trace("Intercepting send_request, operation: " + ri.operation());
        }
        try {
            Any any = this.getTransactionPropagationContextAny();
            if (any != null) {
                ServiceContext sc = new ServiceContext(0, codec.encode_value(any));
                ri.add_request_service_context(sc, true);
            }
        }
        catch (InvalidTypeForEncoding e) {
            throw new NestedRuntimeException(e);
        }
    }

    public void send_poll(ClientRequestInfo ri) {
    }

    public void receive_reply(ClientRequestInfo ri) {
    }

    public void receive_exception(ClientRequestInfo ri) {
    }

    public void receive_other(ClientRequestInfo ri) {
    }

    protected Any getTransactionPropagationContextAny() {
        try {
            PropagationContext pc = null;
            TransactionManager tm = TxServerClientInterceptor.getTransactionManager();
            Transaction tx = tm.getTransaction();
            if (!TxUtils.isUncommitted(tx)) {
                if (traceEnabled) {
                    log.trace("No transaction context");
                }
                return null;
            }
            if (traceEnabled) {
                log.trace("Propagating empty OTS context");
            }
            pc = TxServerClientInterceptor.getEmptyPropagationContext();
            Any any = CorbaORB.getInstance().create_any();
            PropagationContextHelper.insert((Any)any, (PropagationContext)pc);
            return any;
        }
        catch (Exception e) {
            throw new NestedRuntimeException("Error getting tpc", e);
        }
    }
}

