/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice.plugins.io;

import com.arjuna.common.util.FileLocator;
import com.arjuna.common.util.exceptions.LoadPropertiesException;
import com.arjuna.common.util.exceptions.SavePropertiesException;
import com.arjuna.common.util.propertyservice.PropertyManager;
import com.arjuna.common.util.propertyservice.plugins.PropertyManagerIOPlugin;
import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLFilePlugin
implements PropertyManagerIOPlugin {
    private static final String PROPERTIES_ELEMENT_NAME = "properties";
    private static final String DEPENDS_ATTRIBUTE_NAME = "depends";
    private static final String PROPERTY_ELEMENT_NAME = "property";
    private static final String NAME_ATTRIBUTE_NAME = "name";
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private static final String PROPERTY_TYPE_ATTRIBUTE_NAME = "type";
    private static final String SYSTEM_PROPERTY_TYPE_NAME = "system";
    private static DocumentBuilder _documentBuilder;
    private static Hashtable _loadedFiles;

    private static void setURILoaded(PropertyManagerPluginInterface pcm, String uri) {
        ArrayList<String> uris = (ArrayList<String>)_loadedFiles.get(pcm);
        if (uris == null) {
            uris = new ArrayList<String>(1);
            _loadedFiles.put(pcm, uris);
        }
        if (!uris.contains(uri)) {
            uris.add(uri);
        }
    }

    private static boolean isURILoaded(PropertyManagerPluginInterface pcm, String uri) {
        boolean loaded = false;
        ArrayList uris = (ArrayList)_loadedFiles.get(pcm);
        if (uris != null) {
            loaded = uris.contains(uri);
        }
        return loaded;
    }

    public void load(String uri, PropertyManagerPluginInterface pcm, boolean verbose) throws LoadPropertiesException, IOException {
        block16: {
            if (!XMLFilePlugin.isURILoaded(pcm, uri)) {
                try {
                    String filename = FileLocator.locateFile(uri);
                    if (filename != null && new File(filename).exists()) {
                        Document doc = _documentBuilder.parse(filename);
                        Element rootElement = doc.getDocumentElement();
                        XMLFilePlugin.setURILoaded(pcm, uri);
                        NodeList propertiesNodes = rootElement.getElementsByTagName(PROPERTIES_ELEMENT_NAME);
                        Hashtable<PropertyManagerPluginInterface, String> pmDependents = new Hashtable<PropertyManagerPluginInterface, String>();
                        Hashtable<String, PropertyManagerPluginInterface> pms = new Hashtable<String, PropertyManagerPluginInterface>();
                        for (int count = 0; count < propertiesNodes.getLength(); ++count) {
                            PropertyManagerPluginInterface pm;
                            Element propertiesNode = (Element)propertiesNodes.item(count);
                            Attr nameNode = propertiesNode.getAttributeNode(NAME_ATTRIBUTE_NAME);
                            String propertiesName = nameNode != null ? nameNode.getNodeValue() : null;
                            Attr dependsNode = propertiesNode.getAttributeNode(DEPENDS_ATTRIBUTE_NAME);
                            String dependsName = dependsNode != null ? dependsNode.getNodeValue() : "";
                            NodeList propertyNodes = propertiesNode.getElementsByTagName(PROPERTY_ELEMENT_NAME);
                            PropertyManagerPluginInterface propertyManagerPluginInterface = pm = propertiesName != null ? pcm.getTopLevelPropertyManager().getChild(propertiesName) : pcm;
                            if (pm == null) {
                                pm = pcm.createPropertyManager(propertiesName);
                            }
                            if (verbose) {
                                System.out.println("Properties loaded (" + uri + "):");
                            }
                            pm.setUri(uri);
                            pm.setIOPluginClassname(this.getClass().getName());
                            for (int nodeCount = 0; nodeCount < propertyNodes.getLength(); ++nodeCount) {
                                Element propertyNode = (Element)propertyNodes.item(nodeCount);
                                String propertyName = propertyNode.getAttribute(NAME_ATTRIBUTE_NAME);
                                String propertyValue = propertyNode.getAttribute(VALUE_ATTRIBUTE_NAME);
                                String propertyType = propertyNode.getAttribute(PROPERTY_TYPE_ATTRIBUTE_NAME);
                                if (verbose) {
                                    System.out.println(propertyName + "=" + propertyValue);
                                }
                                pm.setProperty(propertyName, propertyValue, false);
                                if (propertyType == null || !propertyType.equalsIgnoreCase(SYSTEM_PROPERTY_TYPE_NAME) || System.getProperty(propertyName) != null) continue;
                                System.setProperty(propertyName, propertyValue);
                            }
                            if (dependsName.length() == 0 && pm != pcm) {
                                pcm.addChild(pm);
                            }
                            pmDependents.put(pm, dependsName);
                            if (propertiesName == null) continue;
                            pms.put(propertiesName, pm);
                        }
                        Enumeration e = pmDependents.keys();
                        while (e.hasMoreElements()) {
                            PropertyManagerPluginInterface pm = (PropertyManagerPluginInterface)e.nextElement();
                            String depends = (String)pmDependents.get(pm);
                            StringTokenizer strtok = new StringTokenizer(depends, ",");
                            while (strtok.hasMoreElements()) {
                                String dependantName = strtok.nextToken().trim();
                                PropertyManager dependant = (PropertyManager)pms.get(dependantName);
                                if (dependant == null) {
                                    throw new LoadPropertiesException("Dependency not found - property file invalid");
                                }
                                pm.addParent(dependant);
                            }
                        }
                        break block16;
                    }
                    throw new FileNotFoundException();
                }
                catch (FileNotFoundException e) {
                    if (verbose) {
                        System.err.println("Cannot load properties file: " + uri);
                    }
                }
                catch (IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new LoadPropertiesException("Failed to open properties file: " + e);
                }
            }
        }
    }

    public void save(String uri, PropertyManagerPluginInterface pcm) throws SavePropertiesException, IOException {
        String string = uri = uri != null ? null : pcm.getUri();
        if (uri == null) {
            throw new SavePropertiesException("No uri is associated with this property manager");
        }
        Properties props = pcm.getLocalProperties();
        try {
            String filename = FileLocator.locateFile(uri);
            Document doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(filename);
            Element root = doc.getDocumentElement();
            String depends = null;
            NodeList propertiesNodes = root.getElementsByTagName(PROPERTIES_ELEMENT_NAME);
            for (int count = 0; count < propertiesNodes.getLength(); ++count) {
                Element propertiesElement = (Element)propertiesNodes.item(count);
                String propertiesName = propertiesElement.getAttributeNode(NAME_ATTRIBUTE_NAME).getNodeValue();
                if (!propertiesName.equals(pcm.getName())) continue;
                root.removeChild(propertiesElement);
                depends = propertiesElement.getAttributeNode(DEPENDS_ATTRIBUTE_NAME).getNodeValue();
                break;
            }
            Element newPropertiesElement = doc.createElement(PROPERTIES_ELEMENT_NAME);
            newPropertiesElement.setAttribute(NAME_ATTRIBUTE_NAME, pcm.getName());
            if (depends != null) {
                newPropertiesElement.setAttribute(DEPENDS_ATTRIBUTE_NAME, depends);
            }
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                Element newPropertyElement = doc.createElement(PROPERTY_ELEMENT_NAME);
                newPropertyElement.setAttribute(NAME_ATTRIBUTE_NAME, key);
                newPropertyElement.setAttribute(VALUE_ATTRIBUTE_NAME, value);
                newPropertiesElement.appendChild(newPropertyElement);
            }
            root.appendChild(newPropertiesElement);
            OutputFormat of = new OutputFormat(doc);
            of.setIndenting(true);
            FileOutputStream out = new FileOutputStream(filename);
            XMLSerializer srl = new XMLSerializer((OutputStream)out, of);
            srl.serialize(doc);
            out.close();
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SavePropertiesException("Unexpected exception: " + e);
        }
    }

    static {
        _loadedFiles = new Hashtable();
        try {
            _documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError("Failed to create document builder:" + e);
        }
    }
}

