/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb;

import java.security.Permission;
import java.util.Iterator;
import java.util.Set;
import javax.security.jacc.EJBMethodPermission;
import javax.security.jacc.EJBRoleRefPermission;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContextException;
import org.jboss.metadata.BeanMetaData;
import org.jboss.metadata.MethodMetaData;
import org.jboss.metadata.OldMetaData;
import org.jboss.metadata.SessionMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.metadata.ejb.spec.ExcludeListMetaData;
import org.jboss.metadata.ejb.spec.MethodInterfaceType;
import org.jboss.metadata.ejb.spec.MethodPermissionMetaData;
import org.jboss.metadata.ejb.spec.MethodPermissionsMetaData;
import org.jboss.metadata.ejb.spec.MethodsMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefMetaData;
import org.jboss.metadata.javaee.spec.SecurityRoleRefsMetaData;

public class EJBPermissionMapping {
    public static void createPermissions(JBossEnterpriseBeanMetaData bean, PolicyConfiguration pc) throws PolicyContextException {
        JBossSessionBeanMetaData smd;
        SecurityRoleRefsMetaData refs;
        MethodsMetaData methods;
        ExcludeListMetaData excluded;
        MethodPermissionsMetaData perms = bean.getMethodPermissions();
        if (perms != null) {
            for (MethodPermissionMetaData perm : perms) {
                MethodsMetaData methods2 = perm.getMethods();
                if (methods2 == null) continue;
                for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods2) {
                    MethodInterfaceType miType;
                    Object params = new String[]{};
                    params = mmd.getMethodParams() != null ? mmd.getMethodParams().toArray((T[])params) : null;
                    String methodName = mmd.getMethodName();
                    if (methodName != null && methodName.equals("*")) {
                        methodName = null;
                    }
                    String iface = (miType = mmd.getMethodIntf()) != null ? miType.name() : null;
                    EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, (String[])params);
                    if (perm.getUnchecked() != null) {
                        pc.addToUncheckedPolicy(p);
                        continue;
                    }
                    Set<String> roles = perm.getRoles();
                    for (String role : roles) {
                        pc.addToRole(role, p);
                    }
                }
            }
        }
        if ((excluded = bean.getExcludeList()) != null && (methods = excluded.getMethods()) != null) {
            for (org.jboss.metadata.ejb.spec.MethodMetaData mmd : methods) {
                MethodInterfaceType miType;
                String methodName;
                String[] params = new String[]{};
                if (mmd.getMethodParams() != null) {
                    params = mmd.getMethodParams().toArray(params);
                }
                if ((methodName = mmd.getMethodName()) != null && methodName.equals("*")) {
                    methodName = null;
                }
                String iface = (miType = mmd.getMethodIntf()) != null ? miType.name() : null;
                EJBMethodPermission p = new EJBMethodPermission(mmd.getEjbName(), methodName, iface, params);
                pc.addToExcludedPolicy(p);
            }
        }
        if ((refs = bean.getSecurityRoleRefs()) != null) {
            for (SecurityRoleRefMetaData ref : refs) {
                EJBRoleRefPermission p = new EJBRoleRefPermission(bean.getEjbName(), ref.getRoleName());
                pc.addToRole(ref.getRoleLink(), p);
            }
        }
        if (bean.isSession() && (smd = (JBossSessionBeanMetaData)bean).isStateful()) {
            EJBMethodPermission p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
            pc.addToUncheckedPolicy(p);
        }
    }

    public static void createPermissions(BeanMetaData bean, PolicyConfiguration pc) throws PolicyContextException {
        SessionMetaData smd;
        Permission p;
        String[] params;
        MethodMetaData mmd;
        Iterator<OldMetaData> iter = bean.getPermissionMethods();
        while (iter.hasNext()) {
            String methodName;
            mmd = iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            if ((methodName = mmd.getMethodName()) != null && methodName.equals("*")) {
                methodName = null;
            }
            EJBMethodPermission p2 = new EJBMethodPermission(mmd.getEjbName(), methodName, mmd.getInterfaceType(), params);
            if (mmd.isUnchecked()) {
                pc.addToUncheckedPolicy(p2);
                continue;
            }
            Set<String> roles = mmd.getRoles();
            for (String role : roles) {
                pc.addToRole(role, p2);
            }
        }
        iter = bean.getExcludedMethods();
        while (iter.hasNext()) {
            mmd = iter.next();
            params = null;
            if (mmd.isParamGiven()) {
                params = mmd.getMethodParams();
            }
            EJBMethodPermission p3 = new EJBMethodPermission(mmd.getEjbName(), mmd.getMethodName(), mmd.getInterfaceType(), params);
            pc.addToExcludedPolicy(p3);
        }
        iter = bean.getSecurityRoleReferences();
        while (iter.hasNext()) {
            org.jboss.metadata.SecurityRoleRefMetaData srrmd = (org.jboss.metadata.SecurityRoleRefMetaData)iter.next();
            p = new EJBRoleRefPermission(bean.getEjbName(), srrmd.getName());
            pc.addToRole(srrmd.getLink(), p);
        }
        if (bean instanceof SessionMetaData && (smd = (SessionMetaData)bean).isStateful()) {
            p = new EJBMethodPermission(bean.getEjbName(), "getEJBObject", "Home", null);
            pc.addToUncheckedPolicy(p);
        }
    }
}

