/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.cmp.jdbc;

import java.lang.reflect.Method;
import java.util.Collection;
import javax.ejb.FinderException;
import javax.ejb.ObjectNotFoundException;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.GenericEntityObjectFactory;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCQueryCommand;
import org.jboss.ejb.plugins.cmp.jdbc.JDBCStoreManager;

public final class JDBCFindEntityCommand {
    private static final String NO_SUCH_ENTITY = "No such entity!";
    private final JDBCStoreManager manager;

    public JDBCFindEntityCommand(JDBCStoreManager manager) {
        this.manager = manager;
    }

    public Object execute(Method finderMethod, Object[] args, EntityEnterpriseContext ctx, GenericEntityObjectFactory factory) throws FinderException {
        JDBCQueryCommand query = this.manager.getQueryManager().getQueryCommand(finderMethod);
        Collection result = query.execute(finderMethod, args, ctx, factory);
        if (result.isEmpty()) {
            throw new ObjectNotFoundException(NO_SUCH_ENTITY);
        }
        if (result.size() == 1) {
            return result.iterator().next();
        }
        throw new FinderException("More than one entity matches the finder criteria: " + result);
    }
}

