/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javassist.bytecode.ClassFile;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.persistence.Entity;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyConfigurationFactory;
import org.hibernate.ejb.packaging.PersistenceMetadata;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.ejb3.ClassFileFilter;
import org.jboss.ejb3.ClientDescriptorFileFilter;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.DependencyPolicy;
import org.jboss.ejb3.DeploymentScope;
import org.jboss.ejb3.DeploymentUnit;
import org.jboss.ejb3.EJBContainer;
import org.jboss.ejb3.Ejb3DescriptorHandler;
import org.jboss.ejb3.Ejb3Handler;
import org.jboss.ejb3.Ejb3HandlerFactory;
import org.jboss.ejb3.Ejb3Registry;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.KernelAbstraction;
import org.jboss.ejb3.PersistenceUnitRegistry;
import org.jboss.ejb3.cache.CacheFactoryRegistry;
import org.jboss.ejb3.cache.persistence.PersistenceManagerFactoryRegistry;
import org.jboss.ejb3.deployers.Ejb3Deployer;
import org.jboss.ejb3.enc.EjbModuleEjbResolver;
import org.jboss.ejb3.enc.EjbModulePersistenceUnitResolver;
import org.jboss.ejb3.enc.MessageDestinationResolver;
import org.jboss.ejb3.entity.PersistenceUnitDeployment;
import org.jboss.ejb3.entity.SecondLevelCacheUtil;
import org.jboss.ejb3.javaee.JavaEEApplication;
import org.jboss.ejb3.javaee.JavaEEComponent;
import org.jboss.ejb3.javaee.JavaEEModule;
import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitMetaData;
import org.jboss.ejb3.metadata.jpa.spec.PersistenceUnitsMetaData;
import org.jboss.ejb3.remoting.RemoteProxyFactoryRegistry;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossMetaData;
import org.jboss.metadata.javaee.spec.MessageDestinationsMetaData;
import org.jboss.virtual.VirtualFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Ejb3Deployment
implements JavaEEModule {
    private static final Logger log = Logger.getLogger(Ejb3Deployment.class);
    public static final String ACTUAL_ENTITY_MANAGER_FACTORY_CONTEXT = "java:/ActualEntityManagerFactories";
    public static final String MANAGED_ENTITY_FACTORY_CONTEXT = "java:/managedEntityFactories";
    private JBossMetaData metaData;
    private PersistenceUnitsMetaData persistenceUnitsMetaData;
    protected DeploymentUnit unit;
    protected Ejb3Deployer deployer;
    protected LinkedHashMap<ObjectName, Container> ejbContainers = new LinkedHashMap();
    protected boolean hasEntities;
    protected List<String> explicitEntityClasses = new ArrayList<String>();
    protected List<PersistenceUnitDeployment> persistenceUnitDeployments = new ArrayList<PersistenceUnitDeployment>();
    protected String defaultSLSBDomain = "Stateless Bean";
    protected String defaultSFSBDomain = "Stateful Bean";
    protected String defaultMDBDomain = "Message Driven Bean";
    protected String defaultConsumerDomain = "Consumer Bean";
    protected String defaultServiceDomain = "Service Bean";
    protected InitialContext initialContext;
    protected KernelAbstraction kernelAbstraction;
    protected MBeanServer mbeanServer;
    protected DeploymentScope deploymentScope;
    protected EjbModuleEjbResolver ejbRefResolver;
    protected EjbModulePersistenceUnitResolver persistenceUnitResolver;
    protected MessageDestinationResolver messageDestinationResolver;
    PolicyConfiguration pc;

    public Ejb3Deployment(DeploymentUnit unit, DeploymentScope deploymentScope, JBossMetaData metaData, PersistenceUnitsMetaData persistenceUnitsMetaData, Ejb3Deployer deployer) {
        assert (unit != null) : "unit is null";
        assert (deployer != null) : "deployer is null";
        this.unit = unit;
        this.deployer = deployer;
        this.deploymentScope = deploymentScope;
        this.metaData = metaData;
        this.persistenceUnitsMetaData = persistenceUnitsMetaData;
        try {
            this.initialContext = InitialContextFactory.getInitialContext(unit.getJndiProperties());
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
        this.ejbRefResolver = new EjbModuleEjbResolver(deploymentScope, unit.getShortName(), this.ejbContainers, this);
        this.persistenceUnitResolver = new EjbModulePersistenceUnitResolver(this.persistenceUnitDeployments, deploymentScope, this.ejbContainers);
        MessageDestinationsMetaData destinations = null;
        if (metaData != null && metaData.getAssemblyDescriptor() != null) {
            destinations = metaData.getAssemblyDescriptor().getMessageDestinations();
        }
        this.messageDestinationResolver = new MessageDestinationResolver(deploymentScope, destinations);
    }

    @Override
    public JavaEEApplication getApplication() {
        return this.deploymentScope;
    }

    public DeploymentScope getEar() {
        return this.deploymentScope;
    }

    public KernelAbstraction getKernelAbstraction() {
        return this.kernelAbstraction;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    public DeploymentUnit getDeploymentUnit() {
        return this.unit;
    }

    public String getDefaultSLSBDomain() {
        return this.defaultSLSBDomain;
    }

    public Ejb3Deployer getDeployer() {
        return this.deployer;
    }

    public CacheFactoryRegistry getCacheFactoryRegistry() {
        return this.getDeployer().getCacheFactoryRegistry();
    }

    public RemoteProxyFactoryRegistry getRemoteProxyFactoryRegistry() {
        return this.getDeployer().getRemoteProxyFactoryRegistry();
    }

    public PersistenceManagerFactoryRegistry getPersistenceManagerFactoryRegistry() {
        return this.getDeployer().getPersistenceManagerFactoryRegistry();
    }

    public String getScopeKernelName() {
        String scopedKernelName = "";
        if (this.deploymentScope != null) {
            scopedKernelName = scopedKernelName + ",ear=" + this.deploymentScope.getShortName();
        }
        scopedKernelName = scopedKernelName + ",jar=" + this.unit.getShortName();
        return scopedKernelName;
    }

    public void setDefaultSLSBDomain(String defaultSLSBDomain) {
        this.defaultSLSBDomain = defaultSLSBDomain;
    }

    public String getDefaultSFSBDomain() {
        return this.defaultSFSBDomain;
    }

    public String getDefaultConsumerDomain() {
        return this.defaultConsumerDomain;
    }

    public void setDefaultSFSBDomain(String defaultSFSBDomain) {
        this.defaultSFSBDomain = defaultSFSBDomain;
    }

    public String getDefaultMDBDomain() {
        return this.defaultMDBDomain;
    }

    public void setDefaultMDBDomain(String defaultMDBDomain) {
        this.defaultMDBDomain = defaultMDBDomain;
    }

    public String getDefaultServiceDomain() {
        return this.defaultServiceDomain;
    }

    public void setDefaultServiceDomain(String defaultServiceDomain) {
        this.defaultServiceDomain = defaultServiceDomain;
    }

    protected String getJaccContextId() {
        return this.unit.getShortName();
    }

    public Container getContainer(ObjectName name) {
        return this.ejbContainers.get(name);
    }

    public Map getEjbContainers() {
        return this.ejbContainers;
    }

    public PersistenceUnitDeployment getPersistenceUnitDeployment(String unitName) throws NameNotFoundException {
        return this.persistenceUnitResolver.getPersistenceUnitDeployment(unitName);
    }

    public PersistenceUnitDeployment getPersistenceUnitDeploymentInternal(String unitName) {
        return this.persistenceUnitResolver.getPersistenceUnitDeploymentInternal(unitName);
    }

    public List<PersistenceUnitDeployment> getPersistenceUnitDeployments() {
        return this.persistenceUnitDeployments;
    }

    public EJBContainer getEjbContainer(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbContainer(ejbLink, businessIntf);
    }

    public String getEjbJndiName(String ejbLink, Class businessIntf) {
        return this.ejbRefResolver.getEjbJndiName(ejbLink, businessIntf);
    }

    public EJBContainer getEjbContainer(Ejb3Deployment deployment, Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(deployment, businessIntf);
    }

    public EJBContainer getEjbContainer(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbContainer(businessIntf);
    }

    public String getEjbJndiName(Class businessIntf) throws NameNotFoundException {
        return this.ejbRefResolver.getEjbJndiName(businessIntf);
    }

    protected void processEJBContainerMetadata(Container container) throws Exception {
        log.trace("Process EJB container metadata " + container);
        ObjectName on = container.getObjectName();
        this.ejbContainers.put(on, container);
        container.processMetadata();
    }

    protected void registerEJBContainer(Container container) throws Exception {
        ObjectName on = container.getObjectName();
        String name = on.getCanonicalName();
        this.kernelAbstraction.install(name, container.getDependencyPolicy(), container);
        this.mbeanServer.registerMBean(container.getMBean(), on);
        log.debug("Bound ejb3 container " + name);
    }

    protected abstract PolicyConfiguration createPolicyConfiguration() throws Exception;

    protected abstract void putJaccInService(PolicyConfiguration var1, DeploymentUnit var2);

    public void create() throws Exception {
        try {
            long start = System.currentTimeMillis();
            this.pc = this.createPolicyConfiguration();
            this.deploy();
            this.initializePersistenceUnits();
            log.debug("EJB3 deployment time took: " + (System.currentTimeMillis() - start));
        }
        catch (Exception e) {
            try {
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    public void start() throws Exception {
        try {
            Container con;
            Container o;
            this.startPersistenceUnits();
            Iterator<Container> i$ = this.ejbContainers.values().iterator();
            while (i$.hasNext()) {
                con = o = i$.next();
                this.processEJBContainerMetadata(con);
            }
            i$ = this.ejbContainers.values().iterator();
            while (i$.hasNext()) {
                con = o = i$.next();
                this.registerEJBContainer(con);
            }
            this.putJaccInService(this.pc, this.unit);
        }
        catch (Exception ex) {
            try {
                this.stop();
                this.destroy();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    protected void deploy() throws Exception {
        Ejb3HandlerFactory factory = Ejb3HandlerFactory.getInstance(this);
        if (this.unit.getUrl() != null) {
            this.deployUrl(factory);
        }
        if (this.unit.getClasses() != null) {
            for (Class explicit : this.unit.getClasses()) {
                if (explicit.isAnnotationPresent(Entity.class)) continue;
                String name = explicit.getName().replace('.', '/') + ".class";
                InputStream stream = explicit.getClassLoader().getResourceAsStream(name);
                this.deployElement(stream, factory, this.initialContext);
            }
        }
        this.deployBeansFromLib(this.initialContext);
    }

    protected void deployUrl(Ejb3HandlerFactory factory) throws Exception {
        List<VirtualFile> clientDescriptors = this.unit.getResources(new ClientDescriptorFileFilter());
        if (clientDescriptors.size() > 0) {
            return;
        }
        InitialContext ctx = this.initialContext;
        List<VirtualFile> classes = this.unit.getResources(new ClassFileFilter());
        for (VirtualFile classFile : classes) {
            InputStream stream = classFile.openStream();
            this.deployElement(stream, factory, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deployElement(InputStream stream, Ejb3HandlerFactory factory, InitialContext ctx) throws Exception {
        DataInputStream dstream = new DataInputStream(new BufferedInputStream(stream));
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            stream.close();
        }
        this.deployElement(factory, cf, ctx);
    }

    protected void deployBeansFromLib(InitialContext ctx) throws Exception {
        JBossMetaData dd = this.getMetaData();
        if (dd != null) {
            Ejb3DescriptorHandler handler = new Ejb3DescriptorHandler(this, dd);
            handler.setCtxProperties(this.unit.getJndiProperties());
            HashMap<String, Container> localContainers = new HashMap<String, Container>();
            for (Container container : this.ejbContainers.values()) {
                localContainers.put(container.getEjbName(), container);
            }
            List<Container> containers = handler.getContainers(this, localContainers);
            for (Container con : containers) {
                ((EJBContainer)con).instantiated();
                this.ejbContainers.put(con.getObjectName(), con);
                Ejb3Registry.register(con);
            }
        }
    }

    protected void deployElement(Ejb3HandlerFactory factory, ClassFile cf, InitialContext ctx) throws Exception {
        Ejb3Handler handler = factory.createHandler(cf);
        handler.setCtxProperties(this.unit.getJndiProperties());
        if (handler.isEjb() || handler.isJBossBeanType()) {
            List<Container> containers = handler.getContainers(cf, this);
            for (Container con : containers) {
                try {
                    ((EJBContainer)con).instantiated();
                    this.ejbContainers.put(con.getObjectName(), con);
                    Ejb3Registry.register(con);
                }
                catch (Throwable t) {
                    throw new DeploymentException("Error creating ejb container " + con.getEjbName() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    protected void initializePersistenceUnits() throws Exception {
        boolean bl = this.hasEntities = this.persistenceUnitsMetaData != null;
        if (!this.hasEntities) {
            return;
        }
        if (this.unit.getClasses() != null) {
            for (Class explicit : this.unit.getClasses()) {
                if (!explicit.isAnnotationPresent(Entity.class)) continue;
                this.explicitEntityClasses.add(explicit.getName());
            }
        }
        for (PersistenceUnitMetaData persistenceUnitMetaData : this.persistenceUnitsMetaData) {
            PersistenceMetadata metadata = persistenceUnitMetaData.getLegacyMetadata();
            String earShortName = this.deploymentScope == null ? null : this.deploymentScope.getShortName();
            boolean isScoped = this.ejbContainers.size() > 0;
            String cache_prefix = metadata.getProps().getProperty("hibernate.cache.region_prefix");
            if (cache_prefix == null) {
                String jarName = isScoped ? this.unit.getShortName() : null;
                cache_prefix = SecondLevelCacheUtil.createCacheRegionPrefix(earShortName, jarName, metadata.getName());
                metadata.getProps().setProperty("hibernate.cache.region_prefix", cache_prefix);
            }
            PersistenceUnitDeployment deployment = new PersistenceUnitDeployment(this.initialContext, this, this.explicitEntityClasses, persistenceUnitMetaData, earShortName, this.unit.getShortName(), isScoped);
            PersistenceUnitRegistry.register(deployment);
            this.persistenceUnitDeployments.add(deployment);
        }
    }

    public abstract DependencyPolicy createDependencyPolicy(JavaEEComponent var1);

    protected void startPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            if (entityDeployment == null) continue;
            DependencyPolicy policy = this.createDependencyPolicy(entityDeployment);
            entityDeployment.addDependencies(policy);
            this.kernelAbstraction.install(entityDeployment.getKernelName(), policy, entityDeployment);
        }
    }

    protected void stopPersistenceUnits() {
        if (this.persistenceUnitDeployments == null) {
            return;
        }
        for (PersistenceUnitDeployment entityDeployment : this.persistenceUnitDeployments) {
            try {
                PersistenceUnitRegistry.unregister(entityDeployment);
                if (entityDeployment == null) continue;
                this.kernelAbstraction.uninstall(entityDeployment.getKernelName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down persistence unit", e);
            }
        }
    }

    public void stop() throws Exception {
        for (ObjectName on : this.ejbContainers.keySet()) {
            try {
                this.mbeanServer.unregisterMBean(on);
                this.kernelAbstraction.uninstall(on.getCanonicalName());
            }
            catch (Exception e) {
                log.debug("error trying to shut down ejb container", e);
            }
        }
        this.stopPersistenceUnits();
    }

    public void destroy() throws Exception {
        this.undeploy();
        PolicyConfigurationFactory pcFactory = PolicyConfigurationFactory.getPolicyConfigurationFactory();
        PolicyConfiguration pc = pcFactory.getPolicyConfiguration(this.getJaccContextId(), true);
        pc.delete();
    }

    private void undeploy() {
        for (Container container : this.ejbContainers.values()) {
            Ejb3Registry.unregister(container);
        }
    }

    public String resolveMessageDestination(String link) {
        return this.messageDestinationResolver.resolveMessageDestination(link);
    }

    public MessageDestinationResolver getMessageDestinationResolver() {
        return this.messageDestinationResolver;
    }

    public JBossMetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public String getName() {
        return this.unit.getShortName();
    }
}

