/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.iiop;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.net.URL;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.ejb3.InitialContextFactory;
import org.jboss.ejb3.NonSerializableFactory;
import org.jboss.ejb3.ProxyFactoryHelper;
import org.jboss.ejb3.annotation.IIOP;
import org.jboss.ejb3.annotation.RemoteBinding;
import org.jboss.ejb3.iiop.BeanCorbaServant;
import org.jboss.ejb3.iiop.EJB3IIOPWebClassLoader;
import org.jboss.ejb3.remoting.RemoteProxyFactory;
import org.jboss.ejb3.session.SessionContainer;
import org.jboss.iiop.CorbaNamingService;
import org.jboss.iiop.CorbaORBService;
import org.jboss.iiop.rmi.InterfaceAnalysis;
import org.jboss.iiop.rmi.ir.InterfaceRepository;
import org.jboss.invocation.iiop.ReferenceFactory;
import org.jboss.invocation.iiop.ServantRegistries;
import org.jboss.invocation.iiop.ServantRegistry;
import org.jboss.invocation.iiop.ServantRegistryKind;
import org.jboss.logging.Logger;
import org.jboss.metadata.IorSecurityConfigMetaData;
import org.jboss.mx.util.MBeanProxyExt;
import org.jboss.proxy.ejb.handle.HandleDelegateImpl;
import org.jboss.system.Registry;
import org.jboss.web.WebClassLoader;
import org.jboss.web.WebServiceMBean;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.Repository;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.PortableServer.Current;
import org.omg.PortableServer.CurrentHelper;
import org.omg.PortableServer.POA;

public class IORFactory
implements RemoteProxyFactory {
    private static final Logger log = Logger.getLogger(IORFactory.class);
    private SessionContainer container;
    private RemoteBinding binding;
    private String webServiceName = "jboss:service=WebService";
    private String[] beanRepositoryIds;
    private String[] homeRepositoryIds;
    private ORB orb;
    private POA irPoa;
    private InterfaceRepository iri;
    private ServantRegistry servantRegistry;
    private ServantRegistry homeServantRegistry;
    private WebClassLoader wcl;
    private ReferenceFactory referenceFactory;
    private ReferenceFactory homeReferenceFactory;
    private static final IIOP defaultIIOP = new IIOP(){

        @Override
        public boolean interfaceRepositorySupported() {
            return false;
        }

        @Override
        public String poa() {
            return "per-servant";
        }

        @Override
        public Class<? extends Annotation> annotationType() {
            return IIOP.class;
        }
    };

    public IORFactory(SessionContainer container, RemoteBinding binding) {
        assert (container != null) : "container is null";
        assert (binding != null) : "binding is null";
        this.container = container;
        this.binding = binding;
    }

    public java.lang.Object createHomeProxy() {
        try {
            Object corbaRef = this.homeReferenceFactory.createReference(this.homeRepositoryIds[0]);
            EJBHome corbaObj = (EJBHome)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBHome.class);
            return corbaObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public java.lang.Object createProxy() {
        try {
            Object corbaRef = this.referenceFactory.createReference(this.beanRepositoryIds[0]);
            EJBObject corbaObj = (EJBObject)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBObject.class);
            return corbaObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public java.lang.Object createProxy(java.lang.Object id) {
        try {
            Object corbaRef = this.referenceFactory.createReferenceWithId(id, this.beanRepositoryIds[0]);
            EJBObject corbaObj = (EJBObject)PortableRemoteObject.narrow((java.lang.Object)corbaRef, EJBObject.class);
            return corbaObj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private IIOP getIIOP() {
        IIOP iiop = this.container.getAnnotation(IIOP.class);
        if (iiop != null) {
            return iiop;
        }
        return defaultIIOP;
    }

    private String getJndiName() {
        return ProxyFactoryHelper.getDefaultRemoteJndiName(this.container);
    }

    private String getServantName() {
        return "Servant/" + this.getJndiName();
    }

    private WebServiceMBean getWebServer() throws MalformedObjectNameException {
        if (this.webServiceName == null) {
            throw new IllegalStateException("iiop is not going to work without a web service");
        }
        return (WebServiceMBean)MBeanProxyExt.create(WebServiceMBean.class, this.webServiceName);
    }

    private void rebind(NamingContextExt ctx, String strName, Object obj) throws Exception {
        NameComponent[] name = ctx.to_name(strName);
        NamingContextExt intermediateCtx = ctx;
        for (int i = 0; i < name.length - 1; ++i) {
            NameComponent[] relativeName = new NameComponent[]{name[i]};
            try {
                intermediateCtx = NamingContextHelper.narrow((Object)intermediateCtx.resolve(relativeName));
                continue;
            }
            catch (NotFound e) {
                intermediateCtx = intermediateCtx.bind_new_context(relativeName);
            }
        }
        intermediateCtx.rebind(new NameComponent[]{name[name.length - 1]}, obj);
    }

    private void removeWebClassLoader() throws MalformedObjectNameException {
        this.getWebServer().removeClassLoader(this.wcl);
    }

    public void setWebServiceName(String name) {
        this.webServiceName = name;
    }

    public void start() throws Exception {
        ServantRegistryKind registryWithPersistentPOA;
        ServantRegistryKind registryWithTransientPOA;
        ObjectName invokerName;
        ServantRegistries servantRegistries;
        Class<?>[] remoteInterfaces = ProxyFactoryHelper.getRemoteAndBusinessRemoteInterfaces(this.container);
        if (remoteInterfaces.length > 1) {
            log.warn("IIOP binding only works on 1 interface, using: " + remoteInterfaces[0].getName());
        }
        InterfaceAnalysis interfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(remoteInterfaces[0]);
        this.beanRepositoryIds = interfaceAnalysis.getAllTypeIds();
        InterfaceAnalysis homeInterfaceAnalysis = null;
        Class<?> homeInterface = ProxyFactoryHelper.getRemoteHomeInterface(this.container);
        if (homeInterface != null) {
            if (!EJBHome.class.isAssignableFrom(homeInterface)) {
                throw new IllegalArgumentException("home interface " + homeInterface.getName() + " must extend javax.ejb.EJBHome (EJB3 4.6.8)");
            }
            homeInterfaceAnalysis = InterfaceAnalysis.getInterfaceAnalysis(homeInterface);
            this.homeRepositoryIds = homeInterfaceAnalysis.getAllTypeIds();
        }
        try {
            this.orb = (ORB)InitialContextFactory.getInitialContext().lookup("java:/" + CorbaORBService.ORB_NAME);
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaORBService.ORB_NAME + ": " + e);
        }
        try {
            this.irPoa = (POA)InitialContextFactory.getInitialContext().lookup("java:/" + CorbaORBService.IR_POA_NAME);
        }
        catch (NamingException e) {
            throw new Exception("Cannot lookup java:/" + CorbaORBService.IR_POA_NAME + ": " + e);
        }
        IIOP iiop = this.getIIOP();
        if (iiop.interfaceRepositorySupported()) {
            this.iri = new InterfaceRepository(this.orb, this.irPoa, this.getJndiName());
            this.iri.mapClass(remoteInterfaces[0]);
            if (homeInterface != null) {
                this.iri.mapClass(homeInterface);
            }
            this.iri.finishBuild();
        }
        if ((servantRegistries = (ServantRegistries)Registry.lookup(invokerName = new ObjectName("jboss:service=invoker,type=iiop"))) == null) {
            throw new Exception("can't find iiop invoker");
        }
        if (iiop.poa().equals("per-servant")) {
            registryWithTransientPOA = ServantRegistryKind.TRANSIENT_POA_PER_SERVANT;
            registryWithPersistentPOA = ServantRegistryKind.PERSISTENT_POA_PER_SERVANT;
        } else if (iiop.poa().equals("shared")) {
            registryWithTransientPOA = ServantRegistryKind.SHARED_TRANSIENT_POA;
            registryWithPersistentPOA = ServantRegistryKind.SHARED_PERSISTENT_POA;
        } else {
            throw new IllegalArgumentException("@IIOP.poa can only be 'per-servant' or 'shared'");
        }
        this.servantRegistry = servantRegistries.getServantRegistry(registryWithTransientPOA);
        this.homeServantRegistry = servantRegistries.getServantRegistry(registryWithPersistentPOA);
        ObjectName on = this.container.getObjectName();
        this.wcl = new EJB3IIOPWebClassLoader(on, (RealClassLoader)((java.lang.Object)this.container.getClassloader()), this.getJndiName());
        WebServiceMBean webServer = this.getWebServer();
        URL[] codebaseURLs = new URL[]{webServer.addClassLoader(this.wcl)};
        this.wcl.setWebURLs(codebaseURLs);
        String codebaseString = this.wcl.getCodebaseString();
        log.debug("codebase = " + codebaseString);
        Any codebase = this.orb.create_any();
        codebase.insert_string(codebaseString);
        Policy codebasePolicy = this.orb.create_policy(305419896, codebase);
        Any secPolicy = this.orb.create_any();
        IorSecurityConfigMetaData iorSecurityConfigMetaData = new IorSecurityConfigMetaData();
        secPolicy.insert_Value((Serializable)iorSecurityConfigMetaData);
        Policy csiv2Policy = this.orb.create_policy(-2023406815, secPolicy);
        Policy[] policies = new Policy[]{codebasePolicy, csiv2Policy};
        InterfaceDef interfaceDef = null;
        if (this.iri != null) {
            Repository ir = this.iri.getReference();
            interfaceDef = InterfaceDefHelper.narrow((Object)ir.lookup_id(this.beanRepositoryIds[0]));
        }
        Current poaCurrent = CurrentHelper.narrow((Object)this.orb.resolve_initial_references("POACurrent"));
        NamingContextExt ctx = this.getNamingContextExt();
        log.debug("binding servant name " + this.getServantName());
        BeanCorbaServant servant = new BeanCorbaServant(this, poaCurrent, this.container, interfaceDef, interfaceAnalysis);
        this.referenceFactory = this.servantRegistry.bind(this.getServantName(), servant, policies);
        EJBObject corbaObj = (EJBObject)this.createProxy();
        this.rebind(ctx, this.getJndiName(), (Object)corbaObj);
        if (homeInterfaceAnalysis != null) {
            servant = new BeanCorbaServant(this, poaCurrent, this.container, null, homeInterfaceAnalysis);
            this.homeReferenceFactory = this.homeServantRegistry.bind(this.getServantName() + "Home", servant, policies);
            java.lang.Object homeObject = this.createHomeProxy();
            this.rebind(ctx, ProxyFactoryHelper.getHomeJndiName(this.container), (Object)homeObject);
        }
        Context compCtx = (Context)InitialContextFactory.getInitialContext().lookup("java:comp");
        NonSerializableFactory.rebind(compCtx, "ORB", this.orb);
        NonSerializableFactory.rebind(compCtx, "HandleDelegate", new HandleDelegateImpl());
    }

    public void stop() throws Exception {
        if (this.homeReferenceFactory != null) {
            this.unbind(ProxyFactoryHelper.getHomeJndiName(this.container));
            this.unbindHomeServant();
        }
        this.unbind(this.getJndiName());
        this.unbindServant();
        this.removeWebClassLoader();
    }

    private void unbind(String strName) {
        try {
            NamingContextExt corbaContext = this.getNamingContextExt();
            NameComponent[] n = corbaContext.to_name(strName);
            this.getNamingContextExt().unbind(n);
        }
        catch (Exception e) {
            log.warn("unable to unbind '" + strName + "'", e);
        }
    }

    private void unbindHomeServant() {
        try {
            this.homeServantRegistry.unbind(this.getServantName() + "Home");
        }
        catch (Exception e) {
            log.warn("unable to unbind home servant", e);
        }
    }

    private void unbindServant() {
        try {
            this.servantRegistry.unbind(this.getServantName());
        }
        catch (Exception e) {
            log.warn("unable to unbind servant", e);
        }
    }

    private NamingContextExt getNamingContextExt() throws NamingException {
        InitialContext initialContext = InitialContextFactory.getInitialContext();
        return NamingContextExtHelper.narrow((Object)((Object)initialContext.lookup("java:/" + CorbaNamingService.NAMING_NAME)));
    }
}

