/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting.transport.rmi;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.server.RMIClientSocketFactory;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.jboss.logging.Logger;
import org.jboss.remoting.AbstractInvoker;
import org.jboss.remoting.InvokerLocator;
import org.jboss.remoting.Version;

public class RemotingRMIClientSocketFactory
implements RMIClientSocketFactory,
Serializable {
    static final long serialVersionUID;
    protected static Logger log;
    protected static HashMap configMaps;
    protected static Map socketFactories;
    protected Map configuration;
    protected InvokerLocator invokerLocator;
    protected transient SocketFactory socketFactory;
    private int timeout = 60000;
    protected String hostName;

    public static void addLocalConfiguration(InvokerLocator invokerLocator, Map localConfig) {
        log.debug("adding local configuration for: " + invokerLocator);
        configMaps.put(new ComparableHolder(invokerLocator), localConfig);
    }

    public RemotingRMIClientSocketFactory(InvokerLocator locator, String hostName, int timeout, Map config) {
        this.invokerLocator = locator;
        this.hostName = hostName;
        this.timeout = timeout;
        this.configuration = new HashMap(config);
    }

    public Socket createSocket(String host, int port) throws IOException {
        if (this.invokerLocator != null) {
            ComparableHolder holder = new ComparableHolder(this.invokerLocator);
            if (!configMaps.containsKey(holder)) {
                log.warn("unrecognized invoker locator: " + this.invokerLocator);
                log.warn("unable to retrieve socket factory: returning plain socket");
                return new Socket(host, port);
            }
            this.socketFactory = this.retrieveSocketFactory(holder);
        }
        String effectiveHost = this.hostName != null ? this.hostName : host;
        Socket socket = null;
        socket = this.socketFactory != null ? this.socketFactory.createSocket(effectiveHost, port) : new Socket(effectiveHost, port);
        socket.setSoTimeout(this.timeout);
        this.socketFactory = null;
        return socket;
    }

    public SocketFactory retrieveSocketFactory(ComparableHolder holder) throws IOException {
        SocketFactory sf = (SocketFactory)socketFactories.get(this);
        if (sf == null) {
            HashMap tempConfig = new HashMap(this.configuration);
            Map localConfig = (Map)configMaps.get(holder);
            if (localConfig != null) {
                tempConfig.putAll(localConfig);
            }
            if (tempConfig.containsKey("customSocketFactory")) {
                sf = (SocketFactory)tempConfig.get("customSocketFactory");
            }
            if (sf == null) {
                sf = SocketFactory.getDefault();
                sf = AbstractInvoker.wrapSocketFactory(sf, tempConfig);
            }
            socketFactories.put(this, sf);
        }
        return sf;
    }

    static {
        log = Logger.getLogger(RemotingRMIClientSocketFactory.class);
        configMaps = new HashMap();
        socketFactories = new HashMap();
        serialVersionUID = Version.getDefaultVersion() == 1 ? -7491556589517716155L : -3039839695840773968L;
    }

    protected static class ComparableHolder {
        private String protocol;
        private InetAddress host;
        private int port;
        private int hashCode;

        public ComparableHolder(InvokerLocator invokerLocator) {
            this.protocol = invokerLocator.getProtocol().toLowerCase();
            try {
                this.host = InetAddress.getByName(invokerLocator.getHost());
            }
            catch (UnknownHostException e) {
                log.error("unable to resolve host: " + invokerLocator.getHost());
            }
            this.port = invokerLocator.getPort();
            this.hashCode = this.protocol.hashCode() * this.host.hashCode() * this.port;
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof ComparableHolder)) {
                return false;
            }
            ComparableHolder holder = (ComparableHolder)obj;
            return this.protocol.equals(holder.protocol.toLowerCase()) && this.host.equals(holder.host) && this.port == holder.port;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }
}

