/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.system.deployers;

import javax.management.ObjectName;
import org.jboss.classloading.spi.RealClassLoader;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.mx.loading.RepositoryClassLoader;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceContext;
import org.jboss.system.ServiceController;
import org.jboss.system.metadata.ServiceMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceDeployer
extends AbstractSimpleRealDeployer<ServiceMetaData> {
    private final ServiceController controller;
    public static final ObjectName DEFAULT_CLASSLOADER_OBJECT_NAME = ObjectNameFactory.create("jboss:service=defaultClassLoader");
    private ObjectName defaultClassLoader = DEFAULT_CLASSLOADER_OBJECT_NAME;

    public ServiceDeployer(ServiceController controller) {
        super(ServiceMetaData.class);
        if (controller == null) {
            throw new IllegalArgumentException("Null controller");
        }
        this.controller = controller;
        this.setComponentsOnly(true);
    }

    public ObjectName getDefaultClassLoader() {
        return this.defaultClassLoader;
    }

    public void setDefaultClassLoader(ObjectName defaultClassLoader) {
        this.defaultClassLoader = defaultClassLoader;
    }

    @Override
    public void deploy(DeploymentUnit unit, ServiceMetaData deployment) throws DeploymentException {
        ObjectName name = deployment.getObjectName();
        try {
            ObjectName loaderName = deployment.getClassLoaderName();
            if (loaderName == null) {
                ClassLoader cl = unit.getClassLoader();
                loaderName = cl != null && cl instanceof RepositoryClassLoader ? ((RepositoryClassLoader)cl).getObjectName() : (cl != null && cl instanceof RealClassLoader ? ((RealClassLoader)((Object)cl)).getObjectName() : this.defaultClassLoader);
            }
            this.controller.install(deployment, loaderName);
            ServiceContext context = this.controller.getServiceContext(name);
            if (context == null) {
                throw new IllegalStateException("No context for " + name);
            }
            try {
                this.create(context);
                try {
                    this.start(context);
                    Throwable t = context.getProblem();
                    if (t != null) {
                        throw t;
                    }
                }
                catch (Throwable t) {
                    this.destroy(name);
                    throw t;
                }
            }
            catch (Throwable t) {
                this.remove(name);
                throw t;
            }
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException("Error deploying: " + name, t);
        }
    }

    @Override
    public void undeploy(DeploymentUnit unit, ServiceMetaData deployment) {
        ObjectName name = deployment.getObjectName();
        ServiceContext context = this.controller.getServiceContext(name);
        if (context != null) {
            this.stop(name);
            this.destroy(name);
            this.remove(name);
        }
    }

    protected void create(ServiceContext context) throws Throwable {
        this.controller.create(context.objectName);
    }

    protected void start(ServiceContext context) throws Throwable {
        this.controller.start(context.objectName);
    }

    protected void stop(ObjectName name) {
        try {
            this.controller.stop(name);
        }
        catch (Throwable t) {
            this.log.warn("Error during stop for " + name, t);
        }
    }

    protected void destroy(ObjectName name) {
        try {
            this.controller.destroy(name);
        }
        catch (Throwable t) {
            this.log.warn("Error during destroy for " + name, t);
        }
    }

    protected void remove(ObjectName name) {
        try {
            this.controller.remove(name);
        }
        catch (Throwable t) {
            this.log.warn("Error during destroy for " + name, t);
        }
    }
}

