/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class CadaverRecord extends PersistenceRecord
/*     */ {
/*     */   private boolean newStateIsValid;
/*     */   private OutputObjectState oldState;
/*     */   private int oType;
/*     */   private ObjectStore store;
/*     */ 
/*     */   public CadaverRecord(OutputObjectState os, ObjectStore objStore, StateManager sm)
/*     */   {
/*  78 */     super(os, objStore, sm);
/*     */ 
/*  80 */     this.newStateIsValid = (os != null);
/*  81 */     this.oldState = null;
/*  82 */     this.oType = 463;
/*  83 */     this.store = objStore;
/*     */ 
/*  85 */     if ((this.store == null) || 
/*  99 */       (tsLogger.arjLogger.debugAllowed()))
/*     */     {
/* 101 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "CadaverRecord::CadaverRecord(" + os + ", " + sm.get_uid() + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 113 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 115 */       tsLogger.arjLogger.debug(2L, 4L, 8L, "CadaverRecord::finalize() for " + order());
/*     */     }
/*     */ 
/* 119 */     this.oldState = null;
/* 120 */     this.store = null;
/*     */ 
/* 122 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public boolean propagateOnAbort()
/*     */   {
/* 134 */     return true;
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/* 146 */     return 111;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 155 */     return ArjunaNames.Implementation_AbstractRecord_CadaverRecord();
/*     */   }
/*     */ 
/*     */   public int nestedAbort()
/*     */   {
/* 167 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 169 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::nestedAbort() for " + order());
/*     */     }
/*     */ 
/* 173 */     if (this.oldState != null) {
/* 174 */       this.newStateIsValid = false;
/*     */     }
/* 176 */     if (this.oType == 101)
/*     */     {
/* 178 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 180 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.CadaverRecord_1", new Object[] { order(), getTypeOfObject() });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 193 */     return 7;
/*     */   }
/*     */ 
/*     */   public int nestedPrepare()
/*     */   {
/* 207 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 209 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::nestedPrepare() for " + order());
/*     */     }
/*     */ 
/* 213 */     if (this.newStateIsValid) {
/* 214 */       return super.nestedPrepare();
/*     */     }
/* 216 */     return 1;
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 225 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 227 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 231 */     this.newStateIsValid = false;
/*     */ 
/* 233 */     if (this.oType == 101)
/*     */     {
/* 235 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 237 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.CadaverRecord_1", new Object[] { order(), getTypeOfObject() });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 244 */     return 7;
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 256 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 258 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 262 */     boolean res = true;
/* 263 */     OutputObjectState oState = this.state;
/*     */ 
/* 265 */     if ((oState != null) && (this.oType == 111))
/*     */     {
/* 267 */       if (this.store == null) {
/* 268 */         return 8;
/*     */       }
/*     */       try
/*     */       {
/* 272 */         res = this.store.commit_state(oState.stateUid(), oState.type());
/*     */       }
/*     */       catch (ObjectStoreException e)
/*     */       {
/* 276 */         res = false;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 282 */     return res ? 7 : 8;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 293 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 295 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "CadaverRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 299 */     int tlpOk = 1;
/* 300 */     OutputObjectState oState = this.newStateIsValid ? this.state : this.oldState;
/*     */ 
/* 302 */     if (oState != null)
/*     */     {
/* 304 */       if (this.oType == 111)
/*     */       {
/* 306 */         if (this.store == null) {
/* 307 */           return 1;
/*     */         }
/*     */         try
/*     */         {
/* 311 */           if (this.store.write_uncommitted(oState.stateUid(), oState.type(), oState))
/*     */           {
/* 313 */             if (shadowForced())
/* 314 */               tlpOk = 0;
/*     */           }
/*     */         }
/*     */         catch (ObjectStoreException e)
/*     */         {
/*     */         }
/*     */       }
/*     */       else {
/* 322 */         tlpOk = 0;
/*     */       }
/*     */     }
/* 325 */     return tlpOk;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 337 */     strm.println("Cadaver for:");
/* 338 */     super.print(strm);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 348 */     return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord/CadaverRecord";
/*     */   }
/*     */ 
/*     */   public boolean doSave()
/*     */   {
/* 362 */     return this.oType == 111;
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create()
/*     */   {
/* 377 */     return new CadaverRecord();
/*     */   }
/*     */ 
/*     */   public void merge(AbstractRecord mergewith)
/*     */   {
/* 399 */     this.oType = mergewith.typeIs();
/*     */ 
/* 401 */     if (this.oldState != null)
/*     */     {
/* 403 */       if (this.newStateIsValid)
/*     */       {
/* 405 */         this.oldState = null;
/*     */       }
/*     */       else
/*     */       {
/* 409 */         setValue(this.oldState);
/* 410 */         this.newStateIsValid = true;
/*     */       }
/*     */     }
/*     */ 
/* 414 */     this.oldState = new OutputObjectState((OutputObjectState)(OutputObjectState)mergewith.value());
/*     */   }
/*     */ 
/*     */   public boolean shouldMerge(AbstractRecord ar)
/*     */   {
/* 430 */     return (order().equals(ar.order())) && ((ar.typeIs() == 111) || (ar.typeIs() == 101));
/*     */   }
/*     */ 
/*     */   public boolean shouldReplace(AbstractRecord ar)
/*     */   {
/* 450 */     return (order().equals(ar.order())) && ((ar.typeIs() == 111) || (ar.typeIs() == 101));
/*     */   }
/*     */ 
/*     */   protected CadaverRecord()
/*     */   {
/* 465 */     this.newStateIsValid = false;
/* 466 */     this.oldState = null;
/* 467 */     this.oType = 463;
/* 468 */     this.store = null;
/*     */ 
/* 470 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 472 */       tsLogger.arjLogger.debug(1L, 2L, 8L, "CadaverRecord::CadaverRecord ()");
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.CadaverRecord
 * JD-Core Version:    0.6.0
 */