/*     */ package com.arjuna.ats.arjuna;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStoreType;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class PersistenceRecord extends RecoveryRecord
/*     */ {
/*     */   public static final int MAX_OBJECT_SIZE = 4096;
/*     */   protected boolean shadowMade;
/*     */   protected ObjectStore store;
/*     */   protected OutputObjectState topLevelState;
/* 642 */   protected static boolean classicPrepare = false;
/*     */ 
/* 644 */   private static boolean writeOptimisation = false;
/*     */ 
/*     */   public PersistenceRecord(OutputObjectState os, ObjectStore objStore, StateManager sm)
/*     */   {
/* 136 */     super(os, sm);
/*     */ 
/* 138 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 140 */       tsLogger.arjLogger.debug(1L, 4L, 8L, "PersistenceRecord::PersistenceRecord(" + os + ", " + sm.get_uid() + ")");
/*     */     }
/*     */ 
/* 144 */     this.shadowMade = false;
/* 145 */     this.store = objStore;
/* 146 */     this.topLevelState = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 151 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 153 */       tsLogger.arjLogger.debug(2L, 4L, 8L, "PersistenceRecord.finalize() for " + order());
/*     */     }
/*     */ 
/* 157 */     this.store = null;
/* 158 */     this.topLevelState = null;
/*     */ 
/* 160 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public int typeIs()
/*     */   {
/* 169 */     return 111;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 174 */     return ArjunaNames.Implementation_AbstractRecord_PersistenceRecord();
/*     */   }
/*     */ 
/*     */   public int topLevelAbort()
/*     */   {
/* 185 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 187 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelAbort() for " + order());
/*     */     }
/*     */ 
/* 191 */     Uid uid = null;
/* 192 */     String type = null;
/*     */ 
/* 194 */     if (this.shadowMade)
/*     */     {
/* 196 */       uid = order();
/* 197 */       type = getTypeOfObject();
/*     */     }
/*     */     else
/*     */     {
/* 201 */       if (this.topLevelState == null)
/*     */       {
/* 203 */         return nestedAbort();
/*     */       }
/*     */ 
/* 207 */       uid = this.topLevelState.stateUid();
/* 208 */       type = this.topLevelState.type();
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 214 */       if (!this.store.remove_uncommitted(uid, type))
/*     */       {
/* 216 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 218 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_19");
/*     */         }
/*     */ 
/* 221 */         return 8;
/*     */       }
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 226 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 228 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_20", new Object[] { e });
/*     */       }
/*     */ 
/* 232 */       e.printStackTrace();
/*     */ 
/* 234 */       return 8;
/*     */     }
/*     */ 
/* 237 */     return nestedAbort();
/*     */   }
/*     */ 
/*     */   public int topLevelCommit()
/*     */   {
/* 246 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 248 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelCommit() for " + order());
/*     */     }
/*     */ 
/* 252 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 254 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_1", new Object[] { order(), getTypeOfObject() });
/*     */     }
/*     */ 
/* 258 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 260 */       if (this.store != null)
/*     */       {
/* 262 */         tsLogger.arjLogger.debug(16L, 4L, 8L, ", store = " + this.store + "(" + this.store.typeIs() + ")");
/*     */       }
/*     */       else
/*     */       {
/* 267 */         tsLogger.arjLogger.debug(16L, 4L, 8L, "");
/*     */       }
/*     */     }
/*     */ 
/* 271 */     boolean result = false;
/*     */ 
/* 273 */     if (this.store != null)
/*     */     {
/*     */       try
/*     */       {
/* 277 */         if (this.shadowMade)
/*     */         {
/* 279 */           result = this.store.commit_state(order(), super.getTypeOfObject());
/*     */ 
/* 281 */           if (!result)
/*     */           {
/* 283 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */             {
/* 285 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_2", new Object[] { order() });
/*     */             }
/*     */ 
/*     */           }
/*     */ 
/*     */         }
/* 292 */         else if (this.topLevelState != null)
/*     */         {
/* 294 */           result = this.store.write_committed(order(), super.getTypeOfObject(), this.topLevelState);
/*     */         }
/* 298 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 299 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_3");
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (ObjectStoreException e)
/*     */       {
/* 305 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 306 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_4", new Object[] { e });
/*     */         }
/*     */ 
/* 309 */         result = false;
/*     */       }
/*     */ 
/*     */     }
/* 314 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 315 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_5");
/*     */     }
/*     */ 
/* 318 */     if (!result)
/*     */     {
/* 320 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 321 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_6");
/*     */       }
/*     */     }
/* 324 */     super.forgetAction(true);
/*     */ 
/* 326 */     return result ? 7 : 8;
/*     */   }
/*     */ 
/*     */   public int topLevelPrepare()
/*     */   {
/* 344 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 346 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelPrepare() for " + order());
/*     */     }
/*     */ 
/* 350 */     int result = 1;
/* 351 */     StateManager sm = this.objectAddr;
/*     */ 
/* 353 */     if ((sm != null) && (this.store != null))
/*     */     {
/* 355 */       this.topLevelState = new OutputObjectState(sm.get_uid(), sm.type());
/*     */ 
/* 357 */       if ((writeOptimisation) || ((!this.store.fullCommitNeeded()) && (sm.save_state(this.topLevelState, 1)) && (this.topLevelState.size() <= 4096)))
/*     */       {
/* 361 */         if (classicPrepare)
/*     */         {
/* 363 */           OutputObjectState dummy = new OutputObjectState(Uid.nullUid(), null);
/*     */           try
/*     */           {
/* 374 */             this.store.write_uncommitted(sm.get_uid(), sm.type(), dummy);
/* 375 */             result = 0;
/*     */           }
/*     */           catch (ObjectStoreException e)
/*     */           {
/* 379 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_21", e);
/*     */           }
/*     */ 
/* 382 */           dummy = null;
/*     */         }
/*     */         else
/*     */         {
/* 386 */           result = 0;
/*     */         }
/*     */ 
/*     */       }
/* 391 */       else if (sm.deactivate(this.store.getStoreName(), false))
/*     */       {
/* 393 */         this.shadowMade = true;
/*     */ 
/* 395 */         result = 0;
/*     */       }
/* 399 */       else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 400 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_7");
/*     */       }
/*     */ 
/*     */     }
/* 406 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 407 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_8");
/*     */     }
/*     */ 
/* 410 */     return result;
/*     */   }
/*     */ 
/*     */   public int topLevelCleanup()
/*     */   {
/* 421 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 423 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::topLevelCleanup() for " + order());
/*     */     }
/*     */ 
/* 427 */     return 7;
/*     */   }
/*     */ 
/*     */   public boolean doSave()
/*     */   {
/* 436 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int ot)
/*     */   {
/* 441 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 443 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::restore_state() for " + order());
/*     */     }
/*     */ 
/* 447 */     boolean res = false;
/* 448 */     int objStoreType = 0;
/*     */     try
/*     */     {
/* 452 */       objStoreType = os.unpackInt();
/*     */ 
/* 454 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */       {
/* 456 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_9", new Object[] { Integer.toString(objStoreType) });
/*     */       }
/*     */ 
/* 460 */       if (ObjectStoreType.valid(objStoreType))
/*     */       {
/* 464 */         if (this.store == null) {
/* 465 */           this.store = new ObjectStore(ObjectStoreType.typeToClassName(objStoreType));
/*     */         }
/*     */ 
/* 468 */         this.store.unpack(os);
/* 469 */         this.shadowMade = os.unpackBoolean();
/*     */ 
/* 473 */         if (!this.shadowMade)
/*     */         {
/* 475 */           this.topLevelState = new OutputObjectState(os);
/* 476 */           res = this.topLevelState.valid();
/*     */         }
/*     */         else {
/* 479 */           res = true;
/*     */         }
/* 481 */         return (res) && (super.restore_state(os, ot));
/*     */       }
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 486 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 487 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_10");
/*     */       }
/*     */     }
/* 490 */     return res;
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, int ot)
/*     */   {
/* 495 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 497 */       tsLogger.arjLogger.debug(16L, 4L, 8L, "PersistenceRecord::save_state() for " + order());
/*     */     }
/*     */ 
/* 501 */     boolean res = true;
/*     */ 
/* 503 */     if (this.store != null)
/*     */     {
/* 505 */       if (!ObjectStoreType.valid(this.store.typeIs()))
/*     */       {
/* 507 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 509 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_11");
/*     */         }
/*     */ 
/* 512 */         res = false;
/*     */       }
/*     */       else
/*     */       {
/*     */         try
/*     */         {
/* 518 */           os.packInt(this.store.typeIs());
/*     */ 
/* 520 */           if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */           {
/* 522 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_12", new Object[] { Integer.toString(this.store.typeIs()) });
/*     */           }
/*     */ 
/* 526 */           this.store.pack(os);
/*     */ 
/* 528 */           if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */           {
/* 530 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_13");
/*     */           }
/*     */ 
/* 533 */           os.packBoolean(this.shadowMade);
/*     */ 
/* 540 */           if (!this.shadowMade)
/*     */           {
/* 542 */             res = this.topLevelState != null;
/*     */ 
/* 544 */             if (res) {
/* 545 */               this.topLevelState.packInto(os);
/*     */             }
/* 548 */             else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 549 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_14");
/*     */             }
/*     */           }
/*     */         }
/*     */         catch (IOException e)
/*     */         {
/* 555 */           res = false;
/*     */ 
/* 557 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 558 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_15");
/*     */         }
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 564 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 565 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.PersistenceRecord_16");
/*     */       }
/*     */       try
/*     */       {
/* 569 */         os.packString(null);
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 573 */         res = false;
/*     */       }
/*     */     }
/*     */ 
/* 577 */     return (res) && (super.save_state(os, ot));
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 582 */     super.print(strm);
/*     */ 
/* 584 */     strm.println("PersistenceRecord with state:\n" + this.state);
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 589 */     return "/StateManager/AbstractRecord/RecoveryRecord/PersistenceRecord";
/*     */   }
/*     */ 
/*     */   public static AbstractRecord create()
/*     */   {
/* 594 */     return new PersistenceRecord();
/*     */   }
/*     */ 
/*     */   protected PersistenceRecord()
/*     */   {
/* 606 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/* 608 */       tsLogger.arjLoggerI18N.debug(1L, 2L, 8L, "com.arjuna.ats.arjuna.PersistenceRecord_17");
/*     */     }
/*     */ 
/* 611 */     this.shadowMade = false;
/* 612 */     this.store = null;
/* 613 */     this.topLevelState = null;
/*     */   }
/*     */ 
/*     */   protected boolean shadowForced()
/*     */   {
/* 623 */     if (this.topLevelState == null)
/*     */     {
/* 625 */       this.shadowMade = true;
/*     */ 
/* 627 */       return true;
/*     */     }
/*     */ 
/* 632 */     return false;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 648 */     String cp = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.classicPrepare");
/*     */ 
/* 650 */     if (cp != null)
/*     */     {
/* 652 */       if (cp.equals("YES")) {
/* 653 */         classicPrepare = true;
/*     */       }
/*     */     }
/* 656 */     String wo = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.coordinator.transactionLog.writeOptimisation");
/*     */ 
/* 658 */     if (wo != null)
/*     */     {
/* 660 */       if (wo.equals("YES"))
/*     */       {
/* 662 */         writeOptimisation = true;
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.PersistenceRecord
 * JD-Core Version:    0.6.0
 */