/*     */ package com.arjuna.ats.arjuna.common;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.ObjectInputStream;
/*     */ import java.io.ObjectOutputStream;
/*     */ import java.io.PrintStream;
/*     */ import java.io.Serializable;
/*     */ import java.net.UnknownHostException;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class Uid
/*     */   implements Cloneable, Serializable
/*     */ {
/*     */   private static final long serialVersionUID = 7808395904206530189L;
/*     */   private int hostAddr;
/*     */   private int process;
/*     */   private int sec;
/*     */   private int other;
/*     */   private int _hashValue;
/*     */   private boolean _valid;
/*     */   private static int uidsCreated;
/*     */   private static int initTime;
/* 681 */   private static char breakChar = ':';
/*     */ 
/* 683 */   private static char fileBreakChar = '_';
/*     */ 
/* 685 */   private static Uid NIL_UID = new Uid("0:0:0:0");
/*     */ 
/* 687 */   private static Uid LAST_RESOURCE_UID = new Uid("0:0:0:1");
/*     */ 
/* 689 */   private static Uid MAX_UID = new Uid("7fffffff:7fffffff:7fffffff:7fffffff");
/*     */ 
/* 691 */   private static Uid MIN_UID = new Uid("-80000000:-80000000:-80000000:-80000000");
/*     */ 
/*     */   public Uid()
/*     */   {
/*  95 */     this.hostAddr = -1;
/*  96 */     this.process = 0;
/*  97 */     this.sec = 0;
/*  98 */     this.other = 0;
/*  99 */     this._hashValue = -1;
/* 100 */     this._valid = true;
/*     */     try
/*     */     {
/* 104 */       this.hostAddr = Utility.hostInetAddr();
/* 105 */       this.process = Utility.getpid();
/*     */ 
/* 107 */       if (initTime == 0) {
/* 108 */         initTime = (int)(System.currentTimeMillis() / 1000L);
/*     */       }
/* 110 */       this.sec = initTime;
/*     */ 
/* 112 */       this.other = getValue();
/*     */     }
/*     */     catch (UnknownHostException e)
/*     */     {
/* 116 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 117 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_1");
/* 118 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public Uid(Uid copyFrom)
/*     */   {
/* 128 */     copy(copyFrom);
/*     */   }
/*     */ 
/*     */   public Uid(String uidString)
/*     */   {
/* 138 */     this(uidString, true);
/*     */   }
/*     */ 
/*     */   public Uid(String uidString, boolean errsOk)
/*     */   {
/* 148 */     char theBreakChar = getBreakChar(uidString);
/*     */ 
/* 150 */     this.hostAddr = -1;
/* 151 */     this.process = 0;
/* 152 */     this.sec = 0;
/* 153 */     this.other = 0;
/* 154 */     this._hashValue = -1;
/* 155 */     this._valid = false;
/*     */ 
/* 157 */     if (uidString.length() > 0)
/*     */     {
/* 159 */       int startIndex = 0;
/* 160 */       int endIndex = 0;
/* 161 */       String s = null;
/*     */       try
/*     */       {
/* 165 */         while (uidString.charAt(endIndex) != theBreakChar) {
/* 166 */           endIndex++;
/*     */         }
/* 168 */         s = uidString.substring(startIndex, endIndex);
/* 169 */         this.hostAddr = (int)Utility.hexStringToLong(s);
/*     */ 
/* 171 */         startIndex = endIndex + 1;
/* 172 */         endIndex++;
/*     */ 
/* 174 */         while (uidString.charAt(endIndex) != theBreakChar) {
/* 175 */           endIndex++;
/*     */         }
/* 177 */         s = uidString.substring(startIndex, endIndex);
/* 178 */         this.process = (int)Utility.hexStringToLong(s);
/*     */ 
/* 180 */         startIndex = endIndex + 1;
/* 181 */         endIndex++;
/*     */ 
/* 183 */         while (uidString.charAt(endIndex) != theBreakChar) {
/* 184 */           endIndex++;
/*     */         }
/* 186 */         s = uidString.substring(startIndex, endIndex);
/* 187 */         this.sec = (int)Utility.hexStringToLong(s);
/*     */ 
/* 189 */         s = uidString.substring(endIndex + 1, uidString.length());
/* 190 */         this.other = (int)Utility.hexStringToLong(s);
/*     */ 
/* 192 */         this._valid = true;
/*     */       }
/*     */       catch (NumberFormatException e)
/*     */       {
/* 196 */         if (!errsOk)
/*     */         {
/* 198 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 200 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_3", new Object[] { uidString });
/*     */           }
/*     */ 
/*     */         }
/*     */ 
/* 205 */         this._valid = false;
/*     */       }
/*     */       catch (StringIndexOutOfBoundsException e)
/*     */       {
/* 209 */         this._valid = false;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 214 */       copy(nullUid());
/*     */     }
/*     */ 
/* 217 */     if (!this._valid)
/*     */     {
/* 219 */       if (errsOk)
/*     */       {
/*     */         try
/*     */         {
/* 223 */           copy(nullUid());
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 227 */           if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */           {
/* 229 */             tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.common.Uid_4", new Object[] { uidString });
/*     */           }
/*     */ 
/* 233 */           throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_2"));
/*     */         }
/*     */ 
/*     */       }
/*     */       else
/*     */       {
/* 239 */         if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*     */         {
/* 241 */           tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.common.Uid_5", new Object[] { uidString });
/*     */         }
/*     */ 
/* 245 */         throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_3") + uidString);
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public int hashCode()
/*     */   {
/* 262 */     if (this._hashValue == -1) {
/* 263 */       generateHash();
/*     */     }
/* 265 */     return this._hashValue;
/*     */   }
/*     */ 
/*     */   public synchronized void pack(OutputBuffer packInto)
/*     */     throws IOException
/*     */   {
/* 274 */     if (this._valid)
/*     */     {
/* 276 */       packInto.packInt(this.hostAddr);
/* 277 */       packInto.packInt(this.process);
/* 278 */       packInto.packInt(this.sec);
/* 279 */       packInto.packInt(this.other);
/*     */     }
/*     */     else {
/* 282 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_9"));
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void unpack(InputBuffer unpackFrom)
/*     */     throws IOException
/*     */   {
/* 292 */     if (this == nullUid()) {
/* 293 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.common.Uid_10"));
/*     */     }
/*     */ 
/* 296 */     this._valid = true;
/*     */     try
/*     */     {
/* 300 */       this.hostAddr = unpackFrom.unpackInt();
/* 301 */       this.process = unpackFrom.unpackInt();
/* 302 */       this.sec = unpackFrom.unpackInt();
/* 303 */       this.other = unpackFrom.unpackInt();
/*     */ 
/* 305 */       this._hashValue = -1;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 309 */       this._valid = false;
/*     */ 
/* 311 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   public void print(PrintStream strm)
/*     */   {
/* 321 */     strm.print("<Uid:" + toString() + ">");
/*     */   }
/*     */ 
/*     */   public String stringForm()
/*     */   {
/* 326 */     return Utility.intToHexString(this.hostAddr) + breakChar + Utility.intToHexString(this.process) + breakChar + Utility.intToHexString(this.sec) + breakChar + Utility.intToHexString(this.other);
/*     */   }
/*     */ 
/*     */   public String fileStringForm()
/*     */   {
/* 339 */     return Utility.intToHexString(this.hostAddr) + fileBreakChar + Utility.intToHexString(this.process) + fileBreakChar + Utility.intToHexString(this.sec) + fileBreakChar + Utility.intToHexString(this.other);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 351 */     return stringForm();
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */     throws CloneNotSupportedException
/*     */   {
/* 360 */     return new Uid(this);
/*     */   }
/*     */ 
/*     */   public synchronized void copy(Uid toCopy)
/*     */   {
/* 369 */     if (toCopy == this) {
/* 370 */       return;
/*     */     }
/* 372 */     this.hostAddr = toCopy.hostAddr;
/* 373 */     this.process = toCopy.process;
/* 374 */     this.sec = toCopy.sec;
/* 375 */     this.other = toCopy.other;
/* 376 */     this._hashValue = toCopy._hashValue;
/* 377 */     this._valid = toCopy._valid;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object o)
/*     */   {
/* 390 */     if ((o instanceof Uid)) {
/* 391 */       return equals((Uid)o);
/*     */     }
/* 393 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Uid u)
/*     */   {
/* 398 */     if (u == null) {
/* 399 */       return false;
/*     */     }
/* 401 */     if (u == this) {
/* 402 */       return true;
/*     */     }
/* 404 */     return (this.other == u.other) && (this.sec == u.sec) && (this.process == u.process) && (this.hostAddr == u.hostAddr);
/*     */   }
/*     */ 
/*     */   public boolean notEquals(Uid u)
/*     */   {
/* 409 */     if (u == null) {
/* 410 */       return true;
/*     */     }
/* 412 */     if (u == this) {
/* 413 */       return false;
/*     */     }
/* 415 */     return (this.other != u.other) || (this.sec != u.sec) || (this.process != u.process) || (this.hostAddr != u.hostAddr);
/*     */   }
/*     */ 
/*     */   public boolean lessThan(Uid u)
/*     */   {
/* 420 */     if (u == null) {
/* 421 */       return false;
/*     */     }
/* 423 */     if (u == this) {
/* 424 */       return false;
/*     */     }
/* 426 */     if (equals(u)) {
/* 427 */       return false;
/*     */     }
/* 429 */     if (LAST_RESOURCE_UID.equals(this)) {
/* 430 */       return false;
/*     */     }
/* 432 */     if (LAST_RESOURCE_UID.equals(u)) {
/* 433 */       return true;
/*     */     }
/* 435 */     if (this.hostAddr < u.hostAddr) {
/* 436 */       return true;
/*     */     }
/* 438 */     if (this.hostAddr == u.hostAddr)
/*     */     {
/* 440 */       if (this.process < u.process) {
/* 441 */         return true;
/*     */       }
/* 443 */       if (this.process == u.process)
/*     */       {
/* 445 */         if (this.sec < u.sec) {
/* 446 */           return true;
/*     */         }
/* 448 */         if ((this.sec == u.sec) && (this.other < u.other))
/* 449 */           return true;
/*     */       }
/*     */     }
/* 452 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean greaterThan(Uid u)
/*     */   {
/* 457 */     if (u == null) {
/* 458 */       return false;
/*     */     }
/* 460 */     if (u == this) {
/* 461 */       return false;
/*     */     }
/* 463 */     if (equals(u)) {
/* 464 */       return false;
/*     */     }
/* 466 */     if (LAST_RESOURCE_UID.equals(this)) {
/* 467 */       return true;
/*     */     }
/* 469 */     if (LAST_RESOURCE_UID.equals(u)) {
/* 470 */       return false;
/*     */     }
/* 472 */     if (this.hostAddr > u.hostAddr) {
/* 473 */       return true;
/*     */     }
/* 475 */     if (this.hostAddr == u.hostAddr)
/*     */     {
/* 477 */       if (this.process > u.process) {
/* 478 */         return true;
/*     */       }
/* 480 */       if (this.process == u.process)
/*     */       {
/* 482 */         if (this.sec > u.sec) {
/* 483 */           return true;
/*     */         }
/* 485 */         if ((this.sec == u.sec) && (this.other > u.other))
/* 486 */           return true;
/*     */       }
/*     */     }
/* 489 */     return false;
/*     */   }
/*     */ 
/*     */   public final synchronized boolean valid()
/*     */   {
/* 498 */     return this._valid;
/*     */   }
/*     */ 
/*     */   public static final Uid nullUid()
/*     */   {
/* 507 */     return NIL_UID;
/*     */   }
/*     */ 
/*     */   public static final Uid lastResourceUid()
/*     */   {
/* 515 */     return LAST_RESOURCE_UID;
/*     */   }
/*     */ 
/*     */   public static final Uid maxUid()
/*     */   {
/* 523 */     return MAX_UID;
/*     */   }
/*     */ 
/*     */   public static final Uid minUid()
/*     */   {
/* 531 */     return MIN_UID;
/*     */   }
/*     */ 
/*     */   private void writeObject(ObjectOutputStream out)
/*     */     throws IOException
/*     */   {
/* 544 */     if (this._valid)
/*     */     {
/* 546 */       out.writeInt(this.hostAddr);
/* 547 */       out.writeInt(this.process);
/* 548 */       out.writeInt(this.sec);
/* 549 */       out.writeInt(this.other);
/*     */     }
/*     */     else {
/* 552 */       throw new IOException("Invalid Uid object.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private void readObject(ObjectInputStream in)
/*     */     throws IOException, ClassNotFoundException
/*     */   {
/* 565 */     this._valid = true;
/*     */     try
/*     */     {
/* 569 */       this.hostAddr = in.readInt();
/* 570 */       this.process = in.readInt();
/* 571 */       this.sec = in.readInt();
/* 572 */       this.other = in.readInt();
/* 573 */       this._hashValue = -1;
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 578 */       this._valid = false;
/*     */ 
/* 580 */       throw e;
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final synchronized int getValue()
/*     */   {
/* 586 */     if ((uidsCreated & 0xF0000000) > 0)
/*     */     {
/* 588 */       uidsCreated = 0;
/* 589 */       initTime = (int)(System.currentTimeMillis() / 1000L);
/*     */     }
/*     */ 
/* 592 */     return uidsCreated++;
/*     */   }
/*     */ 
/*     */   private final synchronized void generateHash()
/*     */   {
/* 602 */     if (this._valid)
/*     */     {
/* 605 */       this._hashValue = (this.hostAddr ^ this.process ^ this.sec ^ this.other);
/*     */ 
/* 637 */       if (this._hashValue < 0) {
/* 638 */         this._hashValue = (-this._hashValue);
/*     */       }
/*     */ 
/*     */     }
/* 642 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 643 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.common.Uid_6");
/*     */     }
/*     */   }
/*     */ 
/*     */   private static final char getBreakChar(String uidString)
/*     */   {
/* 654 */     if (uidString == null) {
/* 655 */       return breakChar;
/*     */     }
/* 657 */     if (uidString.indexOf(fileBreakChar) != -1) {
/* 658 */       return fileBreakChar;
/*     */     }
/* 660 */     return breakChar;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.common.Uid
 * JD-Core Version:    0.6.0
 */