/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class ActionHierarchy
/*     */ {
/*     */   public static final int DEFAULT_HIERARCHY_DEPTH = 5;
/*     */   private ActionInfo[] hierarchy;
/*     */   private int maxHierarchyDepth;
/*     */   private int currentDepth;
/*     */ 
/*     */   public ActionHierarchy(int depth)
/*     */   {
/*  66 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  68 */       tsLogger.arjLogger.debug(1L, 4L, 1L, "ActionHierarchy::ActionHierarchy(" + depth + ")");
/*     */     }
/*     */ 
/*  73 */     this.hierarchy = null;
/*  74 */     this.maxHierarchyDepth = depth;
/*  75 */     this.currentDepth = 0;
/*     */ 
/*  77 */     if (this.maxHierarchyDepth > 0)
/*     */     {
/*  79 */       this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
/*     */ 
/*  81 */       for (int i = 0; i < this.maxHierarchyDepth; i++)
/*  82 */         this.hierarchy[i] = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public ActionHierarchy(ActionHierarchy theCopy)
/*     */   {
/*  92 */     this.hierarchy = null;
/*  93 */     this.maxHierarchyDepth = theCopy.maxHierarchyDepth;
/*  94 */     this.currentDepth = theCopy.currentDepth;
/*     */ 
/*  96 */     if (this.maxHierarchyDepth > 0)
/*     */     {
/*  98 */       this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
/*     */ 
/* 100 */       for (int i = 0; i < this.maxHierarchyDepth; i++) {
/* 101 */         this.hierarchy[i] = null;
/*     */       }
/*     */     }
/* 104 */     for (int i = 0; i < this.currentDepth; i++)
/*     */     {
/* 106 */       this.hierarchy[i] = new ActionInfo(theCopy.hierarchy[i]);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 112 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 114 */       tsLogger.arjLogger.debug(2L, 4L, 1L, "ActionHierarchy::~ActionHierarchy()");
/*     */     }
/*     */ 
/* 119 */     if (this.hierarchy != null)
/* 120 */       this.hierarchy = null;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 129 */     strm.println("\tCurrent depth : " + this.currentDepth);
/*     */ 
/* 131 */     if (this.currentDepth == 0) {
/* 132 */       strm.println("\tAction Uids : NULL");
/*     */     }
/*     */     else {
/* 135 */       strm.println("\tAction Uids :");
/*     */ 
/* 142 */       for (int i = 0; i < this.currentDepth; i++)
/* 143 */         strm.println("\t\t" + this.hierarchy[i].actionUid);
/*     */     }
/*     */   }
/*     */ 
/*     */   public synchronized void copy(ActionHierarchy c)
/*     */   {
/* 159 */     if (this == c) {
/* 160 */       return;
/*     */     }
/* 162 */     if (this.hierarchy != null) {
/* 163 */       this.hierarchy = null;
/*     */     }
/* 165 */     this.currentDepth = c.currentDepth;
/* 166 */     this.maxHierarchyDepth = c.maxHierarchyDepth;
/*     */ 
/* 168 */     if (this.maxHierarchyDepth > 0)
/*     */     {
/* 170 */       this.hierarchy = new ActionInfo[this.maxHierarchyDepth];
/*     */ 
/* 172 */       for (int i = 0; i < this.maxHierarchyDepth; i++) {
/* 173 */         this.hierarchy[i] = null;
/*     */       }
/*     */     }
/* 176 */     for (int i = 0; i < this.currentDepth; i++)
/* 177 */       this.hierarchy[i] = new ActionInfo(c.hierarchy[i]);
/*     */   }
/*     */ 
/*     */   public final boolean equals(ActionHierarchy other)
/*     */   {
/* 186 */     boolean same = true;
/*     */ 
/* 188 */     if (this.currentDepth == other.depth())
/*     */     {
/* 190 */       for (int i = 0; i < this.currentDepth; i++)
/*     */       {
/* 192 */         if (!this.hierarchy[i].notEquals(other.getActionInfo(i)))
/*     */           continue;
/* 194 */         same = false;
/* 195 */         break;
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 200 */       same = false;
/*     */     }
/* 202 */     return same;
/*     */   }
/*     */ 
/*     */   public final boolean add(Uid actionId)
/*     */   {
/* 215 */     return add(actionId, 0);
/*     */   }
/*     */ 
/*     */   public final boolean add(Uid actionId, int at)
/*     */   {
/* 227 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 229 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "ActionHierarchy::add(" + actionId + ", " + at + ")");
/*     */     }
/*     */ 
/* 233 */     boolean result = true;
/*     */ 
/* 235 */     if (this.currentDepth >= this.maxHierarchyDepth)
/*     */     {
/* 237 */       ActionInfo[] newHier = null;
/* 238 */       int newDepth = (this.maxHierarchyDepth + 1) * 2;
/*     */ 
/* 240 */       newHier = new ActionInfo[newDepth];
/*     */ 
/* 242 */       if (newHier != null)
/*     */       {
/* 244 */         this.maxHierarchyDepth = newDepth;
/*     */ 
/* 246 */         for (int i = 0; i < this.currentDepth; i++) {
/* 247 */           newHier[i] = this.hierarchy[i];
/*     */         }
/* 249 */         for (int i = this.currentDepth; i < newDepth; i++) {
/* 250 */           newHier[i] = null;
/*     */         }
/* 252 */         this.hierarchy = newHier;
/* 253 */         newHier = null;
/*     */       }
/*     */       else {
/* 256 */         result = false;
/*     */       }
/*     */     }
/* 259 */     if (result)
/*     */     {
/* 261 */       if (this.hierarchy[this.currentDepth] == null) {
/* 262 */         this.hierarchy[this.currentDepth] = new ActionInfo();
/*     */       }
/*     */ 
/* 268 */       this.hierarchy[this.currentDepth].actionUid = new Uid(actionId);
/* 269 */       this.hierarchy[(this.currentDepth++)].actionType = at;
/*     */     }
/*     */ 
/* 272 */     return result;
/*     */   }
/*     */ 
/*     */   public final boolean isAncestor(Uid target)
/*     */   {
/* 285 */     boolean result = false;
/*     */ 
/* 287 */     for (int i = this.currentDepth - 1; (i >= 0) && (!result); i--)
/*     */     {
/* 289 */       if (this.hierarchy[i].actionUid.equals(target))
/*     */       {
/* 291 */         result = true;
/* 292 */         break;
/*     */       }
/*     */ 
/* 296 */       if (this.hierarchy[i].actionType == 0)
/*     */       {
/*     */         break;
/*     */       }
/*     */     }
/* 301 */     return result;
/*     */   }
/*     */ 
/*     */   public void pack(OutputBuffer state)
/*     */     throws IOException
/*     */   {
/* 310 */     state.packInt(this.currentDepth);
/*     */ 
/* 312 */     for (int i = 0; i < this.currentDepth; i++)
/*     */     {
/* 314 */       this.hierarchy[i].actionUid.pack(state);
/* 315 */       state.packInt(this.hierarchy[i].actionType);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void unpack(InputBuffer state)
/*     */     throws IOException
/*     */   {
/* 328 */     int newDepth = 0;
/* 329 */     ActionHierarchy newHier = null;
/* 330 */     ActionInfo temp = new ActionInfo();
/*     */ 
/* 332 */     newDepth = state.unpackInt();
/*     */     try
/*     */     {
/* 336 */       newHier = new ActionHierarchy(newDepth);
/*     */     }
/*     */     catch (OutOfMemoryError ex)
/*     */     {
/* 340 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.coordinator.ActionHierarchy_1"));
/*     */     }
/*     */ 
/* 343 */     for (int i = 0; i < newDepth; i++)
/*     */     {
/* 345 */       temp.actionUid.unpack(state);
/* 346 */       temp.actionType = state.unpackInt();
/*     */ 
/* 348 */       newHier.add(temp.actionUid, temp.actionType);
/*     */     }
/*     */ 
/* 357 */     this.hierarchy = newHier.hierarchy;
/* 358 */     this.currentDepth = newHier.currentDepth;
/* 359 */     this.maxHierarchyDepth = newHier.maxHierarchyDepth;
/*     */ 
/* 361 */     newHier.hierarchy = null;
/* 362 */     newHier = null;
/*     */   }
/*     */ 
/*     */   public final void forgetDeepest()
/*     */   {
/* 371 */     if (this.currentDepth > 0)
/*     */     {
/* 373 */       this.hierarchy[(--this.currentDepth)] = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final int findCommonPrefix(ActionHierarchy oldHierarchy)
/*     */   {
/* 385 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 387 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "ActionHierarchy::findCommonPrefix()");
/*     */     }
/*     */ 
/* 391 */     int common = 0;
/* 392 */     int max = oldHierarchy.depth();
/*     */ 
/* 394 */     while ((common < this.currentDepth) && (common < max) && (this.hierarchy[common].equals(oldHierarchy.getActionInfo(common))))
/*     */     {
/* 397 */       common++;
/*     */     }
/*     */ 
/* 400 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 402 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "ActionHierarchy::::findCommonPrefix(): prefix is " + common);
/*     */     }
/*     */ 
/* 407 */     return common;
/*     */   }
/*     */ 
/*     */   public final synchronized int depth()
/*     */   {
/* 418 */     return this.currentDepth;
/*     */   }
/*     */ 
/*     */   public final synchronized Uid getDeepestActionUid()
/*     */   {
/* 429 */     if (this.currentDepth > 0) {
/* 430 */       return this.hierarchy[(this.currentDepth - 1)].actionUid;
/*     */     }
/* 432 */     return Uid.nullUid();
/*     */   }
/*     */ 
/*     */   public final synchronized Uid getActionUid(int typeIndex)
/*     */   {
/* 442 */     return this.hierarchy[typeIndex].actionUid;
/*     */   }
/*     */ 
/*     */   public final synchronized ActionInfo getActionInfo(int typeIndex)
/*     */   {
/* 453 */     return this.hierarchy[typeIndex];
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.ActionHierarchy
 * JD-Core Version:    0.6.0
 */