/*      */ package com.arjuna.ats.arjuna.coordinator;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.StateManager;
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*      */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*      */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*      */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*      */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.ats.arjuna.utils.ThreadUtil;
/*      */ import com.arjuna.ats.arjuna.utils.Utility;
/*      */ import com.arjuna.ats.internal.arjuna.thread.ThreadActionData;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import java.io.IOException;
/*      */ import java.util.Collection;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.ResourceBundle;
/*      */ 
/*      */ public class BasicAction extends StateManager
/*      */ {
/*      */   protected RecordList pendingList;
/*      */   protected RecordList preparedList;
/*      */   protected RecordList readonlyList;
/*      */   protected RecordList failedList;
/*      */   protected RecordList heuristicList;
/*      */   protected boolean savedIntentionList;
/*      */   private ActionHierarchy currentHierarchy;
/*      */   private ObjectStore currentStore;
/*      */   private int actionStatus;
/*      */   private int actionType;
/*      */   private BasicAction parentAction;
/*      */   private AbstractRecord recordBeingHandled;
/*      */   private int heuristicDecision;
/*      */   private CheckedAction _checkedAction;
/*      */   private Hashtable _childThreads;
/*      */   private Hashtable _childActions;
/*      */ 
/*      */   public BasicAction()
/*      */   {
/*  288 */     super(2);
/*      */ 
/*  290 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  292 */       tsLogger.arjLogger.debug(1L, 4L, 1L, "BasicAction::BasicAction()");
/*      */     }
/*      */ 
/*  295 */     this.pendingList = null;
/*  296 */     this.preparedList = null;
/*  297 */     this.readonlyList = null;
/*  298 */     this.failedList = null;
/*  299 */     this.heuristicList = null;
/*      */ 
/*  301 */     this.currentHierarchy = null;
/*  302 */     this.currentStore = null;
/*  303 */     this.savedIntentionList = false;
/*      */ 
/*  305 */     this.actionStatus = 8;
/*  306 */     this.actionType = 1;
/*      */ 
/*  308 */     this.parentAction = null;
/*  309 */     this.recordBeingHandled = null;
/*      */ 
/*  311 */     this.heuristicDecision = 0;
/*  312 */     this._checkedAction = new CheckedAction();
/*      */ 
/*  314 */     this._childThreads = null;
/*  315 */     this._childActions = null;
/*      */   }
/*      */ 
/*      */   public BasicAction(Uid objUid)
/*      */   {
/*  325 */     super(objUid, 2);
/*      */ 
/*  327 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  329 */       tsLogger.arjLogger.debug(1L, 4L, 1L, "BasicAction::BasicAction(" + objUid + ")");
/*      */     }
/*      */ 
/*  333 */     this.pendingList = null;
/*  334 */     this.preparedList = null;
/*  335 */     this.readonlyList = null;
/*  336 */     this.failedList = null;
/*  337 */     this.heuristicList = null;
/*      */ 
/*  339 */     this.currentHierarchy = null;
/*  340 */     this.currentStore = null;
/*  341 */     this.savedIntentionList = false;
/*      */ 
/*  343 */     this.actionStatus = 8;
/*  344 */     this.actionType = 1;
/*      */ 
/*  346 */     this.parentAction = null;
/*  347 */     this.recordBeingHandled = null;
/*      */ 
/*  349 */     this.heuristicDecision = 0;
/*  350 */     this._checkedAction = new CheckedAction();
/*      */ 
/*  352 */     this._childThreads = null;
/*  353 */     this._childActions = null;
/*      */   }
/*      */ 
/*      */   public void finalize()
/*      */   {
/*  368 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  370 */       tsLogger.arjLogger.debug(2L, 4L, 1L, "BasicAction::finalize()");
/*      */     }
/*      */ 
/*  373 */     if ((this.actionStatus == 0) || (this.actionStatus == 3))
/*      */     {
/*  378 */       BasicAction currentAct = Current();
/*      */ 
/*  380 */       if ((currentAct != null) && (currentAct != this))
/*      */       {
/*  390 */         if (currentAct.isAncestor(get_uid()))
/*      */         {
/*  392 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  394 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_1", new Object[] { get_uid() });
/*      */           }
/*      */ 
/*  398 */           while ((currentAct != this) && (currentAct != null))
/*      */           {
/*  400 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */             {
/*  402 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_2", new Object[] { currentAct.get_uid() });
/*      */             }
/*      */ 
/*  406 */             currentAct.Abort();
/*      */ 
/*  408 */             currentAct = Current();
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/*  413 */       BasicAction parentAct = parent();
/*      */ 
/*  417 */       while (parentAct != null)
/*      */       {
/*  419 */         parentAct.preventCommit();
/*  420 */         parentAct = parentAct.parent();
/*      */       }
/*      */ 
/*  423 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/*  425 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_3", new Object[] { get_uid() });
/*      */       }
/*      */ 
/*  431 */       Abort();
/*      */     }
/*  435 */     else if (this.actionStatus == 5) {
/*  436 */       Thread.yield();
/*      */     }
/*      */ 
/*  439 */     this.pendingList = null;
/*  440 */     this.preparedList = null;
/*  441 */     this.readonlyList = null;
/*  442 */     this.failedList = null;
/*  443 */     this.heuristicList = null;
/*      */ 
/*  445 */     this.currentStore = null;
/*  446 */     this.currentHierarchy = null;
/*      */ 
/*  448 */     this._checkedAction = null;
/*      */ 
/*  450 */     if (this._childThreads != null)
/*      */     {
/*  452 */       this._childThreads.clear();
/*  453 */       this._childThreads = null;
/*      */     }
/*      */ 
/*  456 */     if (this._childActions != null)
/*      */     {
/*  458 */       this._childActions.clear();
/*  459 */       this._childActions = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public final synchronized ActionHierarchy getHierarchy()
/*      */   {
/*  469 */     return this.currentHierarchy;
/*      */   }
/*      */ 
/*      */   public final boolean preventCommit()
/*      */   {
/*  482 */     boolean res = false;
/*      */ 
/*  486 */     if (this.actionStatus == 0) {
/*  487 */       this.actionStatus = 3;
/*      */     }
/*  489 */     res = this.actionStatus == 3;
/*      */ 
/*  494 */     return res;
/*      */   }
/*      */ 
/*      */   public final int activeThreads()
/*      */   {
/*  503 */     if (this._childThreads != null) {
/*  504 */       return this._childThreads.size();
/*      */     }
/*  506 */     return 0;
/*      */   }
/*      */ 
/*      */   public final synchronized int add(AbstractRecord A)
/*      */   {
/*  519 */     int result = 3;
/*      */ 
/*  521 */     criticalStart();
/*      */ 
/*  523 */     if ((this.actionStatus <= 2) && ((this.recordBeingHandled == null) || (!this.recordBeingHandled.equals(A))))
/*      */     {
/*  526 */       if (this.pendingList == null) {
/*  527 */         this.pendingList = new RecordList();
/*      */       }
/*  529 */       result = this.pendingList.insert(A) ? 2 : 4;
/*      */     }
/*      */ 
/*  533 */     criticalEnd();
/*      */ 
/*  535 */     return result;
/*      */   }
/*      */ 
/*      */   public final synchronized int hierarchyDepth()
/*      */   {
/*  544 */     if (this.currentHierarchy != null) {
/*  545 */       return this.currentHierarchy.depth();
/*      */     }
/*  547 */     return 0;
/*      */   }
/*      */ 
/*      */   public final boolean isAncestor(Uid ancestor)
/*      */   {
/*  560 */     boolean res = false;
/*      */ 
/*  562 */     if (get_uid().equals(ancestor)) {
/*  563 */       res = true;
/*      */     }
/*  566 */     else if ((this.parentAction != null) && (this.actionType != 0)) {
/*  567 */       res = this.parentAction.isAncestor(ancestor);
/*      */     }
/*      */ 
/*  570 */     return res;
/*      */   }
/*      */ 
/*      */   public final BasicAction parent()
/*      */   {
/*  579 */     if (this.actionType == 1) {
/*  580 */       return this.parentAction;
/*      */     }
/*  582 */     return null;
/*      */   }
/*      */ 
/*      */   public final int typeOfAction()
/*      */   {
/*  587 */     return this.actionType;
/*      */   }
/*      */ 
/*      */   public final int status()
/*      */   {
/*  596 */     int s = 9;
/*      */ 
/*  600 */     s = this.actionStatus;
/*      */ 
/*  605 */     return s;
/*      */   }
/*      */ 
/*      */   public ObjectStore getStore()
/*      */   {
/*  617 */     if (this.currentStore == null)
/*      */     {
/*  619 */       this.currentStore = TxControl.getStore();
/*      */     }
/*      */ 
/*  622 */     return this.currentStore;
/*      */   }
/*      */ 
/*      */   public final ObjectStore store()
/*      */   {
/*  627 */     return getStore();
/*      */   }
/*      */ 
/*      */   public final Uid topLevelActionUid()
/*      */   {
/*  640 */     BasicAction root = this;
/*      */ 
/*  642 */     while (root.parent() != null) {
/*  643 */       root = root.parent();
/*      */     }
/*  645 */     return root.get_uid();
/*      */   }
/*      */ 
/*      */   public final BasicAction topLevelAction()
/*      */   {
/*  656 */     BasicAction root = this;
/*      */ 
/*  658 */     while (root.parent() != null) {
/*  659 */       root = root.parent();
/*      */     }
/*  661 */     return root;
/*      */   }
/*      */ 
/*      */   public boolean activate()
/*      */   {
/*  674 */     return activate(null);
/*      */   }
/*      */ 
/*      */   public boolean activate(String root)
/*      */   {
/*  688 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  690 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "BasicAction::activate() for action-id " + get_uid());
/*      */     }
/*      */ 
/*  694 */     boolean restored = false;
/*      */ 
/*  697 */     ObjectStore aaStore = store();
/*      */ 
/*  699 */     if (aaStore == null) {
/*  700 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  706 */       InputObjectState oState = aaStore.read_committed(getSavingUid(), type());
/*      */ 
/*  708 */       if (oState != null)
/*      */       {
/*  710 */         synchronized (this)
/*      */         {
/*  712 */           restored = restore_state(oState, 1);
/*      */         }
/*      */ 
/*  715 */         oState = null;
/*      */       }
/*      */       else
/*      */       {
/*  719 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  721 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_5", new Object[] { get_uid(), type() });
/*      */         }
/*      */ 
/*  725 */         restored = false;
/*      */       }
/*      */ 
/*  728 */       return restored;
/*      */     }
/*      */     catch (ObjectStoreException e)
/*      */     {
/*  732 */       if (tsLogger.arjLogger.isWarnEnabled())
/*  733 */         tsLogger.arjLogger.warn(e.getMessage());
/*      */     }
/*  735 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean deactivate()
/*      */   {
/*  752 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  754 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "BasicAction::deactivate() for action-id " + get_uid());
/*      */     }
/*      */ 
/*  758 */     boolean deactivated = false;
/*      */ 
/*  761 */     ObjectStore aaStore = store();
/*      */ 
/*  763 */     if (aaStore == null) {
/*  764 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  769 */       OutputObjectState oState = new OutputObjectState();
/*      */ 
/*  771 */       if (save_state(oState, 1))
/*      */       {
/*  773 */         if (aaStore.write_committed(getSavingUid(), type(), oState))
/*      */         {
/*  775 */           deactivated = true;
/*      */         }
/*      */         else
/*      */         {
/*  779 */           deactivated = false;
/*      */         }
/*      */ 
/*  782 */         oState = null;
/*      */       }
/*      */       else
/*      */       {
/*  786 */         deactivated = false;
/*      */       }
/*      */ 
/*  790 */       if (!deactivated)
/*      */       {
/*  792 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  794 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_5", new Object[] { get_uid(), type() });
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ObjectStoreException e)
/*      */     {
/*  801 */       if (tsLogger.arjLogger.isWarnEnabled()) {
/*  802 */         tsLogger.arjLogger.warn(e.getMessage());
/*      */       }
/*  804 */       deactivated = false;
/*      */     }
/*      */ 
/*  807 */     return deactivated;
/*      */   }
/*      */ 
/*      */   public final boolean addChildThread()
/*      */   {
/*  820 */     return addChildThread(Thread.currentThread());
/*      */   }
/*      */ 
/*      */   public final boolean addChildThread(Thread t)
/*      */   {
/*  833 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  835 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_6", new Object[] { get_uid(), t });
/*      */     }
/*      */ 
/*  839 */     if (t == null) {
/*  840 */       return false;
/*      */     }
/*  842 */     boolean result = false;
/*      */ 
/*  844 */     criticalStart();
/*      */ 
/*  846 */     synchronized (this)
/*      */     {
/*  848 */       if (this.actionStatus <= 2)
/*      */       {
/*  850 */         if (this._childThreads == null) {
/*  851 */           this._childThreads = new Hashtable();
/*      */         }
/*  853 */         this._childThreads.put(ThreadUtil.getThreadId(t), t);
/*      */ 
/*  856 */         result = true;
/*      */       }
/*      */     }
/*      */ 
/*  860 */     criticalEnd();
/*      */ 
/*  862 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  864 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_7", new Object[] { get_uid(), t, new Boolean(result) });
/*      */     }
/*      */ 
/*  868 */     return result;
/*      */   }
/*      */ 
/*      */   public final boolean removeChildThread()
/*      */   {
/*  884 */     return removeChildThread(ThreadUtil.getThreadId());
/*      */   }
/*      */ 
/*      */   public final boolean removeChildThread(String threadId)
/*      */   {
/*  896 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  898 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_8", new Object[] { get_uid(), threadId });
/*      */     }
/*      */ 
/*  902 */     if (threadId == null) {
/*  903 */       return false;
/*      */     }
/*  905 */     boolean result = false;
/*      */ 
/*  907 */     criticalStart();
/*      */ 
/*  909 */     synchronized (this)
/*      */     {
/*  911 */       if (this._childThreads != null)
/*      */       {
/*  913 */         this._childThreads.remove(threadId);
/*  914 */         result = true;
/*      */       }
/*      */     }
/*      */ 
/*  918 */     criticalEnd();
/*      */ 
/*  920 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  922 */       if (result) {
/*  923 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_9", new Object[] { get_uid(), threadId, "true" });
/*      */       }
/*      */       else {
/*  926 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_9", new Object[] { get_uid(), threadId, "false" });
/*      */       }
/*      */     }
/*      */ 
/*  930 */     return result;
/*      */   }
/*      */ 
/*      */   public final boolean addChildAction(BasicAction act)
/*      */   {
/*  942 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  944 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_10", new Object[] { get_uid(), act != null ? act.get_uid() : Uid.nullUid() });
/*      */     }
/*      */ 
/*  948 */     if (act == null) {
/*  949 */       return false;
/*      */     }
/*  951 */     boolean result = false;
/*      */ 
/*  953 */     criticalStart();
/*      */ 
/*  955 */     synchronized (this)
/*      */     {
/*  962 */       if (this.actionStatus <= 2)
/*      */       {
/*  964 */         if (this._childActions == null) {
/*  965 */           this._childActions = new Hashtable();
/*      */         }
/*  967 */         this._childActions.put(act, act);
/*  968 */         result = true;
/*      */       }
/*      */     }
/*      */ 
/*  972 */     criticalEnd();
/*      */ 
/*  974 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  976 */       if (result) {
/*  977 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_11", new Object[] { get_uid(), act.get_uid(), "true" });
/*      */       }
/*      */       else {
/*  980 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_11", new Object[] { get_uid(), act.get_uid(), "false" });
/*      */       }
/*      */     }
/*      */ 
/*  984 */     return result;
/*      */   }
/*      */ 
/*      */   public final boolean removeChildAction(BasicAction act)
/*      */   {
/* 1000 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/* 1002 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_12", new Object[] { get_uid(), act != null ? act.get_uid() : Uid.nullUid() });
/*      */     }
/*      */ 
/* 1006 */     if (act == null) {
/* 1007 */       return false;
/*      */     }
/* 1009 */     boolean result = false;
/*      */ 
/* 1011 */     criticalStart();
/*      */ 
/* 1013 */     synchronized (this)
/*      */     {
/* 1015 */       if (this._childActions != null)
/*      */       {
/* 1017 */         this._childActions.remove(act);
/* 1018 */         result = true;
/*      */       }
/*      */     }
/*      */ 
/* 1022 */     criticalEnd();
/*      */ 
/* 1024 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/* 1026 */       if (result) {
/* 1027 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_13", new Object[] { get_uid(), act.get_uid(), "true" });
/*      */       }
/*      */       else {
/* 1030 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_13", new Object[] { get_uid(), act.get_uid(), "false" });
/*      */       }
/*      */     }
/*      */ 
/* 1034 */     return result;
/*      */   }
/*      */ 
/*      */   public final synchronized CheckedAction setCheckedAction(CheckedAction c)
/*      */   {
/* 1046 */     criticalStart();
/*      */ 
/* 1048 */     CheckedAction toReturn = this._checkedAction;
/*      */ 
/* 1050 */     this._checkedAction = c;
/*      */ 
/* 1052 */     criticalEnd();
/*      */ 
/* 1054 */     return toReturn;
/*      */   }
/*      */ 
/*      */   public Uid getSavingUid()
/*      */   {
/* 1064 */     return get_uid();
/*      */   }
/*      */ 
/*      */   public String toString()
/*      */   {
/* 1073 */     return new String("BasicAction: " + get_uid() + " status: " + ActionStatus.stringForm(this.actionStatus));
/*      */   }
/*      */ 
/*      */   public boolean save_state(OutputObjectState os, int ot)
/*      */   {
/* 1117 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1119 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "BasicAction::save_state ()");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1124 */       packHeader(os, get_uid(), Utility.getProcessUid());
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1128 */       return false;
/*      */     }
/*      */ 
/* 1141 */     RecordList listToSave = null;
/* 1142 */     boolean res = true;
/*      */ 
/* 1149 */     if ((this.failedList != null) && (this.failedList.size() > 0))
/*      */     {
/* 1151 */       listToSave = this.failedList;
/*      */     }
/*      */     else
/*      */     {
/* 1155 */       listToSave = this.preparedList;
/*      */     }
/*      */ 
/* 1158 */     AbstractRecord first = listToSave != null ? listToSave.getFront() : null;
/*      */ 
/* 1160 */     AbstractRecord temp = first;
/* 1161 */     boolean havePacked = listToSave != null;
/*      */ 
/* 1163 */     while ((res) && (temp != null))
/*      */     {
/* 1165 */       listToSave.putRear(temp);
/*      */ 
/* 1181 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */       {
/* 1183 */         if (temp.doSave()) {
/* 1184 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_14", new Object[] { Integer.toString(temp.typeIs()), temp.type(), "true" });
/*      */         }
/*      */         else {
/* 1187 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_14", new Object[] { Integer.toString(temp.typeIs()), temp.type(), "false" });
/*      */         }
/*      */       }
/*      */ 
/* 1191 */       if (temp.doSave())
/*      */       {
/* 1193 */         res = true;
/*      */         try
/*      */         {
/* 1197 */           if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */           {
/* 1199 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_15", new Object[] { Integer.toString(temp.typeIs()) });
/*      */           }
/*      */ 
/* 1203 */           os.packInt(temp.typeIs());
/* 1204 */           res = temp.save_state(os, ot);
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/* 1208 */           res = false;
/*      */         }
/*      */       }
/*      */ 
/* 1212 */       temp = listToSave.getFront();
/*      */ 
/* 1214 */       if (temp != first)
/*      */         continue;
/* 1216 */       listToSave.putFront(temp);
/* 1217 */       temp = null;
/*      */     }
/*      */ 
/* 1226 */     if ((res) && ((os.notempty()) || (!havePacked)))
/*      */     {
/*      */       try
/*      */       {
/* 1230 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 1232 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_16");
/*      */         }
/*      */ 
/* 1235 */         os.packInt(463);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1239 */         res = false;
/*      */       }
/*      */     }
/*      */ 
/* 1243 */     if (res)
/*      */     {
/* 1247 */       int hSize = this.heuristicList == null ? 0 : this.heuristicList.size();
/*      */       try
/*      */       {
/* 1251 */         os.packInt(hSize);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1255 */         res = false;
/*      */       }
/*      */ 
/* 1258 */       if ((res) && (hSize > 0))
/*      */       {
/* 1260 */         first = this.heuristicList.getFront();
/* 1261 */         temp = first;
/*      */ 
/* 1263 */         while ((res) && (temp != null))
/*      */         {
/* 1265 */           this.heuristicList.putRear(temp);
/*      */ 
/* 1267 */           if (temp.doSave())
/*      */           {
/* 1269 */             res = true;
/*      */             try
/*      */             {
/* 1273 */               if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */               {
/* 1275 */                 tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_17", new Object[] { Integer.toString(temp.typeIs()) });
/*      */               }
/*      */ 
/* 1279 */               os.packInt(temp.typeIs());
/* 1280 */               res = temp.save_state(os, ot);
/*      */             }
/*      */             catch (IOException e)
/*      */             {
/* 1284 */               res = false;
/*      */             }
/*      */           }
/*      */ 
/* 1288 */           temp = this.heuristicList.getFront();
/*      */ 
/* 1290 */           if (temp != first)
/*      */             continue;
/* 1292 */           this.heuristicList.putFront(temp);
/* 1293 */           temp = null;
/*      */         }
/*      */ 
/* 1297 */         if ((res) && (os.notempty()))
/*      */         {
/*      */           try
/*      */           {
/* 1301 */             if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */             {
/* 1303 */               tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_18");
/*      */             }
/*      */ 
/* 1306 */             os.packInt(463);
/*      */           }
/*      */           catch (IOException e)
/*      */           {
/* 1310 */             res = false;
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1316 */     if ((res) && (os.notempty()))
/*      */     {
/*      */       try
/*      */       {
/* 1320 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 1322 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_19", new Object[] { ActionStatus.stringForm(this.actionStatus) });
/*      */         }
/*      */ 
/* 1326 */         os.packInt(this.actionStatus);
/* 1327 */         os.packInt(this.actionType);
/* 1328 */         os.packInt(this.heuristicDecision);
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1332 */         res = false;
/*      */       }
/*      */     }
/*      */ 
/* 1336 */     return res;
/*      */   }
/*      */ 
/*      */   public boolean restore_state(InputObjectState os, int ot)
/*      */   {
/* 1348 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1350 */       tsLogger.arjLogger.debug(16L, 4L, 1L, "BasicAction::restore_state ()");
/*      */     }
/*      */ 
/* 1353 */     createPreparedLists();
/*      */ 
/* 1355 */     boolean res = true;
/* 1356 */     int record_type = 463;
/* 1357 */     int tempActionStatus = 9;
/* 1358 */     int tempActionType = 0;
/* 1359 */     int tempHeuristicDecision = 0;
/*      */     try
/*      */     {
/* 1369 */       Uid txId = new Uid(Uid.nullUid());
/* 1370 */       Uid processUid = new Uid(Uid.nullUid());
/*      */ 
/* 1372 */       unpackHeader(os, txId, processUid);
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1376 */       return false;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1381 */       record_type = os.unpackInt();
/*      */ 
/* 1383 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */       {
/* 1385 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_20", new Object[] { Integer.toString(record_type) });
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (IOException e)
/*      */     {
/* 1391 */       res = false;
/*      */     }
/*      */ 
/* 1394 */     while ((res) && (record_type != 463))
/*      */     {
/* 1396 */       RecoveryAbstractRecord recRecord = new RecoveryAbstractRecord(RecordType.typeToClassName(record_type), record_type, true);
/*      */ 
/* 1398 */       AbstractRecord record = recRecord.record();
/*      */ 
/* 1400 */       if (record == null)
/*      */       {
/* 1402 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 1404 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_21", new Object[] { Integer.toString(record_type) });
/*      */         }
/*      */ 
/* 1408 */         res = false;
/*      */       }
/*      */       else {
/* 1411 */         res = (record.restore_state(os, ot)) && (this.preparedList.insert(record));
/*      */       }
/* 1413 */       if (res)
/*      */       {
/*      */         try
/*      */         {
/* 1417 */           record_type = os.unpackInt();
/*      */ 
/* 1419 */           if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */           {
/* 1421 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_20", new Object[] { Integer.toString(record_type) });
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/* 1427 */           res = false;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1434 */     int hSize = 0;
/*      */ 
/* 1436 */     if (res)
/*      */     {
/*      */       try
/*      */       {
/* 1440 */         hSize = os.unpackInt();
/*      */ 
/* 1442 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 1444 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_22", new Object[] { Integer.toString(hSize) });
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1450 */         res = false;
/*      */       }
/*      */     }
/*      */ 
/* 1454 */     if (hSize > 0)
/*      */     {
/*      */       try
/*      */       {
/* 1458 */         record_type = os.unpackInt();
/*      */ 
/* 1460 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 1462 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_23", new Object[] { Integer.toString(record_type) });
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1468 */         res = false;
/*      */       }
/*      */ 
/* 1471 */       while ((res) && (record_type != 463))
/*      */       {
/* 1473 */         RecoveryAbstractRecord record = new RecoveryAbstractRecord(RecordType.typeToClassName(record_type), record_type, true);
/*      */ 
/* 1477 */         res = (record.restore_state(os, ot)) && (this.heuristicList.insert(record));
/*      */         try
/*      */         {
/* 1481 */           record_type = os.unpackInt();
/*      */ 
/* 1483 */           if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */           {
/* 1485 */             tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_23", new Object[] { Integer.toString(record_type) });
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/* 1491 */           res = false;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1496 */     if (res)
/*      */     {
/*      */       try
/*      */       {
/* 1500 */         tempActionStatus = os.unpackInt();
/* 1501 */         tempActionType = os.unpackInt();
/* 1502 */         tempHeuristicDecision = os.unpackInt();
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/* 1506 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1507 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_24");
/*      */         }
/* 1509 */         res = false;
/*      */       }
/*      */     }
/*      */ 
/* 1513 */     if (res)
/*      */     {
/* 1515 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */       {
/* 1517 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_25", new Object[] { ActionStatus.stringForm(tempActionStatus), Integer.toString(tempActionStatus) });
/*      */ 
/* 1520 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_26", new Object[] { tempActionType == 1 ? "Nested" : "Top-level", Integer.toString(tempActionType) });
/*      */ 
/* 1524 */         tsLogger.arjLoggerI18N.debug(16L, 4L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_27", new Object[] { TwoPhaseOutcome.stringForm(tempHeuristicDecision), Integer.toString(tempHeuristicDecision) });
/*      */       }
/*      */ 
/* 1528 */       this.actionStatus = tempActionStatus;
/* 1529 */       this.actionType = tempActionType;
/* 1530 */       this.heuristicDecision = tempHeuristicDecision;
/* 1531 */       this.savedIntentionList = true;
/*      */     }
/*      */ 
/* 1534 */     return res;
/*      */   }
/*      */ 
/*      */   public String type()
/*      */   {
/* 1543 */     return "/StateManager/BasicAction";
/*      */   }
/*      */ 
/*      */   public static BasicAction Current()
/*      */   {
/* 1552 */     return ThreadActionData.currentAction();
/*      */   }
/*      */ 
/*      */   public static boolean maintainHeuristics()
/*      */   {
/* 1568 */     return TxControl.maintainHeuristics;
/*      */   }
/*      */ 
/*      */   public boolean destroy()
/*      */   {
/* 1581 */     return true;
/*      */   }
/*      */ 
/*      */   public final Object[] childTransactions()
/*      */   {
/* 1592 */     int size = this._childActions.size();
/*      */ 
/* 1594 */     if (size > 0)
/*      */     {
/* 1596 */       Collection c = this._childActions.values();
/*      */ 
/* 1598 */       return c.toArray();
/*      */     }
/*      */ 
/* 1601 */     return null;
/*      */   }
/*      */ 
/*      */   public boolean equals(Object obj)
/*      */   {
/* 1606 */     if ((obj instanceof BasicAction))
/*      */     {
/* 1608 */       if (((BasicAction)obj).get_uid().equals(get_uid())) {
/* 1609 */         return true;
/*      */       }
/*      */     }
/* 1612 */     return false;
/*      */   }
/*      */ 
/*      */   protected boolean forgetHeuristics()
/*      */   {
/* 1625 */     if ((this.heuristicList != null) && (this.heuristicList.size() > 0))
/*      */     {
/* 1627 */       doForget(this.heuristicList);
/* 1628 */       updateState();
/*      */ 
/* 1631 */       return this.heuristicList.size() == 0;
/*      */     }
/*      */ 
/* 1636 */     return true;
/*      */   }
/*      */ 
/*      */   protected synchronized int Begin(BasicAction parentAct)
/*      */   {
/* 1648 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1650 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::Begin() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 1654 */     if (this.actionStatus != 8)
/*      */     {
/* 1656 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 1658 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_29", new Object[] { get_uid(), ActionStatus.stringForm(this.actionStatus) });
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1664 */       actionInitialise(parentAct);
/* 1665 */       this.actionStatus = 0;
/*      */ 
/* 1667 */       if ((this.actionType != 0) && ((parentAct == null) || (parentAct.status() > 0)))
/*      */       {
/* 1670 */         this.actionStatus = 3;
/*      */ 
/* 1672 */         if (parentAct == null)
/*      */         {
/* 1674 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/* 1676 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_30", new Object[] { get_uid() });
/*      */           }
/*      */ 
/*      */         }
/* 1682 */         else if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 1684 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_31", new Object[] { get_uid(), parentAct.get_uid(), Integer.toString(parentAct.status()) });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1690 */       ActionManager.manager().put(this);
/*      */ 
/* 1692 */       if (TxControl.enableStatistics)
/*      */       {
/* 1694 */         TxStats.incrementTransactions();
/*      */ 
/* 1696 */         if (parentAct != null) {
/* 1697 */           TxStats.incrementNestedTransactions();
/*      */         }
/*      */       }
/*      */     }
/* 1701 */     return this.actionStatus;
/*      */   }
/*      */ 
/*      */   protected synchronized int End(boolean reportHeuristics)
/*      */   {
/* 1726 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 1728 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::End() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 1734 */     if ((this.actionStatus != 0) && (this.actionStatus != 3))
/*      */     {
/* 1737 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 1739 */         switch (this.actionStatus)
/*      */         {
/*      */         case 8:
/* 1742 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_33", new Object[] { get_uid() });
/*      */ 
/* 1744 */           break;
/*      */         case 7:
/* 1746 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_34", new Object[] { get_uid() });
/*      */ 
/* 1748 */           break;
/*      */         default:
/* 1750 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_35", new Object[] { get_uid() });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1756 */       return this.actionStatus;
/*      */     }
/*      */ 
/* 1764 */     if ((!checkIsCurrent()) || (checkChildren(true)) || (this.actionStatus == 3))
/*      */     {
/* 1767 */       return Abort();
/*      */     }
/*      */ 
/* 1770 */     if (this.pendingList != null)
/*      */     {
/* 1777 */       if (doOnePhase())
/*      */       {
/* 1779 */         onePhaseCommit(reportHeuristics);
/*      */ 
/* 1781 */         ActionManager.manager().remove(get_uid());
/*      */       }
/* 1785 */       else if (prepare(reportHeuristics) == 1)
/*      */       {
/* 1787 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 1789 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_36", new Object[] { get_uid() });
/*      */         }
/*      */ 
/* 1793 */         if (this.heuristicDecision != 0)
/*      */         {
/* 1795 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/* 1797 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_37", new Object[] { TwoPhaseOutcome.stringForm(this.heuristicDecision) });
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 1802 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 1803 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_38");
/*      */         }
/* 1805 */         if ((!reportHeuristics) && (TxControl.asyncCommit) && (this.parentAction == null))
/*      */         {
/* 1808 */           AsyncCommit.create(this, false);
/*      */         }
/*      */         else {
/* 1811 */           phase2Abort(reportHeuristics);
/*      */         }
/*      */ 
/*      */       }
/* 1815 */       else if ((!reportHeuristics) && (TxControl.asyncCommit) && (this.parentAction == null))
/*      */       {
/* 1818 */         AsyncCommit.create(this, true);
/*      */       }
/*      */       else {
/* 1821 */         phase2Commit(reportHeuristics);
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 1827 */       ActionManager.manager().remove(get_uid());
/*      */ 
/* 1829 */       this.actionStatus = 7;
/*      */     }
/*      */ 
/* 1832 */     boolean returnCurrentStatus = false;
/*      */ 
/* 1834 */     if ((reportHeuristics) || ((!reportHeuristics) && (!TxControl.asyncCommit))) {
/* 1835 */       returnCurrentStatus = true;
/*      */     }
/* 1837 */     if (TxControl.enableStatistics) {
/* 1838 */       TxStats.incrementCommittedTransactions();
/*      */     }
/* 1840 */     if (returnCurrentStatus)
/*      */     {
/* 1842 */       if (reportHeuristics)
/*      */       {
/* 1844 */         switch (this.heuristicDecision)
/*      */         {
/*      */         case 0:
/*      */         case 7:
/* 1848 */           break;
/*      */         case 3:
/* 1850 */           return 11;
/*      */         case 4:
/* 1852 */           return 12;
/*      */         case 5:
/* 1854 */           return 13;
/*      */         case 1:
/*      */         case 2:
/*      */         case 6:
/*      */         default:
/* 1857 */           return 14;
/*      */         }
/*      */       }
/*      */ 
/* 1861 */       return this.actionStatus;
/*      */     }
/*      */ 
/* 1864 */     return 6;
/*      */   }
/*      */ 
/*      */   protected synchronized int Abort()
/*      */   {
/* 1879 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 1881 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::Abort() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 1887 */     if ((this.actionStatus != 0) && (this.actionStatus != 3) && (this.actionStatus != 6))
/*      */     {
/* 1891 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 1893 */         switch (this.actionStatus)
/*      */         {
/*      */         case 8:
/* 1896 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_39", new Object[] { get_uid() });
/*      */ 
/* 1898 */           break;
/*      */         case 4:
/* 1900 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_40", new Object[] { get_uid() });
/*      */ 
/* 1902 */           break;
/*      */         default:
/* 1904 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_41", new Object[] { get_uid() });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 1910 */       return this.actionStatus;
/*      */     }
/*      */ 
/* 1918 */     checkIsCurrent();
/*      */ 
/* 1924 */     checkChildren(false);
/*      */ 
/* 1926 */     if (this.pendingList != null)
/*      */     {
/* 1928 */       this.actionStatus = 2;
/*      */ 
/* 1930 */       while (this.pendingList.size() > 0) {
/* 1931 */         doAbort(this.pendingList, false);
/*      */       }
/*      */ 
/* 1939 */       forgetHeuristics();
/*      */     }
/*      */ 
/* 1942 */     ActionManager.manager().remove(get_uid());
/*      */ 
/* 1944 */     this.actionStatus = 4;
/*      */ 
/* 1946 */     if (TxControl.enableStatistics) {
/* 1947 */       TxStats.incrementAbortedTransactions();
/*      */     }
/* 1949 */     return this.actionStatus;
/*      */   }
/*      */ 
/*      */   protected BasicAction(int at)
/*      */   {
/* 1958 */     super(2);
/*      */ 
/* 1960 */     this.pendingList = null;
/* 1961 */     this.preparedList = null;
/* 1962 */     this.readonlyList = null;
/* 1963 */     this.failedList = null;
/* 1964 */     this.heuristicList = null;
/*      */ 
/* 1966 */     this.currentHierarchy = null;
/* 1967 */     this.currentStore = null;
/* 1968 */     this.savedIntentionList = false;
/*      */ 
/* 1970 */     this.actionStatus = 8;
/* 1971 */     this.actionType = at;
/* 1972 */     this.parentAction = null;
/* 1973 */     this.recordBeingHandled = null;
/*      */ 
/* 1975 */     this.heuristicDecision = 0;
/* 1976 */     this._checkedAction = new CheckedAction();
/*      */ 
/* 1978 */     this._childThreads = null;
/* 1979 */     this._childActions = null;
/*      */   }
/*      */ 
/*      */   protected BasicAction(Uid u, int at, ObjectName objectName)
/*      */   {
/* 1984 */     super(u, at, objectName);
/*      */   }
/*      */ 
/*      */   protected BasicAction(Uid u, int at)
/*      */   {
/* 1993 */     super(u, 2);
/*      */ 
/* 1995 */     this.pendingList = null;
/* 1996 */     this.preparedList = null;
/* 1997 */     this.readonlyList = null;
/* 1998 */     this.failedList = null;
/* 1999 */     this.heuristicList = null;
/*      */ 
/* 2001 */     this.currentHierarchy = null;
/* 2002 */     this.currentStore = null;
/* 2003 */     this.savedIntentionList = false;
/*      */ 
/* 2005 */     this.actionStatus = 8;
/* 2006 */     this.actionType = at;
/* 2007 */     this.parentAction = null;
/* 2008 */     this.recordBeingHandled = null;
/*      */ 
/* 2010 */     this.heuristicDecision = 0;
/* 2011 */     this._checkedAction = new CheckedAction();
/*      */ 
/* 2013 */     this._childThreads = null;
/* 2014 */     this._childActions = null;
/*      */   }
/*      */ 
/*      */   protected final void criticalStart()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected final void criticalEnd()
/*      */   {
/*      */   }
/*      */ 
/*      */   protected final synchronized void phase2Cleanup()
/*      */   {
/* 2058 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 2060 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::phase2Cleanup() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 2064 */     criticalStart();
/*      */ 
/* 2066 */     this.actionStatus = 10;
/*      */ 
/* 2068 */     while ((this.preparedList != null) && (this.preparedList.size() > 0)) {
/* 2069 */       doCleanup(this.preparedList);
/*      */     }
/* 2071 */     while ((this.readonlyList != null) && (this.readonlyList.size() > 0)) {
/* 2072 */       doCleanup(this.readonlyList);
/*      */     }
/* 2074 */     while ((this.pendingList != null) && (this.pendingList.size() > 0)) {
/* 2075 */       doCleanup(this.pendingList);
/*      */     }
/* 2077 */     criticalEnd();
/*      */   }
/*      */ 
/*      */   protected final synchronized void phase2Commit(boolean reportHeuristics)
/*      */   {
/* 2098 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 2100 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::phase2Commit() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 2104 */     if ((this.pendingList != null) && (this.pendingList.size() > 0))
/*      */     {
/* 2106 */       int size = this.pendingList == null ? 0 : this.pendingList.size();
/*      */ 
/* 2108 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 2110 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_42", new Object[] { get_uid(), Integer.toString(size), this.pendingList });
/*      */       }
/*      */ 
/* 2114 */       phase2Abort(reportHeuristics);
/*      */     }
/*      */     else
/*      */     {
/* 2118 */       criticalStart();
/*      */ 
/* 2120 */       this.actionStatus = 6;
/*      */ 
/* 2129 */       doCommit(this.preparedList, reportHeuristics);
/*      */ 
/* 2140 */       if (this.heuristicDecision != 0)
/*      */       {
/* 2146 */         if (this.heuristicDecision == 4) {
/* 2147 */           this.heuristicDecision = 7;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2152 */       if ((this.readonlyList != null) && (this.readonlyList.size() > 0))
/*      */       {
/* 2154 */         while ((this.recordBeingHandled = this.readonlyList.getFront()) != null)
/*      */         {
/* 2156 */           if ((this.actionType == 1) && (this.recordBeingHandled.propagateOnCommit()))
/*      */           {
/* 2159 */             merge(this.recordBeingHandled); continue;
/*      */           }
/*      */ 
/* 2163 */           this.recordBeingHandled = null;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 2168 */       forgetHeuristics();
/*      */ 
/* 2170 */       this.actionStatus = 7;
/*      */ 
/* 2172 */       updateState();
/*      */ 
/* 2174 */       ActionManager.manager().remove(get_uid());
/*      */ 
/* 2176 */       criticalEnd();
/*      */     }
/*      */   }
/*      */ 
/*      */   protected final synchronized void phase2Abort(boolean reportHeuristics)
/*      */   {
/* 2196 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 2198 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::phase2Abort() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 2202 */     criticalStart();
/*      */ 
/* 2204 */     this.actionStatus = 2;
/*      */ 
/* 2206 */     if (this.preparedList != null) {
/* 2207 */       doAbort(this.preparedList, reportHeuristics);
/*      */     }
/* 2209 */     if (!TxControl.readonlyOptimisation)
/*      */     {
/* 2211 */       if (this.readonlyList != null) {
/* 2212 */         doAbort(this.readonlyList, reportHeuristics);
/*      */       }
/*      */     }
/* 2215 */     if (this.pendingList != null) {
/* 2216 */       doAbort(this.pendingList, reportHeuristics);
/*      */     }
/*      */ 
/* 2222 */     if (this.heuristicDecision != 0)
/*      */     {
/* 2224 */       if (this.heuristicDecision == 3) {
/* 2225 */         this.heuristicDecision = 7;
/*      */       }
/*      */     }
/* 2228 */     forgetHeuristics();
/*      */ 
/* 2230 */     this.actionStatus = abortStatus();
/*      */ 
/* 2232 */     updateState();
/*      */ 
/* 2235 */     ActionManager.manager().remove(get_uid());
/*      */ 
/* 2237 */     criticalEnd();
/*      */ 
/* 2244 */     if (TxControl.enableStatistics)
/* 2245 */       TxStats.incrementResourceRollbacks();
/*      */   }
/*      */ 
/*      */   protected final synchronized int prepare(boolean reportHeuristics)
/*      */   {
/* 2260 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 2262 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::prepare () for action-id " + get_uid());
/*      */     }
/*      */ 
/* 2266 */     boolean commitAllowed = this.actionStatus != 3;
/*      */ 
/* 2268 */     this.actionStatus = 1;
/*      */ 
/* 2272 */     if (!commitAllowed)
/*      */     {
/* 2274 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 2276 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_43", new Object[] { get_uid() });
/*      */       }
/*      */ 
/* 2280 */       this.actionStatus = 5;
/*      */ 
/* 2282 */       return 1;
/*      */     }
/*      */ 
/* 2289 */     if (this.actionType == 0)
/*      */     {
/* 2291 */       if (store() == null)
/*      */       {
/* 2293 */         this.actionStatus = 3;
/*      */ 
/* 2295 */         return 1;
/*      */       }
/*      */     }
/*      */ 
/* 2299 */     criticalStart();
/*      */ 
/* 2301 */     createPreparedLists();
/*      */ 
/* 2313 */     int p = 0;
/*      */ 
/* 2322 */     if ((this.actionType == 0) && (TxControl.asyncPrepare))
/*      */     {
/* 2324 */       int numberOfThreads = this.pendingList != null ? this.pendingList.size() : 0;
/*      */ 
/* 2326 */       Thread[] threads = new Thread[numberOfThreads];
/*      */ 
/* 2334 */       for (int i = 0; i < numberOfThreads; i++)
/*      */       {
/* 2336 */         threads[i] = AsyncPrepare.create(this, reportHeuristics, this.pendingList.getFront());
/*      */       }
/*      */ 
/* 2343 */       for (i = 0; i < numberOfThreads; i++)
/*      */       {
/* 2345 */         threads[i].start();
/* 2346 */         Thread.yield();
/*      */       }
/*      */ 
/* 2359 */       for (int j = 0; j < numberOfThreads; j++)
/*      */       {
/* 2361 */         while (threads[j].isAlive())
/*      */         {
/*      */           try
/*      */           {
/* 2365 */             threads[j].join();
/*      */           }
/*      */           catch (Exception e)
/*      */           {
/* 2369 */             if (tsLogger.arjLogger.isWarnEnabled())
/*      */             {
/* 2371 */               tsLogger.arjLogger.warn("BasicAction.prepare - " + e);
/*      */             }
/*      */ 
/* 2375 */             p = 1;
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 2383 */         if (p == 0) {
/* 2384 */           p = ((AsyncPrepare)threads[j]).outcome();
/*      */         }
/* 2386 */         threads[j] = null;
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/* 2391 */       boolean ok = true;
/*      */       do
/*      */       {
/*      */         try
/*      */         {
/* 2397 */           p = doPrepare(reportHeuristics);
/*      */ 
/* 2403 */           if ((p != 0) && (p != 2))
/*      */           {
/* 2406 */             ok = false;
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (IndexOutOfBoundsException e)
/*      */         {
/* 2413 */           ok = false;
/*      */         }
/*      */       }
/* 2416 */       while (ok);
/*      */     }
/*      */ 
/* 2419 */     if ((p != 0) && (p != 2))
/*      */     {
/* 2422 */       if ((this.actionType == 1) && (this.preparedList.size() > 0) && (p == 10))
/*      */       {
/* 2432 */         AbstractRecord tmpRec = this.preparedList.getFront();
/*      */ 
/* 2434 */         while (tmpRec != null)
/*      */         {
/* 2436 */           merge(tmpRec);
/* 2437 */           tmpRec = this.preparedList.getFront();
/*      */         }
/*      */ 
/* 2440 */         if (this.parentAction != null) {
/* 2441 */           this.parentAction.preventCommit();
/*      */         }
/* 2444 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 2445 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_44");
/*      */         }
/*      */       }
/*      */ 
/* 2449 */       criticalEnd();
/*      */ 
/* 2451 */       return 1;
/*      */     }
/*      */ 
/* 2465 */     boolean stateToSave = false;
/* 2466 */     RecordListIterator iter = new RecordListIterator(this.preparedList);
/*      */ 
/* 2472 */     while ((this.recordBeingHandled = iter.iterate()) != null)
/*      */     {
/* 2474 */       if (!stateToSave) {
/* 2475 */         stateToSave = this.recordBeingHandled.doSave();
/*      */       }
/* 2477 */       if (stateToSave) {
/* 2478 */         break;
/*      */       }
/*      */     }
/* 2481 */     iter = null;
/*      */ 
/* 2483 */     if (!stateToSave)
/*      */     {
/* 2485 */       iter = new RecordListIterator(this.heuristicList);
/*      */ 
/* 2491 */       while ((this.recordBeingHandled = this.heuristicList.getFront()) != null)
/*      */       {
/* 2493 */         if (!stateToSave) {
/* 2494 */           stateToSave = this.recordBeingHandled.doSave();
/*      */         }
/* 2496 */         if (stateToSave) {
/* 2497 */           break;
/*      */         }
/*      */       }
/* 2500 */       iter = null;
/*      */     }
/*      */ 
/* 2520 */     if (this.actionType == 0)
/* 2521 */       this.actionStatus = preparedStatus();
/*      */     else {
/* 2523 */       this.actionStatus = 5;
/*      */     }
/*      */ 
/* 2531 */     if ((this.actionType == 0) && (stateToSave) && ((this.preparedList.size() > 0) || (this.heuristicList.size() > 0)))
/*      */     {
/* 2536 */       Uid u = getSavingUid();
/* 2537 */       String tn = type();
/* 2538 */       OutputObjectState state = new OutputObjectState(u, tn);
/*      */ 
/* 2540 */       if (!save_state(state, 1))
/*      */       {
/* 2542 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 2544 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_45", new Object[] { get_uid() });
/*      */         }
/*      */ 
/* 2548 */         criticalEnd();
/*      */ 
/* 2550 */         return 1;
/*      */       }
/*      */ 
/* 2553 */       if (state.notempty())
/*      */       {
/*      */         try
/*      */         {
/* 2557 */           if (!this.currentStore.write_committed(u, tn, state))
/*      */           {
/* 2559 */             if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */             {
/* 2561 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_46", new Object[] { get_uid() });
/*      */             }
/*      */ 
/* 2565 */             criticalEnd();
/*      */ 
/* 2567 */             return 1;
/*      */           }
/*      */ 
/* 2570 */           this.savedIntentionList = true;
/*      */         }
/*      */         catch (ObjectStoreException e)
/*      */         {
/* 2574 */           criticalEnd();
/*      */ 
/* 2576 */           return 1;
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 2581 */     criticalEnd();
/*      */ 
/* 2583 */     if ((this.preparedList.size() == 0) && (this.readonlyList.size() >= 0)) {
/* 2584 */       return 2;
/*      */     }
/* 2586 */     return 0;
/*      */   }
/*      */ 
/*      */   protected void onePhaseCommit(boolean reportHeuristics)
/*      */   {
/* 2596 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 2598 */       tsLogger.arjLogger.debug(16L, 2L, 1L, "BasicAction::onePhaseCommit() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 2604 */     if (this.actionStatus == 3)
/*      */     {
/* 2606 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 2608 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_43", new Object[] { get_uid() });
/*      */       }
/*      */ 
/* 2612 */       Abort();
/*      */ 
/* 2614 */       return;
/*      */     }
/*      */ 
/* 2617 */     this.actionStatus = 6;
/*      */ 
/* 2619 */     criticalStart();
/*      */ 
/* 2621 */     if ((this.heuristicList == null) && (reportHeuristics)) {
/* 2622 */       this.heuristicList = new RecordList();
/*      */     }
/*      */ 
/* 2630 */     boolean stateToSave = false;
/*      */ 
/* 2632 */     this.recordBeingHandled = this.pendingList.getFront();
/*      */ 
/* 2634 */     int p = this.actionType == 0 ? this.recordBeingHandled.topLevelOnePhaseCommit() : this.recordBeingHandled.nestedOnePhaseCommit();
/*      */ 
/* 2637 */     if ((p == 7) || (p == 2))
/*      */     {
/* 2640 */       if ((this.actionType == 1) && (this.recordBeingHandled.propagateOnCommit()))
/*      */       {
/* 2643 */         merge(this.recordBeingHandled);
/*      */       }
/*      */       else
/*      */       {
/* 2647 */         this.recordBeingHandled = null;
/*      */       }
/*      */ 
/* 2650 */       this.actionStatus = 7;
/*      */     }
/* 2656 */     else if (p == 8)
/*      */     {
/* 2663 */       this.recordBeingHandled = null;
/*      */ 
/* 2665 */       this.actionStatus = 4;
/*      */     }
/*      */     else
/*      */     {
/* 2673 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/* 2675 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_47", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(p) });
/*      */       }
/*      */ 
/* 2679 */       if (reportHeuristics)
/*      */       {
/* 2681 */         updateHeuristic(p, true);
/*      */ 
/* 2683 */         if (!this.heuristicList.insert(this.recordBeingHandled)) {
/* 2684 */           this.recordBeingHandled = null;
/*      */         }
/* 2687 */         else if (!stateToSave) {
/* 2688 */           stateToSave = this.recordBeingHandled.doSave();
/*      */         }
/*      */       }
/*      */ 
/* 2692 */       if (this.heuristicDecision == 3)
/*      */       {
/* 2699 */         this.heuristicDecision = 0;
/*      */ 
/* 2704 */         this.actionStatus = 4;
/*      */       }
/* 2706 */       else if (this.heuristicDecision == 4)
/*      */       {
/* 2708 */         this.heuristicDecision = 0;
/* 2709 */         this.actionStatus = 7;
/*      */       }
/*      */       else {
/* 2712 */         this.actionStatus = 7;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 2718 */     if (this.actionType == 0)
/*      */     {
/* 2720 */       if ((stateToSave) && (this.heuristicList.size() > 0))
/*      */       {
/* 2722 */         if (store() == null)
/*      */         {
/* 2724 */           if (tsLogger.arjLoggerI18N.isFatalEnabled())
/*      */           {
/* 2726 */             tsLogger.arjLoggerI18N.fatal("com.arjuna.ats.arjuna.coordinator.BasicAction_48");
/*      */           }
/*      */ 
/* 2729 */           throw new FatalError(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.coordinator.BasicAction_69") + get_uid());
/*      */         }
/*      */ 
/* 2734 */         updateState();
/*      */       }
/*      */     }
/*      */ 
/* 2738 */     forgetHeuristics();
/*      */ 
/* 2740 */     ActionManager.manager().remove(get_uid());
/*      */ 
/* 2742 */     criticalEnd();
/*      */   }
/*      */ 
/*      */   protected final synchronized int getHeuristicDecision()
/*      */   {
/* 2755 */     return this.heuristicDecision;
/*      */   }
/*      */ 
/*      */   protected final synchronized void addRecord(AbstractRecord A)
/*      */   {
/* 2766 */     this.preparedList.insert(A);
/*      */   }
/*      */ 
/*      */   protected int preparedStatus()
/*      */   {
/* 2777 */     if (this.actionType == 0) {
/* 2778 */       return 6;
/*      */     }
/* 2780 */     return 5;
/*      */   }
/*      */ 
/*      */   protected int abortStatus()
/*      */   {
/* 2785 */     return 4;
/*      */   }
/*      */ 
/*      */   protected int commitStatus()
/*      */   {
/* 2790 */     return 7;
/*      */   }
/*      */ 
/*      */   protected int doPrepare(boolean reportHeuristics)
/*      */     throws IndexOutOfBoundsException
/*      */   {
/* 2824 */     int p = 1;
/*      */     do
/*      */     {
/* 2828 */       AbstractRecord rec = this.pendingList != null ? this.pendingList.getFront() : null;
/*      */ 
/* 2837 */       if (rec != null)
/*      */       {
/* 2845 */         p = doPrepare(reportHeuristics, rec);
/*      */       }
/*      */       else
/*      */       {
/* 2855 */         throw new IndexOutOfBoundsException();
/*      */       }
/*      */     }
/* 2858 */     while ((p == 0) || (p == 2));
/*      */ 
/* 2860 */     return p;
/*      */   }
/*      */ 
/*      */   protected int doPrepare(boolean reportHeuristics, AbstractRecord theRecord)
/*      */     throws IndexOutOfBoundsException
/*      */   {
/* 2883 */     int p = 1;
/* 2884 */     AbstractRecord record = theRecord;
/*      */ 
/* 2886 */     if (record != null)
/*      */     {
/* 2888 */       p = this.actionType == 0 ? record.topLevelPrepare() : record.nestedPrepare();
/*      */ 
/* 2891 */       if (p == 0)
/*      */       {
/* 2893 */         record = insertRecord(this.preparedList, record);
/*      */       }
/* 2897 */       else if (p == 2)
/*      */       {
/* 2899 */         record = insertRecord(this.readonlyList, record);
/*      */       }
/*      */       else
/*      */       {
/* 2903 */         if ((p == 1) || (p == 10) || (!reportHeuristics))
/*      */         {
/* 2913 */           if (this.actionType == 1)
/*      */           {
/* 2915 */             if ((this.preparedList.size() > 0) && (p == 10))
/*      */             {
/* 2918 */               if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */               {
/* 2920 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_49", new Object[] { get_uid() });
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 2956 */           record = insertRecord(this.pendingList, record);
/*      */ 
/* 2958 */           record = null;
/*      */ 
/* 2960 */           this.actionStatus = 5;
/*      */ 
/* 2962 */           return p;
/*      */         }
/*      */ 
/* 2974 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 2976 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_50", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(p) });
/*      */         }
/*      */ 
/* 2980 */         if (reportHeuristics) {
/* 2981 */           updateHeuristic(p, false);
/*      */         }
/*      */ 
/* 2992 */         record = insertRecord(this.heuristicList, record);
/*      */ 
/* 3000 */         if (this.heuristicDecision != 4)
/*      */         {
/* 3002 */           this.actionStatus = 5;
/*      */ 
/* 3004 */           return 1;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */     else
/*      */     {
/* 3020 */       throw new IndexOutOfBoundsException();
/*      */     }
/* 3022 */     return p;
/*      */   }
/*      */ 
/*      */   protected int doCommit(RecordList rl, boolean reportHeuristics)
/*      */   {
/* 3032 */     if ((rl != null) && (rl.size() > 0))
/*      */     {
/* 3035 */       boolean pastFirstParticipant = false;
/*      */       AbstractRecord rec;
/* 3037 */       while ((rec = rl.getFront()) != null)
/*      */       {
/* 3039 */         int outcome = doCommit(reportHeuristics, rec);
/*      */ 
/* 3049 */         switch (outcome)
/*      */         {
/*      */         case 4:
/*      */         case 7:
/* 3053 */           pastFirstParticipant = true;
/* 3054 */           break;
/*      */         case 5:
/*      */         case 6:
/*      */         default:
/* 3065 */           pastFirstParticipant = true;
/* 3066 */           break;
/*      */         case 3:
/* 3075 */           if (pastFirstParticipant)
/*      */           {
/*      */             break;
/*      */           }
/*      */ 
/* 3085 */           pastFirstParticipant = true;
/*      */ 
/* 3087 */           int oldDecision = this.heuristicDecision;
/*      */ 
/* 3089 */           phase2Abort(reportHeuristics);
/*      */ 
/* 3091 */           this.heuristicDecision = oldDecision;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3099 */     return 7;
/*      */   }
/*      */ 
/*      */   protected int doCommit(boolean reportHeuristics, AbstractRecord record)
/*      */   {
/* 3104 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/* 3106 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::doCommit (" + record + ")");
/*      */     }
/*      */ 
/* 3116 */     int ok = 8;
/*      */ 
/* 3118 */     this.recordBeingHandled = record;
/*      */ 
/* 3120 */     if (this.recordBeingHandled != null)
/*      */     {
/* 3122 */       if (this.actionType == 0)
/*      */       {
/* 3124 */         if ((ok = this.recordBeingHandled.topLevelCommit()) == 7)
/*      */         {
/* 3130 */           this.recordBeingHandled = null;
/*      */ 
/* 3132 */           updateHeuristic(7, true);
/*      */         }
/*      */         else
/*      */         {
/* 3141 */           if (tsLogger.arjLoggerI18N.debugAllowed(16L, 1L, 1L))
/*      */           {
/* 3143 */             tsLogger.arjLoggerI18N.debug(16L, 1L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_51", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClassName(this.recordBeingHandled.typeIs()) });
/*      */           }
/*      */ 
/* 3147 */           if ((reportHeuristics) && ((ok == 3) || (ok == 4) || (ok == 5) || (ok == 6)))
/*      */           {
/* 3152 */             updateHeuristic(ok, true);
/* 3153 */             this.heuristicList.insert(this.recordBeingHandled);
/*      */           }
/* 3157 */           else if (ok == 9)
/*      */           {
/* 3165 */             updateHeuristic(6, true);
/*      */           }
/*      */           else
/*      */           {
/* 3174 */             this.failedList.insert(this.recordBeingHandled);
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/* 3185 */         ok = this.recordBeingHandled.nestedCommit();
/*      */ 
/* 3187 */         if (this.recordBeingHandled.propagateOnCommit())
/*      */         {
/* 3189 */           merge(this.recordBeingHandled);
/*      */         }
/*      */         else
/*      */         {
/* 3193 */           this.recordBeingHandled = null;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/* 3197 */       if (ok == 7);
/*      */     }
/*      */ 
/* 3203 */     return 7;
/*      */   }
/*      */ 
/*      */   protected int doAbort(RecordList list_toprocess, boolean reportHeuristics)
/*      */   {
/* 3213 */     if ((list_toprocess != null) && (list_toprocess.size() > 0))
/*      */     {
/* 3215 */       while ((this.recordBeingHandled = list_toprocess.getFront()) != null)
/*      */       {
/* 3217 */         doAbort(reportHeuristics, this.recordBeingHandled);
/*      */       }
/*      */     }
/*      */ 
/* 3221 */     return 7;
/*      */   }
/*      */ 
/*      */   protected int doAbort(boolean reportHeuristics, AbstractRecord record)
/*      */   {
/* 3226 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 3228 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::doAbort (" + record + ")");
/*      */     }
/*      */ 
/* 3232 */     int ok = 7;
/*      */ 
/* 3234 */     this.recordBeingHandled = record;
/*      */ 
/* 3236 */     if (this.recordBeingHandled != null)
/*      */     {
/* 3238 */       if (this.actionType == 0)
/* 3239 */         ok = this.recordBeingHandled.topLevelAbort();
/*      */       else {
/* 3241 */         ok = this.recordBeingHandled.nestedAbort();
/*      */       }
/* 3243 */       if ((this.actionType != 0) && (this.recordBeingHandled.propagateOnAbort()))
/*      */       {
/* 3246 */         merge(this.recordBeingHandled);
/*      */       }
/*      */       else
/*      */       {
/* 3250 */         if (ok == 7)
/*      */         {
/* 3252 */           updateHeuristic(7, false);
/*      */         }
/* 3260 */         else if ((reportHeuristics) && ((ok == 3) || (ok == 4) || (ok == 5) || (ok == 6)))
/*      */         {
/* 3265 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/* 3267 */             if (this.actionType == 0) {
/* 3268 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_52", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(ok) });
/*      */             }
/*      */             else {
/* 3271 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_53", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(ok) });
/*      */             }
/*      */           }
/*      */ 
/* 3275 */           updateHeuristic(ok, false);
/* 3276 */           this.heuristicList.insert(this.recordBeingHandled);
/*      */         }
/* 3280 */         else if (ok != 7)
/*      */         {
/* 3282 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/* 3284 */             if (this.actionType == 0) {
/* 3285 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_54", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClassName(this.recordBeingHandled.typeIs()) });
/*      */             }
/*      */             else {
/* 3288 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_55", new Object[] { get_uid(), TwoPhaseOutcome.stringForm(ok), RecordType.typeToClassName(this.recordBeingHandled.typeIs()) });
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 3300 */         this.recordBeingHandled = null;
/*      */       }
/*      */     }
/*      */ 
/* 3304 */     return ok;
/*      */   }
/*      */ 
/*      */   protected AbstractRecord insertRecord(RecordList reclist, AbstractRecord record)
/*      */   {
/* 3309 */     boolean lock = TxControl.asyncPrepare;
/*      */ 
/* 3311 */     if (lock)
/*      */     {
/* 3313 */       synchronized (reclist)
/*      */       {
/* 3315 */         if (!reclist.insert(record)) {
/* 3316 */           record = null;
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/* 3321 */     else if (!reclist.insert(record)) {
/* 3322 */       record = null;
/*      */     }
/*      */ 
/* 3325 */     return record;
/*      */   }
/*      */ 
/*      */   protected boolean checkForCurrent()
/*      */   {
/* 3339 */     return false;
/*      */   }
/*      */ 
/*      */   protected final synchronized void updateHeuristic(int p, boolean commit)
/*      */   {
/* 3360 */     if (p == 7)
/*      */     {
/* 3362 */       if (commit)
/*      */       {
/* 3364 */         if (this.heuristicDecision == 0) {
/* 3365 */           p = 4;
/*      */         }
/* 3367 */         if (this.heuristicDecision == 3)
/* 3368 */           this.heuristicDecision = 5;
/*      */       }
/*      */       else
/*      */       {
/* 3372 */         if (this.heuristicDecision == 0) {
/* 3373 */           p = 3;
/*      */         }
/* 3375 */         if (this.heuristicDecision == 4) {
/* 3376 */           this.heuristicDecision = 5;
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3393 */     switch (this.heuristicDecision)
/*      */     {
/*      */     case 0:
/* 3396 */       if ((p == 0) || (p == 7)) {
/*      */         break;
/*      */       }
/* 3399 */       this.heuristicDecision = p; break;
/*      */     case 4:
/* 3402 */       if ((p == 3) || (p == 5))
/*      */       {
/* 3404 */         this.heuristicDecision = 5;
/*      */       }
/*      */       else {
/* 3407 */         if (p != 6) break;
/* 3408 */         this.heuristicDecision = 6; } break;
/*      */     case 3:
/* 3412 */       if ((p == 4) || (p == 5))
/*      */       {
/* 3414 */         this.heuristicDecision = 5;
/*      */       }
/*      */       else {
/* 3417 */         if (p != 6) break;
/* 3418 */         this.heuristicDecision = 6; } break;
/*      */     case 6:
/* 3422 */       if (p != 5) break;
/* 3423 */       this.heuristicDecision = 5; break;
/*      */     case 5:
/* 3426 */       break;
/*      */     case 1:
/*      */     case 2:
/*      */     default:
/* 3428 */       this.heuristicDecision = p;
/*      */     }
/*      */ 
/* 3432 */     if (TxControl.enableStatistics)
/* 3433 */       TxStats.incrementHeuristics();
/*      */   }
/*      */ 
/*      */   protected void updateState()
/*      */   {
/* 3438 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 3440 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::updateState() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 3453 */     if (this.actionType == 0)
/*      */     {
/* 3460 */       store();
/*      */ 
/* 3467 */       if (((this.failedList != null) && (this.failedList.size() > 0)) || ((this.heuristicList != null) && (this.heuristicList.size() > 0)))
/*      */       {
/* 3474 */         Uid u = getSavingUid();
/* 3475 */         String tn = type();
/* 3476 */         OutputObjectState state = new OutputObjectState(u, tn);
/*      */ 
/* 3478 */         if (!save_state(state, 1))
/*      */         {
/* 3480 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_64");
/*      */         }
/*      */ 
/* 3485 */         if (state.notempty())
/*      */         {
/*      */           try
/*      */           {
/* 3489 */             if (!this.currentStore.write_committed(u, tn, state))
/*      */             {
/* 3491 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_65");
/*      */             }
/*      */           }
/*      */           catch (ObjectStoreException e)
/*      */           {
/* 3496 */             tsLogger.arjLogger.warn(e.getMessage());
/*      */           }
/*      */         }
/*      */       }
/*      */       else
/*      */       {
/*      */         try
/*      */         {
/* 3504 */           if (this.savedIntentionList)
/*      */           {
/* 3506 */             if (this.currentStore.remove_committed(getSavingUid(), type()))
/*      */             {
/* 3508 */               this.savedIntentionList = false;
/*      */             }
/*      */           }
/*      */         }
/*      */         catch (ObjectStoreException e)
/*      */         {
/* 3514 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_70", new Object[] { e });
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private final void createPreparedLists()
/*      */   {
/* 3528 */     if (this.preparedList == null) {
/* 3529 */       this.preparedList = new RecordList();
/*      */     }
/* 3531 */     if (this.readonlyList == null) {
/* 3532 */       this.readonlyList = new RecordList();
/*      */     }
/* 3534 */     if (this.failedList == null) {
/* 3535 */       this.failedList = new RecordList();
/*      */     }
/* 3537 */     if (this.heuristicList == null) {
/* 3538 */       this.heuristicList = new RecordList();
/*      */     }
/* 3540 */     if (this.pendingList == null)
/* 3541 */       this.pendingList = new RecordList();
/*      */   }
/*      */ 
/*      */   private final boolean checkIsCurrent()
/*      */   {
/* 3554 */     boolean isCurrent = true;
/*      */ 
/* 3556 */     if (checkForCurrent())
/*      */     {
/* 3558 */       BasicAction currentAct = Current();
/*      */ 
/* 3562 */       if ((currentAct != null) && (currentAct != this))
/*      */       {
/* 3564 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 3566 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_56", new Object[] { currentAct.get_uid(), get_uid() });
/*      */         }
/*      */ 
/* 3570 */         isCurrent = false;
/*      */ 
/* 3572 */         if (currentAct.isAncestor(get_uid()))
/*      */         {
/* 3576 */           BasicAction parentAct = parent();
/*      */ 
/* 3580 */           while (parentAct != null)
/*      */           {
/* 3582 */             parentAct.preventCommit();
/* 3583 */             parentAct = parentAct.parent();
/*      */           }
/*      */         }
/*      */       }
/*      */ 
/* 3588 */       currentAct = null;
/*      */     }
/*      */ 
/* 3591 */     return isCurrent;
/*      */   }
/*      */ 
/*      */   private final boolean checkChildren(boolean isCommit)
/*      */   {
/* 3596 */     boolean problem = false;
/*      */ 
/* 3603 */     if ((this._childThreads != null) && (this._childThreads.size() > 0))
/*      */     {
/* 3605 */       if ((this._childThreads.size() != 1) || ((this._childThreads.size() == 1) && (!this._childThreads.contains(Thread.currentThread()))))
/*      */       {
/* 3613 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 3615 */           if (isCommit)
/*      */           {
/* 3617 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_57", new Object[] { get_uid() });
/*      */           }
/*      */           else
/*      */           {
/* 3622 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_58", new Object[] { get_uid() });
/*      */           }
/*      */ 
/*      */         }
/*      */ 
/* 3627 */         if (this._checkedAction != null) {
/* 3628 */           this._checkedAction.check(isCommit, get_uid(), this._childThreads);
/*      */         }
/* 3630 */         removeAllChildThreads();
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3636 */     if ((this._childActions != null) && (this._childActions.size() > 0))
/*      */     {
/* 3638 */       problem = true;
/*      */ 
/* 3640 */       Enumeration iter = this._childActions.elements();
/* 3641 */       BasicAction child = null;
/* 3642 */       boolean printError = true;
/*      */ 
/* 3653 */       while (iter.hasMoreElements())
/*      */       {
/* 3655 */         child = (BasicAction)iter.nextElement();
/*      */ 
/* 3657 */         if (child.status() == 4)
/*      */           continue;
/* 3659 */         if (printError)
/*      */         {
/* 3661 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/* 3663 */             if (isCommit)
/*      */             {
/* 3665 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_59", new Object[] { get_uid() });
/*      */             }
/*      */             else
/*      */             {
/* 3670 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_60", new Object[] { get_uid() });
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 3675 */           printError = false;
/*      */         }
/*      */ 
/* 3678 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 3680 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_61", new Object[] { child.get_uid() });
/*      */         }
/*      */ 
/* 3684 */         child.Abort();
/* 3685 */         child = null;
/*      */       }
/*      */ 
/* 3689 */       iter = null;
/*      */ 
/* 3691 */       if (isCommit)
/*      */       {
/* 3693 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/* 3695 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_62", new Object[] { child.get_uid() });
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 3701 */     return problem;
/*      */   }
/*      */ 
/*      */   private final void removeAllChildThreads()
/*      */   {
/* 3719 */     criticalStart();
/*      */ 
/* 3721 */     if ((this._childThreads != null) && (this._childThreads.size() != 0))
/*      */     {
/* 3723 */       Thread currentThread = Thread.currentThread();
/*      */ 
/* 3731 */       Enumeration iter = this._childThreads.elements();
/* 3732 */       Thread t = null;
/*      */ 
/* 3734 */       while (iter.hasMoreElements())
/*      */       {
/* 3736 */         t = (Thread)iter.nextElement();
/*      */ 
/* 3738 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */         {
/* 3740 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_63", new Object[] { get_uid(), t });
/*      */         }
/*      */ 
/* 3744 */         if (t != currentThread) {
/* 3745 */           ThreadActionData.purgeAction(this, t);
/*      */         }
/*      */       }
/*      */     }
/* 3749 */     criticalEnd();
/*      */   }
/*      */ 
/*      */   private final void actionInitialise(BasicAction parent)
/*      */   {
/* 3759 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 3761 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::actionInitialise() for action-id " + get_uid());
/*      */     }
/*      */ 
/* 3765 */     criticalStart();
/*      */ 
/* 3767 */     if (parent != null)
/*      */     {
/* 3769 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */       {
/* 3771 */         tsLogger.arjLoggerI18N.debug(16L, 1L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_66", new Object[] { get_uid(), Integer.toString(parent.actionStatus) });
/*      */       }
/*      */ 
/* 3775 */       this.currentHierarchy = new ActionHierarchy(parent.getHierarchy());
/*      */     }
/*      */     else
/*      */     {
/* 3779 */       this.currentHierarchy = new ActionHierarchy(5);
/*      */     }
/*      */ 
/* 3788 */     this.currentHierarchy.add(get_uid(), this.actionType);
/*      */ 
/* 3790 */     switch (this.actionType)
/*      */     {
/*      */     case 0:
/* 3793 */       if (parent == null)
/*      */       {
/*      */         break;
/*      */       }
/*      */ 
/* 3800 */       if (!tsLogger.arjLoggerI18N.debugAllowed())
/*      */         break;
/* 3802 */       tsLogger.arjLoggerI18N.debug(16L, 1L, 1L, "com.arjuna.ats.arjuna.coordinator.BasicAction_67", new Object[] { get_uid(), parent.get_uid() }); break;
/*      */     case 1:
/* 3808 */       if (parent != null) break;
/* 3809 */       this.actionType = 0;
/*      */     }
/*      */ 
/* 3813 */     this.parentAction = parent;
/*      */ 
/* 3815 */     criticalEnd();
/*      */   }
/*      */ 
/*      */   private final void doForget(RecordList list_toprocess)
/*      */   {
/* 3820 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 3822 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::doForget (" + list_toprocess + ")");
/*      */     }
/*      */ 
/* 3838 */     boolean force = this.heuristicDecision == 7;
/*      */ 
/* 3840 */     if ((!TxControl.maintainHeuristics) || (force))
/*      */     {
/* 3842 */       if (list_toprocess.size() > 0)
/*      */       {
/* 3844 */         RecordList tmpList = new RecordList();
/*      */ 
/* 3846 */         while ((this.recordBeingHandled = list_toprocess.getFront()) != null)
/*      */         {
/* 3852 */           if (this.recordBeingHandled.forgetHeuristic()) {
/* 3853 */             this.recordBeingHandled = null; continue;
/*      */           }
/* 3855 */           tmpList.putFront(this.recordBeingHandled);
/*      */         }
/*      */ 
/* 3863 */         if (tmpList.size() > 0)
/*      */         {
/* 3865 */           while ((this.recordBeingHandled = tmpList.getFront()) != null)
/* 3866 */             list_toprocess.putFront(this.recordBeingHandled);
/*      */         }
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private final void doCleanup(RecordList list_toprocess)
/*      */   {
/* 3887 */     if (tsLogger.arjLogger.isDebugEnabled())
/*      */     {
/* 3889 */       tsLogger.arjLogger.debug(16L, 1L, 1L, "BasicAction::doCleanup (" + list_toprocess + ")");
/*      */     }
/*      */ 
/* 3893 */     if (list_toprocess.size() > 0)
/*      */     {
/* 3895 */       int ok = 7;
/*      */ 
/* 3897 */       while ((this.recordBeingHandled = list_toprocess.getFront()) != null)
/*      */       {
/* 3899 */         if (this.actionType == 0)
/* 3900 */           ok = this.recordBeingHandled.topLevelCleanup();
/*      */         else {
/* 3902 */           ok = this.recordBeingHandled.nestedCleanup();
/*      */         }
/* 3904 */         if ((this.actionType != 0) && (this.recordBeingHandled.propagateOnAbort()))
/*      */         {
/* 3907 */           merge(this.recordBeingHandled); continue;
/*      */         }
/*      */ 
/* 3911 */         if (ok != 7);
/* 3916 */         this.recordBeingHandled = null;
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private final synchronized boolean doOnePhase()
/*      */   {
/* 3924 */     if (TxControl.onePhase)
/*      */     {
/* 3926 */       return (this.pendingList == null) || (this.pendingList.size() == 1);
/*      */     }
/*      */ 
/* 3930 */     return false;
/*      */   }
/*      */ 
/*      */   private final synchronized void merge(AbstractRecord A)
/*      */   {
/*      */     int as;
/* 3944 */     if ((as = this.parentAction.add(A)) != 2)
/*      */     {
/* 3946 */       A = null;
/*      */ 
/* 3948 */       if (as == 3)
/* 3949 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.coordinator.BasicAction_68");
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.BasicAction
 * JD-Core Version:    0.6.0
 */