/*     */ package com.arjuna.ats.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.PrintWriter;
/*     */ 
/*     */ public class RecordList
/*     */ {
/*     */   protected AbstractRecord listHead;
/*     */   private AbstractRecord listTail;
/*     */   private int noEntries;
/*     */ 
/*     */   public RecordList()
/*     */   {
/*  76 */     this.listHead = null;
/*  77 */     this.listTail = null;
/*  78 */     this.noEntries = 0;
/*     */   }
/*     */ 
/*     */   public RecordList(RecordList copy)
/*     */   {
/*  83 */     this.listHead = copy.listHead;
/*  84 */     this.listTail = copy.listTail;
/*  85 */     this.noEntries = copy.noEntries;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  91 */     int count = this.noEntries;
/*     */ 
/*  93 */     for (int i = 0; i < count; i++)
/*     */     {
/*  95 */       AbstractRecord temp = getFront();
/*  96 */       temp = null;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final AbstractRecord getFront()
/*     */   {
/* 108 */     AbstractRecord temp = this.listHead;
/*     */ 
/* 110 */     if (this.noEntries == 1)
/*     */     {
/* 112 */       this.listHead = (this.listTail = null);
/* 113 */       this.noEntries = 0;
/*     */     }
/* 115 */     else if (this.noEntries > 1)
/*     */     {
/* 117 */       this.listHead = this.listHead.getNext();
/* 118 */       this.listHead.setPrevious(null);
/* 119 */       temp.setNext(null);
/* 120 */       temp.setPrevious(null);
/* 121 */       this.noEntries -= 1;
/*     */     }
/*     */ 
/* 124 */     return temp;
/*     */   }
/*     */ 
/*     */   public final AbstractRecord getRear()
/*     */   {
/* 135 */     AbstractRecord temp = this.listTail;
/*     */ 
/* 137 */     if (this.noEntries == 1)
/*     */     {
/* 139 */       this.listHead = (this.listTail = null);
/* 140 */       this.noEntries = 0;
/*     */     }
/* 142 */     else if (this.noEntries > 1)
/*     */     {
/* 144 */       this.listTail = this.listTail.getPrevious();
/* 145 */       this.listTail.setNext(null);
/* 146 */       temp.setPrevious(null);
/* 147 */       this.noEntries -= 1;
/*     */     }
/*     */ 
/* 150 */     return temp;
/*     */   }
/*     */ 
/*     */   public AbstractRecord getNext(AbstractRecord current)
/*     */   {
/* 155 */     AbstractRecord rec = current.getNext();
/*     */ 
/* 157 */     if (remove(rec)) {
/* 158 */       return rec;
/*     */     }
/* 160 */     return null;
/*     */   }
/*     */ 
/*     */   public final boolean insert(AbstractRecord newRecord)
/*     */   {
/* 170 */     return insert(newRecord, this.listHead);
/*     */   }
/*     */ 
/*     */   public final void print(PrintWriter strm)
/*     */   {
/* 175 */     AbstractRecord arp = this.listHead;
/*     */ 
/* 177 */     for (int i = 0; i < this.noEntries; i++)
/*     */     {
/* 179 */       strm.print(arp);
/* 180 */       arp = arp.getNext();
/*     */     }
/*     */   }
/*     */ 
/*     */   public final void putFront(AbstractRecord newRecord)
/*     */   {
/* 190 */     if (this.listHead == null)
/*     */     {
/* 192 */       this.listHead = (this.listTail = newRecord);
/* 193 */       newRecord.setNext(null);
/* 194 */       newRecord.setPrevious(null);
/*     */     }
/*     */     else
/*     */     {
/* 198 */       this.listHead.setPrevious(newRecord);
/* 199 */       newRecord.setPrevious(null);
/* 200 */       newRecord.setNext(this.listHead);
/* 201 */       this.listHead = newRecord;
/*     */     }
/*     */ 
/* 204 */     this.noEntries += 1;
/*     */   }
/*     */ 
/*     */   public final void putRear(AbstractRecord newRecord)
/*     */   {
/* 213 */     if (this.listTail == null)
/*     */     {
/* 215 */       this.listHead = (this.listTail = newRecord);
/* 216 */       newRecord.setNext(null);
/* 217 */       newRecord.setPrevious(null);
/*     */     }
/*     */     else
/*     */     {
/* 221 */       this.listTail.setNext(newRecord);
/* 222 */       newRecord.setPrevious(this.listTail);
/* 223 */       newRecord.setNext(null);
/* 224 */       this.listTail = newRecord;
/*     */     }
/*     */ 
/* 227 */     this.noEntries += 1;
/*     */   }
/*     */ 
/*     */   public final AbstractRecord peekFront()
/*     */   {
/* 232 */     return this.listHead;
/*     */   }
/*     */ 
/*     */   public final AbstractRecord peekRear()
/*     */   {
/* 237 */     return this.listTail;
/*     */   }
/*     */ 
/*     */   public final AbstractRecord peekNext(AbstractRecord curr)
/*     */   {
/* 242 */     return curr.getNext();
/*     */   }
/*     */ 
/*     */   public final boolean remove(AbstractRecord oldRecord)
/*     */   {
/* 251 */     if (oldRecord == null) {
/* 252 */       return false;
/*     */     }
/* 254 */     if (this.noEntries == 1)
/*     */     {
/* 256 */       this.listHead = (this.listTail = null);
/* 257 */       this.noEntries = 0;
/*     */     }
/* 259 */     else if (this.noEntries > 1)
/*     */     {
/* 261 */       if (this.listHead == oldRecord)
/*     */       {
/* 263 */         this.listHead = oldRecord.getNext();
/*     */ 
/* 265 */         if (this.listHead != null) {
/* 266 */           this.listHead.setPrevious(null);
/*     */         }
/*     */ 
/*     */       }
/* 270 */       else if (this.listTail == oldRecord)
/*     */       {
/* 272 */         this.listTail = oldRecord.getPrevious();
/*     */ 
/* 274 */         if (this.listTail != null)
/* 275 */           this.listTail.setNext(null);
/*     */       }
/*     */       else
/*     */       {
/* 279 */         if (oldRecord.getPrevious() != null) {
/* 280 */           oldRecord.getPrevious().setNext(oldRecord.getNext());
/*     */         }
/* 282 */         if (oldRecord.getNext() != null) {
/* 283 */           oldRecord.getNext().setPrevious(oldRecord.getPrevious());
/*     */         }
/*     */       }
/*     */ 
/* 287 */       this.noEntries -= 1;
/*     */     }
/*     */ 
/* 290 */     return true;
/*     */   }
/*     */ 
/*     */   public final int size()
/*     */   {
/* 299 */     return this.noEntries;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 304 */     AbstractRecord rec = this.listHead;
/* 305 */     String s = "RecordList:";
/*     */ 
/* 307 */     if (rec == null) {
/* 308 */       s = s + " empty";
/*     */     }
/*     */     else {
/* 311 */       while (rec != null)
/*     */       {
/* 313 */         s = s + " " + rec.order();
/* 314 */         rec = rec.getNext();
/*     */       }
/*     */     }
/*     */ 
/* 318 */     return s;
/*     */   }
/*     */ 
/*     */   private final boolean insert(AbstractRecord newRecord, AbstractRecord startAt)
/*     */   {
/* 354 */     AbstractRecord current = startAt;
/*     */ 
/* 360 */     while (current != null)
/*     */     {
/* 362 */       if (newRecord.shouldMerge(current))
/*     */       {
/* 364 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 366 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_1", new Object[] { this, newRecord.type(), current.type(), newRecord.order() });
/*     */         }
/*     */ 
/* 372 */         newRecord.merge(current);
/* 373 */         replace(newRecord, current);
/*     */ 
/* 375 */         return true;
/*     */       }
/*     */ 
/* 379 */       if (newRecord.shouldReplace(current))
/*     */       {
/* 381 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 383 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_2", new Object[] { this, current.type(), newRecord.type(), newRecord.order() });
/*     */         }
/*     */ 
/* 389 */         replace(newRecord, current);
/*     */ 
/* 391 */         return true;
/*     */       }
/*     */ 
/* 395 */       if (newRecord.shouldAdd(current))
/*     */       {
/* 397 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 399 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_3", new Object[] { this, newRecord.type(), current.type(), newRecord.order() });
/*     */         }
/*     */ 
/* 405 */         insertBefore(newRecord, current);
/*     */ 
/* 407 */         return true;
/*     */       }
/*     */ 
/* 411 */       if (newRecord.shouldAlter(current)) {
/* 412 */         newRecord.alter(current);
/*     */       }
/* 414 */       if (newRecord.equals(current))
/*     */       {
/* 416 */         return false;
/*     */       }
/* 418 */       if (newRecord.lessThan(current))
/*     */       {
/* 420 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 422 */           tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_4", new Object[] { this, newRecord.type(), newRecord.order(), current.type() });
/*     */         }
/*     */ 
/* 428 */         insertBefore(newRecord, current);
/*     */ 
/* 430 */         return true;
/*     */       }
/*     */ 
/* 433 */       current = current.getNext();
/*     */     }
/*     */ 
/* 439 */     if (current == null)
/*     */     {
/* 441 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */       {
/* 443 */         tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_5", new Object[] { this, newRecord.type(), newRecord.order() });
/*     */       }
/*     */ 
/* 448 */       putRear(newRecord);
/*     */     }
/*     */     else
/*     */     {
/* 452 */       if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */       {
/* 454 */         tsLogger.arjLoggerI18N.debug(16L, 1L, 8L, "com.arjuna.ats.arjuna.coordinator.RecordList_6", new Object[] { this, newRecord.type(), newRecord.order(), current.type(), current.order() });
/*     */       }
/*     */ 
/* 460 */       insertBefore(newRecord, current);
/*     */     }
/*     */ 
/* 463 */     return true;
/*     */   }
/*     */ 
/*     */   private final void insertBefore(AbstractRecord newRecord, AbstractRecord before)
/*     */   {
/* 474 */     newRecord.setPrevious(before.getPrevious());
/* 475 */     newRecord.setNext(before);
/* 476 */     before.setPrevious(newRecord);
/*     */ 
/* 480 */     if (newRecord.getPrevious() != null) {
/* 481 */       newRecord.getPrevious().setNext(newRecord);
/*     */     }
/*     */     else {
/* 484 */       this.listHead = newRecord;
/*     */     }
/* 486 */     this.noEntries += 1;
/*     */   }
/*     */ 
/*     */   private final void replace(AbstractRecord newRecord, AbstractRecord oldRecord)
/*     */   {
/* 491 */     newRecord.setPrevious(oldRecord.getPrevious());
/* 492 */     newRecord.setNext(oldRecord.getNext());
/*     */ 
/* 494 */     if (newRecord.getPrevious() != null)
/* 495 */       newRecord.getPrevious().setNext(newRecord);
/*     */     else {
/* 497 */       this.listHead = newRecord;
/*     */     }
/* 499 */     if (newRecord.getNext() != null)
/* 500 */       newRecord.getNext().setPrevious(newRecord);
/*     */     else {
/* 502 */       this.listTail = newRecord;
/*     */     }
/* 504 */     oldRecord = null;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.coordinator.RecordList
 * JD-Core Version:    0.6.0
 */