/*     */ package com.arjuna.ats.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Configuration;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.state.InputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputBuffer;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.File;
/*     */ import java.io.IOException;
/*     */ import java.io.SyncFailedException;
/*     */ 
/*     */ public abstract class ObjectStoreImple
/*     */ {
/*     */   protected int shareStatus;
/* 434 */   private String _objectStoreRoot = null;
/* 435 */   private String _objectStoreDir = null;
/*     */ 
/* 437 */   private static final ClassName _className = new ClassName("ObjectStoreImple");
/*     */ 
/*     */   public abstract int typeIs();
/*     */ 
/*     */   public abstract boolean allObjUids(String paramString, InputObjectState paramInputObjectState, int paramInt)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean allTypes(InputObjectState paramInputObjectState)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract int currentState(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract String getStoreName();
/*     */ 
/*     */   public abstract boolean commit_state(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean hide_state(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean reveal_state(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract InputObjectState read_committed(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract InputObjectState read_uncommitted(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean remove_committed(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean remove_uncommitted(Uid paramUid, String paramString)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean write_committed(Uid paramUid, String paramString, OutputObjectState paramOutputObjectState)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public abstract boolean write_uncommitted(Uid paramUid, String paramString, OutputObjectState paramOutputObjectState)
/*     */     throws ObjectStoreException;
/*     */ 
/*     */   public void sync()
/*     */     throws SyncFailedException, ObjectStoreException
/*     */   {
/*     */   }
/*     */ 
/*     */   public String locateStore(String localOSRoot)
/*     */     throws ObjectStoreException
/*     */   {
/* 242 */     if (this._objectStoreRoot == null) {
/* 243 */       this._objectStoreRoot = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.localOSRoot");
/*     */     }
/* 245 */     if (this._objectStoreDir == null)
/*     */     {
/* 247 */       this._objectStoreDir = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
/* 248 */       if ((this._objectStoreDir == null) || (this._objectStoreDir.length() == 0)) {
/* 249 */         this._objectStoreDir = Configuration.objectStoreRoot();
/*     */       }
/* 251 */       if ((this._objectStoreDir == null) || (this._objectStoreDir.length() == 0)) {
/* 252 */         throw new ObjectStoreException("com.arjuna.ats.arjuna.objectstore.objectStoreDir not set.");
/*     */       }
/* 254 */       if (!this._objectStoreDir.endsWith(File.separator)) {
/* 255 */         this._objectStoreDir += File.separator;
/*     */       }
/*     */ 
/* 262 */       this._objectStoreDir += className().stringForm();
/*     */     }
/*     */ 
/* 265 */     String toReturn = null;
/*     */ 
/* 267 */     if ((localOSRoot == null) || (localOSRoot.length() == 0))
/*     */     {
/* 269 */       if ((this._objectStoreRoot != null) && (this._objectStoreRoot.length() > 0))
/* 270 */         localOSRoot = this._objectStoreRoot;
/*     */       else {
/* 272 */         localOSRoot = "defaultStore" + File.separator;
/*     */       }
/*     */     }
/* 275 */     if ((localOSRoot != null) && (localOSRoot.length() > 0)) {
/* 276 */       toReturn = this._objectStoreDir + File.separator + localOSRoot;
/*     */     }
/* 278 */     if (!toReturn.endsWith(File.separator)) {
/* 279 */       toReturn = toReturn + File.separator;
/*     */     }
/* 281 */     return toReturn;
/*     */   }
/*     */ 
/*     */   public boolean fullCommitNeeded()
/*     */   {
/* 293 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean isType(Uid u, String tn, int st)
/*     */     throws ObjectStoreException
/*     */   {
/* 310 */     return currentState(u, tn) == st;
/*     */   }
/*     */ 
/*     */   public void initialise(Uid u, String tn)
/*     */   {
/*     */   }
/*     */ 
/*     */   public void pack(OutputBuffer buff)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public void unpack(InputBuffer buff)
/*     */     throws IOException
/*     */   {
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 341 */     return _className;
/*     */   }
/*     */ 
/*     */   public final int shareState()
/*     */   {
/* 346 */     return this.shareStatus;
/*     */   }
/*     */ 
/*     */   public final String storeDir()
/*     */   {
/* 351 */     return this._objectStoreDir;
/*     */   }
/*     */ 
/*     */   public final String storeRoot()
/*     */   {
/* 356 */     return this._objectStoreRoot;
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 361 */     return _className;
/*     */   }
/*     */ 
/*     */   protected ObjectStoreImple()
/*     */   {
/* 366 */     this(14);
/*     */   }
/*     */ 
/*     */   protected ObjectStoreImple(int ss)
/*     */   {
/* 371 */     this.shareStatus = ss;
/*     */   }
/*     */ 
/*     */   protected ObjectStoreImple(ObjectName objName)
/*     */   {
/* 376 */     parseObjectName(objName);
/*     */   }
/*     */ 
/*     */   protected abstract boolean supressEntry(String paramString);
/*     */ 
/*     */   protected String revealedId(String name)
/*     */   {
/* 393 */     return name;
/*     */   }
/*     */ 
/*     */   private final void parseObjectName(ObjectName objName)
/*     */   {
/* 398 */     if (objName != null)
/*     */     {
/*     */       try
/*     */       {
/* 402 */         this._objectStoreRoot = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.localOSRoot");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 410 */         this._objectStoreDir = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.objectStoreDir");
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*     */       try
/*     */       {
/* 418 */         String shareType = objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.share");
/*     */ 
/* 420 */         if (shareType != null)
/*     */         {
/* 422 */           if (shareType.equals("OS_SHARED"))
/* 423 */             this.shareStatus = 13;
/*     */         }
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.objectstore.ObjectStoreImple
 * JD-Core Version:    0.6.0
 */