/*     */ package com.arjuna.ats.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Configuration;
/*     */ import com.arjuna.ats.internal.arjuna.recovery.RecoveryManagerImple;
/*     */ import java.io.PrintStream;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class RecoveryManager
/*     */ {
/*     */   public static final int INDIRECT_MANAGEMENT = 0;
/*     */   public static final int DIRECT_MANAGEMENT = 1;
/* 260 */   private RecoveryManagerImple _theImple = null;
/*     */   private int _mode;
/* 263 */   private static RecoveryManager _recoveryManager = null;
/*     */   private static boolean delayRecoveryManagerThread;
/*     */ 
/*     */   public static final synchronized RecoveryManager manager()
/*     */     throws IllegalArgumentException
/*     */   {
/* 102 */     return manager(0);
/*     */   }
/*     */ 
/*     */   public static final synchronized RecoveryManager manager(int mode)
/*     */     throws IllegalArgumentException
/*     */   {
/* 120 */     if (_recoveryManager == null) {
/* 121 */       _recoveryManager = new RecoveryManager(mode);
/*     */     }
/* 124 */     else if (_recoveryManager.mode() != mode) {
/* 125 */       throw new IllegalArgumentException();
/*     */     }
/*     */ 
/* 128 */     return _recoveryManager;
/*     */   }
/*     */ 
/*     */   public static synchronized void delayRecoveryManagerThread()
/*     */   {
/* 136 */     delayRecoveryManagerThread = true;
/*     */   }
/*     */ 
/*     */   public final void scan()
/*     */   {
/* 146 */     this._theImple.scan();
/*     */   }
/*     */ 
/*     */   public final void scan(RecoveryScan callback)
/*     */   {
/* 161 */     ScanThread st = new ScanThread(this._theImple, callback);
/*     */ 
/* 163 */     st.start();
/*     */   }
/*     */ 
/*     */   public final void stop()
/*     */   {
/* 172 */     this._theImple.stop();
/*     */   }
/*     */ 
/*     */   public void startRecoveryManagerThread()
/*     */   {
/* 180 */     this._theImple.start();
/*     */   }
/*     */ 
/*     */   public final void addModule(RecoveryModule module)
/*     */   {
/* 191 */     this._theImple.addModule(module);
/*     */   }
/*     */ 
/*     */   public final Vector getModules()
/*     */   {
/* 196 */     return this._theImple.getModules();
/*     */   }
/*     */ 
/*     */   public final int mode()
/*     */   {
/* 208 */     return this._mode;
/*     */   }
/*     */ 
/*     */   public static void main(String[] args)
/*     */   {
/* 217 */     boolean testMode = false;
/*     */ 
/* 219 */     for (int i = 0; i < args.length; i++)
/*     */     {
/* 221 */       if (args[i].compareTo("-help") == 0)
/*     */       {
/* 223 */         System.out.println("Usage: com.arjuna.ats.arjuna.recovery.RecoveryManager [-help] [-test] [-version]");
/* 224 */         System.exit(0);
/*     */       }
/* 226 */       if (args[i].compareTo("-version") == 0)
/*     */       {
/* 228 */         System.out.println("Version " + Configuration.version());
/* 229 */         System.exit(0);
/*     */       }
/* 231 */       if (args[i].compareTo("-test") != 0)
/*     */         continue;
/* 233 */       testMode = true;
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 239 */       manager();
/*     */ 
/* 241 */       if (testMode)
/* 242 */         System.out.println("Ready");
/*     */     }
/*     */     catch (Throwable e)
/*     */     {
/* 246 */       e.printStackTrace();
/*     */     }
/*     */   }
/*     */ 
/*     */   private RecoveryManager(int mode)
/*     */   {
/* 252 */     if ((mode == 0) && (!delayRecoveryManagerThread))
/* 253 */       this._theImple = new RecoveryManagerImple(true);
/*     */     else {
/* 255 */       this._theImple = new RecoveryManagerImple(false);
/*     */     }
/* 257 */     this._mode = mode;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.recovery.RecoveryManager
 * JD-Core Version:    0.6.0
 */