/*     */ package com.arjuna.ats.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector;
/*     */ import com.arjuna.ats.internal.arjuna.recovery.TransactionStatusManagerItem;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.StringTokenizer;
/*     */ import java.util.Vector;
/*     */ 
/*     */ public class TransactionStatusConnectionManager
/*     */ {
/* 269 */   private static String _typeName = TransactionStatusManagerItem.typeName();
/*     */ 
/* 272 */   private Hashtable _tscTable = new Hashtable();
/*     */ 
/* 275 */   private static ObjectStore _objStore = null;
/*     */ 
/*     */   public TransactionStatusConnectionManager()
/*     */   {
/*  64 */     if (_objStore == null)
/*     */     {
/*  66 */       _objStore = TxControl.getStore();
/*     */     }
/*     */ 
/*  69 */     updateTSMI();
/*     */   }
/*     */ 
/*     */   public int getTransactionStatus(Uid tranUid)
/*     */   {
/*  84 */     String transactionType = "";
/*     */ 
/*  86 */     int status = getTransactionStatus(transactionType, tranUid);
/*     */ 
/*  88 */     return status;
/*     */   }
/*     */ 
/*     */   public int getTransactionStatus(String transactionType, Uid tranUid)
/*     */   {
/*  97 */     int status = 9;
/*     */ 
/* 103 */     String process_id = get_process_id(tranUid);
/*     */ 
/* 105 */     if (!this._tscTable.containsKey(process_id))
/*     */     {
/* 107 */       updateTSMI();
/*     */     }
/*     */ 
/* 110 */     if (this._tscTable.containsKey(process_id))
/*     */     {
/* 112 */       TransactionStatusConnector tsc = (TransactionStatusConnector)this._tscTable.get(process_id);
/*     */ 
/* 114 */       if (tsc.isDead())
/*     */       {
/* 116 */         this._tscTable.remove(process_id);
/* 117 */         tsc.delete();
/* 118 */         tsc = null;
/*     */       }
/*     */       else
/*     */       {
/* 122 */         status = tsc.getTransactionStatus(transactionType, tranUid);
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 135 */     if (status == 9)
/*     */     {
/* 137 */       ActionStatusService ass = new ActionStatusService();
/*     */       try
/*     */       {
/* 141 */         status = ass.getTransactionStatus(transactionType, tranUid.stringForm());
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 145 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 147 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_1", ex);
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 152 */     return status;
/*     */   }
/*     */ 
/*     */   public void updateTSMI()
/*     */   {
/* 162 */     boolean tsmis = false;
/*     */ 
/* 164 */     InputObjectState uids = new InputObjectState();
/* 165 */     Vector tsmiVector = new Vector();
/*     */     try
/*     */     {
/* 169 */       tsmis = _objStore.allObjUids(_typeName, uids);
/*     */     }
/*     */     catch (ObjectStoreException ex)
/*     */     {
/* 173 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */       {
/* 175 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_2", new Object[] { ex });
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 182 */     if (tsmis)
/*     */     {
/* 184 */       Uid theUid = new Uid(Uid.nullUid());
/*     */ 
/* 186 */       boolean moreUids = true;
/*     */ 
/* 188 */       while (moreUids)
/*     */       {
/*     */         try
/*     */         {
/* 192 */           theUid.unpack(uids);
/*     */ 
/* 194 */           if (theUid.equals(Uid.nullUid()))
/*     */           {
/* 196 */             moreUids = false;
/*     */           }
/*     */           else
/*     */           {
/* 200 */             Uid newUid = new Uid(theUid);
/*     */ 
/* 202 */             if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */             {
/* 204 */               tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_3", new Object[] { newUid });
/*     */             }
/*     */ 
/* 209 */             tsmiVector.addElement(newUid);
/*     */           }
/*     */         }
/*     */         catch (Exception ex)
/*     */         {
/* 214 */           moreUids = false;
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 221 */     Enumeration tsmiEnum = tsmiVector.elements();
/*     */ 
/* 223 */     while (tsmiEnum.hasMoreElements())
/*     */     {
/* 225 */       Uid currentUid = (Uid)tsmiEnum.nextElement();
/*     */ 
/* 227 */       String process_id = get_process_id(currentUid);
/*     */ 
/* 229 */       if (!this._tscTable.containsKey(process_id))
/*     */       {
/* 231 */         TransactionStatusConnector tsc = new TransactionStatusConnector(process_id, currentUid);
/*     */ 
/* 233 */         if (tsc.isDead())
/*     */         {
/* 235 */           tsc.delete();
/* 236 */           tsc = null;
/*     */         }
/*     */         else
/*     */         {
/* 240 */           this._tscTable.put(process_id, tsc);
/*     */         }
/*     */ 
/* 243 */         if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */         {
/* 245 */           tsLogger.arjLoggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager_4", new Object[] { process_id });
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String get_process_id(Uid uid)
/*     */   {
/* 260 */     String strUid = uid.toString();
/* 261 */     StringTokenizer st = new StringTokenizer(strUid, ":");
/* 262 */     st.nextToken();
/* 263 */     String process_id_in_Hex = st.nextToken();
/*     */ 
/* 265 */     return process_id_in_Hex;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.recovery.TransactionStatusConnectionManager
 * JD-Core Version:    0.6.0
 */