/*     */ package com.arjuna.ats.arjuna.state;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.util.ResourceBundle;
/*     */ 
/*     */ public class InputBuffer
/*     */ {
/*     */   protected boolean _valid;
/*     */   private DataInputStream _input;
/*     */   private ByteArrayInputStream _inputStream;
/*     */   private byte[] _byteArray;
/*     */ 
/*     */   public InputBuffer()
/*     */   {
/*  73 */     this._byteArray = null;
/*  74 */     this._valid = false;
/*  75 */     this._inputStream = null;
/*  76 */     this._input = null;
/*     */   }
/*     */ 
/*     */   public InputBuffer(byte[] b)
/*     */   {
/*  85 */     this._valid = true;
/*     */ 
/*  87 */     this._byteArray = new byte[b.length];
/*     */ 
/*  89 */     System.arraycopy(b, 0, this._byteArray, 0, b.length);
/*     */     try
/*     */     {
/*  93 */       this._inputStream = new ByteArrayInputStream(this._byteArray);
/*  94 */       this._input = new DataInputStream(this._inputStream);
/*     */ 
/*  96 */       skipHeader();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 100 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public InputBuffer(InputBuffer buff)
/*     */   {
/* 110 */     this._byteArray = null;
/* 111 */     this._valid = false;
/* 112 */     this._inputStream = null;
/* 113 */     this._input = null;
/*     */ 
/* 115 */     copy(buff);
/*     */   }
/*     */ 
/*     */   public final synchronized boolean valid()
/*     */   {
/* 124 */     return this._valid;
/*     */   }
/*     */ 
/*     */   public synchronized void copy(InputBuffer buff)
/*     */   {
/* 133 */     if (buff._valid)
/*     */     {
/* 135 */       this._byteArray = new byte[buff._byteArray.length];
/* 136 */       this._valid = true;
/*     */ 
/* 138 */       System.arraycopy(buff._byteArray, 0, this._byteArray, 0, buff._byteArray.length);
/*     */       try
/*     */       {
/* 142 */         this._inputStream = new ByteArrayInputStream(this._byteArray);
/* 143 */         this._input = new DataInputStream(this._inputStream);
/*     */ 
/* 145 */         skipHeader();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 149 */         this._valid = false;
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   public final synchronized int length()
/*     */   {
/* 160 */     return this._byteArray == null ? 0 : this._byteArray.length;
/*     */   }
/*     */ 
/*     */   public final synchronized byte[] buffer()
/*     */   {
/* 169 */     return this._byteArray;
/*     */   }
/*     */ 
/*     */   public final synchronized void setBuffer(byte[] b)
/*     */   {
/* 178 */     this._byteArray = new byte[b.length];
/*     */ 
/* 180 */     System.arraycopy(b, 0, this._byteArray, 0, b.length);
/*     */     try
/*     */     {
/* 184 */       this._inputStream = new ByteArrayInputStream(this._byteArray);
/* 185 */       this._input = new DataInputStream(this._inputStream);
/*     */ 
/* 187 */       this._valid = true;
/*     */ 
/* 189 */       skipHeader();
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 193 */       this._byteArray = null;
/* 194 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final synchronized byte unpackByte()
/*     */     throws IOException
/*     */   {
/* 206 */     if (!this._valid) {
/* 207 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_1"));
/*     */     }
/* 209 */     int i = unpackInt();
/*     */ 
/* 211 */     return (byte)i;
/*     */   }
/*     */ 
/*     */   public final synchronized byte[] unpackBytes()
/*     */     throws IOException
/*     */   {
/* 222 */     if (!this._valid) {
/* 223 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_2"));
/*     */     }
/* 225 */     int index = unpackInt();
/* 226 */     int size = unpackInt();
/* 227 */     byte[] b = new byte[size];
/*     */ 
/* 229 */     if (size > 0)
/*     */     {
/* 231 */       this._input.readFully(b);
/*     */ 
/* 233 */       realign(size);
/*     */     }
/*     */ 
/* 236 */     return b;
/*     */   }
/*     */ 
/*     */   public final synchronized boolean unpackBoolean()
/*     */     throws IOException
/*     */   {
/* 247 */     if (!this._valid) {
/* 248 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_3"));
/*     */     }
/* 250 */     this._valid = false;
/*     */ 
/* 252 */     this._inputStream.skip(3L);
/*     */ 
/* 254 */     boolean b = this._input.readBoolean();
/*     */ 
/* 256 */     this._valid = true;
/*     */ 
/* 258 */     return b;
/*     */   }
/*     */ 
/*     */   public final synchronized char unpackChar()
/*     */     throws IOException
/*     */   {
/* 269 */     if (!this._valid) {
/* 270 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_4"));
/*     */     }
/* 272 */     int i = unpackInt();
/*     */ 
/* 274 */     return (char)i;
/*     */   }
/*     */ 
/*     */   public final synchronized short unpackShort()
/*     */     throws IOException
/*     */   {
/* 285 */     if (!this._valid) {
/* 286 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_5"));
/*     */     }
/* 288 */     int i = unpackInt();
/*     */ 
/* 290 */     return (short)i;
/*     */   }
/*     */ 
/*     */   public final synchronized int unpackInt()
/*     */     throws IOException
/*     */   {
/* 301 */     if (!this._valid) {
/* 302 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_6"));
/*     */     }
/* 304 */     this._valid = false;
/*     */ 
/* 306 */     int i = this._input.readInt();
/*     */ 
/* 308 */     this._valid = true;
/*     */ 
/* 310 */     return i;
/*     */   }
/*     */ 
/*     */   public final synchronized long unpackLong()
/*     */     throws IOException
/*     */   {
/* 321 */     if (!this._valid) {
/* 322 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_7"));
/*     */     }
/* 324 */     this._valid = false;
/*     */ 
/* 326 */     long l = this._input.readLong();
/*     */ 
/* 328 */     this._valid = true;
/*     */ 
/* 330 */     return l;
/*     */   }
/*     */ 
/*     */   public final synchronized float unpackFloat()
/*     */     throws IOException
/*     */   {
/* 341 */     if (!this._valid) {
/* 342 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_8"));
/*     */     }
/* 344 */     this._valid = false;
/*     */ 
/* 346 */     float f = this._input.readFloat();
/*     */ 
/* 348 */     this._valid = true;
/*     */ 
/* 350 */     return f;
/*     */   }
/*     */ 
/*     */   public final synchronized double unpackDouble()
/*     */     throws IOException
/*     */   {
/* 361 */     if (!this._valid) {
/* 362 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_9"));
/*     */     }
/* 364 */     this._valid = false;
/*     */ 
/* 366 */     double d = this._input.readDouble();
/*     */ 
/* 368 */     this._valid = true;
/*     */ 
/* 370 */     return d;
/*     */   }
/*     */ 
/*     */   public final synchronized String unpackString()
/*     */     throws IOException
/*     */   {
/* 386 */     if (!this._valid) {
/* 387 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_10"));
/*     */     }
/* 389 */     int index = unpackInt();
/* 390 */     int length = unpackInt();
/*     */ 
/* 392 */     if (length == 0) {
/* 393 */       return null;
/*     */     }
/*     */ 
/* 401 */     byte[] b = new byte[length - 1];
/* 402 */     byte[] dummy = new byte[1];
/*     */ 
/* 404 */     this._input.read(b, 0, length - 1);
/* 405 */     this._input.read(dummy, 0, 1);
/*     */ 
/* 407 */     realign(length);
/*     */ 
/* 409 */     return new String(b);
/*     */   }
/*     */ 
/*     */   public synchronized void unpackFrom(InputBuffer buff)
/*     */     throws IOException
/*     */   {
/* 422 */     if (buff == null) {
/* 423 */       throw new IOException(tsLogger.log_mesg.getString("com.arjuna.ats.arjuna.state.InputBuffer_11"));
/*     */     }
/* 425 */     this._valid = false;
/*     */ 
/* 432 */     int i = buff.unpackInt();
/*     */ 
/* 434 */     this._byteArray = new byte[i];
/*     */ 
/* 436 */     for (int j = 0; j < i; j++) {
/* 437 */       this._byteArray[j] = buff.unpackByte();
/*     */     }
/* 439 */     this._valid = true;
/*     */     try
/*     */     {
/* 443 */       this._inputStream = new ByteArrayInputStream(this._byteArray);
/* 444 */       this._input = new DataInputStream(this._inputStream);
/*     */ 
/* 446 */       skipHeader();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 450 */       this._valid = false;
/*     */     }
/*     */   }
/*     */ 
/*     */   public final boolean reread()
/*     */   {
/* 460 */     if (!this._valid) {
/* 461 */       return false;
/*     */     }
/*     */     try
/*     */     {
/* 465 */       this._inputStream = new ByteArrayInputStream(this._byteArray);
/* 466 */       this._input = new DataInputStream(this._inputStream);
/*     */ 
/* 468 */       skipHeader();
/*     */     }
/*     */     catch (IOException e)
/*     */     {
/* 472 */       this._valid = false;
/*     */     }
/*     */ 
/* 475 */     return this._valid;
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 484 */     if (this._valid)
/*     */     {
/* 486 */       strm.println("InputBuffer : \n");
/*     */ 
/* 488 */       strm.println("InputBuffer : \n");
/*     */ 
/* 490 */       for (int i = 0; i < this._byteArray.length; i++)
/* 491 */         strm.write((char)this._byteArray[i]);
/*     */     }
/*     */     else {
/* 494 */       strm.println("InputBuffer : invalid.");
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void realign(int amount) throws IOException {
/* 499 */     if (amount % 4 > 0)
/*     */     {
/* 501 */       int excess = 4 - amount % 4;
/*     */ 
/* 503 */       if (this._inputStream.available() < excess) {
/* 504 */         excess = this._inputStream.available();
/*     */       }
/* 506 */       this._input.skipBytes(excess);
/*     */     }
/*     */   }
/*     */ 
/*     */   private final void skipHeader() throws IOException
/*     */   {
/* 512 */     this._inputStream.skip(8L);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.state.InputBuffer
 * JD-Core Version:    0.6.0
 */