/*     */ package com.arjuna.ats.arjuna.xa;
/*     */ 
/*     */ import java.io.Serializable;
/*     */ 
/*     */ public class XID
/*     */   implements Serializable
/*     */ {
/*     */   public static final int XIDDATASIZE = 128;
/*     */   public static final int MAXGTRIDSIZE = 64;
/*     */   public static final int MAXBQUALSIZE = 64;
/*     */   public static final int NULL_XID = -1;
/*     */   public int formatID;
/*     */   public int gtrid_length;
/*     */   public int bqual_length;
/* 149 */   public byte[] data = new byte[''];
/*     */ 
/*     */   public XID()
/*     */   {
/*  63 */     this.formatID = -1;
/*  64 */     this.gtrid_length = 0;
/*  65 */     this.bqual_length = 0;
/*     */   }
/*     */ 
/*     */   public final boolean isSameTransaction(XID xid)
/*     */   {
/*  74 */     if (this.formatID == xid.formatID)
/*     */     {
/*  76 */       if (this.gtrid_length == xid.gtrid_length)
/*     */       {
/*  78 */         if (equals(xid)) {
/*  79 */           return true;
/*     */         }
/*     */ 
/*  82 */         for (int i = 0; i < this.gtrid_length; i++)
/*     */         {
/*  84 */           if (this.data[i] != xid.data[i]) {
/*  85 */             return false;
/*     */           }
/*     */         }
/*  88 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  93 */     return false;
/*     */   }
/*     */ 
/*     */   public void copy(XID toCopy)
/*     */   {
/*  98 */     if ((toCopy == null) || (toCopy.formatID == -1))
/*     */     {
/* 100 */       this.formatID = -1;
/* 101 */       this.gtrid_length = 0;
/* 102 */       this.bqual_length = 0;
/*     */     }
/*     */     else
/*     */     {
/* 106 */       this.formatID = toCopy.formatID;
/* 107 */       this.gtrid_length = toCopy.gtrid_length;
/* 108 */       this.bqual_length = toCopy.bqual_length;
/*     */ 
/* 110 */       System.arraycopy(toCopy.data, 0, this.data, 0, toCopy.data.length);
/*     */     }
/*     */   }
/*     */ 
/*     */   public boolean equals(XID other)
/*     */   {
/* 116 */     if (other == null) {
/* 117 */       return false;
/*     */     }
/* 119 */     if (other == this) {
/* 120 */       return true;
/*     */     }
/*     */ 
/* 123 */     if ((this.formatID == other.formatID) && (this.gtrid_length == other.gtrid_length) && (this.bqual_length == other.bqual_length))
/*     */     {
/* 127 */       for (int i = 0; i < this.gtrid_length + this.bqual_length; i++)
/*     */       {
/* 129 */         if (this.data[i] != other.data[i]) {
/* 130 */           return false;
/*     */         }
/*     */       }
/* 133 */       return true;
/*     */     }
/*     */ 
/* 136 */     return false;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 142 */     return new String("< " + this.formatID + ", " + this.gtrid_length + ", " + this.bqual_length + ", " + new String(this.data) + " >");
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.arjuna.xa.XID
 * JD-Core Version:    0.6.0
 */