/*     */ package com.arjuna.ats.internal.arjuna.coordinator;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.Reapable;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ 
/*     */ public class ReaperElement
/*     */   implements Comparable
/*     */ {
/*     */   public Reapable _control;
/*     */   public long _absoluteTimeout;
/*     */   public int _timeout;
/*     */   public int _status;
/*     */   public Thread _worker;
/*     */   public static final int RUN = 0;
/*     */   public static final int SCHEDULE_CANCEL = 1;
/*     */   public static final int CANCEL = 2;
/*     */   public static final int CANCEL_INTERRUPTED = 3;
/*     */   public static final int FAIL = 4;
/*     */   public static final int COMPLETE = 5;
/*     */   public static final int ZOMBIE = 6;
/*     */ 
/*     */   public ReaperElement(Reapable control, int timeout)
/*     */   {
/*  51 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  53 */       tsLogger.arjLogger.debug(1L, 4L, 1L, "ReaperElement::ReaperElement ( " + control + ", " + timeout + " )");
/*     */     }
/*     */ 
/*  59 */     this._control = control;
/*  60 */     this._timeout = timeout;
/*  61 */     this._status = 0;
/*  62 */     this._worker = null;
/*     */ 
/*  69 */     this._absoluteTimeout = (timeout * 1000 + System.currentTimeMillis());
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  74 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  76 */       tsLogger.arjLogger.debug(2L, 4L, 1L, "ReaperElement.finalize ()");
/*     */     }
/*     */ 
/*  81 */     this._control = null;
/*     */   }
/*     */ 
/*     */   public int compareTo(Object o)
/*     */   {
/*  94 */     ReaperElement other = (ReaperElement)o;
/*     */ 
/*  96 */     if (this._absoluteTimeout == other._absoluteTimeout) {
/*  97 */       if (this._control.get_uid().equals(other._control.get_uid()))
/*  98 */         return 0;
/*  99 */       if (this._control.get_uid().greaterThan(other._control.get_uid())) {
/* 100 */         return 1;
/*     */       }
/* 102 */       return -1;
/*     */     }
/*     */ 
/* 105 */     return this._absoluteTimeout > other._absoluteTimeout ? 1 : -1;
/*     */   }
/*     */ 
/*     */   public final String statusName()
/*     */   {
/* 238 */     switch (this._status)
/*     */     {
/*     */     case 0:
/* 241 */       return "RUN";
/*     */     case 1:
/* 243 */       return "SCHEDULE_CANCEL";
/*     */     case 2:
/* 245 */       return "CANCEL";
/*     */     case 3:
/* 247 */       return "CANCEL_INTERRUPTED";
/*     */     case 4:
/* 249 */       return "FAIL";
/*     */     case 5:
/* 251 */       return "COMPLETE";
/*     */     case 6:
/* 253 */       return "ZOMBIE";
/*     */     }
/* 255 */     return "UNKNOWN";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.coordinator.ReaperElement
 * JD-Core Version:    0.6.0
 */