/*     */ package com.arjuna.ats.internal.arjuna.gandiva.nameservice;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.gandiva.nameservice.NameServiceImple;
/*     */ import java.io.ByteArrayInputStream;
/*     */ import java.io.ByteArrayOutputStream;
/*     */ import java.io.DataInputStream;
/*     */ import java.io.DataOutputStream;
/*     */ import java.io.IOException;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class PNS extends NameServiceImple
/*     */ {
/*     */   private Properties _properties;
/*     */   private String _name;
/*     */   private boolean _initialized;
/*     */   private Uid _id;
/*     */   private static final char SIGNED_NUMBER = '#';
/*     */   private static final char UNSIGNED_NUMBER = '~';
/*     */   private static final char STRING = '^';
/*     */   private static final char OBJECTNAME = '%';
/*     */   private static final char CLASSNAME = '-';
/*     */   private static final char UID = '+';
/*     */   private static final char nameStart = '!';
/*     */   private static final String pnsName = "PNS:";
/*     */ 
/*     */   public PNS()
/*     */   {
/*  70 */     this._properties = new Properties();
/*  71 */     this._name = null;
/*  72 */     this._initialized = false;
/*     */   }
/*     */ 
/*     */   public PNS(PNS impl)
/*     */   {
/*  77 */     this._properties = new Properties(impl._properties);
/*     */ 
/*  79 */     if (impl._name != null)
/*  80 */       this._name = new String(impl._name);
/*     */     else {
/*  82 */       this._name = null;
/*     */     }
/*  84 */     this._initialized = impl._initialized;
/*     */   }
/*     */ 
/*     */   public int attributeType(String objName, String attrName) throws IOException
/*     */   {
/*  89 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/*  91 */     if (attr == null) {
/*  92 */       throw new IOException("No such attribute.");
/*     */     }
/*     */ 
/*  95 */     if (attr.charAt(0) == '#')
/*  96 */       return 0;
/*  97 */     if (attr.charAt(0) == '~')
/*  98 */       return 1;
/*  99 */     if (attr.charAt(0) == '^')
/* 100 */       return 2;
/* 101 */     if (attr.charAt(0) == '%')
/* 102 */       return 3;
/* 103 */     if (attr.charAt(0) == '-')
/* 104 */       return 4;
/* 105 */     if (attr.charAt(0) == '+') {
/* 106 */       return 5;
/*     */     }
/* 108 */     throw new IOException("Unknown attribute type.");
/*     */   }
/*     */ 
/*     */   public synchronized String firstAttributeName(String objName)
/*     */     throws IOException
/*     */   {
/* 114 */     if (!this._initialized) {
/* 115 */       loadState(objName);
/*     */     }
/* 117 */     if (this._properties.isEmpty()) {
/* 118 */       throw new IOException("No attributes.");
/*     */     }
/*     */ 
/* 121 */     Enumeration keys = this._properties.keys();
/* 122 */     String firstAttr = (String)keys.nextElement();
/*     */ 
/* 124 */     keys = null;
/*     */ 
/* 126 */     return firstAttr;
/*     */   }
/*     */ 
/*     */   public synchronized String nextAttributeName(String objName, String attrName)
/*     */     throws IOException
/*     */   {
/* 132 */     if (!this._initialized) {
/* 133 */       loadState(objName);
/*     */     }
/*     */ 
/* 141 */     if (this._properties.isEmpty()) {
/* 142 */       throw new IOException("No attributes.");
/*     */     }
/*     */ 
/* 145 */     Enumeration keys = this._properties.keys();
/*     */ 
/* 147 */     while (keys.hasMoreElements())
/*     */     {
/* 149 */       String attr = (String)keys.nextElement();
/*     */ 
/* 151 */       if (attr.compareTo(attrName) == 0)
/*     */       {
/* 153 */         if (keys.hasMoreElements())
/*     */         {
/* 155 */           attr = (String)keys.nextElement();
/*     */ 
/* 157 */           keys = null;
/*     */ 
/* 159 */           return attr;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 164 */     throw new IOException("No more attributes.");
/*     */   }
/*     */ 
/*     */   public long getLongAttribute(String objName, String attrName)
/*     */     throws IOException
/*     */   {
/* 170 */     if (!this._initialized) {
/* 171 */       loadState(objName);
/*     */     }
/* 173 */     if (this._properties.isEmpty()) {
/* 174 */       throw new IOException("No attributes.");
/*     */     }
/* 176 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/* 178 */     if (attr != null)
/*     */     {
/* 180 */       if (attr.charAt(0) == '#')
/*     */       {
/*     */         try
/*     */         {
/* 184 */           return Long.parseLong(new String(attr.substring(1)));
/*     */         }
/*     */         catch (NumberFormatException e)
/*     */         {
/* 188 */           throw new IOException("Not a number.");
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 192 */           throw new IOException("Not a number.");
/*     */         }
/*     */       }
/*     */ 
/* 196 */       throw new IOException("Not a signed number.");
/*     */     }
/*     */ 
/* 199 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public String getStringAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 204 */     if (!this._initialized) {
/* 205 */       loadState(objName);
/*     */     }
/* 207 */     if (this._properties.isEmpty()) {
/* 208 */       throw new IOException("No attributes.");
/*     */     }
/* 210 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/* 212 */     if (attr != null)
/*     */     {
/* 214 */       if (attr.charAt(0) == '^')
/*     */       {
/*     */         try
/*     */         {
/* 218 */           return new String(attr.substring(1));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 222 */           throw new IOException("No string.");
/*     */         }
/*     */       }
/*     */ 
/* 226 */       throw new IOException("Not a string.");
/*     */     }
/*     */ 
/* 229 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectNameAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 234 */     if (!this._initialized) {
/* 235 */       loadState(objName);
/*     */     }
/* 237 */     if (this._properties.isEmpty()) {
/* 238 */       throw new IOException("No attributes.");
/*     */     }
/* 240 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/* 242 */     if (attr != null)
/*     */     {
/* 244 */       if (attr.charAt(0) == '%')
/*     */       {
/*     */         try
/*     */         {
/* 248 */           return new ObjectName(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 252 */           throw new IOException("No ObjectName.");
/*     */         }
/*     */       }
/*     */ 
/* 256 */       throw new IOException("Not an ObjectName.");
/*     */     }
/*     */ 
/* 259 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public ClassName getClassNameAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 264 */     if (!this._initialized) {
/* 265 */       loadState(objName);
/*     */     }
/* 267 */     if (this._properties.isEmpty()) {
/* 268 */       throw new IOException("No attributes.");
/*     */     }
/* 270 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/* 272 */     if (attr != null)
/*     */     {
/* 274 */       if (attr.charAt(0) == '-')
/*     */       {
/*     */         try
/*     */         {
/* 278 */           return new ClassName(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 282 */           throw new IOException("No ClassName.");
/*     */         }
/*     */       }
/*     */ 
/* 286 */       throw new IOException("Not a ClassName.");
/*     */     }
/*     */ 
/* 289 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public Uid getUidAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 294 */     if (!this._initialized) {
/* 295 */       loadState(objName);
/*     */     }
/* 297 */     if (this._properties.isEmpty()) {
/* 298 */       throw new IOException("No attributes.");
/*     */     }
/* 300 */     String attr = this._properties.getProperty(attrName, null);
/*     */ 
/* 302 */     if (attr != null)
/*     */     {
/* 304 */       if (attr.charAt(0) == '+')
/*     */       {
/*     */         try
/*     */         {
/* 308 */           return new Uid(new String(attr.substring(1)));
/*     */         }
/*     */         catch (StringIndexOutOfBoundsException e)
/*     */         {
/* 312 */           throw new IOException("No Uid.");
/*     */         }
/*     */       }
/*     */ 
/* 316 */       throw new IOException("Not a Uid.");
/*     */     }
/*     */ 
/* 319 */     throw new IOException("No such attribute.");
/*     */   }
/*     */ 
/*     */   public String setLongAttribute(String objName, String attrName, long value)
/*     */     throws IOException
/*     */   {
/* 330 */     if (!this._initialized) {
/* 331 */       loadState(objName);
/*     */     }
/* 333 */     if (!this._properties.isEmpty())
/*     */     {
/* 335 */       if (this._properties.get(attrName) != null) {
/* 336 */         throw new IOException("Attribute " + attrName + " already present.");
/*     */       }
/*     */     }
/* 339 */     Long l = new Long(value);
/* 340 */     String s = new String('#' + l.toString());
/*     */ 
/* 342 */     this._properties.put(attrName, s);
/*     */ 
/* 344 */     l = null;
/* 345 */     s = null;
/*     */ 
/* 347 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String setStringAttribute(String objName, String attrName, String value) throws IOException
/*     */   {
/* 352 */     if (!this._initialized) {
/* 353 */       loadState(objName);
/*     */     }
/* 355 */     if (!this._properties.isEmpty())
/*     */     {
/* 357 */       if (this._properties.get(attrName) != null) {
/* 358 */         throw new IOException("Attribute " + attrName + " already present.");
/*     */       }
/*     */     }
/* 361 */     String s = new String('^' + value);
/*     */ 
/* 363 */     this._properties.put(attrName, s);
/*     */ 
/* 365 */     s = null;
/*     */ 
/* 367 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String setObjectNameAttribute(String objName, String attrName, ObjectName value) throws IOException
/*     */   {
/* 372 */     if (!this._initialized) {
/* 373 */       loadState(objName);
/*     */     }
/* 375 */     if (!this._properties.isEmpty())
/*     */     {
/* 377 */       if (this._properties.get(attrName) != null) {
/* 378 */         throw new IOException("Attribute " + attrName + " already present.");
/*     */       }
/*     */     }
/* 381 */     String s = new String('%' + value.stringForm());
/*     */ 
/* 383 */     this._properties.put(attrName, s);
/*     */ 
/* 385 */     s = null;
/*     */ 
/* 387 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String setClassNameAttribute(String objName, String attrName, ClassName value) throws IOException
/*     */   {
/* 392 */     if (!this._initialized) {
/* 393 */       loadState(objName);
/*     */     }
/* 395 */     if (!this._properties.isEmpty())
/*     */     {
/* 397 */       if (this._properties.get(attrName) != null) {
/* 398 */         throw new IOException("Attribute " + attrName + " already present.");
/*     */       }
/*     */     }
/* 401 */     String s = new String('-' + value.stringForm());
/*     */ 
/* 403 */     this._properties.put(attrName, s);
/*     */ 
/* 405 */     s = null;
/*     */ 
/* 407 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String setUidAttribute(String objName, String attrName, Uid value) throws IOException
/*     */   {
/* 412 */     if (!this._initialized) {
/* 413 */       loadState(objName);
/*     */     }
/* 415 */     if (!this._properties.isEmpty())
/*     */     {
/* 417 */       if (this._properties.get(attrName) != null) {
/* 418 */         throw new IOException("Attribute " + attrName + " already present.");
/*     */       }
/*     */     }
/* 421 */     String s = new String('+' + value.stringForm());
/*     */ 
/* 423 */     this._properties.put(attrName, s);
/*     */ 
/* 425 */     s = null;
/*     */ 
/* 427 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String removeAttribute(String objName, String attrName) throws IOException
/*     */   {
/* 432 */     if (!this._initialized) {
/* 433 */       loadState(objName);
/*     */     }
/* 435 */     if (this._properties.isEmpty()) {
/* 436 */       throw new IOException("Attribute " + attrName + " not present.");
/*     */     }
/*     */ 
/* 439 */     this._properties.remove(attrName);
/*     */ 
/* 441 */     return saveState();
/*     */   }
/*     */ 
/*     */   public String uniqueAttributeName(String objName)
/*     */     throws IOException
/*     */   {
/* 447 */     Uid u = new Uid();
/*     */ 
/* 449 */     return u.stringForm();
/*     */   }
/*     */ 
/*     */   public ObjectName uniqueObjectName() throws IOException
/*     */   {
/* 454 */     Uid uid = new Uid();
/* 455 */     ObjectName uniqueName = new ObjectName("PNS:" + uid.stringForm());
/*     */ 
/* 457 */     return uniqueName;
/*     */   }
/*     */ 
/*     */   public Object clone()
/*     */   {
/* 462 */     return new PNS(this);
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 467 */     return ArjunaNames.Implementation_NameService_PNS();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 472 */     return ArjunaNames.Implementation_NameService_PNS();
/*     */   }
/*     */ 
/*     */   private void loadState(String objName) throws IOException
/*     */   {
/* 477 */     if (!this._initialized)
/*     */     {
/* 479 */       this._initialized = true;
/*     */ 
/* 481 */       if (objName != null)
/*     */       {
/* 483 */         int namePoint = objName.indexOf('!');
/*     */ 
/* 485 */         if (namePoint == -1) {
/* 486 */           this._name = new String(objName);
/*     */         }
/*     */         else {
/* 489 */           this._name = objName.substring(0, namePoint - 1);
/*     */ 
/* 491 */           String nameString = objName.substring(namePoint, objName.length());
/* 492 */           DataInputStream input = new DataInputStream(new ByteArrayInputStream(nameString.getBytes()));
/*     */ 
/* 494 */           this._properties.load(input);
/*     */ 
/* 496 */           nameString = null;
/* 497 */           input = null;
/*     */         }
/*     */       }
/*     */       else {
/* 501 */         this._name = "";
/*     */       }
/*     */     }
/*     */   }
/*     */ 
/*     */   private String saveState() throws IOException {
/* 507 */     ByteArrayOutputStream os = new ByteArrayOutputStream();
/* 508 */     DataOutputStream output = new DataOutputStream(os);
/*     */ 
/* 510 */     this._properties.store(output, null);
/*     */ 
/* 512 */     output = null;
/*     */ 
/* 514 */     return new String(this._name + '!' + os.toString());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.gandiva.nameservice.PNS
 * JD-Core Version:    0.6.0
 */