/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ 
/*     */ public class ActionStore extends ShadowNoFileLockStore
/*     */ {
/* 346 */   private static boolean checkSync = false;
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  71 */     return 0;
/*     */   }
/*     */ 
/*     */   public int currentState(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/*  84 */     int theState = 0;
/*     */ 
/*  86 */     if (storeValid())
/*     */     {
/*  88 */       String path = genPathName(objUid, tName, 11);
/*     */ 
/*  90 */       if (exists(path)) {
/*  91 */         theState = 1;
/*     */       }
/*  93 */       path = null;
/*     */     }
/*     */ 
/*  96 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*     */     {
/*  98 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 16L, "com.arjuna.ats.internal.arjuna.objectstore.ActionStore_1", new Object[] { objUid, tName, ObjectStore.stateStatusString(theState) });
/*     */     }
/*     */ 
/* 104 */     return theState;
/*     */   }
/*     */ 
/*     */   public boolean commit_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/* 116 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 118 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.commit_state(" + objUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 123 */     boolean result = false;
/*     */ 
/* 127 */     if (!storeValid()) {
/* 128 */       return false;
/*     */     }
/* 130 */     if (currentState(objUid, tName) == 1) {
/* 131 */       result = true;
/*     */     }
/* 133 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean hide_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 138 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 140 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.hide_state(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 144 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean reveal_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 149 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 151 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.reveal_state(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 155 */     return false;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 160 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 162 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.read_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 166 */     return super.read_committed(storeUid, tName);
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 171 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 173 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.read_uncommitted(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 177 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 182 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 184 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.remove_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 188 */     return super.remove_committed(storeUid, tName);
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 193 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 195 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.remove_uncommitted(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 199 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException
/*     */   {
/* 204 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 206 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.write_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 210 */     return super.write_committed(storeUid, tName, state);
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException
/*     */   {
/* 215 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 217 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ActionStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")");
/*     */     }
/*     */ 
/* 221 */     return false;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 226 */     return ArjunaNames.Implementation_ObjectStore_ActionStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 231 */     return ArjunaNames.Implementation_ObjectStore_ActionStore();
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create()
/*     */   {
/* 241 */     return new ActionStore("");
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(Object[] param)
/*     */   {
/* 250 */     if (param == null) {
/* 251 */       return null;
/*     */     }
/* 253 */     String location = (String)param[0];
/* 254 */     Integer shareStatus = (Integer)param[1];
/* 255 */     int ss = 14;
/*     */ 
/* 257 */     if (shareStatus != null)
/*     */     {
/*     */       try
/*     */       {
/* 261 */         if (shareStatus.intValue() == 13)
/* 262 */           ss = 13;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 266 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 268 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ActionStore_2", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 274 */     return new ActionStore(location, ss);
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(ObjectName param)
/*     */   {
/* 279 */     if (param == null) {
/* 280 */       return null;
/*     */     }
/* 282 */     return new ActionStore(param);
/*     */   }
/*     */ 
/*     */   protected ActionStore(String locationOfStore)
/*     */   {
/* 287 */     this(locationOfStore, 14);
/*     */   }
/*     */ 
/*     */   protected ActionStore(String locationOfStore, int shareStatus)
/*     */   {
/* 292 */     super(shareStatus);
/*     */     try
/*     */     {
/* 296 */       setupStore(locationOfStore);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 300 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 301 */         tsLogger.arjLogger.warn(e.getMessage());
/*     */       }
/* 303 */       super.makeInvalid();
/*     */ 
/* 305 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected ActionStore()
/*     */   {
/* 311 */     this(14);
/*     */   }
/*     */ 
/*     */   protected ActionStore(int shareStatus)
/*     */   {
/* 316 */     super(shareStatus);
/*     */   }
/*     */ 
/*     */   protected ActionStore(ObjectName objName)
/*     */   {
/* 321 */     super(objName);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean setupStore(String location) throws ObjectStoreException
/*     */   {
/* 326 */     if (!checkSync)
/*     */     {
/* 328 */       String syncOpt = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.transactionSync");
/*     */ 
/* 330 */       if (syncOpt != null)
/*     */       {
/* 332 */         if (syncOpt.compareTo("OFF") == 0)
/* 333 */           syncOff();
/*     */         else
/* 335 */           syncOn();
/*     */       }
/*     */       else {
/* 338 */         syncOn();
/*     */       }
/* 340 */       checkSync = true;
/*     */     }
/*     */ 
/* 343 */     return super.setupStore(location);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.ActionStore
 * JD-Core Version:    0.6.0
 */