/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.common.arjPropertyManager;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.jdbc.JDBCAccess;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.io.IOException;
/*     */ 
/*     */ public class JDBCActionStore extends JDBCStore
/*     */ {
/*     */   private JDBCAccess _txJDBCAccess;
/*     */   private String _txClassName;
/*     */   private String _txTableName;
/* 287 */   private static String _defaultTxTableName = "JBossTSTxTable";
/*     */ 
/*     */   public int typeIs()
/*     */   {
/*  71 */     return 16;
/*     */   }
/*     */ 
/*     */   public synchronized boolean commit_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/*  83 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/*  85 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.commit_state(" + objUid + ", " + tName + ")");
/*     */     }
/*     */ 
/*  90 */     boolean result = false;
/*     */ 
/*  94 */     if (!storeValid()) {
/*  95 */       return false;
/*     */     }
/*  97 */     if (currentState(objUid, tName) == 1) {
/*  98 */       result = true;
/*     */     }
/* 100 */     return result;
/*     */   }
/*     */ 
/*     */   public boolean hide_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 105 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 107 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.hide_state(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 111 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean reveal_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 116 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 118 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.reveal_state(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 122 */     return false;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 127 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 129 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.read_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 133 */     return super.read_committed(storeUid, tName);
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 138 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 140 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.read_uncommitted(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 144 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 149 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 151 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.remove_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 155 */     return super.remove_committed(storeUid, tName);
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 160 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 162 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.remove_uncommitted(" + u + ", " + tn + ")");
/*     */     }
/*     */ 
/* 166 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException
/*     */   {
/* 171 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 173 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.write_committed(" + storeUid + ", " + tName + ")");
/*     */     }
/*     */ 
/* 177 */     return super.write_committed(storeUid, tName, state);
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException
/*     */   {
/* 182 */     if (tsLogger.arjLogger.debugAllowed())
/*     */     {
/* 184 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "JDBCActionStore.write_uncommitted(" + u + ", " + tn + ", " + s + ")");
/*     */     }
/*     */ 
/* 188 */     return false;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 193 */     return ArjunaNames.Implementation_ObjectStore_JDBCActionStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 198 */     return ArjunaNames.Implementation_ObjectStore_JDBCActionStore();
/*     */   }
/*     */ 
/*     */   public static JDBCStore create()
/*     */   {
/* 203 */     return new JDBCActionStore();
/*     */   }
/*     */ 
/*     */   public static JDBCStore create(Object[] param)
/*     */   {
/* 208 */     if (param == null) {
/* 209 */       return null;
/*     */     }
/* 211 */     return new JDBCActionStore((String)param[0]);
/*     */   }
/*     */ 
/*     */   public static JDBCStore create(ObjectName param)
/*     */   {
/* 216 */     if (param == null) {
/* 217 */       return null;
/*     */     }
/* 219 */     return new JDBCActionStore(param);
/*     */   }
/*     */ 
/*     */   private JDBCActionStore()
/*     */   {
/*     */   }
/*     */ 
/*     */   private JDBCActionStore(String tableName)
/*     */   {
/* 229 */     super(tableName);
/*     */   }
/*     */ 
/*     */   private JDBCActionStore(ObjectName objName)
/*     */   {
/* 234 */     super(objName);
/*     */   }
/*     */ 
/*     */   protected String getAccessClassName()
/*     */   {
/* 239 */     if (this._txClassName == null)
/* 240 */       this._txClassName = arjPropertyManager.propertyManager.getProperty("com.arjuna.ats.arjuna.objectstore.jdbcTxDbAccess");
/* 241 */     return this._txClassName;
/*     */   }
/*     */ 
/*     */   protected void setAccessClassName(String txClassName)
/*     */   {
/* 246 */     this._txClassName = txClassName;
/*     */   }
/*     */ 
/*     */   protected String getDefaultTableName()
/*     */   {
/* 251 */     return _defaultTxTableName;
/*     */   }
/*     */ 
/*     */   protected String getAccessClassNameFromObject(ObjectName objName) throws IOException
/*     */   {
/* 256 */     return objName.getStringAttribute("com.arjuna.ats.arjuna.objectstore.jdbcTxDbAccess");
/*     */   }
/*     */ 
/*     */   protected String getTableNameFromObject(ObjectName objName) throws IOException
/*     */   {
/* 261 */     return objName.getStringAttribute(ArjunaNames.Implementation_ObjectStore_JDBC_tableName());
/*     */   }
/*     */ 
/*     */   protected JDBCAccess getJDBCAccess()
/*     */   {
/* 266 */     return this._txJDBCAccess;
/*     */   }
/*     */ 
/*     */   protected void setJDBCAccess(JDBCAccess jdbcAccess)
/*     */   {
/* 271 */     this._txJDBCAccess = jdbcAccess;
/*     */   }
/*     */ 
/*     */   protected String getTableName()
/*     */   {
/* 276 */     return this._txTableName;
/*     */   }
/*     */ 
/*     */   protected void setTableName(String tableName)
/*     */   {
/* 281 */     this._txTableName = tableName;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.JDBCActionStore
 * JD-Core Version:    0.6.0
 */