/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.ArjunaNames;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public class NullActionStore extends ShadowNoFileLockStore
/*     */ {
/*     */   public int typeIs()
/*     */   {
/*  71 */     return 19;
/*     */   }
/*     */ 
/*     */   public int currentState(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/*  82 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean commit_state(Uid objUid, String tName)
/*     */     throws ObjectStoreException
/*     */   {
/*  94 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean hide_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/*  99 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean reveal_state(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 104 */     return false;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 109 */     return null;
/*     */   }
/*     */ 
/*     */   public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 114 */     return null;
/*     */   }
/*     */ 
/*     */   public boolean remove_committed(Uid storeUid, String tName) throws ObjectStoreException
/*     */   {
/* 119 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException
/*     */   {
/* 124 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean write_committed(Uid storeUid, String tName, OutputObjectState state) throws ObjectStoreException
/*     */   {
/* 129 */     return true;
/*     */   }
/*     */ 
/*     */   public boolean write_uncommitted(Uid u, String tn, OutputObjectState s) throws ObjectStoreException
/*     */   {
/* 134 */     return false;
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 139 */     return ArjunaNames.Implementation_ObjectStore_NullActionStore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 144 */     return ArjunaNames.Implementation_ObjectStore_NullActionStore();
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create()
/*     */   {
/* 154 */     return new NullActionStore("");
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(Object[] param)
/*     */   {
/* 163 */     if (param == null) {
/* 164 */       return null;
/*     */     }
/* 166 */     String location = (String)param[0];
/* 167 */     Integer shareStatus = (Integer)param[1];
/* 168 */     int ss = 14;
/*     */ 
/* 170 */     if (shareStatus != null)
/*     */     {
/*     */       try
/*     */       {
/* 174 */         if (shareStatus.intValue() == 13)
/* 175 */           ss = 13;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 179 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */         {
/* 181 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.NullActionStore_2", new Object[] { e });
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 187 */     return new NullActionStore(location, ss);
/*     */   }
/*     */ 
/*     */   public static ShadowingStore create(ObjectName param)
/*     */   {
/* 192 */     if (param == null) {
/* 193 */       return null;
/*     */     }
/* 195 */     return new NullActionStore(param);
/*     */   }
/*     */ 
/*     */   protected NullActionStore(String locationOfStore)
/*     */   {
/* 200 */     this(locationOfStore, 14);
/*     */   }
/*     */ 
/*     */   protected NullActionStore(String locationOfStore, int shareStatus)
/*     */   {
/* 205 */     super(shareStatus);
/*     */     try
/*     */     {
/* 209 */       setupStore(locationOfStore);
/*     */     }
/*     */     catch (ObjectStoreException e)
/*     */     {
/* 213 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 214 */         tsLogger.arjLogger.warn(e.getMessage());
/*     */       }
/* 216 */       super.makeInvalid();
/*     */ 
/* 218 */       throw new FatalError(e.toString());
/*     */     }
/*     */   }
/*     */ 
/*     */   protected NullActionStore()
/*     */   {
/* 224 */     this(14);
/*     */   }
/*     */ 
/*     */   protected NullActionStore(int shareStatus)
/*     */   {
/* 229 */     super(shareStatus);
/*     */   }
/*     */ 
/*     */   protected NullActionStore(ObjectName objName)
/*     */   {
/* 234 */     super(objName);
/*     */   }
/*     */ 
/*     */   protected synchronized boolean setupStore(String location) throws ObjectStoreException
/*     */   {
/* 239 */     return true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.NullActionStore
 * JD-Core Version:    0.6.0
 */