/*     */ package com.arjuna.ats.internal.arjuna.objectstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.gandiva.inventory.InventoryElement;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.objectstore.ObjectStoreImple;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ 
/*     */ public abstract class ObjectStoreSetup
/*     */   implements InventoryElement
/*     */ {
/* 195 */   private static boolean _alwaysCreate = false;
/* 196 */   private static StoreList _headOfList = null;
/*     */ 
/*     */   protected abstract ObjectStoreImple create(String paramString);
/*     */ 
/*     */   protected synchronized ObjectStoreImple createStore(String location)
/*     */   {
/*  65 */     StoreList slptr = null;
/*  66 */     boolean found = false; boolean endOfList = false;
/*     */ 
/*  68 */     if (location == null) {
/*  69 */       location = "";
/*     */     }
/*  71 */     slptr = _headOfList;
/*     */ 
/*  73 */     while ((slptr != null) && (!found) && (!endOfList))
/*     */     {
/*  75 */       if (!_alwaysCreate)
/*     */       {
/*  77 */         String sName = slptr.instance.getStoreName();
/*     */ 
/*  79 */         if (sName == null) {
/*  80 */           sName = "";
/*     */         }
/*  82 */         if (sName.compareTo(location) == 0)
/*     */         {
/*  84 */           found = true;
/*  85 */           break;
/*     */         }
/*     */       }
/*     */ 
/*  89 */       if (slptr.next != null) {
/*  90 */         slptr = slptr.next; continue;
/*     */       }
/*  92 */       endOfList = true;
/*     */     }
/*     */ 
/*  95 */     if (!found)
/*     */     {
/*  97 */       StoreList toAdd = new StoreList();
/*  98 */       toAdd.instance = create(location);
/*     */ 
/* 100 */       if (_headOfList == null)
/* 101 */         _headOfList = toAdd;
/*     */       else {
/* 103 */         slptr.next = toAdd;
/*     */       }
/* 105 */       slptr = toAdd;
/*     */     }
/*     */ 
/* 108 */     slptr.useCount += 1L;
/*     */ 
/* 110 */     return slptr.instance;
/*     */   }
/*     */ 
/*     */   private synchronized boolean referenceStore(ObjectStoreImple toRef)
/*     */   {
/* 115 */     StoreList slptr = null;
/* 116 */     boolean found = false; boolean endOfList = false;
/*     */ 
/* 118 */     slptr = _headOfList;
/* 119 */     while ((slptr != null) && (!found) && (!endOfList))
/*     */     {
/* 121 */       if (slptr.instance == toRef) {
/* 122 */         found = true; continue;
/*     */       }
/*     */ 
/* 125 */       if (slptr.next != null) {
/* 126 */         slptr = slptr.next; continue;
/*     */       }
/* 128 */       endOfList = true;
/*     */     }
/*     */ 
/* 132 */     if (!found)
/*     */     {
/* 134 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 135 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_1");
/* 136 */       return false;
/*     */     }
/*     */ 
/* 139 */     slptr.useCount += 1L;
/*     */ 
/* 141 */     return true;
/*     */   }
/*     */ 
/*     */   private synchronized void destroyStore(String location, ObjectStoreImple toDelete)
/*     */   {
/* 146 */     if (toDelete == null) {
/* 147 */       return;
/*     */     }
/* 149 */     StoreList slptr = null; StoreList slmarker = null;
/* 150 */     boolean found = false;
/*     */ 
/* 152 */     if (location == null) {
/* 153 */       location = "";
/*     */     }
/* 155 */     if (_headOfList == null)
/*     */     {
/* 157 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 158 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_2");
/* 159 */       return;
/*     */     }
/*     */ 
/* 162 */     slptr = _headOfList;
/* 163 */     while ((slptr != null) && (!found))
/*     */     {
/* 165 */       if (slptr.instance == toDelete) {
/* 166 */         found = true; continue;
/*     */       }
/*     */ 
/* 169 */       slmarker = slptr;
/* 170 */       slptr = slptr.next;
/*     */     }
/*     */ 
/* 174 */     if (!found)
/*     */     {
/* 176 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 177 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup_3");
/* 178 */       toDelete = null;
/* 179 */       return;
/*     */     }
/*     */ 
/* 182 */     slptr.useCount -= 1L;
/*     */ 
/* 184 */     if (slptr.useCount == 0L)
/*     */     {
/* 186 */       if (slmarker == null)
/* 187 */         _headOfList = slptr.next;
/*     */       else {
/* 189 */         slmarker.next = slptr.next;
/*     */       }
/* 191 */       toDelete = null;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.ObjectStoreSetup
 * JD-Core Version:    0.6.0
 */