/*      */ package com.arjuna.ats.internal.arjuna.objectstore;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.ArjunaNames;
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.exceptions.FatalError;
/*      */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*      */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*      */ import com.arjuna.ats.arjuna.gandiva.ObjectName;
/*      */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*      */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.ats.arjuna.utils.FileLock;
/*      */ import com.arjuna.ats.arjuna.utils.Utility;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import java.io.File;
/*      */ import java.io.FileDescriptor;
/*      */ import java.io.FileInputStream;
/*      */ import java.io.FileNotFoundException;
/*      */ import java.io.FileOutputStream;
/*      */ import java.io.IOException;
/*      */ import java.io.SyncFailedException;
/*      */ import java.util.ResourceBundle;
/*      */ 
/*      */ public class ShadowingStore extends FileSystemStore
/*      */ {
/*      */   public static final char HIDDINGCHAR = '#';
/*      */   public static final char SHADOWCHAR = '!';
/* 1015 */   private static boolean isWindows = Utility.isWindows();
/*      */ 
/*      */   public int typeIs()
/*      */   {
/*  101 */     return 2;
/*      */   }
/*      */ 
/*      */   public int currentState(Uid objUid, String tName)
/*      */     throws ObjectStoreException
/*      */   {
/*  113 */     int theState = 0;
/*      */ 
/*  115 */     if (storeValid())
/*      */     {
/*  117 */       String path = genPathName(objUid, tName, 10);
/*      */ 
/*  119 */       if (exists(path))
/*      */       {
/*  121 */         theState = 2;
/*      */       }
/*      */       else
/*      */       {
/*  125 */         path = path + '#';
/*      */ 
/*  127 */         if (exists(path))
/*      */         {
/*  129 */           theState = 6;
/*      */         }
/*      */         else
/*      */         {
/*  133 */           path = genPathName(objUid, tName, 11);
/*      */ 
/*  135 */           if (exists(path))
/*      */           {
/*  137 */             theState = 1;
/*      */           }
/*      */           else
/*      */           {
/*  141 */             path = path + '#';
/*      */ 
/*  143 */             if (exists(path))
/*      */             {
/*  145 */               theState = 5;
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*  151 */     if (tsLogger.arjLoggerI18N.debugAllowed())
/*      */     {
/*  153 */       tsLogger.arjLoggerI18N.debug(16L, 4L, 16L, "com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_22", new Object[] { objUid, tName, ObjectStore.stateStatusString(theState) });
/*      */     }
/*      */ 
/*  159 */     return theState;
/*      */   }
/*      */ 
/*      */   public boolean commit_state(Uid objUid, String tName)
/*      */     throws ObjectStoreException
/*      */   {
/*  170 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  172 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.commit_state(" + objUid + ", " + tName + ")");
/*      */     }
/*      */ 
/*  176 */     boolean result = false;
/*      */ 
/*  180 */     if (!storeValid())
/*      */     {
/*  182 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  183 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_1");
/*      */       }
/*  185 */       return false;
/*      */     }
/*      */ 
/*  188 */     if (tName != null)
/*      */     {
/*  190 */       String shadow = null;
/*  191 */       String filename = null;
/*  192 */       int state = currentState(objUid, tName);
/*      */ 
/*  194 */       if ((state == 6) || (state == 2))
/*      */       {
/*  197 */         shadow = genPathName(objUid, tName, 10);
/*  198 */         filename = genPathName(objUid, tName, 11);
/*      */ 
/*  200 */         if (state == 6)
/*      */         {
/*  204 */           shadow = shadow + '#';
/*  205 */           filename = filename + '#';
/*      */         }
/*      */ 
/*  208 */         File shadowState = new File(shadow);
/*  209 */         File originalState = new File(filename);
/*      */ 
/*  218 */         result = renameFromTo(shadowState, originalState);
/*      */ 
/*  220 */         if (!result)
/*      */         {
/*  222 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  224 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_2", new Object[] { shadow, filename });
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  230 */           super.addToCache(filename);
/*  231 */           super.removeFromCache(shadow);
/*      */         }
/*      */ 
/*  234 */         shadowState = null;
/*  235 */         originalState = null;
/*      */       }
/*      */       else {
/*  238 */         result = true;
/*      */       }
/*      */     } else {
/*  241 */       throw new ObjectStoreException("ShadowStore::commit_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
/*      */     }
/*  243 */     return result;
/*      */   }
/*      */ 
/*      */   public boolean hide_state(Uid objUid, String tName)
/*      */     throws ObjectStoreException
/*      */   {
/*  254 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  256 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.hide_state(" + objUid + ", " + tName + ")");
/*      */     }
/*      */ 
/*  260 */     boolean hiddenOk = true;
/*      */ 
/*  264 */     if (storeValid())
/*      */     {
/*  266 */       int state = currentState(objUid, tName);
/*  267 */       String path1 = null;
/*  268 */       String path2 = null;
/*      */ 
/*  270 */       switch (state)
/*      */       {
/*      */       case 5:
/*      */       case 6:
/*  274 */         break;
/*      */       case 1:
/*  277 */         path1 = genPathName(objUid, tName, 11);
/*  278 */         path2 = new String(path1) + '#';
/*      */ 
/*  280 */         File newState = new File(path1);
/*  281 */         File oldState = new File(path2);
/*      */ 
/*  283 */         if (renameFromTo(newState, oldState))
/*      */         {
/*  285 */           super.removeFromCache(path1);
/*  286 */           super.addToCache(path2);
/*      */         }
/*  290 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  292 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_3", new Object[] { newState, oldState });
/*      */         }
/*      */ 
/*  297 */         newState = null;
/*  298 */         oldState = null;
/*      */ 
/*  300 */         break;
/*      */       case 2:
/*  304 */         path1 = genPathName(objUid, tName, 10);
/*  305 */         path2 = new String(path1) + '#';
/*      */ 
/*  307 */         File newState = new File(path1);
/*  308 */         File oldState = new File(path2);
/*      */ 
/*  310 */         if (renameFromTo(newState, oldState))
/*      */         {
/*  312 */           super.removeFromCache(path1);
/*  313 */           super.addToCache(path2);
/*      */         }
/*  317 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  319 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_3", new Object[] { newState, oldState });
/*      */         }
/*      */ 
/*  324 */         newState = null;
/*  325 */         oldState = null;
/*      */ 
/*  327 */         break;
/*      */       case 3:
/*      */       case 4:
/*      */       default:
/*  330 */         hiddenOk = false;
/*      */       }
/*      */     }
/*      */     else {
/*  334 */       hiddenOk = false;
/*      */     }
/*  336 */     return hiddenOk;
/*      */   }
/*      */ 
/*      */   public boolean reveal_state(Uid objUid, String tName)
/*      */     throws ObjectStoreException
/*      */   {
/*  342 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  344 */       tsLogger.arjLogger.debug(16L, 4L, 16L, "ShadowingStore.reveal_state(" + objUid + ", " + tName + ")");
/*      */     }
/*      */ 
/*  348 */     boolean revealedOk = true;
/*      */ 
/*  350 */     if (storeValid())
/*      */     {
/*  352 */       int state = currentState(objUid, tName);
/*  353 */       String path1 = null;
/*  354 */       String path2 = null;
/*      */ 
/*  356 */       switch (state)
/*      */       {
/*      */       case 6:
/*  360 */         path1 = genPathName(objUid, tName, 10);
/*  361 */         path2 = new String(path1) + '#';
/*      */ 
/*  363 */         File newState = new File(path2);
/*  364 */         File oldState = new File(path1);
/*      */ 
/*  366 */         if (renameFromTo(newState, oldState))
/*      */         {
/*  368 */           super.removeFromCache(path2);
/*  369 */           super.addToCache(path1);
/*      */         }
/*  373 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  375 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_4", new Object[] { newState, oldState });
/*      */         }
/*      */ 
/*  380 */         newState = null;
/*  381 */         oldState = null;
/*      */ 
/*  383 */         break;
/*      */       case 5:
/*  387 */         path1 = genPathName(objUid, tName, 11);
/*  388 */         path2 = new String(path1) + '#';
/*      */ 
/*  390 */         File newState = new File(path2);
/*  391 */         File oldState = new File(path1);
/*      */ 
/*  393 */         if (renameFromTo(newState, oldState))
/*      */         {
/*  395 */           super.removeFromCache(path2);
/*  396 */           super.addToCache(path1);
/*      */         }
/*  400 */         else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  402 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_4", new Object[] { newState, oldState });
/*      */         }
/*      */ 
/*  407 */         newState = null;
/*  408 */         oldState = null;
/*      */ 
/*  410 */         break;
/*      */       case 1:
/*      */       case 2:
/*  414 */         break;
/*      */       case 3:
/*      */       case 4:
/*      */       default:
/*  416 */         revealedOk = false;
/*      */       }
/*      */     }
/*      */     else {
/*  420 */       revealedOk = false;
/*      */     }
/*  422 */     return revealedOk;
/*      */   }
/*      */ 
/*      */   public ClassName className()
/*      */   {
/*  427 */     return ArjunaNames.Implementation_ObjectStore_ShadowingStore();
/*      */   }
/*      */ 
/*      */   public static ClassName name()
/*      */   {
/*  432 */     return ArjunaNames.Implementation_ObjectStore_ShadowingStore();
/*      */   }
/*      */ 
/*      */   public static ShadowingStore create()
/*      */   {
/*  437 */     return new ShadowingStore("");
/*      */   }
/*      */ 
/*      */   public static ShadowingStore create(Object[] param)
/*      */   {
/*  442 */     if (param == null) {
/*  443 */       return null;
/*      */     }
/*  445 */     String location = (String)param[0];
/*  446 */     Integer shareStatus = (Integer)param[1];
/*  447 */     int ss = 14;
/*      */ 
/*  449 */     if (shareStatus != null)
/*      */     {
/*      */       try
/*      */       {
/*  453 */         if (shareStatus.intValue() == 13)
/*  454 */           ss = 13;
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*  458 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  460 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_5", new Object[] { e });
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  466 */     return new ShadowingStore(location, ss);
/*      */   }
/*      */ 
/*      */   public static ShadowingStore create(ObjectName param)
/*      */   {
/*  471 */     if (param == null) {
/*  472 */       return null;
/*      */     }
/*  474 */     return new ShadowingStore(param);
/*      */   }
/*      */ 
/*      */   protected String genPathName(Uid objUid, String tName, int ft)
/*      */     throws ObjectStoreException
/*      */   {
/*  487 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  489 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.genPathName(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
/*      */     }
/*      */ 
/*  493 */     String fname = super.genPathName(objUid, tName, ft);
/*      */ 
/*  495 */     if (ft == 10) {
/*  496 */       fname = fname + '!';
/*      */     }
/*  498 */     return fname;
/*      */   }
/*      */ 
/*      */   protected String revealedId(String name)
/*      */   {
/*  503 */     int index = name.indexOf('#');
/*      */ 
/*  505 */     if (index == -1) {
/*  506 */       index = name.indexOf('!');
/*      */     }
/*  508 */     if (index != -1) {
/*  509 */       return name.substring(0, index);
/*      */     }
/*  511 */     return name;
/*      */   }
/*      */ 
/*      */   protected InputObjectState read_state(Uid objUid, String tName, int ft)
/*      */     throws ObjectStoreException
/*      */   {
/*  517 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  519 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.read_state(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
/*      */     }
/*      */ 
/*  523 */     if (!storeValid())
/*      */     {
/*  525 */       if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  526 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_6");
/*      */       }
/*  528 */       return null;
/*      */     }
/*      */ 
/*  531 */     InputObjectState new_image = null;
/*      */ 
/*  533 */     if (tName != null)
/*      */     {
/*  535 */       int state = currentState(objUid, tName);
/*      */ 
/*  537 */       if ((state == 1) || (state == 2))
/*      */       {
/*  544 */         if (((state == 1) && (ft != 11)) || ((state == 2) && (ft != 10)))
/*      */         {
/*  547 */           return null;
/*      */         }
/*      */ 
/*  550 */         String fname = genPathName(objUid, tName, ft);
/*  551 */         File fd = openAndLock(fname, 0, false);
/*      */ 
/*  553 */         if (fd != null)
/*      */         {
/*  555 */           int imageSize = (int)fd.length();
/*  556 */           byte[] buffer = new byte[imageSize];
/*  557 */           FileInputStream ifile = null;
/*      */           try
/*      */           {
/*  561 */             ifile = new FileInputStream(fd);
/*      */           }
/*      */           catch (FileNotFoundException e)
/*      */           {
/*  565 */             closeAndUnlock(fd, ifile, null);
/*      */ 
/*  567 */             throw new ObjectStoreException("ShadowingStore::read_state error: " + e);
/*      */           }
/*      */ 
/*      */           try
/*      */           {
/*  574 */             if ((buffer != null) && (ifile.read(buffer, 0, imageSize) == imageSize))
/*      */             {
/*  576 */               new_image = new InputObjectState(objUid, tName, buffer);
/*      */             }
/*      */             else {
/*  579 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_7");
/*      */             }
/*      */           }
/*      */           catch (IOException e)
/*      */           {
/*  584 */             closeAndUnlock(fd, ifile, null);
/*      */ 
/*  586 */             throw new ObjectStoreException("ShadowingStore::read_state failed: " + e);
/*      */           }
/*      */ 
/*  589 */           if (!closeAndUnlock(fd, ifile, null))
/*      */           {
/*  591 */             if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/*  592 */               tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_8", new Object[] { fname });
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  600 */       throw new ObjectStoreException("ShadowStore::read_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
/*      */     }
/*  602 */     return new_image;
/*      */   }
/*      */ 
/*      */   protected boolean remove_state(Uid objUid, String name, int ft) throws ObjectStoreException
/*      */   {
/*  607 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  609 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.remove_state(" + objUid + ", " + name + ", " + ObjectStore.stateTypeString(ft) + ")");
/*      */     }
/*      */ 
/*  613 */     boolean removeOk = true;
/*      */ 
/*  615 */     if (!storeValid()) {
/*  616 */       return false;
/*      */     }
/*  618 */     if (name != null)
/*      */     {
/*  620 */       int state = currentState(objUid, name);
/*      */ 
/*  622 */       if ((state == 1) || (state == 2))
/*      */       {
/*  624 */         String fname = genPathName(objUid, name, ft);
/*  625 */         File fd = openAndLock(fname, 1, false);
/*      */ 
/*  627 */         if (fd != null)
/*      */         {
/*  629 */           if (!fd.canWrite())
/*      */           {
/*  631 */             removeOk = false;
/*      */ 
/*  633 */             if (ft == 11)
/*      */             {
/*  635 */               if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */               {
/*  637 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_9", new Object[] { objUid, name });
/*      */               }
/*      */ 
/*  641 */               if (!fd.exists())
/*      */               {
/*  643 */                 if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */                 {
/*  645 */                   tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_10", new Object[] { objUid, name });
/*      */                 }
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*  652 */           else if (!fd.delete())
/*      */           {
/*  654 */             removeOk = false;
/*      */ 
/*  656 */             if (ft == 11)
/*      */             {
/*  658 */               if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */               {
/*  660 */                 tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_11", new Object[] { fname });
/*      */               }
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  666 */           closeAndUnlock(fd, null, null);
/*      */         }
/*      */         else
/*      */         {
/*  670 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */           {
/*  672 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_12", new Object[] { objUid });
/*      */           }
/*      */ 
/*  676 */           removeOk = false;
/*      */         }
/*      */ 
/*  679 */         if (removeOk)
/*  680 */           super.removeFromCache(fname);
/*      */       }
/*      */       else
/*      */       {
/*  684 */         removeOk = false;
/*      */ 
/*  686 */         if (state == 0)
/*  687 */           tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_14", new Object[] { objUid, name });
/*      */         else
/*  689 */           tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_15", new Object[] { objUid, name });
/*      */       }
/*      */     }
/*      */     else
/*      */     {
/*  694 */       removeOk = false;
/*      */ 
/*  696 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/*  698 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_17", new Object[] { objUid });
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  703 */     return removeOk;
/*      */   }
/*      */ 
/*      */   protected boolean write_state(Uid objUid, String tName, OutputObjectState state, int ft)
/*      */     throws ObjectStoreException
/*      */   {
/*  717 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  719 */       tsLogger.arjLogger.debug(16L, 2L, 16L, "ShadowingStore.write_state(" + objUid + ", " + tName + ", " + ObjectStore.stateTypeString(ft) + ")");
/*      */     }
/*      */ 
/*  723 */     if (!storeValid()) {
/*  724 */       return false;
/*      */     }
/*  726 */     if (tName != null)
/*      */     {
/*  728 */       String fname = genPathName(objUid, tName, ft);
/*  729 */       File fd = openAndLock(fname, 1, true);
/*  730 */       int imageSize = state.length();
/*      */ 
/*  732 */       if (fd == null)
/*      */       {
/*  734 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  736 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_18", new Object[] { fname });
/*      */         }
/*      */ 
/*  740 */         return false;
/*      */       }
/*      */ 
/*  743 */       FileOutputStream ofile = null;
/*      */ 
/*  745 */       if (imageSize > 0)
/*      */       {
/*      */         try
/*      */         {
/*  749 */           ofile = new FileOutputStream(fd);
/*      */ 
/*  751 */           ofile.write(state.buffer(), 0, imageSize);
/*      */ 
/*  753 */           if (synchronousWrites())
/*      */           {
/*  757 */             ofile.flush();
/*      */ 
/*  759 */             FileDescriptor fileDesc = ofile.getFD();
/*  760 */             fileDesc.sync();
/*      */           }
/*      */         }
/*      */         catch (SyncFailedException e)
/*      */         {
/*  765 */           closeAndUnlock(fd, null, ofile);
/*      */ 
/*  767 */           throw new ObjectStoreException("ShadowingStore::write_state() - write failed to sync for " + fname);
/*      */         }
/*      */         catch (FileNotFoundException e)
/*      */         {
/*  771 */           closeAndUnlock(fd, null, ofile);
/*      */ 
/*  773 */           e.printStackTrace();
/*      */ 
/*  775 */           throw new ObjectStoreException("ShadowingStore::write_state() - write failed to locate file " + fname + ": " + e);
/*      */         }
/*      */         catch (IOException e)
/*      */         {
/*  779 */           closeAndUnlock(fd, null, ofile);
/*      */ 
/*  781 */           e.printStackTrace();
/*      */ 
/*  783 */           throw new ObjectStoreException("ShadowingStore::write_state() - write failed for " + fname + ": " + e);
/*      */         }
/*      */       }
/*      */ 
/*  787 */       if (!closeAndUnlock(fd, null, ofile))
/*      */       {
/*  789 */         if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */         {
/*  791 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_19", new Object[] { fname });
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  796 */       super.addToCache(fname);
/*      */ 
/*  798 */       return true;
/*      */     }
/*      */ 
/*  801 */     throw new ObjectStoreException("ShadowStore::write_state - " + tsLogger.log_mesg.getString("com.arjuna.ats.internal.arjuna.objectstore.notypenameuid") + objUid);
/*      */   }
/*      */ 
/*      */   protected ShadowingStore(String locationOfStore)
/*      */   {
/*  806 */     this(locationOfStore, 14);
/*      */   }
/*      */ 
/*      */   protected ShadowingStore(String locationOfStore, int shareStatus)
/*      */   {
/*  811 */     super(shareStatus);
/*      */ 
/*  813 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  815 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore(" + locationOfStore + ")");
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  821 */       setupStore(locationOfStore);
/*      */     }
/*      */     catch (ObjectStoreException e)
/*      */     {
/*  825 */       tsLogger.arjLogger.fatal(e.getMessage());
/*      */ 
/*  827 */       throw new FatalError(e.toString());
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ShadowingStore()
/*      */   {
/*  833 */     this(14);
/*      */   }
/*      */ 
/*      */   protected ShadowingStore(int shareStatus)
/*      */   {
/*  838 */     super(shareStatus);
/*      */ 
/*  840 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  842 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore( " + shareStatus + " )");
/*      */     }
/*      */   }
/*      */ 
/*      */   protected ShadowingStore(ObjectName objName)
/*      */   {
/*  849 */     super(objName);
/*      */ 
/*  851 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  853 */       tsLogger.arjLogger.debug(1L, 2L, 16L, "ShadowingStore.ShadowingStore( " + objName + " )");
/*      */     }
/*      */   }
/*      */ 
/*      */   private boolean closeAndUnlock(File fd, FileInputStream ifile, FileOutputStream ofile)
/*      */   {
/*  866 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  868 */       tsLogger.arjLogger.debug(16L, 1L, 16L, "ShadowingStore.closeAndUnlock(" + fd + ", " + ifile + ", " + ofile + ")");
/*      */     }
/*      */ 
/*  872 */     boolean closedOk = unlock(fd);
/*      */     try
/*      */     {
/*  876 */       if (ifile != null)
/*  877 */         ifile.close();
/*      */       else
/*  879 */         ofile.close();
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  883 */       closedOk = false;
/*      */     }
/*      */ 
/*  886 */     return closedOk;
/*      */   }
/*      */ 
/*      */   private File openAndLock(String fname, int lmode, boolean create) throws ObjectStoreException
/*      */   {
/*  891 */     if (tsLogger.arjLogger.debugAllowed())
/*      */     {
/*  893 */       tsLogger.arjLogger.debug(16L, 1L, 16L, "ShadowingStore.openAndLock(" + fname + ", " + FileLock.modeString(lmode) + ", " + create + ")");
/*      */     }
/*      */ 
/*  898 */     File fd = null;
/*      */ 
/*  900 */     if (fd == null)
/*      */     {
/*  902 */       fd = new File(fname);
/*      */ 
/*  904 */       if (!fd.exists())
/*      */       {
/*  906 */         if (createHierarchy(fname))
/*      */         {
/*  908 */           if (!lock(fd, lmode, create))
/*      */           {
/*  910 */             return null;
/*      */           }
/*      */ 
/*  913 */           return fd;
/*      */         }
/*      */ 
/*  916 */         throw new ObjectStoreException("ShadowingStore.openAndLock failed to create hierarchy " + fname);
/*      */       }
/*      */ 
/*  919 */       if (!lock(fd, lmode, create)) {
/*  920 */         fd = null;
/*      */       }
/*      */     }
/*  923 */     return fd;
/*      */   }
/*      */ 
/*      */   private final synchronized boolean renameFromTo(File from, File to)
/*      */   {
/*  951 */     if (!isWindows) {
/*  952 */       return from.renameTo(to);
/*      */     }
/*      */ 
/*  957 */     if (!from.exists())
/*      */     {
/*  973 */       super.removeFromCache(from.toString());
/*      */ 
/*  975 */       if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*      */       {
/*  977 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore_20", new Object[] { from });
/*      */       }
/*      */ 
/*  981 */       return true;
/*      */     }
/*      */ 
/*  990 */     to.delete();
/*      */ 
/*  992 */     boolean res = from.renameTo(to);
/*      */ 
/*  996 */     return true;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.ShadowingStore
 * JD-Core Version:    0.6.0
 */