/*     */ package com.arjuna.ats.internal.arjuna.objectstore.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.sql.Blob;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ 
/*     */ public class apache_driver extends JDBCImple
/*     */ {
/*     */   private static final int _maxStateSize = 10485760;
/*     */ 
/*     */   public InputObjectState read_state(Uid objUid, String tName, int ft, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/*  55 */     InputObjectState newImage = null;
/*     */ 
/*  57 */     if (!storeValid()) {
/*  58 */       return newImage;
/*     */     }
/*  60 */     if (tName != null)
/*     */     {
/*  62 */       if ((ft == 1) || (ft == 2))
/*     */       {
/*  64 */         int pool = getPool();
/*  65 */         ResultSet rs = null;
/*     */         try
/*     */         {
/*  68 */           PreparedStatement pstmt = this._preparedStatements[pool][4];
/*  69 */           if (pstmt == null)
/*     */           {
/*  71 */             pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*  72 */             this._preparedStatements[pool][4] = pstmt;
/*     */           }
/*     */ 
/*  75 */           pstmt.setString(1, objUid.stringForm());
/*  76 */           pstmt.setString(2, tName);
/*  77 */           pstmt.setInt(3, ft);
/*     */ 
/*  79 */           rs = pstmt.executeQuery();
/*     */ 
/*  81 */           if (!rs.next()) {
/*  82 */             Object localObject1 = null;
/*     */             return localObject1;
/*     */           }
/*  84 */           myBlob = rs.getBlob(1);
/*  85 */           byte[] buffer = ((Blob)myBlob).getBytes(1L, (int)((Blob)myBlob).length());
/*     */ 
/*  87 */           if (buffer != null)
/*     */           {
/*  89 */             newImage = new InputObjectState(objUid, tName, buffer);
/*     */           }
/*  92 */           else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*  93 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_1");
/*     */         }
/*     */         catch (Throwable e)
/*     */         {
/*     */           Object myBlob;
/*  98 */           if (retryConnection(e, pool)) {
/*  99 */             myBlob = read_state(objUid, tName, ft, tableName);
/*     */             return myBlob;
/*     */           }
/* 101 */           throw new ObjectStoreException(e.toString());
/*     */         }
/*     */         finally
/*     */         {
/*     */           try
/*     */           {
/* 108 */             if (rs != null)
/* 109 */               rs.close();
/*     */           }
/*     */           catch (Exception re) {
/*     */           }
/* 113 */           freePool(pool);
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/* 118 */       throw new ObjectStoreException("oracle.read_state - object with uid " + objUid + " has no TypeName");
/*     */     }
/* 120 */     return (InputObjectState)newImage;
/*     */   }
/*     */ 
/*     */   public boolean write_state(Uid objUid, String tName, OutputObjectState state, int s, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/* 126 */     boolean result = false;
/* 127 */     int imageSize = state.length();
/* 128 */     if (imageSize > 10485760)
/* 129 */       throw new ObjectStoreException("Object state is too large - maximum size allowed: 10485760");
/* 130 */     byte[] b = state.buffer();
/* 131 */     if ((imageSize > 0) && (storeValid()))
/*     */     {
/* 133 */       int pool = getPool();
/*     */       try
/*     */       {
/* 136 */         PreparedStatement pstmt = this._preparedStatements[pool][9];
/* 137 */         if (pstmt == null)
/*     */         {
/* 139 */           pstmt = this._theConnection[pool].prepareStatement("UPDATE " + tableName + " SET ObjectState = ? WHERE UidString = ? AND StateType = ?");
/* 140 */           this._preparedStatements[pool][9] = pstmt;
/*     */         }
/* 142 */         pstmt.setBytes(1, b);
/* 143 */         pstmt.setString(2, objUid.stringForm());
/* 144 */         pstmt.setInt(3, s);
/* 145 */         rowcount = pstmt.executeUpdate();
/* 146 */         if (rowcount <= 0)
/*     */         {
/* 153 */           PreparedStatement pstmt2 = this._preparedStatements[pool][6];
/* 154 */           if (pstmt2 == null)
/*     */           {
/* 156 */             pstmt2 = this._theConnection[pool].prepareStatement("INSERT INTO " + tableName + " (StateType,TypeName,UidString,ObjectState) VALUES (?,?,?,?)");
/* 157 */             this._preparedStatements[pool][6] = pstmt2;
/*     */           }
/* 159 */           pstmt2.setInt(1, s);
/* 160 */           pstmt2.setString(2, tName);
/* 161 */           pstmt2.setString(3, objUid.stringForm());
/* 162 */           pstmt2.setBytes(4, b);
/* 163 */           pstmt2.executeUpdate();
/*     */         }
/* 165 */         result = true;
/*     */       }
/*     */       catch (Throwable e)
/*     */       {
/*     */         int rowcount;
/* 169 */         if (retryConnection(e, pool))
/*     */         {
/* 171 */           rowcount = write_state(objUid, tName, state, s, tableName);
/*     */           return rowcount;
/*     */         }
/* 174 */         if (tsLogger.arjLoggerI18N.isWarnEnabled()) {
/* 175 */           tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_2", new Object[] { e });
/*     */         }
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 182 */           this._theConnection[pool].setAutoCommit(true);
/*     */         } catch (Exception e) {
/*     */         }
/* 185 */         freePool(pool);
/*     */       }
/*     */     }
/* 188 */     return result;
/*     */   }
/*     */ 
/*     */   protected void createTable(Statement stmt, String tableName)
/*     */     throws SQLException
/*     */   {
/* 195 */     stmt.executeUpdate("CREATE TABLE " + tableName + " (StateType INTEGER NOT NULL, TypeName VARCHAR(1024), UidString VARCHAR(255) NOT NULL, ObjectState BLOB, PRIMARY KEY(UidString, StateType))");
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 201 */     return "apache";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.jdbc.apache_driver
 * JD-Core Version:    0.6.0
 */