/*     */ package com.arjuna.ats.internal.arjuna.objectstore.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.internal.arjuna.objectstore.JDBCImple;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.sql.Connection;
/*     */ import java.sql.PreparedStatement;
/*     */ import java.sql.ResultSet;
/*     */ import java.sql.SQLException;
/*     */ import java.sql.Statement;
/*     */ 
/*     */ public class oracle_8_0_driver extends JDBCImple
/*     */ {
/*     */   private static final int _maxStateSize = 65535;
/* 241 */   private String blobName = "BLOB";
/*     */ 
/*     */   public InputObjectState read_state(Uid objUid, String tName, int ft, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/*  73 */     InputObjectState newImage = null;
/*     */ 
/*  75 */     if (!storeValid()) {
/*  76 */       return newImage;
/*     */     }
/*  78 */     if (tName != null)
/*     */     {
/*  80 */       if ((ft == 1) || (ft == 2))
/*     */       {
/*  82 */         int pool = getPool();
/*  83 */         ResultSet rs = null;
/*     */         try
/*     */         {
/*  87 */           PreparedStatement pstmt = this._preparedStatements[pool][4];
/*     */ 
/*  89 */           if (pstmt == null)
/*     */           {
/*  91 */             pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND TypeName = ? AND StateType = ?");
/*     */ 
/*  93 */             this._preparedStatements[pool][4] = pstmt;
/*     */           }
/*     */ 
/*  96 */           pstmt.setString(1, objUid.stringForm());
/*  97 */           pstmt.setString(2, tName);
/*  98 */           pstmt.setInt(3, ft);
/*     */ 
/* 100 */           rs = pstmt.executeQuery();
/*     */ 
/* 102 */           if (!rs.next()) {
/* 103 */             Object localObject1 = null;
/*     */             return localObject1;
/*     */           }
/* 106 */           byte[] buffer = rs.getBytes(1);
/*     */ 
/* 108 */           rs.close();
/*     */ 
/* 110 */           if (buffer != null)
/*     */           {
/* 112 */             newImage = new InputObjectState(objUid, tName, buffer);
/*     */           }
/*     */           else {
/* 115 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.drivers.oracle_8_0_1");
/*     */           }
/*     */         }
/*     */         catch (Exception e)
/*     */         {
/* 120 */           throw new ObjectStoreException(e.toString());
/*     */         }
/*     */         finally
/*     */         {
/*     */           try
/*     */           {
/* 126 */             rs.close();
/*     */           }
/*     */           catch (Exception re) {
/*     */           }
/* 130 */           freePool(pool);
/*     */         }
/*     */       }
/*     */     }
/*     */     else {
/* 135 */       throw new ObjectStoreException("oracle_8_0.read_state - object with uid " + objUid + " has no TypeName");
/*     */     }
/* 137 */     return newImage;
/*     */   }
/*     */ 
/*     */   public boolean write_state(Uid objUid, String tName, OutputObjectState state, int s, String tableName)
/*     */     throws ObjectStoreException
/*     */   {
/* 143 */     boolean result = false;
/*     */ 
/* 145 */     int imageSize = state.length();
/*     */ 
/* 147 */     if (imageSize > 65535) {
/* 148 */       throw new ObjectStoreException("Object state is too large - maximum size allowed: 65535");
/*     */     }
/* 150 */     byte[] b = state.buffer();
/*     */ 
/* 152 */     if ((imageSize > 0) && (storeValid()))
/*     */     {
/* 154 */       int pool = getPool();
/* 155 */       ResultSet rs = null;
/*     */       try
/*     */       {
/* 160 */         PreparedStatement pstmt = this._preparedStatements[pool][9];
/*     */ 
/* 162 */         this._theConnection[pool].setAutoCommit(false);
/*     */ 
/* 164 */         if (pstmt == null)
/*     */         {
/* 166 */           pstmt = this._theConnection[pool].prepareStatement("SELECT ObjectState FROM " + tableName + " WHERE UidString = ? AND StateType = ? AND TypeName = ? FOR UPDATE", 1003, 1008);
/* 167 */           this._preparedStatements[pool][9] = pstmt;
/*     */         }
/*     */ 
/* 170 */         pstmt.setString(1, objUid.stringForm());
/* 171 */         pstmt.setInt(2, s);
/* 172 */         pstmt.setString(3, tName);
/*     */ 
/* 174 */         rs = pstmt.executeQuery();
/*     */ 
/* 176 */         if (rs.next())
/*     */         {
/* 178 */           rs.updateBytes(1, b);
/* 179 */           rs.updateRow();
/*     */         }
/*     */         else
/*     */         {
/* 184 */           PreparedStatement pstmt2 = this._preparedStatements[pool][6];
/*     */ 
/* 186 */           if (pstmt2 == null)
/*     */           {
/* 188 */             pstmt2 = this._theConnection[pool].prepareStatement("INSERT INTO " + tableName + " (StateType,TypeName,UidString,ObjectState) VALUES (?,?,?,?)");
/*     */ 
/* 190 */             this._preparedStatements[pool][6] = pstmt2;
/*     */           }
/*     */ 
/* 193 */           pstmt2.setInt(1, s);
/* 194 */           pstmt2.setString(2, tName);
/* 195 */           pstmt2.setString(3, objUid.stringForm());
/* 196 */           pstmt2.setBytes(4, b);
/*     */ 
/* 198 */           pstmt2.executeUpdate();
/* 199 */           this._theConnection[pool].commit();
/*     */         }
/*     */ 
/* 202 */         rs.close();
/* 203 */         this._theConnection[pool].commit();
/* 204 */         result = true;
/*     */       }
/*     */       catch (Exception re)
/*     */       {
/* 209 */         tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.objectstore.drivers.oracle_8_0_2", new Object[] { e });
/*     */       }
/*     */       finally
/*     */       {
/*     */         try
/*     */         {
/* 215 */           this._theConnection[pool].setAutoCommit(true);
/*     */         }
/*     */         catch (Exception e) {
/*     */         }
/*     */         try {
/* 220 */           rs.close();
/*     */         }
/*     */         catch (Exception re) {
/*     */         }
/* 224 */         freePool(pool);
/*     */       }
/*     */     }
/* 227 */     return result;
/*     */   }
/*     */ 
/*     */   protected void createTable(Statement stmt, String tableName) throws SQLException
/*     */   {
/* 232 */     stmt.executeUpdate("CREATE TABLE " + tableName + " (StateType INTEGER, TypeName VARCHAR(1024), UidString VARCHAR(255), ObjectState " + this.blobName + ", PRIMARY KEY(UidString, StateType, TypeName))");
/*     */   }
/*     */ 
/*     */   public String name()
/*     */   {
/* 237 */     return "oracle_8_0";
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.objectstore.jdbc.oracle_8_0_driver
 * JD-Core Version:    0.6.0
 */