/*     */ package com.arjuna.ats.internal.arjuna.recovery;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.logging.tsLogger;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStreamReader;
/*     */ import java.io.OutputStreamWriter;
/*     */ import java.io.PrintWriter;
/*     */ import java.net.Socket;
/*     */ 
/*     */ public class TransactionStatusConnector
/*     */ {
/*     */   private String _pid;
/*     */   private Uid _pidUid;
/* 322 */   private TransactionStatusManagerItem _tsmi = null;
/*     */ 
/* 326 */   private boolean _tsmFound = false;
/*     */ 
/* 330 */   private int _attempts_to_recreate_tsmi = 0;
/* 331 */   private int _max_attempts_to_recreate_tsmi = 3;
/*     */ 
/* 336 */   private int _attempts_to_establish_connection = 0;
/* 337 */   private int _max_attempts_to_establish_connection = 3;
/*     */   private Socket _connector_socket;
/* 341 */   private int _socket_timeout_in_msecs = 1000;
/*     */   private BufferedReader _from_server;
/*     */   private PrintWriter _to_server;
/* 348 */   private boolean _dead = false;
/*     */ 
/* 352 */   private boolean _testMode = false;
/*     */ 
/*     */   public TransactionStatusConnector(String pid, Uid pidUid)
/*     */   {
/*  65 */     this._pid = pid;
/*  66 */     this._pidUid = pidUid;
/*     */   }
/*     */ 
/*     */   public boolean test(TransactionStatusManagerItem tsmi)
/*     */   {
/*  76 */     this._testMode = true;
/*  77 */     this._tsmi = tsmi;
/*     */ 
/*  79 */     boolean ok = establishConnection();
/*     */ 
/*  81 */     if (!ok)
/*     */     {
/*  83 */       setDeadTSM();
/*     */     }
/*     */ 
/*  86 */     return ok;
/*     */   }
/*     */ 
/*     */   public void delete()
/*     */   {
/*  97 */     if (this._dead)
/*     */     {
/*  99 */       TransactionStatusManagerItem.removeThis(this._pidUid);
/*     */     }
/* 103 */     else if (tsLogger.arjLoggerI18N.isWarnEnabled())
/* 104 */       tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_1");
/*     */   }
/*     */ 
/*     */   public boolean isDead()
/*     */   {
/* 114 */     return this._dead;
/*     */   }
/*     */ 
/*     */   public int getTransactionStatus(String transaction_type, Uid tranUid)
/*     */   {
/* 124 */     int status = 9;
/*     */ 
/* 126 */     if (!this._dead)
/*     */     {
/* 128 */       if (!this._tsmFound)
/*     */       {
/* 131 */         this._tsmFound = recreateTransactionStatusManagerItem();
/*     */ 
/* 133 */         if (this._tsmFound)
/*     */         {
/* 135 */           this._tsmFound = establishConnection();
/*     */         }
/*     */       }
/*     */ 
/* 139 */       if (this._tsmFound)
/*     */       {
/*     */         try
/*     */         {
/* 145 */           this._to_server.println(transaction_type);
/* 146 */           this._to_server.println(tranUid.toString());
/* 147 */           this._to_server.flush();
/*     */ 
/* 155 */           String server_data = this._from_server.readLine();
/* 156 */           status = Integer.parseInt(server_data);
/*     */         }
/*     */         catch (IOException ex)
/*     */         {
/* 163 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 165 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_2");
/*     */           }
/*     */ 
/* 168 */           this._tsmFound = false;
/*     */         }
/*     */         catch (Exception other)
/*     */         {
/* 172 */           if (tsLogger.arjLoggerI18N.isWarnEnabled())
/*     */           {
/* 174 */             tsLogger.arjLoggerI18N.warn("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_3");
/*     */           }
/*     */ 
/* 177 */           this._tsmFound = false;
/*     */         }
/*     */       }
/*     */     }
/*     */ 
/* 182 */     return status;
/*     */   }
/*     */ 
/*     */   private void setDeadTSM()
/*     */   {
/* 190 */     this._dead = true;
/*     */ 
/* 192 */     if (this._tsmi != null)
/* 193 */       this._tsmi.markAsDead();
/*     */   }
/*     */ 
/*     */   private boolean establishConnection()
/*     */   {
/* 203 */     boolean connectionEstablished = false;
/*     */ 
/* 205 */     if (this._tsmi != null)
/*     */     {
/*     */       try
/*     */       {
/* 209 */         String serverHost = this._tsmi.host();
/* 210 */         int serverPort = this._tsmi.port();
/*     */ 
/* 212 */         this._connector_socket = new Socket(serverHost, serverPort);
/* 213 */         this._connector_socket.setSoTimeout(this._socket_timeout_in_msecs);
/*     */ 
/* 216 */         this._from_server = new BufferedReader(new InputStreamReader(this._connector_socket.getInputStream()));
/*     */ 
/* 218 */         this._to_server = new PrintWriter(new OutputStreamWriter(this._connector_socket.getOutputStream()));
/*     */ 
/* 223 */         String server_pid = this._from_server.readLine();
/*     */ 
/* 225 */         if (Utility.hexStringToInt(server_pid) == Utility.hexStringToInt(this._pid))
/*     */         {
/* 227 */           if (!this._testMode)
/*     */           {
/* 229 */             this._to_server.println("OK");
/* 230 */             this._to_server.flush();
/*     */ 
/* 232 */             if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */             {
/* 234 */               tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_4", new Object[] { this._pid, serverHost, Integer.toString(serverPort), this._connector_socket });
/*     */             }
/*     */ 
/*     */           }
/*     */           else
/*     */           {
/* 241 */             this._to_server.println("TEST");
/* 242 */             this._to_server.flush();
/*     */ 
/* 245 */             this._connector_socket.close();
/*     */           }
/*     */ 
/* 248 */           connectionEstablished = true;
/*     */         }
/*     */         else
/*     */         {
/* 252 */           this._to_server.println("DEAD");
/* 253 */           this._to_server.flush();
/*     */ 
/* 256 */           this._connector_socket.close();
/*     */ 
/* 258 */           setDeadTSM();
/*     */ 
/* 260 */           if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */           {
/* 262 */             tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_5", new Object[] { this._pid });
/*     */           }
/*     */         }
/*     */ 
/*     */       }
/*     */       catch (IOException ex)
/*     */       {
/* 269 */         if (tsLogger.arjLoggerI18N.isInfoEnabled())
/*     */         {
/* 271 */           tsLogger.arjLoggerI18N.info("com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector_6");
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/* 276 */       this._attempts_to_establish_connection = (connectionEstablished ? 0 : this._attempts_to_establish_connection + 1);
/*     */ 
/* 278 */       if (this._attempts_to_establish_connection > this._max_attempts_to_establish_connection)
/*     */       {
/* 280 */         setDeadTSM();
/*     */       }
/*     */     }
/*     */ 
/* 284 */     return connectionEstablished;
/*     */   }
/*     */ 
/*     */   private boolean recreateTransactionStatusManagerItem()
/*     */   {
/* 292 */     boolean tsmiFound = false;
/*     */ 
/* 294 */     if (this._tsmi == null)
/*     */     {
/*     */       try
/*     */       {
/* 298 */         this._tsmi = TransactionStatusManagerItem.recreate(this._pidUid);
/*     */ 
/* 300 */         tsmiFound = true;
/* 301 */         this._attempts_to_recreate_tsmi = 0;
/*     */       }
/*     */       catch (Exception ex)
/*     */       {
/* 305 */         if (++this._attempts_to_recreate_tsmi > this._max_attempts_to_recreate_tsmi)
/*     */         {
/* 307 */           setDeadTSM();
/*     */         }
/*     */ 
/* 310 */         this._tsmi = null;
/*     */       }
/*     */     }
/*     */ 
/* 314 */     return tsmiFound;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.arjuna.recovery.TransactionStatusConnector
 * JD-Core Version:    0.6.0
 */