/*     */ package com.arjuna.ats.internal.jbossatx.jta;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
/*     */ import java.io.Serializable;
/*     */ import java.util.Hashtable;
/*     */ import javax.naming.Context;
/*     */ import javax.naming.Name;
/*     */ import javax.naming.spi.ObjectFactory;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.logging.Logger;
/*     */ import org.jboss.tm.TransactionPropagationContextFactory;
/*     */ import org.jboss.tm.TransactionPropagationContextImporter;
/*     */ 
/*     */ public class PropagationContextManager
/*     */   implements TransactionPropagationContextFactory, TransactionPropagationContextImporter, ObjectFactory, Serializable
/*     */ {
/*  54 */   private Logger log = Logger.getLogger(PropagationContextManager.class);
/*     */ 
/*     */   public Object getTransactionPropagationContext()
/*     */   {
/*  64 */     if (this.log.isDebugEnabled())
/*     */     {
/*  66 */       this.log.debug("PropagationContextManager.getTransactionPropagationContext - called");
/*     */     }
/*     */ 
/*  69 */     String txid = BasicAction.Current() == null ? null : BasicAction.Current().get_uid().stringForm();
/*     */ 
/*  71 */     return txid;
/*     */   }
/*     */ 
/*     */   public Object getTransactionPropagationContext(Transaction tx)
/*     */   {
/*  83 */     if (this.log.isDebugEnabled())
/*     */     {
/*  85 */       this.log.debug("PropagationContextManager.getTransactionPropagationContext(Transaction) - called tx = " + tx);
/*     */     }
/*     */ 
/*  88 */     if ((tx instanceof TransactionImple)) {
/*  89 */       return ((TransactionImple)tx).get_uid().stringForm();
/*     */     }
/*  91 */     return null;
/*     */   }
/*     */ 
/*     */   public Transaction importTransactionPropagationContext(Object tpc)
/*     */   {
/* 107 */     if (this.log.isDebugEnabled())
/*     */     {
/* 109 */       this.log.debug("PropagationContextManager.importTransactionPropagationContext(Object) - called tpc = " + tpc);
/*     */     }
/*     */ 
/* 112 */     javax.transaction.TransactionManager tm = com.arjuna.ats.jta.TransactionManager.transactionManager();
/*     */ 
/* 114 */     if ((tpc instanceof String))
/*     */     {
/*     */       try
/*     */       {
/* 118 */         Uid importedTx = new Uid((String)tpc);
/*     */ 
/* 120 */         Transaction newTx = TransactionImple.getTransaction(importedTx);
/*     */ 
/* 122 */         if (this.log.isDebugEnabled())
/*     */         {
/* 124 */           this.log.debug("PropagationContextManager.importTransactionPropagationContext(Object) - transaction = " + newTx);
/*     */         }
/*     */ 
/* 127 */         return newTx;
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 131 */         this.log.error("Unexpected exception occurred", e);
/* 132 */         return null;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 137 */     this.log.error("jboss-atx: unknown Tx PropagationContext");
/* 138 */     return null;
/*     */   }
/*     */ 
/*     */   public Object getObjectInstance(Object obj, Name name, Context nameCtx, Hashtable environment)
/*     */     throws Exception
/*     */   {
/* 145 */     return new PropagationContextManager();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jbossatx.jta.PropagationContextManager
 * JD-Core Version:    0.6.0
 */