/*      */ package com.arjuna.ats.internal.jta.recovery.arjunacore;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.coordinator.TxControl;
/*      */ import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
/*      */ import com.arjuna.ats.arjuna.objectstore.ObjectStore;
/*      */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.internal.arjuna.utils.XATxConverter;
/*      */ import com.arjuna.ats.internal.jta.Implementations;
/*      */ import com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction;
/*      */ import com.arjuna.ats.internal.jta.utils.XAUtils;
/*      */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*      */ import com.arjuna.ats.jta.logging.jtaLogger;
/*      */ import com.arjuna.ats.jta.recovery.XARecoveryResource;
/*      */ import com.arjuna.ats.jta.recovery.XARecoveryResourceManager;
/*      */ import com.arjuna.ats.jta.recovery.XAResourceRecovery;
/*      */ import com.arjuna.ats.jta.utils.XAHelper;
/*      */ import com.arjuna.ats.jta.xa.XidImple;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.io.IOException;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Hashtable;
/*      */ import java.util.Properties;
/*      */ import java.util.Vector;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import javax.transaction.xa.Xid;
/*      */ 
/*      */ public class XARecoveryModule
/*      */   implements RecoveryModule
/*      */ {
/*      */   public static final String XARecoveryPropertyNamePrefix = "com.arjuna.ats.jta.recovery.XAResourceRecovery";
/*      */   private static final String RECOVER_ALL_NODES = "*";
/* 1258 */   private ObjectStore _objStore = new ObjectStore();
/*      */ 
/* 1260 */   private InputObjectState _uids = new InputObjectState();
/*      */ 
/* 1262 */   private Vector _xaRecoverers = null;
/*      */ 
/* 1264 */   private Hashtable _failures = null;
/*      */ 
/* 1266 */   private Vector _xaRecoveryNodes = null;
/*      */ 
/* 1268 */   private Hashtable _xidScans = null;
/*      */ 
/* 1270 */   private XARecoveryResourceManager _recoveryManagerClass = null;
/*      */ 
/* 1272 */   private String _logName = null;
/*      */ 
/* 1275 */   private String _transactionType = new AtomicAction().type();
/*      */ 
/* 1278 */   private static ObjectStore _transactionStore = null;
/*      */ 
/* 1280 */   private static int _backoffPeriod = 0;
/*      */   private static final int XA_BACKOFF_PERIOD = 20000;
/*      */   private static final char BREAKCHARACTER = ';';
/*      */ 
/*      */   public XARecoveryModule()
/*      */   {
/*   75 */     this(XARecoveryResourceManagerImple.class.getName(), "Local XARecoveryModule");
/*      */ 
/*   79 */     Implementations.initialise();
/*      */   }
/*      */ 
/*      */   public void periodicWorkFirstPass()
/*      */   {
/*   96 */     if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */     {
/*   98 */       jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.firstpass", new Object[] { this._logName });
/*      */     }
/*      */ 
/*  104 */     this._uids = new InputObjectState();
/*      */     try
/*      */     {
/*  112 */       if (!this._objStore.allObjUids(this._recoveryManagerClass.type(), this._uids))
/*      */       {
/*  114 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  116 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.alluids");
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (ObjectStoreException e)
/*      */     {
/*  123 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  125 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.objstoreerror", e);
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  133 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  135 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicfirstpass", new Object[] { this._logName + ".periodicWorkFirstPass exception " }, e);
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   public void periodicWorkSecondPass()
/*      */   {
/*  155 */     if (jtaLogger.logger.isInfoEnabled())
/*      */     {
/*  157 */       if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */       {
/*  159 */         jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.secondpass", new Object[] { this._logName });
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  170 */       transactionInitiatedRecovery();
/*      */ 
/*  172 */       if (jtaLogger.logger.isDebugEnabled())
/*      */       {
/*  174 */         jtaLogger.logger.debug(16L, 4L, 2048L, this._logName + ".transactionInitiatedRecovery completed");
/*      */       }
/*      */ 
/*  184 */       resourceInitiatedRecovery();
/*      */ 
/*  186 */       if (jtaLogger.logger.isDebugEnabled())
/*      */       {
/*  188 */         jtaLogger.logger.debug(16L, 4L, 2048L, this._logName + ".resourceInitiatedRecovery completed");
/*      */       }
/*      */ 
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  196 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  198 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.periodicsecondpass", new Object[] { this._logName + ".periodicWorkSecondPass exception " }, e);
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  208 */     clearAllFailures();
/*      */   }
/*      */ 
/*      */   public String id()
/*      */   {
/*  213 */     return "XARecoveryModule:" + this._recoveryManagerClass;
/*      */   }
/*      */ 
/*      */   public XAResource getNewXAResource(Xid xid)
/*      */   {
/*  226 */     if (this._xidScans != null)
/*      */     {
/*  228 */       Enumeration keys = this._xidScans.keys();
/*      */ 
/*  230 */       while (keys.hasMoreElements())
/*      */       {
/*  232 */         XAResource theKey = (XAResource)keys.nextElement();
/*  233 */         RecoveryXids xids = (RecoveryXids)this._xidScans.get(theKey);
/*      */ 
/*  235 */         if (xids.contains(xid)) {
/*  236 */           return theKey;
/*      */         }
/*      */       }
/*      */     }
/*  240 */     return null;
/*      */   }
/*      */ 
/*      */   protected XARecoveryModule(String recoveryClass, String logName)
/*      */   {
/*  255 */     this._xaRecoverers = new Vector();
/*  256 */     this._logName = logName;
/*      */     try
/*      */     {
/*  260 */       Class c = Thread.currentThread().getContextClassLoader().loadClass(recoveryClass);
/*      */ 
/*  263 */       this._recoveryManagerClass = ((XARecoveryResourceManager)c.newInstance());
/*      */     }
/*      */     catch (Exception ex)
/*      */     {
/*  267 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  269 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.constfail", ex);
/*      */       }
/*      */ 
/*  273 */       this._recoveryManagerClass = null;
/*      */     }
/*      */ 
/*  276 */     Properties props = jtaPropertyManager.propertyManager.getProperties();
/*      */ 
/*  278 */     if (props != null)
/*      */     {
/*  280 */       Enumeration names = props.propertyNames();
/*      */ 
/*  282 */       while (names.hasMoreElements())
/*      */       {
/*  284 */         String propName = (String)names.nextElement();
/*      */ 
/*  286 */         if (propName.startsWith("com.arjuna.ats.jta.recovery.XAResourceRecovery"))
/*      */         {
/*  294 */           String theClassAndParameter = jtaPropertyManager.propertyManager.getProperty(propName);
/*      */ 
/*  299 */           int breakPosition = theClassAndParameter.indexOf(';');
/*      */ 
/*  302 */           String theClass = null;
/*  303 */           String theParameter = null;
/*      */ 
/*  305 */           if (breakPosition != -1)
/*      */           {
/*  307 */             theClass = theClassAndParameter.substring(0, breakPosition);
/*      */ 
/*  309 */             theParameter = theClassAndParameter.substring(breakPosition + 1);
/*      */           }
/*      */           else
/*      */           {
/*  314 */             theClass = theClassAndParameter;
/*      */           }
/*      */ 
/*  317 */           if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */           {
/*  319 */             if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */             {
/*  321 */               jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.loading", new Object[] { this._logName, theClass + (theParameter != null ? theParameter : "") });
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*  332 */           if (theClass == null)
/*      */           {
/*  334 */             if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */             {
/*  336 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.classloadfail", new Object[] { this._logName, propName });
/*      */             }
/*      */ 
/*      */           }
/*      */           else
/*      */           {
/*      */             try
/*      */             {
/*  347 */               Class c = Thread.currentThread().getContextClassLoader().loadClass(theClass);
/*      */ 
/*  351 */               XAResourceRecovery ri = (XAResourceRecovery)c.newInstance();
/*      */ 
/*  354 */               if (theParameter != null) {
/*  355 */                 ri.initialise(theParameter);
/*      */               }
/*  357 */               this._xaRecoverers.addElement(ri);
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/*  361 */               if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */               {
/*  363 */                 jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.general", new Object[] { e, theClass });
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*  374 */         else if (propName.startsWith("com.arjuna.ats.jta.xaRecoveryNode"))
/*      */         {
/*  380 */           String name = jtaPropertyManager.propertyManager.getProperty(propName);
/*      */ 
/*  383 */           if (this._xaRecoveryNodes == null) {
/*  384 */             this._xaRecoveryNodes = new Vector();
/*      */           }
/*  386 */           this._xaRecoveryNodes.addElement(name);
/*      */         }
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  392 */     if ((this._xaRecoveryNodes == null) || (this._xaRecoveryNodes.size() == 0))
/*      */     {
/*  394 */       if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */       {
/*  396 */         jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.noxanodes");
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   private final boolean transactionInitiatedRecovery()
/*      */   {
/*  420 */     Uid theUid = new Uid();
/*      */ 
/*  422 */     while (theUid.notEquals(Uid.nullUid()))
/*      */     {
/*      */       try
/*      */       {
/*  426 */         theUid.unpack(this._uids);
/*      */ 
/*  428 */         if (theUid.notEquals(Uid.nullUid()))
/*      */         {
/*  435 */           if (this._objStore.currentState(theUid, this._recoveryManagerClass.type()) != 0)
/*      */           {
/*  438 */             boolean problem = false;
/*  439 */             XARecoveryResource record = null;
/*      */             try
/*      */             {
/*  443 */               record = this._recoveryManagerClass.getResource(theUid);
/*      */ 
/*  445 */               problem = true;
/*      */ 
/*  447 */               switch (record.recoverable())
/*      */               {
/*      */               case 12:
/*  451 */                 if (jtaLogger.logger.isDebugEnabled())
/*      */                 {
/*  453 */                   jtaLogger.logger.debug(16L, 4L, 2048L, "XARecovery attempting recovery of " + theUid);
/*      */                 }
/*      */ 
/*  461 */                 int recoveryStatus = record.recover();
/*      */ 
/*  463 */                 if (recoveryStatus != 1)
/*      */                 {
/*  465 */                   if (recoveryStatus == 3)
/*      */                   {
/*  467 */                     problem = false;
/*      */ 
/*  469 */                     if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */                     {
/*  472 */                       jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.recoverydelayed", new Object[] { theUid, new Integer(recoveryStatus) });
/*      */                     }
/*      */ 
/*      */                   }
/*  484 */                   else if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */                   {
/*  487 */                     jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryfailed", new Object[] { theUid, new Integer(recoveryStatus) });
/*      */                   }
/*      */ 
/*      */                 }
/*      */                 else
/*      */                 {
/*  499 */                   problem = false;
/*      */                 }
/*      */ 
/*  503 */                 break;
/*      */               case 11:
/*  512 */                 problem = false;
/*      */ 
/*  514 */                 break;
/*      */               case 10:
/*      */               default:
/*  518 */                 if (!jtaLogger.logger.isDebugEnabled())
/*      */                   break;
/*  520 */                 jtaLogger.logger.debug(16L, 4L, 2048L, "XARecovery " + theUid + " is non-recoverable");
/*      */               }
/*      */ 
/*      */             }
/*      */             catch (NullPointerException ex)
/*      */             {
/*  533 */               problem = true;
/*      */             }
/*      */             catch (Throwable e)
/*      */             {
/*  537 */               problem = true;
/*      */ 
/*  539 */               if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */               {
/*  541 */                 jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.recoveryerror", e);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*  548 */             if ((problem) && (record != null))
/*      */             {
/*  560 */               if (record.getXid() == null)
/*      */               {
/*  562 */                 if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */                 {
/*  564 */                   jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.cannotadd");
/*      */                 }
/*      */ 
/*      */               }
/*      */               else
/*      */               {
/*  570 */                 addFailure(record.getXid(), record.get_uid());
/*      */               }
/*      */             }
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (IOException e)
/*      */       {
/*  578 */         theUid = Uid.nullUid();
/*      */       }
/*      */       catch (Throwable e)
/*      */       {
/*  582 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  584 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.unexpectedrecoveryerror", e);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  592 */     return true;
/*      */   }
/*      */ 
/*      */   private final boolean resourceInitiatedRecovery()
/*      */   {
/*  627 */     if (this._xaRecoverers.size() > 0)
/*      */     {
/*  629 */       for (int i = 0; i < this._xaRecoverers.size(); i++)
/*      */       {
/*  631 */         XAResource resource = null;
/*      */         try
/*      */         {
/*  635 */           XAResourceRecovery ri = (XAResourceRecovery)this._xaRecoverers.elementAt(i);
/*      */ 
/*  638 */           while (ri.hasMoreResources())
/*      */           {
/*      */             try
/*      */             {
/*  642 */               resource = ri.getXAResource();
/*      */ 
/*  644 */               xaRecovery(resource);
/*      */             }
/*      */             catch (Exception exp)
/*      */             {
/*  648 */               if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */               {
/*  650 */                 jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", exp);
/*      */               }
/*      */ 
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/*      */         }
/*      */         catch (Exception ex)
/*      */         {
/*  660 */           if (!jtaLogger.loggerI18N.isWarnEnabled())
/*      */             continue;
/*  662 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.getxaresource", ex);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/*  671 */     return true;
/*      */   }
/*      */ 
/*      */   private final boolean xaRecovery(XAResource xares)
/*      */   {
/*  693 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  695 */       jtaLogger.logger.debug(16L, 4L, 2048L, "xarecovery of " + xares);
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  702 */       Xid[] trans = null;
/*      */       try
/*      */       {
/*  706 */         trans = xares.recover(16777216);
/*      */ 
/*  708 */         if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */         {
/*  710 */           jtaLogger.logger.debug(16L, 4L, 2048L, "Found " + (trans != null ? trans.length : 0) + " xids in doubt");
/*      */         }
/*      */ 
/*      */       }
/*      */       catch (XAException e)
/*      */       {
/*  719 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  721 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[] { this._logName + ".xaRecovery ", e, XAHelper.printXAErrorCode(e) });
/*      */         }
/*      */ 
/*      */         try
/*      */         {
/*  730 */           xares.recover(8388608);
/*      */         }
/*      */         catch (Exception e1)
/*      */         {
/*      */         }
/*      */ 
/*  736 */         return false;
/*      */       }
/*      */ 
/*  739 */       RecoveryXids xidsToRecover = null;
/*      */ 
/*  741 */       if (this._xidScans == null) {
/*  742 */         this._xidScans = new Hashtable();
/*      */       }
/*      */       else {
/*  745 */         xidsToRecover = (RecoveryXids)this._xidScans.get(xares);
/*      */ 
/*  747 */         if (xidsToRecover == null)
/*      */         {
/*  749 */           Enumeration elements = this._xidScans.elements();
/*  750 */           boolean found = false;
/*      */ 
/*  752 */           while (elements.hasMoreElements())
/*      */           {
/*  754 */             xidsToRecover = (RecoveryXids)elements.nextElement();
/*      */ 
/*  756 */             if (!xidsToRecover.isSameRM(xares))
/*      */               continue;
/*  758 */             found = true;
/*      */           }
/*      */ 
/*  764 */           if (!found) {
/*  765 */             xidsToRecover = null;
/*      */           }
/*      */         }
/*      */       }
/*  769 */       if (xidsToRecover == null)
/*      */       {
/*  771 */         xidsToRecover = new RecoveryXids(xares);
/*      */ 
/*  773 */         this._xidScans.put(xares, xidsToRecover);
/*      */       }
/*      */ 
/*  776 */       xidsToRecover.nextScan(trans);
/*      */ 
/*  778 */       Object[] xids = xidsToRecover.toRecover();
/*      */ 
/*  780 */       if (xids != null)
/*      */       {
/*  782 */         if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */         {
/*  784 */           jtaLogger.logger.debug(16L, 4L, 2048L, "Have " + xids.length + " Xids to recover on this pass.");
/*      */         }
/*      */ 
/*  791 */         for (int j = 0; j < xids.length; j++)
/*      */         {
/*  793 */           boolean doForget = false;
/*      */ 
/*  799 */           Uid recordUid = null;
/*  800 */           boolean foundTransaction = false;
/*      */           do
/*      */           {
/*  806 */             recordUid = previousFailure((Xid)xids[j]);
/*      */ 
/*  808 */             if ((recordUid == null) && (foundTransaction))
/*      */             {
/*      */               break;
/*      */             }
/*      */ 
/*  816 */             if (recordUid == null)
/*      */             {
/*  824 */               if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */               {
/*  826 */                 jtaLogger.logger.debug(16L, 4L, 2048L, "Checking node name of " + (Xid)xids[j]);
/*      */               }
/*      */ 
/*  833 */               String nodeName = XAUtils.getXANodeName((Xid)xids[j]);
/*      */ 
/*  835 */               boolean doRecovery = false;
/*      */ 
/*  837 */               if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */               {
/*  839 */                 jtaLogger.logger.debug(16L, 4L, 2048L, "Node name is " + nodeName);
/*      */               }
/*      */ 
/*  851 */               if ((nodeName == null) && (this._xaRecoveryNodes != null) && (this._xaRecoveryNodes.contains("*")))
/*      */               {
/*  856 */                 if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */                 {
/*  858 */                   jtaLogger.logger.debug(16L, 4L, 2048L, "Will recover this Xid (a)");
/*      */                 }
/*      */ 
/*  865 */                 doRecovery = true;
/*      */               }
/*  869 */               else if (nodeName != null)
/*      */               {
/*  877 */                 if (this._xaRecoveryNodes != null)
/*      */                 {
/*  879 */                   if ((this._xaRecoveryNodes.contains("*")) || (this._xaRecoveryNodes.contains(nodeName)))
/*      */                   {
/*  884 */                     if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */                     {
/*  887 */                       jtaLogger.logger.debug(16L, 4L, 2048L, "Will recover this Xid (b)");
/*      */                     }
/*      */ 
/*  895 */                     doRecovery = true;
/*      */                   }
/*  899 */                   else if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */                   {
/*  902 */                     jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid (a)");
/*      */                   }
/*      */ 
/*      */                 }
/*  913 */                 else if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */                 {
/*  916 */                   jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid (b)");
/*      */                 }
/*      */ 
/*      */               }
/*  927 */               else if (jtaLogger.loggerI18N.isDebugEnabled())
/*      */               {
/*  929 */                 jtaLogger.logger.debug(16L, 4L, 2048L, "Will not recover this Xid");
/*      */               }
/*      */ 
/*      */               try
/*      */               {
/*  941 */                 if (doRecovery)
/*      */                 {
/*  943 */                   if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */                   {
/*  945 */                     jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.rollingback", new Object[] { XAHelper.xidToString((Xid)xids[j]) });
/*      */                   }
/*      */ 
/*  953 */                   if (!transactionLog((Xid)xids[j])) {
/*  954 */                     xares.rollback((Xid)xids[j]);
/*      */                   }
/*      */ 
/*      */                 }
/*  965 */                 else if (jtaLogger.loggerI18N.isInfoEnabled())
/*      */                 {
/*  967 */                   jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.info.notrollback", new Object[] { XAHelper.xidToString((Xid)xids[j]) });
/*      */                 }
/*      */ 
/*      */               }
/*      */               catch (XAException e1)
/*      */               {
/*  978 */                 e1.printStackTrace();
/*      */ 
/*  980 */                 switch (e1.errorCode)
/*      */                 {
/*      */                 case -3:
/*  983 */                   break;
/*      */                 case 5:
/*      */                 case 6:
/*      */                 case 7:
/*      */                 case 8:
/*      */                 case 100:
/*  990 */                   if (doForget) break;
/*  991 */                   doForget = true;
/*      */                 }
/*      */ 
/*      */               }
/*      */               catch (Exception e2)
/*      */               {
/* 1000 */                 if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */                 {
/* 1002 */                   jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery2", new Object[] { this._logName + ".xaRecovery ", e2 });
/*      */                 }
/*      */ 
/*      */               }
/*      */ 
/*      */             }
/*      */             else
/*      */             {
/* 1015 */               foundTransaction = true;
/*      */ 
/* 1023 */               XARecoveryResource record = this._recoveryManagerClass.getResource(recordUid, xares);
/*      */ 
/* 1025 */               int recoveryStatus = record.recover();
/*      */ 
/* 1027 */               if (recoveryStatus != 1)
/*      */               {
/* 1029 */                 if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */                 {
/* 1031 */                   jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.failedtorecover", new Object[] { this._logName + ".xaRecovery ", new Integer(recoveryStatus) });
/*      */                 }
/*      */ 
/*      */               }
/*      */ 
/* 1043 */               removeFailure(record.getXid(), record.get_uid());
/*      */             }
/*      */ 
/* 1046 */             if (!doForget)
/*      */               continue;
/*      */             try
/*      */             {
/* 1050 */               xares.forget((Xid)xids[j]);
/*      */             }
/*      */             catch (Exception e)
/*      */             {
/* 1054 */               if (!jtaLogger.loggerI18N.isWarnEnabled())
/*      */                 continue;
/* 1056 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.forgetfailed", new Object[] { this._logName + ".xaRecovery", e });
/*      */             }
/*      */ 
/*      */           }
/*      */ 
/* 1067 */           while (recordUid != null);
/*      */         }
/*      */       }
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/* 1073 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1075 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.generalrecoveryerror", new Object[] { this._logName + ".xaRecovery", e });
/*      */       }
/*      */ 
/* 1082 */       e.printStackTrace();
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/* 1087 */       if (xares != null)
/* 1088 */         xares.recover(8388608);
/*      */     }
/*      */     catch (XAException e)
/*      */     {
/* 1092 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/* 1094 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.recovery.xarecovery1", new Object[] { this._logName + ".xaRecovery", e, XAHelper.printXAErrorCode(e) });
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1102 */     return true;
/*      */   }
/*      */ 
/*      */   private final boolean transactionLog(Xid xid)
/*      */   {
/* 1120 */     if (_transactionStore == null)
/*      */     {
/* 1122 */       _transactionStore = TxControl.getStore();
/*      */     }
/*      */ 
/* 1125 */     XidImple theXid = new XidImple(xid);
/* 1126 */     Uid u = XATxConverter.getUid(theXid.getXID());
/*      */ 
/* 1129 */     if (!u.equals(Uid.nullUid()))
/*      */     {
/*      */       try
/*      */       {
/* 1133 */         if (_transactionStore.currentState(u, this._transactionType) != 0)
/*      */         {
/* 1135 */           return true;
/*      */         }
/*      */       }
/*      */       catch (Exception ex)
/*      */       {
/* 1140 */         ex.printStackTrace();
/*      */       }
/*      */ 
/*      */     }
/* 1145 */     else if (jtaLogger.logger.isInfoEnabled())
/*      */     {
/* 1147 */       jtaLogger.loggerI18N.info("com.arjuna.ats.internal.jta.recovery.notaxid", new Object[] { xid });
/*      */     }
/*      */ 
/* 1154 */     return false;
/*      */   }
/*      */ 
/*      */   private final Uid previousFailure(Xid xid)
/*      */   {
/* 1166 */     if (this._failures == null)
/*      */     {
/* 1168 */       return null;
/*      */     }
/*      */ 
/* 1171 */     Enumeration e = this._failures.keys();
/*      */ 
/* 1173 */     while (e.hasMoreElements())
/*      */     {
/* 1175 */       Xid theXid = (Xid)e.nextElement();
/*      */ 
/* 1177 */       if (XAHelper.sameXID(xid, theXid))
/*      */       {
/* 1180 */         Vector failureItem = (Vector)this._failures.get(theXid);
/* 1181 */         Uid u = (Uid)failureItem.remove(0);
/*      */ 
/* 1183 */         if (failureItem.size() == 0) {
/* 1184 */           this._failures.remove(theXid);
/*      */         }
/* 1186 */         return u;
/*      */       }
/*      */ 
/*      */     }
/*      */ 
/* 1192 */     return null;
/*      */   }
/*      */ 
/*      */   private void addFailure(Xid xid, Uid uid)
/*      */   {
/* 1203 */     if (this._failures == null) {
/* 1204 */       this._failures = new Hashtable();
/*      */     }
/* 1206 */     Vector failureItem = (Vector)this._failures.get(xid);
/*      */ 
/* 1208 */     if (failureItem == null)
/*      */     {
/* 1210 */       failureItem = new Vector();
/*      */ 
/* 1212 */       this._failures.put(xid, failureItem);
/*      */     }
/*      */ 
/* 1215 */     failureItem.addElement(uid);
/*      */   }
/*      */ 
/*      */   private void removeFailure(Xid xid, Uid uid)
/*      */   {
/* 1227 */     Vector failureItem = (Vector)this._failures.get(xid);
/*      */ 
/* 1229 */     if (failureItem != null)
/*      */     {
/* 1244 */       failureItem.remove(uid);
/*      */ 
/* 1247 */       if (failureItem.size() == 0)
/* 1248 */         this._failures.remove(xid);
/*      */     }
/*      */   }
/*      */ 
/*      */   private void clearAllFailures()
/*      */   {
/* 1254 */     if (this._failures != null)
/* 1255 */       this._failures.clear();
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 1292 */     String env = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.xaBackoffPeriod");
/*      */ 
/* 1295 */     _backoffPeriod = 20000;
/*      */ 
/* 1297 */     if (env != null)
/*      */     {
/*      */       try
/*      */       {
/* 1301 */         Integer i = new Integer(env);
/*      */ 
/* 1303 */         _backoffPeriod = i.intValue();
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/* 1307 */         throw new ExceptionInInitializerError(e);
/*      */       }
/*      */     }
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule
 * JD-Core Version:    0.6.0
 */