/*      */ package com.arjuna.ats.internal.jta.resources.arjunacore;
/*      */ 
/*      */ import com.arjuna.ats.arjuna.common.Uid;
/*      */ import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
/*      */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*      */ import com.arjuna.ats.arjuna.recovery.RecoveryManager;
/*      */ import com.arjuna.ats.arjuna.recovery.RecoveryModule;
/*      */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*      */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*      */ import com.arjuna.ats.internal.jta.recovery.arjunacore.XARecoveryModule;
/*      */ import com.arjuna.ats.internal.jta.resources.XAResourceErrorHandler;
/*      */ import com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple;
/*      */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*      */ import com.arjuna.ats.jta.logging.jtaLogger;
/*      */ import com.arjuna.ats.jta.resources.EndXAResource;
/*      */ import com.arjuna.ats.jta.resources.StartXAResource;
/*      */ import com.arjuna.ats.jta.utils.XAHelper;
/*      */ import com.arjuna.ats.jta.xa.RecoverableXAConnection;
/*      */ import com.arjuna.ats.jta.xa.XidImple;
/*      */ import com.arjuna.common.util.logging.LogNoi18n;
/*      */ import com.arjuna.common.util.logging.Logi18n;
/*      */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*      */ import java.io.ByteArrayInputStream;
/*      */ import java.io.ByteArrayOutputStream;
/*      */ import java.io.NotSerializableException;
/*      */ import java.io.ObjectInputStream;
/*      */ import java.io.ObjectOutputStream;
/*      */ import java.io.Serializable;
/*      */ import java.util.Enumeration;
/*      */ import java.util.Vector;
/*      */ import javax.transaction.xa.XAException;
/*      */ import javax.transaction.xa.XAResource;
/*      */ import javax.transaction.xa.Xid;
/*      */ 
/*      */ public class XAResourceRecord extends AbstractRecord
/*      */ {
/*      */   public static final int XACONNECTION = 0;
/*   84 */   private static final Uid START_XARESOURCE = Uid.minUid();
/*      */ 
/*   86 */   private static final Uid END_XARESOURCE = Uid.maxUid();
/*      */   protected XAResource _theXAResource;
/*      */   private RecoverableXAConnection _recoveryObject;
/*      */   private Xid _tranID;
/*      */   private boolean _prepared;
/*      */   private boolean _valid;
/*      */   private int _heuristic;
/*      */   private TransactionImple _theTransaction;
/* 1134 */   private static boolean _rollbackOptimization = false;
/*      */ 
/*      */   public XAResourceRecord(TransactionImple tx, XAResource res, Xid xid, Object[] params)
/*      */   {
/*   99 */     super(new Uid(), null, 1);
/*      */ 
/*  101 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  103 */       jtaLogger.logger.debug(1L, 4L, 1L, "XAResourceRecord.XAResourceRecord ( " + xid + " )");
/*      */     }
/*      */ 
/*  109 */     this._theXAResource = res;
/*  110 */     this._recoveryObject = null;
/*  111 */     this._tranID = xid;
/*      */ 
/*  113 */     this._valid = true;
/*      */ 
/*  115 */     if (params != null)
/*      */     {
/*  117 */       if (params.length >= 0)
/*      */       {
/*  119 */         if ((params[0] instanceof RecoverableXAConnection)) {
/*  120 */           this._recoveryObject = ((RecoverableXAConnection)params[0]);
/*      */         }
/*      */       }
/*      */     }
/*  124 */     this._prepared = false;
/*  125 */     this._heuristic = 7;
/*      */ 
/*  127 */     this._theTransaction = tx;
/*      */   }
/*      */ 
/*      */   public void finalize()
/*      */   {
/*  132 */     if (this._theTransaction != null)
/*      */     {
/*  134 */       this._theTransaction = null;
/*      */     }
/*      */   }
/*      */ 
/*      */   public final Xid getXid()
/*      */   {
/*  140 */     return this._tranID;
/*      */   }
/*      */ 
/*      */   public Uid order()
/*      */   {
/*  145 */     if ((this._theXAResource instanceof StartXAResource)) {
/*  146 */       return START_XARESOURCE;
/*      */     }
/*      */ 
/*  149 */     if ((this._theXAResource instanceof EndXAResource)) {
/*  150 */       return END_XARESOURCE;
/*      */     }
/*  152 */     return super.order();
/*      */   }
/*      */ 
/*      */   public boolean propagateOnCommit()
/*      */   {
/*  158 */     return false;
/*      */   }
/*      */ 
/*      */   public int typeIs()
/*      */   {
/*  163 */     return 171;
/*      */   }
/*      */ 
/*      */   public ClassName className()
/*      */   {
/*  168 */     return new ClassName("RecordType.JTA_RECORD");
/*      */   }
/*      */ 
/*      */   public Object value()
/*      */   {
/*  173 */     return this._theXAResource;
/*      */   }
/*      */ 
/*      */   public void setValue(Object o)
/*      */   {
/*  184 */     if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */     {
/*  186 */       jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.setvalue", new Object[] { "XAResourceRecord::set_value()" });
/*      */     }
/*      */   }
/*      */ 
/*      */   public int nestedAbort()
/*      */   {
/*  196 */     return 7;
/*      */   }
/*      */ 
/*      */   public int nestedCommit()
/*      */   {
/*  201 */     return 7;
/*      */   }
/*      */ 
/*      */   public int nestedPrepare()
/*      */   {
/*  210 */     return 0;
/*      */   }
/*      */ 
/*      */   public int topLevelPrepare()
/*      */   {
/*  224 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  226 */       jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelPrepare for " + this._tranID);
/*      */     }
/*      */ 
/*  232 */     if ((!this._valid) || (this._theXAResource == null))
/*      */     {
/*  234 */       removeConnection();
/*      */ 
/*  236 */       return 2;
/*      */     }
/*      */ 
/*  239 */     if (this._tranID == null)
/*      */     {
/*  241 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  243 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparenulltx", new Object[] { "XAResourceRecord.prepare" });
/*      */       }
/*      */ 
/*  250 */       removeConnection();
/*      */ 
/*  252 */       return 1;
/*      */     }
/*      */ 
/*      */     try
/*      */     {
/*  257 */       if (endAssociation())
/*      */       {
/*  259 */         this._theXAResource.end(this._tranID, 67108864);
/*      */       }
/*      */ 
/*  262 */       this._prepared = true;
/*      */ 
/*  264 */       if (this._theXAResource.prepare(this._tranID) == 3)
/*      */       {
/*  266 */         return 2;
/*      */       }
/*      */ 
/*  269 */       return 0;
/*      */     }
/*      */     catch (XAException e1)
/*      */     {
/*  273 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  275 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparefailed", new Object[] { "XAResourceRecord.prepare", XAHelper.printXAErrorCode(e1) });
/*      */       }
/*      */ 
/*  288 */       if (_rollbackOptimization) {
/*  289 */         removeConnection();
/*      */       }
/*  291 */       if ((e1.errorCode == -3) || (e1.errorCode == -7)) {
/*  292 */         return 6;
/*      */       }
/*  294 */       return 1;
/*      */     }
/*      */     catch (Exception e2)
/*      */     {
/*  298 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  300 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.preparefailed", new Object[] { "XAResourceRecord.prepare", e2 });
/*      */       }
/*      */ 
/*  307 */       if (_rollbackOptimization)
/*  308 */         removeConnection();
/*      */     }
/*  310 */     return 1;
/*      */   }
/*      */ 
/*      */   public int topLevelAbort()
/*      */   {
/*  325 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  327 */       jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelAbort for " + this._tranID);
/*      */     }
/*      */ 
/*  333 */     if (!this._valid) {
/*  334 */       return 8;
/*      */     }
/*  336 */     if ((this._theTransaction != null) && (this._theTransaction.getXAResourceState(this._theXAResource) == 4))
/*      */     {
/*  343 */       return 7;
/*      */     }
/*      */ 
/*  346 */     if (this._tranID == null)
/*      */     {
/*  348 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  350 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.rollbacknulltx", new Object[] { "XAResourceRecord.rollback" });
/*      */       }
/*      */ 
/*  357 */       return 8;
/*      */     }
/*      */ 
/*  361 */     if (this._theXAResource != null)
/*      */     {
/*  363 */       if (this._heuristic != 7) {
/*  364 */         return this._heuristic;
/*      */       }
/*      */       try
/*      */       {
/*  368 */         if (!this._prepared)
/*      */         {
/*  370 */           if (endAssociation())
/*      */           {
/*  372 */             this._theXAResource.end(this._tranID, 67108864);
/*      */           }
/*      */         }
/*      */ 
/*  376 */         this._theXAResource.rollback(this._tranID);
/*      */       }
/*      */       catch (XAException e1)
/*      */       {
/*  380 */         if (!notAProblem(e1, false))
/*      */         {
/*  386 */           if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */           {
/*  388 */             jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.rollbackxaerror", new Object[] { "XAResourceRecord.rollback", XAHelper.printXAErrorCode(e1) });
/*      */           }
/*      */ 
/*  398 */           switch (e1.errorCode)
/*      */           {
/*      */           case -3:
/*  401 */             if (!this._prepared)
/*      */               break;
/*      */           case 8:
/*  404 */             i = 6;
/*      */             return i;
/*      */           case 7:
/*  406 */             i = 4;
/*      */             return i;
/*      */           case 5:
/*  408 */             i = 5;
/*      */             return i;
/*      */           case 6:
/*      */           case 100:
/*      */           case 101:
/*      */           case 102:
/*      */           case 103:
/*      */           case 104:
/*      */           case 105:
/*      */           case 106:
/*      */           case 107:
/*  418 */             break;
/*      */           default:
/*  420 */             i = 8;
/*      */             return i;
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e2)
/*      */       {
/*  426 */         e2.printStackTrace();
/*      */ 
/*  428 */         int i = 8;
/*      */         return i;
/*      */       }
/*      */       finally
/*      */       {
/*  432 */         if (!this._prepared)
/*  433 */           removeConnection();
/*      */       }
/*      */     }
/*      */     else {
/*  437 */       return 8;
/*      */     }
/*      */ 
/*  440 */     return 7;
/*      */   }
/*      */ 
/*      */   public int topLevelCommit()
/*      */   {
/*  454 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  456 */       jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelCommit for " + this._tranID);
/*      */     }
/*      */ 
/*  462 */     if (!this._prepared) {
/*  463 */       return 9;
/*      */     }
/*  465 */     if (this._tranID == null)
/*      */     {
/*  467 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  469 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.commitnulltx", new Object[] { "XAResourceRecord.commit" });
/*      */       }
/*      */ 
/*  476 */       return 8;
/*      */     }
/*      */ 
/*  480 */     if (this._theXAResource != null)
/*      */     {
/*  482 */       if (this._heuristic != 7) {
/*  483 */         return this._heuristic;
/*      */       }
/*      */       try
/*      */       {
/*  487 */         this._theXAResource.commit(this._tranID, false);
/*      */       }
/*      */       catch (XAException e1)
/*      */       {
/*  491 */         if (!notAProblem(e1, true))
/*      */         {
/*  497 */           if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */           {
/*  499 */             jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.commitxaerror", new Object[] { "XAResourceRecord.commit", XAHelper.printXAErrorCode(e1) });
/*      */           }
/*      */ 
/*  515 */           switch (e1.errorCode)
/*      */           {
/*      */           case 8:
/*  518 */             i = 6;
/*      */             return i;
/*      */           case 7:
/*  520 */             break;
/*      */           case -3:
/*      */           case 6:
/*      */           case 100:
/*      */           case 101:
/*      */           case 102:
/*      */           case 103:
/*      */           case 104:
/*      */           case 105:
/*      */           case 106:
/*      */           case 107:
/*  531 */             i = 3;
/*      */             return i;
/*      */           case 5:
/*  533 */             i = 5;
/*      */             return i;
/*      */           case -6:
/*      */           case -4:
/*  536 */             break;
/*      */           case 4:
/*  538 */             i = 8;
/*      */             return i;
/*      */           case -7:
/*      */           case -5:
/*  543 */             i = 6;
/*      */             return i;
/*      */           default:
/*  545 */             i = 6;
/*      */             return i;
/*      */           }
/*      */         }
/*      */       }
/*      */       catch (Exception e2)
/*      */       {
/*  551 */         int i = 8;
/*      */         return i; } finally { removeConnection(); }
/*      */     }
/*      */     else
/*      */     {
/*  559 */       return 8;
/*      */     }
/*      */ 
/*  562 */     return 7;
/*      */   }
/*      */ 
/*      */   protected boolean notAProblem(XAException ex, boolean commit)
/*      */   {
/*  572 */     return XAResourceErrorHandler.notAProblem(this._theXAResource, ex, commit);
/*      */   }
/*      */ 
/*      */   public int nestedOnePhaseCommit()
/*      */   {
/*  577 */     return 8;
/*      */   }
/*      */ 
/*      */   public int topLevelOnePhaseCommit()
/*      */   {
/*  596 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  598 */       jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.topLevelOnePhaseCommit for " + this._tranID);
/*      */     }
/*      */ 
/*  604 */     if (this._tranID == null)
/*      */     {
/*  606 */       if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */       {
/*  608 */         jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.opcnulltx", new Object[] { "XAResourceRecord.1pc" });
/*      */       }
/*      */ 
/*  615 */       return 8;
/*      */     }
/*      */ 
/*  619 */     if (this._theXAResource != null)
/*      */     {
/*  621 */       if (this._heuristic != 7) {
/*  622 */         return this._heuristic;
/*      */       }
/*      */ 
/*      */       try
/*      */       {
/*  631 */         if (endAssociation())
/*      */         {
/*  633 */           this._theXAResource.end(this._tranID, 67108864);
/*      */         }
/*      */ 
/*  636 */         this._theXAResource.commit(this._tranID, true);
/*      */       }
/*      */       catch (XAException e1)
/*      */       {
/*  646 */         if ((e1.errorCode >= 100) && (e1.errorCode < 107))
/*      */         {
/*  649 */           i = 8;
/*      */           return i;
/*      */         }
/*  652 */         switch (e1.errorCode)
/*      */         {
/*      */         case 5:
/*      */         case 8:
/*  656 */           i = 6;
/*      */           return i;
/*      */         case 7:
/*  658 */           forget();
/*  659 */           break;
/*      */         case -3:
/*      */         case 6:
/*      */         case 100:
/*      */         case 101:
/*      */         case 102:
/*      */         case 103:
/*      */         case 104:
/*      */         case 105:
/*      */         case 106:
/*      */         case 107:
/*  670 */           forget();
/*  671 */           i = 8;
/*      */           return i;
/*      */         case -6:
/*      */         case -4:
/*  674 */           break;
/*      */         case -7:
/*      */         case -5:
/*  678 */           i = 8;
/*      */           return i;
/*      */         default:
/*  681 */           i = 8;
/*      */           return i;
/*      */         }
/*      */       }
/*      */       catch (Exception e2)
/*      */       {
/*  687 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */         {
/*  689 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.opcerror", new Object[] { "XAResourceRecord.commit_one_phase", e2 });
/*      */         }
/*      */ 
/*  697 */         int i = 8;
/*      */         return i; } finally { removeConnection(); }
/*      */     }
/*      */     else
/*      */     {
/*  705 */       return 8;
/*      */     }
/*      */ 
/*  708 */     return 7;
/*      */   }
/*      */ 
/*      */   public boolean forgetHeuristic()
/*      */   {
/*  713 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  715 */       jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.forget for " + this._tranID);
/*      */     }
/*      */ 
/*  721 */     forget();
/*      */ 
/*  723 */     removeConnection();
/*      */ 
/*  725 */     return true;
/*      */   }
/*      */ 
/*      */   private void forget()
/*      */   {
/*  730 */     if ((this._theXAResource != null) && (this._tranID != null))
/*      */     {
/*      */       try
/*      */       {
/*  734 */         this._theXAResource.forget(this._tranID);
/*      */       }
/*      */       catch (Exception e)
/*      */       {
/*      */       }
/*      */     }
/*      */   }
/*      */ 
/*      */   protected int recover()
/*      */   {
/*  749 */     if (jtaLogger.logger.isDebugEnabled())
/*      */     {
/*  751 */       jtaLogger.logger.debug(16L, 2L, 1L, "XAResourceRecord.recover");
/*      */     }
/*      */ 
/*  757 */     return 2;
/*      */   }
/*      */ 
/*      */   public static AbstractRecord create()
/*      */   {
/*  762 */     return new XAResourceRecord();
/*      */   }
/*      */ 
/*      */   public static void remove(AbstractRecord toDelete)
/*      */   {
/*  767 */     toDelete = null;
/*      */   }
/*      */ 
/*      */   public boolean save_state(OutputObjectState os, int t)
/*      */   {
/*  778 */     boolean res = false;
/*      */     try
/*      */     {
/*  782 */       os.packInt(this._heuristic);
/*      */ 
/*  789 */       XidImple.pack(os, this._tranID);
/*      */ 
/*  795 */       if (this._recoveryObject == null)
/*      */       {
/*  797 */         os.packInt(1);
/*      */ 
/*  799 */         boolean shouldSerialize = false;
/*      */         try
/*      */         {
/*  803 */           if ((this._theXAResource instanceof Serializable)) {
/*  804 */             shouldSerialize = true;
/*      */           }
/*  806 */           ByteArrayOutputStream s = new ByteArrayOutputStream();
/*  807 */           ObjectOutputStream o = new ObjectOutputStream(s);
/*      */ 
/*  811 */           if (this._theXAResource == null) {
/*  812 */             throw new NotSerializableException();
/*      */           }
/*  814 */           o.writeObject(this._theXAResource);
/*  815 */           o.close();
/*      */ 
/*  817 */           os.packBoolean(true);
/*      */ 
/*  819 */           os.packBytes(s.toByteArray());
/*      */         }
/*      */         catch (NotSerializableException ex)
/*      */         {
/*  823 */           if (!shouldSerialize)
/*      */           {
/*  827 */             os.packBoolean(false);
/*      */           }
/*  831 */           else if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */           {
/*  833 */             jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.savestate");
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  840 */         os.packInt(0);
/*  841 */         os.packString(this._recoveryObject.getClass().getName());
/*      */ 
/*  843 */         this._recoveryObject.packInto(os);
/*      */       }
/*      */ 
/*  846 */       res = true;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  850 */       e.printStackTrace();
/*      */ 
/*  852 */       res = false;
/*      */     }
/*      */ 
/*  855 */     if (res) {
/*  856 */       res = (res) && (super.save_state(os, t));
/*      */     }
/*  858 */     return res;
/*      */   }
/*      */ 
/*      */   public boolean restore_state(InputObjectState os, int t)
/*      */   {
/*  872 */     boolean res = false;
/*      */     try
/*      */     {
/*  876 */       this._heuristic = os.unpackInt();
/*  877 */       this._tranID = XidImple.unpack(os);
/*      */ 
/*  879 */       this._theXAResource = null;
/*  880 */       this._recoveryObject = null;
/*      */ 
/*  882 */       if (os.unpackInt() == 1)
/*      */       {
/*  884 */         boolean haveXAResource = os.unpackBoolean();
/*      */ 
/*  886 */         if (haveXAResource)
/*      */         {
/*      */           try
/*      */           {
/*  890 */             byte[] b = os.unpackBytes();
/*      */ 
/*  892 */             ByteArrayInputStream s = new ByteArrayInputStream(b);
/*  893 */             ObjectInputStream o = new ObjectInputStream(s);
/*      */ 
/*  895 */             this._theXAResource = ((XAResource)o.readObject());
/*  896 */             o.close();
/*      */ 
/*  898 */             if (jtaLogger.logger.isDebugEnabled())
/*      */             {
/*  900 */               jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.restore_state - XAResource de-serialized");
/*      */             }
/*      */ 
/*      */           }
/*      */           catch (Exception ex)
/*      */           {
/*  912 */             if (jtaLogger.loggerI18N.isWarnEnabled())
/*      */             {
/*  914 */               jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.restorestate", ex);
/*      */             }
/*      */ 
/*  918 */             return false;
/*      */           }
/*      */ 
/*      */         }
/*      */         else
/*      */         {
/*  927 */           this._theXAResource = getNewXAResource();
/*      */ 
/*  929 */           if (this._theXAResource == null)
/*      */           {
/*  931 */             jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.resources.arjunacore.norecoveryxa", new Object[] { this._tranID });
/*      */           }
/*      */         }
/*      */ 
/*      */       }
/*      */       else
/*      */       {
/*  938 */         String creatorName = os.unpackString();
/*  939 */         Class c = Thread.currentThread().getContextClassLoader().loadClass(creatorName);
/*      */ 
/*  942 */         this._recoveryObject = ((RecoverableXAConnection)c.newInstance());
/*      */ 
/*  944 */         this._recoveryObject.unpackFrom(os);
/*  945 */         this._theXAResource = this._recoveryObject.getResource();
/*      */ 
/*  947 */         if (jtaLogger.logger.isDebugEnabled())
/*      */         {
/*  949 */           jtaLogger.logger.debug(16L, 4L, 1L, "XAResourceRecord.restore_state - XAResource got from " + creatorName);
/*      */         }
/*      */ 
/*      */       }
/*      */ 
/*  957 */       res = true;
/*      */     }
/*      */     catch (Exception e)
/*      */     {
/*  961 */       e.printStackTrace();
/*      */ 
/*  963 */       res = false;
/*      */     }
/*      */ 
/*  966 */     if (res) {
/*  967 */       res = (res) && (super.restore_state(os, t));
/*      */     }
/*  969 */     return res;
/*      */   }
/*      */ 
/*      */   public String type()
/*      */   {
/*  974 */     return typeName();
/*      */   }
/*      */ 
/*      */   public static String typeName()
/*      */   {
/*  979 */     return "/StateManager/AbstractRecord/XAResourceRecord";
/*      */   }
/*      */ 
/*      */   public boolean doSave()
/*      */   {
/*  984 */     return true;
/*      */   }
/*      */ 
/*      */   public void merge(AbstractRecord a)
/*      */   {
/*      */   }
/*      */ 
/*      */   public void alter(AbstractRecord a)
/*      */   {
/*      */   }
/*      */ 
/*      */   public boolean shouldAdd(AbstractRecord a)
/*      */   {
/*  997 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean shouldAlter(AbstractRecord a)
/*      */   {
/* 1002 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean shouldMerge(AbstractRecord a)
/*      */   {
/* 1007 */     return false;
/*      */   }
/*      */ 
/*      */   public boolean shouldReplace(AbstractRecord a)
/*      */   {
/* 1012 */     return false;
/*      */   }
/*      */ 
/*      */   protected XAResourceRecord()
/*      */   {
/* 1019 */     this._theXAResource = null;
/* 1020 */     this._recoveryObject = null;
/* 1021 */     this._tranID = null;
/* 1022 */     this._prepared = true;
/* 1023 */     this._heuristic = 7;
/* 1024 */     this._valid = true;
/* 1025 */     this._theTransaction = null;
/*      */   }
/*      */ 
/*      */   protected XAResourceRecord(Uid u)
/*      */   {
/* 1030 */     super(u, null, 1);
/*      */ 
/* 1032 */     this._theXAResource = null;
/* 1033 */     this._recoveryObject = null;
/* 1034 */     this._tranID = null;
/* 1035 */     this._prepared = true;
/* 1036 */     this._heuristic = 7;
/* 1037 */     this._valid = true;
/* 1038 */     this._theTransaction = null;
/*      */   }
/*      */ 
/*      */   protected synchronized void setXAResource(XAResource res)
/*      */   {
/* 1047 */     this._theXAResource = res;
/*      */   }
/*      */ 
/*      */   private final XAResource getNewXAResource()
/*      */   {
/* 1062 */     RecoveryManager recMan = RecoveryManager.manager();
/* 1063 */     Vector recoveryModules = recMan.getModules();
/*      */ 
/* 1065 */     if (recoveryModules != null)
/*      */     {
/* 1067 */       Enumeration modules = recoveryModules.elements();
/*      */ 
/* 1069 */       while (modules.hasMoreElements())
/*      */       {
/* 1071 */         RecoveryModule m = (RecoveryModule)modules.nextElement();
/*      */ 
/* 1073 */         if ((m instanceof XARecoveryModule))
/*      */         {
/* 1075 */           return ((XARecoveryModule)m).getNewXAResource(this._tranID);
/*      */         }
/*      */       }
/*      */     }
/*      */ 
/* 1080 */     return null;
/*      */   }
/*      */ 
/*      */   private final void removeConnection()
/*      */   {
/* 1091 */     if (this._recoveryObject != null)
/*      */     {
/* 1093 */       this._recoveryObject.close();
/* 1094 */       this._recoveryObject = null;
/*      */     }
/*      */ 
/* 1097 */     if (this._theTransaction != null)
/* 1098 */       this._theTransaction = null;
/*      */   }
/*      */ 
/*      */   private final boolean endAssociation()
/*      */   {
/* 1108 */     boolean doEnd = true;
/*      */ 
/* 1110 */     if (this._theTransaction != null)
/*      */     {
/* 1112 */       if (this._theTransaction.getXAResourceState(this._theXAResource) == 1)
/*      */       {
/* 1116 */         doEnd = false;
/*      */       }
/*      */     }
/*      */     else {
/* 1120 */       doEnd = false;
/*      */     }
/* 1122 */     return doEnd;
/*      */   }
/*      */ 
/*      */   static
/*      */   {
/* 1138 */     String optimization = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.jtaTMImplementation", "OFF");
/*      */ 
/* 1141 */     if (optimization.equals("ON"))
/* 1142 */       _rollbackOptimization = true;
/*      */   }
/*      */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.resources.arjunacore.XAResourceRecord
 * JD-Core Version:    0.6.0
 */