/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.utils.ThreadUtil;
/*     */ import com.arjuna.ats.jta.common.jtaPropertyManager;
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.propertyservice.PropertyManager;
/*     */ import java.util.Hashtable;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ 
/*     */ public class BaseTransaction
/*     */ {
/* 315 */   private static boolean _supportSubtransactions = false;
/*     */ 
/* 317 */   private static Hashtable _timeouts = new Hashtable();
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/*  58 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  60 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.begin");
/*     */     }
/*     */ 
/*  71 */     if (!_supportSubtransactions)
/*     */     {
/*     */       try
/*     */       {
/*  75 */         checkTransactionState();
/*     */       }
/*     */       catch (IllegalStateException e1)
/*     */       {
/*  79 */         throw new NotSupportedException(e1.getMessage());
/*     */       }
/*     */       catch (Exception e2)
/*     */       {
/*  83 */         throw new SystemException(e2.toString());
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/*  88 */     Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
/*  89 */     int v = 0;
/*     */ 
/*  91 */     if (value != null)
/*     */     {
/*  93 */       v = value.intValue();
/*     */     }
/*     */ 
/*  98 */     TransactionImple.putTransaction(new TransactionImple(v));
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/* 119 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 121 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.commit");
/*     */     }
/*     */ 
/* 127 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 129 */     if (theTransaction == null) {
/* 130 */       throw new IllegalStateException("BaseTransaction.commit - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
/*     */     }
/*     */ 
/* 135 */     theTransaction.commitAndDisassociate();
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/* 147 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 149 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.rollback");
/*     */     }
/*     */ 
/* 155 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 157 */     if (theTransaction == null) {
/* 158 */       throw new IllegalStateException("BaseTransaction.rollback - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.notx"));
/*     */     }
/*     */ 
/* 163 */     theTransaction.rollbackAndDisassociate();
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 178 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 180 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.setRollbackOnly");
/*     */     }
/*     */ 
/* 186 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 188 */     if (theTransaction == null) {
/* 189 */       throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.nosuchtx"));
/*     */     }
/*     */ 
/* 193 */     theTransaction.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public int getStatus() throws SystemException
/*     */   {
/* 198 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 200 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.getStatus");
/*     */     }
/*     */ 
/* 206 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 208 */     if (theTransaction == null) {
/* 209 */       return 6;
/*     */     }
/* 211 */     return theTransaction.getStatus();
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int seconds)
/*     */     throws SystemException
/*     */   {
/* 217 */     if (seconds >= 0)
/*     */     {
/* 219 */       _timeouts.put(ThreadUtil.getThreadId(), new Integer(seconds));
/*     */     }
/*     */   }
/*     */ 
/*     */   public int getTimeout() throws SystemException
/*     */   {
/* 225 */     Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
/*     */ 
/* 227 */     if (value != null)
/*     */     {
/* 229 */       return value.intValue();
/*     */     }
/*     */ 
/* 232 */     return 0;
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 237 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 239 */     if (theTransaction == null) {
/* 240 */       return "Transaction: unknown";
/*     */     }
/* 242 */     return "Transaction: " + theTransaction;
/*     */   }
/*     */ 
/*     */   public TransactionImple createSubordinate() throws NotSupportedException, SystemException
/*     */   {
/* 247 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/* 249 */       jtaLogger.logger.debug(16L, 4L, 1L, "BaseTransaction.createSubordinate");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 257 */       checkTransactionState();
/*     */     }
/*     */     catch (IllegalStateException e1)
/*     */     {
/* 261 */       throw new NotSupportedException();
/*     */     }
/*     */     catch (Exception e2)
/*     */     {
/* 265 */       throw new SystemException(e2.toString());
/*     */     }
/*     */ 
/* 268 */     Integer value = (Integer)_timeouts.get(ThreadUtil.getThreadId());
/* 269 */     int v = 0;
/*     */ 
/* 271 */     if (value != null)
/*     */     {
/* 273 */       v = value.intValue();
/*     */     }
/*     */ 
/* 278 */     return new com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple(v);
/*     */   }
/*     */ 
/*     */   final void checkTransactionState()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 299 */     TransactionImple theTransaction = TransactionImple.getTransaction();
/*     */ 
/* 301 */     if (theTransaction == null) {
/* 302 */       return;
/*     */     }
/*     */ 
/* 305 */     if ((theTransaction.getStatus() != 6) && (!_supportSubtransactions))
/*     */     {
/* 308 */       throw new IllegalStateException("BaseTransaction.checkTransactionState - " + jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.alreadyassociated"));
/*     */     }
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/* 321 */     String subtran = jtaPropertyManager.propertyManager.getProperty("com.arjuna.ats.jta.supportSubtransactions");
/*     */ 
/* 324 */     if ((subtran != null) && (subtran.equals("YES")))
/* 325 */       _supportSubtransactions = true;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.BaseTransaction
 * JD-Core Version:    0.6.0
 */