/*     */ package com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate;
/*     */ 
/*     */ import com.arjuna.ats.jta.logging.jtaLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.ResourceBundle;
/*     */ import javax.transaction.HeuristicCommitException;
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ 
/*     */ public class TransactionImple extends com.arjuna.ats.internal.jta.transaction.arjunacore.TransactionImple
/*     */ {
/*     */   public TransactionImple(int timeout)
/*     */   {
/*  65 */     this(new SubordinateAtomicAction(timeout));
/*     */   }
/*     */ 
/*     */   public TransactionImple(com.arjuna.ats.internal.jta.transaction.arjunacore.AtomicAction act)
/*     */   {
/*  72 */     super(act);
/*     */ 
/*  74 */     putTransaction(this);
/*     */   }
/*     */ 
/*     */   public boolean equals(Object obj)
/*     */   {
/*  83 */     if (jtaLogger.logger.isDebugEnabled())
/*     */     {
/*  85 */       jtaLogger.logger.debug(16L, 4L, 1L, "TransactionImple.equals");
/*     */     }
/*     */ 
/*  88 */     if (obj == null) {
/*  89 */       return false;
/*     */     }
/*  91 */     if (obj == this) {
/*  92 */       return true;
/*     */     }
/*  94 */     if ((obj instanceof TransactionImple))
/*     */     {
/*  96 */       return super.equals(obj);
/*     */     }
/*     */ 
/*  99 */     return false;
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException
/*     */   {
/* 113 */     throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.invalidstate"));
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/* 125 */     throw new IllegalStateException(jtaLogger.logMesg.getString("com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.invalidstate"));
/*     */   }
/*     */ 
/*     */   public int doPrepare()
/*     */   {
/*     */     try
/*     */     {
/* 135 */       SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
/*     */ 
/* 137 */       if (!endSuspendedRMs()) {
/* 138 */         this._theTransaction.preventCommit();
/*     */       }
/* 140 */       int res = subAct.doPrepare();
/*     */ 
/* 142 */       switch (res)
/*     */       {
/*     */       case 1:
/*     */       case 2:
/* 146 */         removeTransaction(this);
/*     */       }
/*     */ 
/* 150 */       return res;
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 154 */       ex.printStackTrace();
/*     */     }
/* 156 */     return 11;
/*     */   }
/*     */ 
/*     */   public void doCommit()
/*     */     throws IllegalStateException, HeuristicMixedException, HeuristicRollbackException, SystemException
/*     */   {
/*     */     try
/*     */     {
/* 166 */       SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
/*     */ 
/* 168 */       int res = subAct.doCommit();
/*     */ 
/* 170 */       switch (res)
/*     */       {
/*     */       case 6:
/*     */       case 7:
/*     */       case 12:
/* 175 */         removeTransaction(this);
/* 176 */         break;
/*     */       case 2:
/*     */       case 4:
/* 179 */         throw new HeuristicRollbackException();
/*     */       case 11:
/* 181 */         throw new HeuristicRollbackException();
/*     */       case 13:
/*     */       case 14:
/* 184 */         throw new HeuristicMixedException();
/*     */       case 9:
/* 186 */         removeTransaction(this);
/*     */ 
/* 188 */         throw new IllegalStateException();
/*     */       case 3:
/*     */       case 5:
/*     */       case 8:
/*     */       case 10:
/*     */       default:
/* 190 */         throw new HeuristicMixedException();
/*     */       }
/*     */ 
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 197 */       ex.printStackTrace();
/*     */ 
/* 199 */       throw new IllegalStateException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void doRollback()
/*     */     throws IllegalStateException, HeuristicMixedException, HeuristicCommitException, SystemException
/*     */   {
/*     */     try
/*     */     {
/* 208 */       SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
/*     */ 
/* 210 */       if (!endSuspendedRMs())
/*     */       {
/* 212 */         if (jtaLogger.loggerI18N.isWarnEnabled())
/*     */         {
/* 214 */           jtaLogger.loggerI18N.warn("com.arjuna.ats.internal.jta.transaction.arjunacore.endsuspendfailed1");
/*     */         }
/*     */       }
/*     */ 
/* 218 */       int res = subAct.doRollback();
/*     */ 
/* 220 */       switch (res)
/*     */       {
/*     */       case 2:
/*     */       case 4:
/*     */       case 11:
/* 225 */         removeTransaction(this);
/*     */ 
/* 227 */         break;
/*     */       case 12:
/* 229 */         throw new HeuristicCommitException();
/*     */       case 13:
/*     */       case 14:
/* 232 */         throw new HeuristicMixedException();
/*     */       case 3:
/*     */       case 5:
/*     */       case 6:
/*     */       case 7:
/*     */       case 8:
/*     */       case 9:
/*     */       case 10:
/*     */       default:
/* 234 */         throw new HeuristicMixedException();
/*     */       }
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 239 */       ex.printStackTrace();
/*     */ 
/* 241 */       throw new IllegalStateException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public void doForget() throws IllegalStateException
/*     */   {
/*     */     try
/*     */     {
/* 249 */       SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
/*     */ 
/* 251 */       subAct.doForget();
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 255 */       throw new IllegalStateException();
/*     */     }
/*     */     finally
/*     */     {
/* 259 */       removeTransaction(this);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void doOnePhaseCommit()
/*     */     throws IllegalStateException, HeuristicRollbackException
/*     */   {
/*     */     try
/*     */     {
/* 268 */       SubordinateAtomicAction subAct = (SubordinateAtomicAction)this._theTransaction;
/*     */ 
/* 270 */       if (!endSuspendedRMs()) {
/* 271 */         this._theTransaction.preventCommit();
/*     */       }
/* 273 */       int status = subAct.doOnePhaseCommit();
/*     */ 
/* 275 */       switch (status)
/*     */       {
/*     */       case 7:
/*     */       case 12:
/* 279 */         removeTransaction(this);
/*     */ 
/* 281 */         break;
/*     */       case 2:
/*     */       case 3:
/*     */       case 4:
/*     */       case 5:
/*     */       case 6:
/*     */       case 8:
/*     */       case 10:
/*     */       case 11:
/*     */       case 13:
/*     */       case 14:
/*     */       default:
/* 287 */         throw new HeuristicRollbackException();
/*     */       case 9:
/* 289 */         throw new IllegalStateException();
/*     */       }
/*     */     }
/*     */     catch (ClassCastException ex)
/*     */     {
/* 294 */       ex.printStackTrace();
/*     */ 
/* 296 */       throw new IllegalStateException();
/*     */     }
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 302 */     if (this._theTransaction == null) {
/* 303 */       return "TransactionImple < ac-subordinate, NoTransaction >";
/*     */     }
/*     */ 
/* 306 */     return "TransactionImple < ac-subordinate, " + this._theTransaction + " >";
/*     */   }
/*     */ 
/*     */   protected void commitAndDisassociate()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, SystemException, IllegalStateException
/*     */   {
/* 323 */     throw new IllegalStateException();
/*     */   }
/*     */ 
/*     */   protected void rollbackAndDisassociate()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/* 335 */     throw new IllegalStateException();
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.jta.transaction.arjunacore.subordinate.TransactionImple
 * JD-Core Version:    0.6.0
 */