/*    */ package com.arjuna.ats.internal.tsmx.mbeans;
/*    */ 
/*    */ import com.arjuna.ats.tsmx.TransactionServiceMX;
/*    */ import com.arjuna.ats.tsmx.agent.AgentInterface;
/*    */ import com.arjuna.ats.tsmx.logging.tsmxLogger;
/*    */ import com.arjuna.common.util.exceptions.ManagementPluginException;
/*    */ import com.arjuna.common.util.logging.LogNoi18n;
/*    */ import com.arjuna.common.util.propertyservice.plugins.PropertyManagementPlugin;
/*    */ import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
/*    */ import java.io.IOException;
/*    */ import java.io.PrintStream;
/*    */ import java.util.Properties;
/*    */ import javax.management.MBeanServer;
/*    */ 
/*    */ public class PropertyServiceJMXPlugin
/*    */   implements PropertyManagementPlugin
/*    */ {
/*    */   public void initialise(PropertyManagerPluginInterface pm)
/*    */     throws ManagementPluginException, IOException
/*    */   {
/*    */     try
/*    */     {
/* 56 */       registerPropertyManagers(pm);
/*    */     }
/*    */     catch (Exception e)
/*    */     {
/* 60 */       throw new ManagementPluginException("Failed to register mbeans: " + e);
/*    */     }
/*    */   }
/*    */ 
/*    */   private void registerPropertyManagers(PropertyManagerPluginInterface pm)
/*    */     throws Exception
/*    */   {
/* 73 */     if (!pm.getLocalProperties().isEmpty())
/*    */     {
/* 75 */       PropertyServiceMBeanWrapper mbean = null;
/*    */       try
/*    */       {
/* 80 */         mbean = new PropertyServiceMBeanWrapper(pm);
/*    */ 
/* 82 */         if (tsmxLogger.logger.isInfoEnabled())
/*    */         {
/* 84 */           tsmxLogger.logger.info("Registering mbean for module '" + pm.getName() + "'");
/*    */         }
/*    */ 
/* 88 */         TransactionServiceMX.getTransactionServiceMX().getAgentInterface().getAgent().registerMBean(mbean, mbean.getObjectName());
/*    */       }
/*    */       catch (MappingsNotFoundException e)
/*    */       {
/* 92 */         if (pm.verbose())
/*    */         {
/* 94 */           System.err.println("Mappings not found: " + e.toString());
/*    */         }
/*    */ 
/*    */       }
/*    */ 
/* 99 */       PropertyManagerPluginInterface[] children = pm.getChildren();
/* 100 */       for (int count = 0; count < children.length; count++)
/*    */       {
/* 102 */         registerPropertyManagers(children[count]);
/*    */       }
/*    */     }
/*    */   }
/*    */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceJMXPlugin
 * JD-Core Version:    0.6.0
 */