/*     */ package com.arjuna.ats.internal.tsmx.mbeans;
/*     */ 
/*     */ import com.arjuna.common.util.exceptions.SavePropertiesException;
/*     */ import com.arjuna.common.util.propertyservice.propertycontainer.PropertyManagerPluginInterface;
/*     */ import java.io.BufferedReader;
/*     */ import java.io.IOException;
/*     */ import java.io.InputStream;
/*     */ import java.io.InputStreamReader;
/*     */ import java.util.ArrayList;
/*     */ import java.util.Enumeration;
/*     */ import java.util.Hashtable;
/*     */ import java.util.Properties;
/*     */ import javax.management.Attribute;
/*     */ import javax.management.AttributeList;
/*     */ import javax.management.AttributeNotFoundException;
/*     */ import javax.management.DynamicMBean;
/*     */ import javax.management.InvalidAttributeValueException;
/*     */ import javax.management.MBeanAttributeInfo;
/*     */ import javax.management.MBeanException;
/*     */ import javax.management.MBeanInfo;
/*     */ import javax.management.MBeanOperationInfo;
/*     */ import javax.management.MalformedObjectNameException;
/*     */ import javax.management.ObjectName;
/*     */ import javax.management.ReflectionException;
/*     */ 
/*     */ public class PropertyServiceMBeanWrapper
/*     */   implements DynamicMBean
/*     */ {
/*     */   private static final String PROPERTY_FILE_MBEAN_OBJECT_NAME_PREFIX = "com.arjuna.ats.properties:module=";
/*     */   private static final String MAPPINGS_FILENAME_SUFFIX = "-properties.mappings";
/*     */   private static final String COMMENT_PREFIX = "#";
/*  62 */   private PropertyManagerPluginInterface _pm = null;
/*  63 */   private ArrayList _attributeMapping = new ArrayList();
/*  64 */   private MBeanInfo _info = null;
/*  65 */   private Hashtable _comment = new Hashtable();
/*  66 */   private ArrayList _propertyMapping = new ArrayList();
/*     */ 
/*     */   PropertyServiceMBeanWrapper(PropertyManagerPluginInterface pm) throws MappingsNotFoundException
/*     */   {
/*  70 */     this._pm = pm;
/*     */ 
/*  72 */     retrievePropertyToAttributeMappings(pm.getName());
/*     */   }
/*     */ 
/*     */   public void save()
/*     */     throws IOException, SavePropertiesException, ClassNotFoundException
/*     */   {
/*  87 */     this._pm.save(null, null);
/*     */   }
/*     */ 
/*     */   private void retrievePropertyToAttributeMappings(String name)
/*     */     throws MappingsNotFoundException
/*     */   {
/*  93 */     InputStream mappingsIn = Thread.currentThread().getContextClassLoader().getResourceAsStream(name + "-properties.mappings");
/*     */ 
/*  95 */     if (mappingsIn != null)
/*     */     {
/*     */       try
/*     */       {
/*  99 */         BufferedReader in = new BufferedReader(new InputStreamReader(mappingsIn));
/*     */ 
/* 101 */         String comment = null;
/*     */         String mapping;
/* 110 */         while ((mapping = in.readLine()) != null)
/*     */         {
/* 112 */           if (mapping.startsWith("#"))
/*     */           {
/* 114 */             if (mapping.length() <= 1)
/*     */               continue;
/* 116 */             comment = mapping.substring(1); continue;
/*     */           }
/*     */ 
/* 121 */           if (mapping.indexOf('=') == -1)
/*     */           {
/* 123 */             throw new MappingsNotFoundException("A valid property-to-attribute was not found (" + name + "-properties.mappings" + ")");
/*     */           }
/*     */ 
/* 126 */           this._propertyMapping.add(mapping.substring(0, mapping.indexOf('=')));
/* 127 */           this._attributeMapping.add(mapping.substring(mapping.indexOf('=') + 1));
/*     */ 
/* 130 */           if (comment != null)
/*     */           {
/* 132 */             this._comment.put(mapping.substring(0, mapping.indexOf('=')), comment);
/*     */           }
/*     */ 
/* 135 */           comment = null;
/*     */         }
/*     */ 
/* 139 */         in.close();
/*     */       }
/*     */       catch (IOException e)
/*     */       {
/* 143 */         throw new MappingsNotFoundException("Failed to load property-to-attribute mappings (" + name + "-properties.mappings" + ")");
/*     */       }
/*     */     }
/*     */     else
/*     */     {
/* 148 */       throw new MappingsNotFoundException("Failed to find property-to-attribute mappings (" + name + "-properties.mappings" + ")");
/*     */     }
/*     */   }
/*     */ 
/*     */   private String getPropertyForAttribute(String attributeName)
/*     */   {
/* 154 */     String property = null;
/* 155 */     int index = this._attributeMapping.indexOf(attributeName);
/*     */ 
/* 157 */     if (index != -1)
/*     */     {
/* 159 */       property = (String)this._propertyMapping.get(index);
/*     */     }
/*     */ 
/* 162 */     return property;
/*     */   }
/*     */ 
/*     */   public void setAttribute(Attribute attribute)
/*     */     throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException
/*     */   {
/* 169 */     if (this._attributeMapping.contains(attribute.getName()))
/*     */     {
/* 171 */       String property = getPropertyForAttribute(attribute.getName());
/*     */ 
/* 173 */       if (property == null)
/*     */       {
/* 175 */         throw new AttributeNotFoundException("Attribute-to-property mapping not found for: " + attribute.getName());
/*     */       }
/*     */ 
/* 179 */       this._pm.setProperty(property, (String)attribute.getValue());
/*     */     }
/*     */     else {
/* 182 */       throw new AttributeNotFoundException("Attribute '" + attribute.getName() + "' does not exist within this property manager");
/*     */     }
/*     */   }
/*     */ 
/*     */   public AttributeList setAttributes(AttributeList attributeList) {
/* 187 */     AttributeList returnList = new AttributeList();
/*     */ 
/* 189 */     for (int count = 0; count < attributeList.size(); count++)
/*     */     {
/* 191 */       Attribute attribute = (Attribute)attributeList.get(count);
/*     */ 
/* 194 */       if (!this._attributeMapping.contains(attribute.getName())) {
/*     */         continue;
/*     */       }
/*     */       try
/*     */       {
/* 199 */         setAttribute(attribute);
/*     */ 
/* 202 */         returnList.add(attribute);
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 211 */     return returnList;
/*     */   }
/*     */ 
/*     */   public Object getAttribute(String s) throws AttributeNotFoundException, MBeanException, ReflectionException
/*     */   {
/* 216 */     String returnValue = null;
/*     */ 
/* 219 */     if (this._attributeMapping.contains(s))
/*     */     {
/* 221 */       returnValue = this._pm.getProperty(getPropertyForAttribute(s), null);
/*     */     }
/*     */ 
/* 224 */     if (returnValue == null)
/*     */     {
/* 226 */       throw new AttributeNotFoundException("The attribute '" + s + "' is not defined");
/*     */     }
/*     */ 
/* 229 */     return returnValue;
/*     */   }
/*     */ 
/*     */   public AttributeList getAttributes(String[] strings)
/*     */   {
/* 234 */     AttributeList returnList = new AttributeList(strings.length);
/*     */ 
/* 236 */     for (int count = 0; count < strings.length; count++)
/*     */     {
/*     */       try
/*     */       {
/* 240 */         returnList.add(new Attribute(strings[count], getAttribute(strings[count])));
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 248 */     return returnList;
/*     */   }
/*     */ 
/*     */   public Object invoke(String methodName, Object[] params, String[] signature) throws MBeanException, ReflectionException
/*     */   {
/* 253 */     if ((methodName.equals("save")) && (params.length == 0))
/*     */     {
/*     */       try
/*     */       {
/* 257 */         save();
/*     */       }
/*     */       catch (Exception e)
/*     */       {
/* 261 */         throw new MBeanException(e);
/*     */       }
/*     */     }
/* 264 */     return null;
/*     */   }
/*     */ 
/*     */   public MBeanInfo getMBeanInfo()
/*     */   {
/* 269 */     if (this._info == null)
/*     */     {
/* 271 */       this._info = new MBeanInfo(getClass().getName(), "This is a mbean representing the properties stored in '" + this._pm.getName() + "'", getAttributeInfo(), null, getOperationInfo(), null);
/*     */     }
/*     */ 
/* 279 */     return this._info;
/*     */   }
/*     */ 
/*     */   private MBeanOperationInfo[] getOperationInfo()
/*     */   {
/* 284 */     MBeanOperationInfo saveOperation = null;
/*     */     try
/*     */     {
/* 288 */       saveOperation = new MBeanOperationInfo("Save the properties", getClass().getMethod("save", (Class[])null));
/*     */     }
/*     */     catch (NoSuchMethodException e)
/*     */     {
/*     */     }
/*     */ 
/* 296 */     return new MBeanOperationInfo[] { saveOperation };
/*     */   }
/*     */ 
/*     */   private MBeanAttributeInfo[] getAttributeInfo()
/*     */   {
/* 301 */     ArrayList attributes = new ArrayList();
/* 302 */     Properties p = new Properties();
/* 303 */     p.putAll(this._pm.getLocalProperties());
/*     */ 
/* 305 */     for (Enumeration e = p.keys(); e.hasMoreElements(); )
/*     */     {
/* 307 */       String propertyName = (String)e.nextElement();
/*     */ 
/* 309 */       if (this._propertyMapping.contains(propertyName))
/*     */       {
/* 311 */         int index = this._propertyMapping.indexOf(propertyName);
/*     */ 
/* 313 */         if (index != -1)
/*     */         {
/* 316 */           String comment = (String)this._comment.get(propertyName);
/*     */ 
/* 318 */           attributes.add(new MBeanAttributeInfo((String)this._attributeMapping.get(index), String.class.getName(), comment, true, true, false));
/*     */         }
/*     */ 
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 328 */     MBeanAttributeInfo[] attrInfo = new MBeanAttributeInfo[attributes.size()];
/* 329 */     attributes.toArray(attrInfo);
/*     */ 
/* 331 */     return attrInfo;
/*     */   }
/*     */ 
/*     */   public ObjectName getObjectName()
/*     */     throws MalformedObjectNameException
/*     */   {
/* 341 */     return new ObjectName("com.arjuna.ats.properties:module=" + this._pm.getName());
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.tsmx.mbeans.PropertyServiceMBeanWrapper
 * JD-Core Version:    0.6.0
 */