/*     */ package com.arjuna.ats.internal.txoj.lockstore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.txoj.exceptions.LockStoreException;
/*     */ 
/*     */ class LockStoreSegment
/*     */ {
/*     */   private LockStoreList headOfList;
/*     */ 
/*     */   public LockStoreSegment()
/*     */   {
/* 138 */     this.headOfList = null;
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/* 143 */     this.headOfList = null;
/*     */   }
/*     */ 
/*     */   public synchronized boolean write_committed(Uid u, String tName, OutputObjectState state)
/*     */   {
/* 148 */     if (state.size() <= 0) {
/* 149 */       return false;
/*     */     }
/* 151 */     LockStoreList ptr = find(tName);
/*     */ 
/* 153 */     if (ptr == null)
/*     */     {
/* 155 */       ptr = new LockStoreList(tName);
/* 156 */       ptr.setNext(this.headOfList);
/*     */ 
/* 158 */       this.headOfList = ptr;
/*     */     }
/*     */ 
/* 161 */     ptr.add(u, state);
/*     */ 
/* 163 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized InputObjectState read_state(Uid u, String tName) throws LockStoreException
/*     */   {
/* 168 */     LockStoreList ptr = find(tName);
/*     */ 
/* 170 */     if (ptr == null) {
/* 171 */       return null;
/*     */     }
/* 173 */     return ptr.get(u);
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove_state(Uid u, String tName)
/*     */   {
/* 178 */     boolean found = false;
/* 179 */     LockStoreList ptr = this.headOfList;
/*     */ 
/* 181 */     while ((!found) && (ptr != null))
/*     */     {
/* 183 */       if (ptr.name().compareTo(tName) == 0) {
/* 184 */         found = true; continue;
/*     */       }
/* 186 */       ptr = ptr.getNext();
/*     */     }
/*     */ 
/* 189 */     if (!found) {
/* 190 */       return true;
/*     */     }
/* 192 */     ptr.remove(u);
/*     */ 
/* 194 */     return true;
/*     */   }
/*     */ 
/*     */   public synchronized boolean remove_segment(String tName)
/*     */   {
/* 199 */     boolean found = false;
/* 200 */     LockStoreList ptr = this.headOfList;
/* 201 */     LockStoreList trail = null;
/*     */ 
/* 203 */     while ((!found) && (ptr != null))
/*     */     {
/* 205 */       if (ptr.name().compareTo(tName) == 0) {
/* 206 */         found = true; continue;
/*     */       }
/*     */ 
/* 209 */       trail = ptr;
/* 210 */       ptr = ptr.getNext();
/*     */     }
/*     */ 
/* 214 */     if (!found) {
/* 215 */       return true;
/*     */     }
/*     */ 
/* 218 */     if (trail == null)
/* 219 */       this.headOfList = ptr.getNext();
/*     */     else {
/* 221 */       trail.setNext(ptr.getNext());
/*     */     }
/* 223 */     ptr = null;
/*     */ 
/* 226 */     return true;
/*     */   }
/*     */ 
/*     */   private LockStoreList find(String tName)
/*     */   {
/* 231 */     boolean found = false;
/* 232 */     LockStoreList ptr = this.headOfList;
/*     */ 
/* 234 */     while ((!found) && (ptr != null))
/*     */     {
/* 236 */       if (ptr.name().compareTo(tName) == 0) {
/* 237 */         found = true; continue;
/*     */       }
/* 239 */       ptr = ptr.getNext();
/*     */     }
/*     */ 
/* 242 */     return ptr;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.lockstore.LockStoreSegment
 * JD-Core Version:    0.6.0
 */