/*     */ package com.arjuna.ats.internal.txoj.semaphore;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.gandiva.ClassName;
/*     */ import com.arjuna.ats.internal.arjuna.template.KeyedList;
/*     */ import com.arjuna.ats.txoj.TxOJNames;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.ats.txoj.semaphore.SemaphoreImple;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import com.arjuna.common.util.logging.Logi18n;
/*     */ import java.util.Hashtable;
/*     */ 
/*     */ public class BasicSemaphore extends SemaphoreImple
/*     */ {
/*     */   private Thread owner;
/*     */   private int useCount;
/*     */   private Hashtable waiters;
/*     */   private int numberOfResources;
/*     */   private String semKey;
/* 234 */   private static KeyedList semaphoreList = new KeyedList();
/*     */ 
/*     */   public BasicSemaphore(String key)
/*     */   {
/*  58 */     this.owner = null;
/*  59 */     this.useCount = 0;
/*  60 */     this.waiters = new Hashtable();
/*  61 */     this.numberOfResources = 1;
/*  62 */     this.semKey = key;
/*     */ 
/*  64 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  66 */       txojLogger.aitLogger.debug(1L, 4L, 128L, "BasicSemapore::BasicSemaphore ( " + key + " )");
/*     */     }
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */   {
/*  77 */     if (this.waiters.size() != 0)
/*     */     {
/*  79 */       if (txojLogger.aitLoggerI18N.isWarnEnabled())
/*     */       {
/*  81 */         txojLogger.aitLoggerI18N.warn("com.arjuna.ats.internal.txoj.semaphore.BasicSemaphore_1");
/*     */       }
/*     */     }
/*     */ 
/*  85 */     this.owner = null;
/*  86 */     this.waiters = null;
/*     */   }
/*     */ 
/*     */   public int lock()
/*     */   {
/*  95 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  97 */       txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::lock()");
/*     */     }
/*     */ 
/* 102 */     synchronized (this)
/*     */     {
/* 104 */       Thread t = Thread.currentThread();
/*     */ 
/* 106 */       if (this.owner == null) {
/* 107 */         this.owner = t;
/*     */       }
/* 110 */       else if (this.owner != t)
/*     */       {
/* 112 */         this.waiters.put(t, t);
/*     */ 
/* 114 */         while (this.owner != null)
/*     */         {
/*     */           try
/*     */           {
/* 118 */             wait();
/*     */           }
/*     */           catch (InterruptedException e)
/*     */           {
/*     */           }
/*     */         }
/*     */ 
/* 125 */         this.waiters.remove(t);
/*     */ 
/* 127 */         this.owner = t;
/*     */       }
/*     */ 
/* 131 */       this.useCount += 1;
/*     */     }
/*     */ 
/* 134 */     return 0;
/*     */   }
/*     */ 
/*     */   public int unlock()
/*     */   {
/* 139 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 141 */       txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::unlock()");
/*     */     }
/*     */ 
/* 146 */     synchronized (this)
/*     */     {
/* 148 */       Thread t = Thread.currentThread();
/*     */ 
/* 150 */       if (this.owner != t) {
/* 151 */         return 3;
/*     */       }
/*     */ 
/* 154 */       if (--this.useCount == 0)
/*     */       {
/* 156 */         this.owner = null;
/*     */ 
/* 158 */         if (this.waiters.size() > 0)
/*     */         {
/* 160 */           notify();
/*     */         }
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 166 */     return 1;
/*     */   }
/*     */ 
/*     */   public int tryLock()
/*     */   {
/* 171 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 173 */       txojLogger.aitLogger.debug(16L, 4L, 128L, "BasicSemapore::tryLock()");
/*     */     }
/*     */ 
/* 178 */     synchronized (this)
/*     */     {
/* 180 */       if ((this.owner == null) || (this.owner == Thread.currentThread())) {
/* 181 */         return lock();
/*     */       }
/* 183 */       return 2;
/*     */     }
/*     */   }
/*     */ 
/*     */   public ClassName className()
/*     */   {
/* 189 */     return TxOJNames.Implementation_Semaphore_BasicSemaphore();
/*     */   }
/*     */ 
/*     */   public static ClassName name()
/*     */   {
/* 194 */     return TxOJNames.Implementation_Semaphore_BasicSemaphore();
/*     */   }
/*     */ 
/*     */   public static BasicSemaphore create(Object[] param)
/*     */   {
/* 203 */     if (param == null) {
/* 204 */       return null;
/*     */     }
/* 206 */     String key = (String)param[0];
/* 207 */     Object ptr = semaphoreList.get(key);
/*     */ 
/* 209 */     if (ptr != null)
/*     */     {
/* 211 */       if ((ptr instanceof BasicSemaphore)) {
/* 212 */         return (BasicSemaphore)ptr;
/*     */       }
/* 214 */       return null;
/*     */     }
/*     */ 
/* 221 */     BasicSemaphore sem = new BasicSemaphore(key);
/*     */ 
/* 223 */     semaphoreList.add(sem, key);
/*     */ 
/* 225 */     return sem;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.internal.txoj.semaphore.BasicSemaphore
 * JD-Core Version:    0.6.0
 */