/*     */ package com.arjuna.ats.jbossatx;
/*     */ 
/*     */ import javax.transaction.HeuristicMixedException;
/*     */ import javax.transaction.HeuristicRollbackException;
/*     */ import javax.transaction.InvalidTransactionException;
/*     */ import javax.transaction.NotSupportedException;
/*     */ import javax.transaction.RollbackException;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import javax.transaction.TransactionManager;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.tm.TransactionLocalDelegate;
/*     */ import org.jboss.tm.TransactionTimeoutConfiguration;
/*     */ 
/*     */ public abstract class BaseTransactionManagerDelegate
/*     */   implements TransactionManager, TransactionLocalDelegate, TransactionTimeoutConfiguration
/*     */ {
/*     */   private final TransactionManager transactionManager;
/*     */   private final TransactionLocalDelegate transactionLocalDelegate;
/*     */ 
/*     */   protected BaseTransactionManagerDelegate(TransactionManager transactionManager)
/*     */   {
/*  57 */     this(transactionManager, new TransactionLocalDelegateImpl());
/*     */   }
/*     */ 
/*     */   protected BaseTransactionManagerDelegate(TransactionManager transactionManager, TransactionLocalDelegate transactionLocalDelegate)
/*     */   {
/*  67 */     this.transactionManager = transactionManager;
/*  68 */     this.transactionLocalDelegate = transactionLocalDelegate;
/*     */   }
/*     */ 
/*     */   public void begin()
/*     */     throws NotSupportedException, SystemException
/*     */   {
/*  77 */     this.transactionManager.begin();
/*     */   }
/*     */ 
/*     */   public void commit()
/*     */     throws RollbackException, HeuristicMixedException, HeuristicRollbackException, SecurityException, IllegalStateException, SystemException
/*     */   {
/*  87 */     this.transactionManager.commit();
/*     */   }
/*     */ 
/*     */   public int getStatus()
/*     */     throws SystemException
/*     */   {
/*  97 */     return this.transactionManager.getStatus();
/*     */   }
/*     */ 
/*     */   public Transaction getTransaction()
/*     */     throws SystemException
/*     */   {
/* 107 */     return this.transactionManager.getTransaction();
/*     */   }
/*     */ 
/*     */   public void resume(Transaction transaction)
/*     */     throws InvalidTransactionException, IllegalStateException, SystemException
/*     */   {
/* 117 */     this.transactionManager.resume(transaction);
/*     */   }
/*     */ 
/*     */   public void rollback()
/*     */     throws IllegalStateException, SecurityException, SystemException
/*     */   {
/* 126 */     this.transactionManager.rollback();
/*     */   }
/*     */ 
/*     */   public void setRollbackOnly()
/*     */     throws IllegalStateException, SystemException
/*     */   {
/* 135 */     this.transactionManager.setRollbackOnly();
/*     */   }
/*     */ 
/*     */   public void setTransactionTimeout(int timeout)
/*     */     throws SystemException
/*     */   {
/* 145 */     this.transactionManager.setTransactionTimeout(timeout);
/*     */   }
/*     */ 
/*     */   public Transaction suspend()
/*     */     throws SystemException
/*     */   {
/* 155 */     return this.transactionManager.suspend();
/*     */   }
/*     */ 
/*     */   public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/* 166 */     return this.transactionLocalDelegate.containsValue(transactionLocal, transaction);
/*     */   }
/*     */ 
/*     */   public Object getValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/* 177 */     return this.transactionLocalDelegate.getValue(transactionLocal, transaction);
/*     */   }
/*     */ 
/*     */   public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value)
/*     */   {
/* 189 */     this.transactionLocalDelegate.storeValue(transactionLocal, transaction, value);
/*     */   }
/*     */ 
/*     */   public void lock(TransactionLocal local, Transaction tx)
/*     */     throws InterruptedException
/*     */   {
/* 200 */     this.transactionLocalDelegate.lock(local, tx);
/*     */   }
/*     */ 
/*     */   public void unlock(TransactionLocal local, Transaction tx)
/*     */   {
/* 208 */     this.transactionLocalDelegate.unlock(local, tx);
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jbossatx.BaseTransactionManagerDelegate
 * JD-Core Version:    0.6.0
 */