/*     */ package com.arjuna.ats.jbossatx;
/*     */ 
/*     */ import java.lang.ref.WeakReference;
/*     */ import java.util.Collections;
/*     */ import java.util.HashMap;
/*     */ import java.util.Map;
/*     */ import java.util.WeakHashMap;
/*     */ import javax.transaction.Synchronization;
/*     */ import javax.transaction.SystemException;
/*     */ import javax.transaction.Transaction;
/*     */ import org.jboss.tm.TransactionLocal;
/*     */ import org.jboss.tm.TransactionLocalDelegate;
/*     */ import org.jboss.util.NestedRuntimeException;
/*     */ 
/*     */ public class TransactionLocalDelegateImpl
/*     */   implements TransactionLocalDelegate
/*     */ {
/*     */   private Map transactionMap;
/*     */ 
/*     */   public TransactionLocalDelegateImpl()
/*     */   {
/*  47 */     this.transactionMap = Collections.synchronizedMap(new WeakHashMap());
/*     */   }
/*     */ 
/*     */   public boolean containsValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/*  57 */     Map map = getMap(transaction, false);
/*  58 */     return (map != null) && (map.containsKey(transactionLocal));
/*     */   }
/*     */ 
/*     */   public Object getValue(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/*  69 */     Map map = getMap(transaction, false);
/*  70 */     return map == null ? null : map.get(transactionLocal);
/*     */   }
/*     */ 
/*     */   public void storeValue(TransactionLocal transactionLocal, Transaction transaction, Object value)
/*     */   {
/*     */     int status;
/*     */     try
/*     */     {
/*  85 */       status = transaction.getStatus();
/*     */     }
/*     */     catch (SystemException se)
/*     */     {
/*  89 */       throw new NestedRuntimeException(se);
/*     */     }
/*  91 */     if (status == 0)
/*     */     {
/*  93 */       Map map = getMap(transaction, true);
/*  94 */       map.put(transactionLocal, value);
/*     */     }
/*     */   }
/*     */ 
/*     */   public void lock(TransactionLocal transactionLocal, Transaction transaction)
/*     */     throws InterruptedException
/*     */   {
/*     */     int status;
/*     */     try
/*     */     {
/* 111 */       status = transaction.getStatus();
/*     */     }
/*     */     catch (SystemException se)
/*     */     {
/* 115 */       throw new NestedRuntimeException(se);
/*     */     }
/* 117 */     if (status != 0)
/*     */     {
/* 119 */       throw new IllegalStateException("Transaction not active");
/*     */     }
/* 121 */     TransactionLocalSynchronization synchronization = getSynchronization(transaction, true);
/* 122 */     synchronization.lock(transactionLocal);
/*     */   }
/*     */ 
/*     */   public void unlock(TransactionLocal transactionLocal, Transaction transaction)
/*     */   {
/* 132 */     TransactionLocalSynchronization synchronization = getSynchronization(transaction, true);
/* 133 */     if (synchronization != null)
/*     */     {
/* 135 */       synchronization.unlock(transactionLocal);
/*     */     }
/*     */   }
/*     */ 
/*     */   private Map getMap(Transaction transaction, boolean create)
/*     */   {
/* 147 */     TransactionLocalSynchronization synchronization = getSynchronization(transaction, create);
/* 148 */     return synchronization == null ? null : synchronization.getMap();
/*     */   }
/*     */ 
/*     */   private TransactionLocalSynchronization getSynchronization(Transaction transaction, boolean create)
/*     */   {
/* 159 */     WeakReference reference = (WeakReference)this.transactionMap.get(transaction);
/* 160 */     if (reference != null)
/*     */     {
/* 162 */       TransactionLocalSynchronization synchronization = (TransactionLocalSynchronization)reference.get();
/* 163 */       if (synchronization != null)
/*     */       {
/* 165 */         return synchronization;
/*     */       }
/*     */     }
/*     */ 
/* 169 */     if (!create)
/*     */     {
/* 171 */       return null;
/*     */     }
/*     */ 
/* 174 */     TransactionLocalSynchronization synchronization = new TransactionLocalSynchronization(null);
/*     */     try
/*     */     {
/* 177 */       transaction.registerSynchronization(synchronization);
/*     */     }
/*     */     catch (Exception ex)
/*     */     {
/* 181 */       throw new NestedRuntimeException(ex);
/*     */     }
/* 183 */     this.transactionMap.put(transaction, new WeakReference(synchronization));
/* 184 */     return synchronization;
/*     */   }
/*     */ 
/*     */   private static class TransactionLocalSynchronization
/*     */     implements Synchronization
/*     */   {
/* 197 */     private Map map = Collections.synchronizedMap(new HashMap());
/*     */     private Thread lockingThread;
/*     */     private int lockCount;
/* 209 */     private byte[] lock = new byte[0];
/*     */ 
/*     */     public Map getMap()
/*     */     {
/* 217 */       return this.map;
/*     */     }
/*     */ 
/*     */     public void afterCompletion(int result)
/*     */     {
/*     */     }
/*     */ 
/*     */     public void beforeCompletion()
/*     */     {
/*     */     }
/*     */ 
/*     */     public void lock(TransactionLocal transactionLocal)
/*     */     {
/* 243 */       synchronized (this.lock)
/*     */       {
/* 245 */         Thread currentThread = Thread.currentThread();
/* 246 */         if (currentThread == this.lockingThread)
/*     */         {
/* 248 */           this.lockCount += 1;
/* 249 */           return;
/*     */         }
/*     */ 
/* 252 */         while (this.lockingThread != null)
/*     */         {
/*     */           try
/*     */           {
/* 256 */             this.lock.wait();
/*     */           }
/*     */           catch (InterruptedException ie) {
/*     */           }
/*     */         }
/* 261 */         this.lockingThread = currentThread;
/* 262 */         this.lockCount += 1;
/*     */       }
/*     */     }
/*     */ 
/*     */     public void unlock(TransactionLocal transactionLocal)
/*     */     {
/* 272 */       synchronized (this.lock)
/*     */       {
/* 274 */         Thread currentThread = Thread.currentThread();
/* 275 */         if (currentThread != this.lockingThread)
/*     */         {
/* 277 */           throw new IllegalStateException("Unlock called from wrong thread.  Locking thread: " + this.lockingThread + ", current thread: " + currentThread);
/*     */         }
/*     */ 
/* 281 */         if (--this.lockCount == 0)
/*     */         {
/* 283 */           this.lockingThread = null;
/* 284 */           this.lock.notify();
/*     */         }
/*     */       }
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jbossatx.TransactionLocalDelegateImpl
 * JD-Core Version:    0.6.0
 */