/*     */ package com.arjuna.ats.jdbc;
/*     */ 
/*     */ import com.arjuna.ats.internal.jdbc.ConnectionManager;
/*     */ import com.arjuna.ats.jdbc.logging.jdbcLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.sql.Connection;
/*     */ import java.sql.Driver;
/*     */ import java.sql.DriverManager;
/*     */ import java.sql.DriverPropertyInfo;
/*     */ import java.sql.SQLException;
/*     */ import java.util.Properties;
/*     */ 
/*     */ public class TransactionalDriver
/*     */   implements Driver
/*     */ {
/*     */   public static final String arjunaDriver = "jdbc:arjuna:";
/*     */   public static final String jdbc = "jdbc:";
/*     */   public static final String userName = "user";
/*     */   public static final String password = "password";
/*     */   public static final String dynamicClass = "DYNAMIC_CLASS";
/*     */   public static final String createDb = "CREATE_DB";
/*     */ 
/*     */   public TransactionalDriver()
/*     */   {
/*  72 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  74 */       jdbcLogger.logger.debug(1L, 4L, 1L, "TransactionalDriver.TransactionalDriver ()");
/*     */     }
/*     */   }
/*     */ 
/*     */   public Connection connect(String url, Properties info)
/*     */     throws SQLException
/*     */   {
/*  81 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/*  83 */       jdbcLogger.logger.debug(16L, 4L, 1L, "TransactionalDriver.connect ( " + url + " )");
/*     */     }
/*     */ 
/*  87 */     if (!url.startsWith("jdbc:arjuna:"))
/*     */     {
/*  89 */       return null;
/*     */     }
/*     */ 
/*  93 */     return ConnectionManager.create(url.substring("jdbc:arjuna:".length()), info);
/*     */   }
/*     */ 
/*     */   public boolean acceptsURL(String url)
/*     */     throws SQLException
/*     */   {
/*  99 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 101 */       jdbcLogger.logger.debug(16L, 4L, 1L, "TransactionalDriver.acceptsURL ( " + url + " )");
/*     */     }
/*     */ 
/* 105 */     if (url != null)
/*     */     {
/* 108 */       return url.indexOf("jdbc:arjuna:") != -1;
/*     */     }
/*     */ 
/* 113 */     return false;
/*     */   }
/*     */ 
/*     */   public int getMajorVersion()
/*     */   {
/* 118 */     return 2;
/*     */   }
/*     */ 
/*     */   public int getMinorVersion()
/*     */   {
/* 123 */     return 0;
/*     */   }
/*     */ 
/*     */   public boolean jdbcCompliant()
/*     */   {
/* 128 */     return true;
/*     */   }
/*     */ 
/*     */   public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException
/*     */   {
/* 133 */     if (jdbcLogger.logger.isDebugEnabled())
/*     */     {
/* 135 */       jdbcLogger.logger.debug(16L, 4L, 1L, "TransactionalDriver.getPropertyInfo ( " + url + " )");
/*     */     }
/*     */ 
/* 139 */     int index = url.indexOf("jdbc:arjuna:");
/*     */ 
/* 141 */     if (index == -1) {
/* 142 */       return null;
/*     */     }
/*     */ 
/* 145 */     String theUrl = url.substring(index + "jdbc:arjuna:".length());
/* 146 */     Driver d = DriverManager.getDriver(theUrl);
/*     */ 
/* 148 */     if (d != null) {
/* 149 */       return d.getPropertyInfo(theUrl, info);
/*     */     }
/* 151 */     return null;
/*     */   }
/*     */ 
/*     */   static
/*     */   {
/*     */     try
/*     */     {
/* 159 */       DriverManager.registerDriver(new TransactionalDriver());
/*     */     }
/*     */     catch (Exception e)
/*     */     {
/* 163 */       throw new ExceptionInInitializerError(e);
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.jdbc.TransactionalDriver
 * JD-Core Version:    0.6.0
 */