/*     */ package com.arjuna.ats.txoj;
/*     */ 
/*     */ import com.arjuna.ats.arjuna.StateManager;
/*     */ import com.arjuna.ats.arjuna.common.Uid;
/*     */ import com.arjuna.ats.arjuna.coordinator.ActionHierarchy;
/*     */ import com.arjuna.ats.arjuna.coordinator.BasicAction;
/*     */ import com.arjuna.ats.arjuna.state.InputObjectState;
/*     */ import com.arjuna.ats.arjuna.state.OutputObjectState;
/*     */ import com.arjuna.ats.arjuna.utils.Utility;
/*     */ import com.arjuna.ats.txoj.logging.txojLogger;
/*     */ import com.arjuna.common.util.logging.LogNoi18n;
/*     */ import java.io.IOException;
/*     */ import java.io.PrintWriter;
/*     */ import java.io.StringWriter;
/*     */ 
/*     */ public class Lock extends StateManager
/*     */ {
/*     */   private int currentStatus;
/*     */   private Lock nextLock;
/*     */   private int lMode;
/*     */   private ActionHierarchy owners;
/* 498 */   private static Uid applicUid = null;
/* 499 */   private static int applicPid = Utility.getpid();
/*     */ 
/*     */   public Lock()
/*     */   {
/*  69 */     super(2);
/*     */ 
/*  71 */     this.currentStatus = 0;
/*  72 */     this.nextLock = null;
/*  73 */     this.lMode = 1;
/*  74 */     this.owners = new ActionHierarchy(0);
/*     */   }
/*     */ 
/*     */   public Lock(int lm)
/*     */   {
/*  87 */     super(2);
/*     */ 
/*  89 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/*  91 */       txojLogger.aitLogger.debug(1L, 4L, 2L, "Lock::Lock(" + lm + ")");
/*     */     }
/*     */ 
/*  95 */     this.currentStatus = 0;
/*  96 */     this.nextLock = null;
/*  97 */     this.lMode = lm;
/*  98 */     this.owners = new ActionHierarchy(0);
/*     */ 
/* 100 */     BasicAction curr = BasicAction.Current();
/*     */ 
/* 102 */     if (curr == null)
/*     */     {
/* 104 */       int currentPid = 0;
/* 105 */       ActionHierarchy ah = new ActionHierarchy(1);
/*     */ 
/* 107 */       if (applicUid == null)
/*     */       {
/* 109 */         applicUid = new Uid();
/*     */       }
/*     */ 
/* 112 */       if (applicPid != currentPid)
/*     */       {
/* 114 */         Uid temp = new Uid();
/*     */ 
/* 121 */         applicPid = currentPid;
/* 122 */         applicUid.copy(temp);
/*     */       }
/*     */ 
/* 125 */       ah.add(applicUid);
/* 126 */       this.owners.copy(ah);
/*     */     }
/*     */     else
/*     */     {
/* 130 */       this.owners.copy(curr.getHierarchy());
/*     */     }
/*     */   }
/*     */ 
/*     */   public Lock(Uid storeUid)
/*     */   {
/* 141 */     super(storeUid, 2);
/*     */ 
/* 143 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 145 */       txojLogger.aitLogger.debug(1L, 4L, 2L, "Lock::Lock(" + storeUid + ")");
/*     */     }
/*     */ 
/* 149 */     this.currentStatus = 0;
/* 150 */     this.nextLock = null;
/* 151 */     this.lMode = 1;
/* 152 */     this.owners = new ActionHierarchy(0);
/*     */   }
/*     */ 
/*     */   public void finalize()
/*     */     throws Throwable
/*     */   {
/* 161 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 163 */       txojLogger.aitLogger.debug(2L, 4L, 2L, "Lock.finalize()");
/*     */     }
/*     */ 
/* 167 */     super.terminate();
/*     */ 
/* 169 */     this.owners = null;
/*     */ 
/* 171 */     super.finalize();
/*     */   }
/*     */ 
/*     */   public final int getLockMode()
/*     */   {
/* 186 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 188 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getLockMode()");
/*     */     }
/*     */ 
/* 192 */     return this.lMode;
/*     */   }
/*     */ 
/*     */   public final Uid getCurrentOwner()
/*     */   {
/* 201 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 203 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentOwner()");
/*     */     }
/*     */ 
/* 207 */     return this.owners.getDeepestActionUid();
/*     */   }
/*     */ 
/*     */   public final ActionHierarchy getAllOwners()
/*     */   {
/* 217 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 219 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getAllOwners()");
/*     */     }
/*     */ 
/* 223 */     return this.owners;
/*     */   }
/*     */ 
/*     */   public final int getCurrentStatus()
/*     */   {
/* 232 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 234 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentStatus()");
/*     */     }
/*     */ 
/* 238 */     return this.currentStatus;
/*     */   }
/*     */ 
/*     */   public final void changeHierarchy(ActionHierarchy newOwner)
/*     */   {
/* 248 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 250 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::getCurrentOwner()");
/*     */     }
/*     */ 
/* 254 */     this.owners.copy(newOwner);
/*     */ 
/* 256 */     if (this.currentStatus == 0)
/* 257 */       this.currentStatus = 1;
/*     */   }
/*     */ 
/*     */   public final void propagate()
/*     */   {
/* 266 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 268 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::propagate()");
/*     */     }
/*     */ 
/* 272 */     this.owners.forgetDeepest();
/*     */ 
/* 274 */     this.currentStatus = 2;
/*     */   }
/*     */ 
/*     */   public boolean modifiesObject()
/*     */   {
/* 288 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 290 */       txojLogger.aitLogger.debug(256L, 4L, 2L, "Lock::modifiesObject()");
/*     */     }
/*     */ 
/* 294 */     return this.lMode == 1;
/*     */   }
/*     */ 
/*     */   public boolean conflictsWith(Lock otherLock)
/*     */   {
/* 309 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 311 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::conflictsWith(" + otherLock + ")\n" + "\tLock 1:\n" + this + "\n" + "\tLock 2:\n" + otherLock);
/*     */     }
/*     */ 
/* 317 */     if (!getCurrentOwner().equals(otherLock.getCurrentOwner()))
/*     */     {
/* 319 */       switch (this.lMode)
/*     */       {
/*     */       case 1:
/* 322 */         return true;
/*     */       case 0:
/* 324 */         if (otherLock.getLockMode() == 0) break;
/* 325 */         return true;
/*     */       }
/*     */ 
/*     */     }
/*     */ 
/* 330 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Object otherLock)
/*     */   {
/* 339 */     if ((otherLock instanceof Lock)) {
/* 340 */       return equals((Lock)otherLock);
/*     */     }
/* 342 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean equals(Lock otherLock)
/*     */   {
/* 354 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 356 */       txojLogger.aitLogger.debug(32L, 4L, 2L, "Lock::equals(" + otherLock + ")\n" + "\tLock 1:\n" + this + "\n" + "\tLock 2:\n" + otherLock);
/*     */     }
/*     */ 
/* 362 */     if (this == otherLock) {
/* 363 */       return true;
/*     */     }
/*     */ 
/* 369 */     return (this.lMode == otherLock.lMode) && (this.owners.equals(otherLock.owners)) && (this.currentStatus == otherLock.currentStatus);
/*     */   }
/*     */ 
/*     */   public String toString()
/*     */   {
/* 381 */     StringWriter strm = new StringWriter();
/*     */ 
/* 383 */     strm.write("Lock object : \n");
/* 384 */     strm.write("\tunique id is : " + get_uid() + "\n");
/*     */ 
/* 386 */     strm.write("\tcurrent_status : " + LockStatus.printString(this.currentStatus));
/*     */ 
/* 388 */     strm.write("\n\tMode : " + LockMode.stringForm(this.lMode));
/*     */ 
/* 390 */     strm.write("\n\tOwner List : \n");
/* 391 */     this.owners.print(new PrintWriter(strm));
/*     */ 
/* 393 */     return strm.toString();
/*     */   }
/*     */ 
/*     */   public void print(PrintWriter strm)
/*     */   {
/* 402 */     strm.print(toString());
/*     */   }
/*     */ 
/*     */   public boolean restore_state(InputObjectState os, int ot)
/*     */   {
/* 414 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 416 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::restore_state(" + os + ", " + ot + ")");
/*     */     }
/*     */ 
/* 420 */     ActionHierarchy ah = new ActionHierarchy(0);
/*     */     try
/*     */     {
/* 424 */       this.currentStatus = os.unpackInt();
/* 425 */       this.lMode = os.unpackInt();
/* 426 */       ah.unpack(os);
/* 427 */       this.owners = ah;
/*     */ 
/* 429 */       return true;
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 433 */     return false;
/*     */   }
/*     */ 
/*     */   public boolean save_state(OutputObjectState os, int ot)
/*     */   {
/* 446 */     if (txojLogger.aitLogger.isDebugEnabled())
/*     */     {
/* 448 */       txojLogger.aitLogger.debug(16L, 4L, 2L, "Lock::save_state(" + os + ", " + ot + ")");
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 454 */       os.packInt(this.currentStatus);
/* 455 */       os.packInt(this.lMode);
/* 456 */       this.owners.pack(os);
/*     */ 
/* 458 */       return os.valid();
/*     */     }
/*     */     catch (IOException e) {
/*     */     }
/* 462 */     return false;
/*     */   }
/*     */ 
/*     */   public String type()
/*     */   {
/* 472 */     return "/StateManager/Lock";
/*     */   }
/*     */ 
/*     */   protected Lock getLink()
/*     */   {
/* 481 */     return this.nextLock;
/*     */   }
/*     */ 
/*     */   protected void setLink(Lock pointTo)
/*     */   {
/* 490 */     this.nextLock = pointTo;
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.Lock
 * JD-Core Version:    0.6.0
 */