/*     */ package com.arjuna.ats.txoj;
/*     */ 
/*     */ import java.util.Calendar;
/*     */ import java.util.Date;
/*     */ 
/*     */ class LockConflictManager
/*     */ {
/*     */   private Object _lock;
/*     */   private int _signals;
/*     */ 
/*     */   LockConflictManager()
/*     */   {
/*  53 */     this._lock = new Object();
/*  54 */     this._signals = 0;
/*     */   }
/*     */ 
/*     */   int wait(int retry, int waitTime)
/*     */   {
/*  71 */     if (retry < 0)
/*     */     {
/*  77 */       Date d1 = Calendar.getInstance().getTime();
/*     */ 
/*  79 */       synchronized (this._lock)
/*     */       {
/*     */         try
/*     */         {
/*  89 */           if (this._signals == 0)
/*     */           {
/*  91 */             this._lock.wait(waitTime);
/*     */           }
/*     */           else
/*     */           {
/*  95 */             this._signals -= 1;
/*     */ 
/*  97 */             return waitTime;
/*     */           }
/*     */         }
/*     */         catch (InterruptedException e)
/*     */         {
/*     */         }
/*     */       }
/*     */ 
/* 105 */       Date d2 = Calendar.getInstance().getTime();
/*     */ 
/* 107 */       return (int)(d2.getTime() - d1.getTime());
/*     */     }
/*     */ 
/*     */     try
/*     */     {
/* 115 */       Thread.sleep(waitTime);
/*     */     }
/*     */     catch (InterruptedException e)
/*     */     {
/*     */     }
/*     */ 
/* 121 */     return 0;
/*     */   }
/*     */ 
/*     */   void signal()
/*     */   {
/* 131 */     synchronized (this._lock)
/*     */     {
/* 133 */       this._lock.notifyAll();
/*     */ 
/* 135 */       this._signals += 1;
/*     */ 
/* 137 */       if (this._signals < 0)
/* 138 */         this._signals = 1;
/*     */     }
/*     */   }
/*     */ }

/* Location:           /home/mnovotny/projects/EMBEDDED_JBOSS_BETA3_COMMUNITY/embedded/output/lib/embedded-jboss/lib/jboss-embedded-all.jar
 * Qualified Name:     com.arjuna.ats.txoj.LockConflictManager
 * JD-Core Version:    0.6.0
 */